/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.factor;

import java.awt.Color;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.xml.sax.SAXException;
import se.prediktera.breeze.common.entry.factor.FactorHolder;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.util.XmlDocumentRoot;
import se.prediktera.breeze.entry.factor.SampleVariableValueParser;
import se.prediktera.breeze.entry.sample.Sample;

public class SampleVariableValueParserTest {
    @Test
    public void shouldParseStandardCaseAndCreateFactorsAsNeeded() throws SAXException, IOException, ParserConfigurationException {
        Sample sample = new Sample();
        FactorHolder factorHolder = new FactorHolder();
        SampleVariableValueParser.parseVariables(factorHolder, new XmlDocumentRoot("<variables>\r\n<qualitative id=\"4c5b766d\" name=\"Type\">\r\n  <class>-</class>\r\n</qualitative>\r\n<quantitative id=\"6f90ccb2\" name=\"Baking soda\" unit=\"\">\r\n  <value>0</value>\r\n</quantitative>\r\n<quantitative id=\"6f1b9c07\" name=\"Vanilla\" unit=\"\">\r\n  <value>50</value>\r\n</quantitative>\r\n</variables>\r\n").node(), sample);
        CategoryFactor categoryFactor = (CategoryFactor)factorHolder.getFactorByUid("4c5b766d");
        PropertyFactor propertyFactor = (PropertyFactor)factorHolder.getFactorByUid("6f90ccb2");
        PropertyFactor propertyFactor2 = (PropertyFactor)factorHolder.getFactorByUid("6f1b9c07");
        MatcherAssert.assertThat((Object)sample.getSampleValues().getValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((Object)sample.getSampleValues().getValue(propertyFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((Object)sample.getSampleValues().getValue(propertyFactor2), (Matcher)CoreMatchers.is((Object)Float.valueOf(50.0f)));
    }

    @Test
    public void shouldParseStandardCaseWithExistingFactors() throws SAXException, IOException, ParserConfigurationException {
        Sample sample = new Sample();
        FactorHolder factorHolder = new FactorHolder();
        CategoryFactor categoryFactor = new CategoryFactor("Type", "4c5b766d");
        categoryFactor.addNoClass("-", Color.red);
        categoryFactor.addClass("A");
        categoryFactor.addClass("B");
        categoryFactor.addClass("C");
        factorHolder.getCategoryFactors().add(categoryFactor);
        PropertyFactor propertyFactor = new PropertyFactor("Vanilla", "6f1b9c07");
        factorHolder.getPropertyFactors().add(propertyFactor);
        SampleVariableValueParser.parseVariables(factorHolder, new XmlDocumentRoot("<variables>\r\n<qualitative id=\"4c5b766d\" name=\"Type\">\r\n  <class>B</class>\r\n</qualitative>\r\n<quantitative id=\"6f1b9c07\" name=\"Vanilla\" unit=\"\">\r\n  <value>50</value>\r\n</quantitative>\r\n</variables>\r\n").node(), sample);
        MatcherAssert.assertThat((Object)sample.getSampleValues().getValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(2.0f)));
        MatcherAssert.assertThat((Object)sample.getSampleValues().getValue(propertyFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(50.0f)));
    }
}

