/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.group;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.breeze.backend.tree.groupandmeasurementtree.GroupAndMeasurementDefaultFunctionTreeListMap;
import se.prediktera.breeze.common.entry.ObjectWithChildrenAndParent;
import se.prediktera.breeze.common.entry.factor.FactorHolder;
import se.prediktera.breeze.common.entry.factor.category.CategoryList;
import se.prediktera.breeze.common.entry.factor.property.PropertyList;
import se.prediktera.breeze.common.entry.group.BasicGroup;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractFunctionTree;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorHolder;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorInterface;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.BreezeRecycleBin;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.EntryData;
import se.prediktera.breeze.entry.WorkflowOrGroup;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.comment.CommentList;
import se.prediktera.breeze.entry.identifier.IdentifierList;
import se.prediktera.breeze.entry.legacy.LegacyFileFormat;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SampleSegmentationColumn;
import se.prediktera.breeze.entry.workflow.LimitConfiguration;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.util.xmlproperties.DefaultXmlProperties;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlProperties;
import se.prediktera.breeze.test.stubs.WorkflowWithoutIO;
import se.prediktera.breeze.util.SortedFileList;
import se.prediktera.map.common.error.Logg;

public class Group
extends BasicGroup
implements ObjectWithChildrenAndParent<Workflow, Measurement>,
Entry,
WorkflowOrGroup,
DescriptorInterface {
    private final EntryData entryData;
    private final CommentList comments = new CommentList();
    private final DefaultXmlProperties properties = new DefaultXmlProperties("settings");
    private final DescriptorHolder descriptorHolder = new DescriptorHolder(this);
    private Workflow parent;
    private List<Measurement> childList = new ArrayList<Measurement>();

    public Group(String string, Workflow workflow) {
        this.entryData = new EntryData(this, string, workflow.getFolder());
        this.setParent(workflow);
    }

    public Group(File file, Workflow workflow) {
        File file2 = new LegacyFileFormat.GroupLegacyFileFormat().renameIfNeeded(file);
        this.setParent(workflow);
        this.entryData = new EntryData(file2.getName());
        Node node = XmlParserHelper.parseXMLRoot(this.getXml(), "group", "design");
        this.entryData.setAttributesAndNewName(node, null);
        boolean bl = false;
        NodeList nodeList = node.getChildNodes();
        block14: for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node2 = nodeList.item(i);
            if (node2 == null) continue;
            switch (string = node2.getNodeName().toLowerCase()) {
                case "comments": {
                    this.getComments().parseComments(node2);
                    continue block14;
                }
                case "settings": {
                    this.getProperties().setRootProperty(node2);
                    bl = true;
                    continue block14;
                }
                case "descriptors": {
                    this.getDescriptorHolder().parseResults(node2, GroupAndMeasurementDefaultFunctionTreeListMap.getInstance().getFunctionTreeList("group"));
                    continue block14;
                }
                case "identifiers": {
                    this.getIdentifiers().parseIdentifiers(node2);
                    continue block14;
                }
                case "variables": {
                    this.getFactorHolder().parseVariables(node2);
                }
            }
        }
        XmlProperties.ensureThatSettingsExists(this.getProperties(), node, bl);
        this.clearChildList();
    }

    @Override
    public boolean isGrayed() {
        return GroupAndMeasurementDefaultFunctionTreeListMap.getInstance().isGrayed(this);
    }

    public boolean useReferences() {
        if (this.getChildCount() > 0) {
            for (Measurement measurement : this.getChildList()) {
                if (!measurement.hasData()) continue;
                return measurement.hasReferences();
            }
        }
        return true;
    }

    public IdentifierList getIdentifiers() {
        return this.getParent().getIdentifiers();
    }

    public FactorHolder getFactorHolder() {
        return this.getParent().getFactorHolder();
    }

    public Group duplicate(String string) {
        return new Group(string, this.getParent());
    }

    @Override
    public boolean delete(boolean bl) {
        Measurement.clearFromCache(this);
        return BreezeRecycleBin.delete(this, Entry.EntryType.Group, bl);
    }

    public AbstractFunctionTree getWorkflowSampleTree() {
        return this.getParent().getAnalyseTree();
    }

    public SampleSegmentationColumn getSamples(int n) {
        SampleSegmentationColumn sampleSegmentationColumn = new SampleSegmentationColumn();
        for (Measurement measurement : this.getChildList()) {
            sampleSegmentationColumn.addAll(measurement.getSamples(n));
        }
        return sampleSegmentationColumn;
    }

    public SampleSegmentationColumn getSamples(String string) {
        SampleSegmentationColumn sampleSegmentationColumn = new SampleSegmentationColumn();
        for (Measurement measurement : this.getChildList()) {
            sampleSegmentationColumn.addAll(measurement.getSamples(string));
        }
        return sampleSegmentationColumn;
    }

    public void performGroupDescriptors() {
        GroupAndMeasurementDefaultFunctionTreeListMap.getInstance().performGroupDescriptors(this);
    }

    @Override
    public void save() {
        this.performGroupDescriptors();
        Document document = XmlParserHelper.createXMLdoc();
        Element element = XmlParserHelper.addRoot("group", document);
        this.getEntryData().writeXmlAttributes(element, "Group");
        this.getDescriptorHolder().writeResults(XmlParserHelper.addElement(element, "descriptors"));
        XmlProperties.addProperties(this.getProperties(), document, element);
        this.getComments().addComments(element);
        XmlProperties.createDirectoriesAndOutputXML(this.getXml(), document);
    }

    @Override
    public File getXml() {
        return new File(this.getFolder(), "group.xml");
    }

    @Override
    public File getFolder() {
        return new File(this.getParent().getFolder(), this.getName());
    }

    public double getFirstDescriptorValueByName(String string) {
        return GroupAndMeasurementDefaultFunctionTreeListMap.getInstance().getFirstDescriptorValueByName(this, string);
    }

    @Override
    public File getCustomImageFile() {
        return Group.getMeasurementImageFile(this.getFolder());
    }

    public static File getMeasurementImageFile(File file) {
        if (!file.exists()) {
            return null;
        }
        for (File file2 : file.listFiles()) {
            File file3;
            if (!file2.isDirectory() || (file3 = Group.getThumbnailInFolder(file2)) == null) continue;
            return file3;
        }
        return null;
    }

    public static File getThumbnailInFolder(File file) {
        File file2 = new File(file, "measurement.jpg");
        if (file2.exists()) {
            return file2;
        }
        File file3 = new File(file, "measurement.png");
        if (file3.exists()) {
            return file3;
        }
        File file4 = new File(file, "measurement_raw.png");
        if (file4.exists()) {
            return file4;
        }
        File file5 = new File(file, file.getName() + "_raw.png");
        if (file5.exists()) {
            return file5;
        }
        return null;
    }

    public CategoryList getCategoryFactors() {
        return this.getParent().getCategoryFactors();
    }

    public PropertyList getPropertyFactors() {
        return this.getParent().getPropertyFactors();
    }

    public Measurement getFirstMeasurementWithData() {
        return Measurement.getFirstMeasurementWithData(this.getChildList());
    }

    @Override
    public CommentList getComments() {
        return this.comments;
    }

    @Override
    public XmlProperties getProperties() {
        return this.properties;
    }

    @Override
    public String getName() {
        return this.entryData.getName();
    }

    @Override
    public EntryData getEntryData() {
        return this.entryData;
    }

    @Override
    public String getUid() {
        return this.entryData.getUid();
    }

    public String toString() {
        return this.entryData.toString();
    }

    @Override
    public boolean applyChangesNeeded() {
        return false;
    }

    @Override
    public void rename(String string) throws IOException {
        Measurement.clearFromCache(this);
        this.entryData.rename(string, this.getFolder(), this.getParent().getFolder());
    }

    public String nextMeasurementName() {
        if (!BreezeProperties.getInstance().getNameTemplate().isEmpty()) {
            return BreezeProperties.getInstance().getNameTemplate();
        }
        return this.nextLegacyMeasurementName();
    }

    public String nextLegacyMeasurementName() {
        Pattern pattern = Pattern.compile("^M(\\d+)([-_].*)?$");
        int n = 0;
        for (Measurement measurement : this.getChildList()) {
            Matcher matcher = pattern.matcher(measurement.getName());
            if (!matcher.matches()) continue;
            n = Math.max(n, Integer.parseInt(matcher.group(1)));
        }
        return "M" + StringUtils.leftPad((String)String.valueOf(n + 1), (int)4, (char)'0');
    }

    public void setLimit(LimitConfiguration limitConfiguration) {
        this.properties.setPropertyLocal("limit", limitConfiguration.getName());
        this.save();
    }

    public String getLimit() {
        return this.properties.getPropertyLocal("limit", null);
    }

    public static Group createStandaloneGroup(File file) {
        File file2 = file.getParentFile();
        return new Group(file, WorkflowWithoutIO.inFolder(new File(file2.getParentFile(), file2.getName())));
    }

    public void setParent(Workflow workflow) {
        this.parent = workflow;
    }

    @Override
    public Workflow getParent() {
        return this.parent;
    }

    public int getIndexWithinWorkflow() {
        return this.parent.getChildIndex(this);
    }

    public void clearChildList() {
        this.childList = null;
    }

    public List<Measurement> getChildList() {
        if (this.childList == null) {
            this.childList = this.getAllMeasurements();
        }
        return this.childList;
    }

    public synchronized List<Measurement> syncToExisting(BreezeProgressManager breezeProgressManager) {
        if (this.childList == null) {
            this.childList = new ArrayList<Measurement>();
        }
        breezeProgressManager.setInfoText("Adding measurements");
        List list = this.childList.stream().map(Measurement::getFolder).collect(Collectors.toList());
        List<File> list2 = new SortedFileList.SortedFolderList(this.getFolder()).getFiles();
        breezeProgressManager.setMaximumAndReset(list2.size());
        for (File file : list2) {
            if (list.contains(file)) {
                breezeProgressManager.incStep();
                continue;
            }
            if (Paths.get(file.getAbsolutePath(), "measurement.xml").toFile().exists()) {
                this.childList.add(new Measurement(file, this));
            }
            breezeProgressManager.incStep();
        }
        return this.childList;
    }

    private List<Measurement> getAllMeasurements() {
        ArrayList<Measurement> arrayList = new ArrayList<Measurement>();
        HashSet<String> hashSet = new HashSet<String>();
        for (File file : new SortedFileList.SortedFolderList(this.getFolder())) {
            try {
                Measurement measurement = new Measurement(new LegacyFileFormat.MeasurementLegacyFileFormat().renameIfNeeded(file), this);
                if (hashSet.contains(measurement.getUid())) {
                    Logg.warn((String)("Warning!, measurement (" + measurement.getName() + ") has similar uid in group, uid will be replaced"), (Object[])new Object[0]);
                    measurement.getEntryData().renewUid();
                    measurement.save();
                }
                arrayList.add(measurement);
                hashSet.add(measurement.getUid());
            }
            catch (XmlParserHelper.XmlFileNotFoundException xmlFileNotFoundException) {}
        }
        return arrayList;
    }

    public int getMeasurementFolderCount() {
        int n = 0;
        for (File file : this.getFolder().listFiles()) {
            if (!file.isDirectory() || !new File(file, "measurement.xml").exists() || !new File(file, "measurement.raw").exists() || !new File(file, "measurement.hdr").exists()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public Measurement addChild(Measurement measurement) {
        measurement.setParent(this);
        this.getChildList().add(measurement);
        return measurement;
    }

    public Measurement getChild(int n) {
        return this.getChildList().get(n);
    }

    @Override
    public int getChildCount() {
        return this.getChildList().size();
    }

    @Override
    public void removeChild(int n) {
        this.getChildList().remove(n);
    }

    @Override
    public void removeChild(Measurement measurement) {
        this.getChildList().remove(measurement);
    }

    @Override
    public int getChildIndex(Measurement measurement) {
        return this.getChildList().indexOf(measurement);
    }

    @Override
    public DescriptorHolder getDescriptorHolder() {
        return this.descriptorHolder;
    }

    @Override
    public final float getDescriptorValue(DescriptorTreeNode descriptorTreeNode) {
        return this.descriptorHolder.getDescriptorValue(descriptorTreeNode);
    }

    @Override
    public final FunctionResult getFunctionResult(String string) {
        return this.descriptorHolder.getFunctionResult(string);
    }

    @Override
    public final void putFunctionResult(String string, FunctionResult functionResult) {
        this.descriptorHolder.putFunctionResult(string, functionResult);
    }

    @Override
    public int getChildrenWithData() {
        int n = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!this.getChild(i).hasData()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public Entry.EntryType getEntryType() {
        return Entry.EntryType.Group;
    }

    public static Group getGroup(Object object) {
        if (object instanceof Workflow) {
            Workflow workflow = (Workflow)object;
            if (workflow.getChildCount() > 0) {
                return workflow.getChild(0);
            }
        } else {
            if (object instanceof Group) {
                Group group = (Group)object;
                return group;
            }
            if (object instanceof Measurement) {
                Measurement measurement = (Measurement)object;
                return measurement.getParent();
            }
            if (object instanceof Sample) {
                Sample sample = (Sample)object;
                return sample.measurement().getParent();
            }
            if (object instanceof Analyse) {
                Analyse analyse = (Analyse)object;
                return analyse.getFirstGroup();
            }
        }
        return null;
    }

    public Measurement getMeasurement(String string) {
        for (Measurement measurement : this.getChildList()) {
            if (!measurement.getName().equalsIgnoreCase(string)) continue;
            return measurement;
        }
        return null;
    }
}

