/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.group;

import com.mycila.xmltool.XMLDoc;
import com.mycila.xmltool.XMLTag;
import java.io.File;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import se.prediktera.breeze.common.util.test.asserts.AssertXml;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.test.MockBreezeTestProperties;
import se.prediktera.breeze.test.SlowTestCategory;
import se.prediktera.breeze.test.stubs.GroupWithoutIO;
import se.prediktera.breeze.test.stubs.MeasurementWithoutIO;
import se.prediktera.breeze.util.FileWithStringContent;

@Category(value={SlowTestCategory.class})
public class GroupTest
extends MockBreezeTestProperties {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private Group groupForSave;
    private Group groupForLoad;
    private static final String xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<group xmlns=\"Prediktera.XML.GroupXml\" createdby=\"Administrator \" createddate=\"20170210113803\" id=\"43jkk34j\">\r\n  <descriptors>\r\n    <values>\r\n      <value id=\"0\">7.0</value>\r\n      <value id=\"1\">7.0</value>\r\n      <value id=\"2\">7.0</value>\r\n      <value id=\"3\">7.0</value>\r\n    </values>\r\n  </descriptors>\r\n  <settings>\r\n    <preview>\r\n      <excludebackground>false</excludebackground>\r\n    </preview>\r\n  </settings>\r\n  <images/>\r\n  <comments/>\r\n</group>\r\n";

    @Before
    public void setup() throws IOException {
        Workflow workflow = new Workflow("workflowuid", this.tempFolder.getRoot());
        this.groupForSave = new Group("Group hello hello", workflow);
        workflow.addChild(this.groupForSave);
        File file = new File(new File(workflow.getFolder(), "existinggroup"), "group.xml");
        new FileWithStringContent(xmlString).writtenTo(file);
        this.groupForLoad = new Group(file.getParentFile(), workflow);
        workflow.addChild(this.groupForLoad);
    }

    @Test
    public void shouldSaveXmlInCorrectDirectoryWithCorrectFilename() {
        this.groupForSave.save();
        MatcherAssert.assertThat((String)"group xml file exists", (boolean)this.groupForSave.getXml().exists());
        AssertXml.assertValidXmlFile(this.groupForSave.getXml());
    }

    @Test
    public void shouldSaveUidInXmlFile() {
        this.groupForSave.save();
        XMLTag xMLTag = XMLDoc.from((File)this.groupForSave.getXml(), (boolean)true);
        MatcherAssert.assertThat((Object)xMLTag.getAttribute("id", "/group", new Object[0]), (Matcher)CoreMatchers.equalTo((Object)this.groupForSave.getUid()));
    }

    @Test
    public void shouldSetUidFromXmlFile() throws Exception {
        MatcherAssert.assertThat((String)"group uid was read from xml", (Object)this.groupForLoad.getUid(), (Matcher)CoreMatchers.equalTo((Object)"43jkk34j"));
    }

    @Test
    public void shouldSetNameFromFolder() throws Exception {
        MatcherAssert.assertThat((String)"group name is folder name", (Object)this.groupForLoad.getName(), (Matcher)CoreMatchers.equalTo((Object)"existinggroup"));
    }

    @Test
    public void shouldRenameFolderAndChangeNameTrimmingSpaces() throws IOException {
        this.groupForSave.save();
        this.groupForSave.rename(" new name ");
        MatcherAssert.assertThat((String)"folder is renamed without spaces", (boolean)new File(this.groupForSave.getParent().getFolder(), "new name").exists());
        MatcherAssert.assertThat((String)"analyse is renamed without spaces", (Object)this.groupForSave.getName(), (Matcher)CoreMatchers.is((Object)"new name"));
    }

    @Test
    public void nextMeasurementNameShouldIncreaseBy1From1() {
        GroupWithMeasurementNames groupWithMeasurementNames = new GroupWithMeasurementNames(this, "M0001");
        MatcherAssert.assertThat((Object)groupWithMeasurementNames.nextMeasurementName(), (Matcher)CoreMatchers.is((Object)"M0002"));
    }

    @Test
    public void nextMeasurementNameShouldIncreaseBy1() {
        GroupWithMeasurementNames groupWithMeasurementNames = new GroupWithMeasurementNames(this, "M0001", "M0002");
        MatcherAssert.assertThat((Object)groupWithMeasurementNames.nextMeasurementName(), (Matcher)CoreMatchers.is((Object)"M0003"));
    }

    @Test
    public void nextMeasurementNameShouldNotCollide() {
        GroupWithMeasurementNames groupWithMeasurementNames = new GroupWithMeasurementNames(this, "M0001", "M0003");
        MatcherAssert.assertThat((Object)groupWithMeasurementNames.nextMeasurementName(), (Matcher)CoreMatchers.is((Object)"M0004"));
    }

    @Test
    public void nextMeasurementNameShouldGoByHighest() {
        GroupWithMeasurementNames groupWithMeasurementNames = new GroupWithMeasurementNames(this, "M0017");
        MatcherAssert.assertThat((Object)groupWithMeasurementNames.nextMeasurementName(), (Matcher)CoreMatchers.is((Object)"M0018"));
    }

    @Test
    public void nextMeasurementNameShouldHandleValuesAbove10000() {
        MatcherAssert.assertThat((Object)new GroupWithMeasurementNames(this, "M9999").nextMeasurementName(), (Matcher)CoreMatchers.is((Object)"M10000"));
        MatcherAssert.assertThat((Object)new GroupWithMeasurementNames(this, "M10000").nextMeasurementName(), (Matcher)CoreMatchers.is((Object)"M10001"));
        MatcherAssert.assertThat((Object)new GroupWithMeasurementNames(this, "M100000").nextMeasurementName(), (Matcher)CoreMatchers.is((Object)"M100001"));
        MatcherAssert.assertThat((Object)new GroupWithMeasurementNames(this, "M999999999").nextMeasurementName(), (Matcher)CoreMatchers.is((Object)"M1000000000"));
    }

    @Test
    public void nextMeasurementNameShouldStartWithOne() {
        GroupWithMeasurementNames groupWithMeasurementNames = new GroupWithMeasurementNames(this, new String[0]);
        MatcherAssert.assertThat((Object)groupWithMeasurementNames.nextMeasurementName(), (Matcher)CoreMatchers.is((Object)"M0001"));
    }

    @Test
    public void nextMeasurementNameShouldIgnoreInvalidNames() {
        MatcherAssert.assertThat((Object)new GroupWithMeasurementNames(this, "FM0001").nextMeasurementName(), (Matcher)CoreMatchers.is((Object)"M0001"));
        MatcherAssert.assertThat((Object)new GroupWithMeasurementNames(this, "M0001E").nextMeasurementName(), (Matcher)CoreMatchers.is((Object)"M0001"));
    }

    @Test
    public void nextMeasurementNameShouldHandleUnderline() {
        GroupWithMeasurementNames groupWithMeasurementNames = new GroupWithMeasurementNames(this, "M0001_1");
        MatcherAssert.assertThat((Object)groupWithMeasurementNames.nextMeasurementName(), (Matcher)CoreMatchers.is((Object)"M0002"));
    }

    @Test
    public void nextMeasurementNameShouldHandleUnderlineText() {
        GroupWithMeasurementNames groupWithMeasurementNames = new GroupWithMeasurementNames(this, "M0001_VNIR", "M0001_SWIR");
        MatcherAssert.assertThat((Object)groupWithMeasurementNames.nextMeasurementName(), (Matcher)CoreMatchers.is((Object)"M0002"));
    }

    @Test
    public void nextMeasurementNameShouldHandleUnderlineTextAndNumber() {
        GroupWithMeasurementNames groupWithMeasurementNames = new GroupWithMeasurementNames(this, "M0001_VNIR-1800", "M0001_SWIR-384");
        MatcherAssert.assertThat((Object)groupWithMeasurementNames.nextMeasurementName(), (Matcher)CoreMatchers.is((Object)"M0002"));
    }

    public class GroupWithMeasurementNames
    extends GroupWithoutIO {
        public GroupWithMeasurementNames(GroupTest groupTest, String ... stringArray) {
            for (String string : stringArray) {
                this.addChild(new MeasurementWithoutIO(string, (Group)this));
            }
        }
    }
}

