/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.identifier;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;

public class IdentifierList
implements Iterable<Identifier> {
    private final List<Identifier> identifiers = new ArrayList<Identifier>();

    public boolean identifierExists(String string) {
        for (Identifier identifier : this) {
            if (!identifier.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public Identifier getIdentifier(String string) {
        for (Identifier identifier : this) {
            if (!identifier.getName().equals(string)) continue;
            return identifier;
        }
        return null;
    }

    public Identifier add(Identifier identifier) {
        this.identifiers.add(identifier);
        return identifier;
    }

    public Identifier addIdentifier(String string) {
        return this.add(new Identifier(string));
    }

    public Identifier addIdentifierOrGetExisting(String string) {
        Identifier identifier = this.getIdentifier(string);
        if (identifier != null) {
            return identifier;
        }
        return this.add(new Identifier(string));
    }

    public void remove(Workflow workflow, Identifier identifier) {
        this.identifiers.remove(identifier);
        this.removeIdentifierFromSamples(workflow, identifier);
    }

    public void removeIdentifierFromSamples(Workflow workflow, Identifier identifier) {
        for (Group group : workflow.getChildList()) {
            for (Measurement measurement : group.getChildList()) {
                measurement.getRootSample().forEverySample(basicSample -> ((Sample)basicSample).getIdentifierProperties().removeID(identifier));
                measurement.save();
            }
        }
    }

    public void parseIdentifiers(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getNodeName().equalsIgnoreCase("identifier")) continue;
            String string = nodeList.item(i).getTextContent();
            this.identifiers.add(new Identifier(string));
        }
    }

    public void addIdentifiers(Element element) {
        Element element2 = XmlParserHelper.addElement(element, "identifiers");
        for (Identifier identifier : this) {
            XmlParserHelper.addElement((Node)element2, "identifier", identifier.getName());
        }
    }

    @Override
    public Iterator<Identifier> iterator() {
        return this.identifiers.iterator();
    }

    public int size() {
        return this.identifiers.size();
    }

    public Identifier getFirst() {
        if (this.identifiers.isEmpty()) {
            return null;
        }
        return this.get(0);
    }

    public Identifier get(int n) {
        if (n < this.identifiers.size()) {
            return this.identifiers.get(n);
        }
        return null;
    }

    public List getList() {
        return this.identifiers;
    }

    public static void parseIdentifiers(Group group, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getNodeName().toLowerCase();
            if (!string.equals("id") && !string.equals("identifier")) continue;
            NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
            String string2 = namedNodeMap.getNamedItem("name").getNodeValue();
            Identifier identifier = group.getIdentifiers().getIdentifier(string2);
            if (identifier != null) continue;
            group.getIdentifiers().addIdentifier(string2);
        }
    }
}

