/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.legacy;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.util.RetryOnIOException;

public abstract class LegacyFileFormat {
    public File renameIfNeeded(File file) {
        File file2;
        File file3 = new File(file, this.getTypeFilename() + ".xml");
        if (!file3.exists() && (file2 = new File(file, file.getName() + ".xml")).exists()) {
            try {
                File file4 = this.renameFolder(file, file2);
                this.renameXml(file, file4);
                this.renameAdditionalFiles(file, file4);
                return file4;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return file;
    }

    protected void renameXml(File file, File file2) throws IOException {
        File file3 = new File(file2, file.getName() + ".xml");
        Files.move(file3.toPath(), new File(file2, this.getTypeFilename() + ".xml").toPath(), new CopyOption[0]);
    }

    private File renameFolder(File file, File file2) throws IOException {
        String string;
        Node node = XmlParserHelper.parseXMLRoot(file2, this.getValidXmlRootNodeNames());
        Node node2 = node.getAttributes().getNamedItem("name");
        String string2 = string = node2 != null ? node2.getNodeValue() : FileHelper.getFileName(file2);
        if (file.getName().equals(string)) {
            return file;
        }
        File file3 = this.findNewFolderName(file, string);
        new RetryOnIOException(() -> Files.move(file.toPath(), file3.toPath(), new CopyOption[0])).tryAndThrowLast(new Time.Seconds(1.0), new Time.MilliSeconds(100L));
        return file3;
    }

    private File findNewFolderName(File file, String string) {
        String string2 = FileHelper.createValidFolderName(string);
        File file2 = new File(file.getParentFile(), string2);
        int n = 1;
        while (file2.exists()) {
            file2 = new File(file.getParentFile(), string2 + "_" + n);
            ++n;
        }
        return file2;
    }

    protected boolean renameFile(File file, String string, String string2) {
        File file2 = new File(file, string);
        if (file2.exists()) {
            try {
                Files.move(file2.toPath(), new File(file, string2).toPath(), new CopyOption[0]);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            return true;
        }
        return false;
    }

    protected void renameAdditionalFiles(File file, File file2) {
        this.renameAdditionalFiles(file, file2, file.getName());
    }

    protected abstract void renameAdditionalFiles(File var1, File var2, String var3);

    protected abstract String getTypeFilename();

    protected abstract String[] getValidXmlRootNodeNames();

    public static class MeasurementLegacyFileFormat
    extends LegacyFileFormat {
        private final String[] filenamePatterns = new String[]{"%s.xml", "%s.raw", "%s.hdr", "%s_raw.png", "darkref_%s.raw", "darkref_%s.hdr", "whiteref_%s.raw", "whiteref_%s.hdr", "%s_prediction.raw", "%s_prediction.hdr"};

        @Override
        protected String getTypeFilename() {
            return "measurement";
        }

        @Override
        protected String[] getValidXmlRootNodeNames() {
            return new String[]{"measurement", "sample"};
        }

        public void renameAdditionalFiles(File file, String string) {
            this.renameAdditionalFiles(file, file, string);
        }

        @Override
        protected void renameAdditionalFiles(File file, File file2, String string) {
            for (String string2 : this.filenamePatterns) {
                String string3 = String.format(string2, string);
                String string4 = String.format(string2, this.getTypeFilename());
                this.renameFile(file2, string3, string4);
            }
        }
    }

    public static class GroupLegacyFileFormat
    extends LegacyFileFormat {
        @Override
        protected String getTypeFilename() {
            return "group";
        }

        @Override
        protected String[] getValidXmlRootNodeNames() {
            return new String[]{"group", "design"};
        }

        @Override
        protected void renameAdditionalFiles(File file, File file2, String string) {
        }
    }

    public static class WorkflowLegacyFileFormat
    extends LegacyFileFormat {
        @Override
        protected String getTypeFilename() {
            return "workflow";
        }

        @Override
        protected String[] getValidXmlRootNodeNames() {
            return new String[]{"workflow"};
        }

        @Override
        protected void renameAdditionalFiles(File file, File file2, String string) {
        }
    }

    public static class AnalyseLegacyFileFormat
    extends LegacyFileFormat {
        @Override
        protected void renameAdditionalFiles(File file, File file2, String string) {
            this.renameFile(file2, file.getName() + ".map", this.getTypeFilename() + ".map");
        }

        @Override
        protected String getTypeFilename() {
            return "model";
        }

        @Override
        protected String[] getValidXmlRootNodeNames() {
            return new String[]{"model", "workflow"};
        }
    }
}

