/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.legacy;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import se.prediktera.breeze.common.entry.measurement.MeasurementFileLocation;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.legacy.LegacyFileFormat;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.test.MockBreezeTestProperties;
import se.prediktera.breeze.test.SlowTestCategory;
import se.prediktera.breeze.util.FileWithStringContent;

@Category(value={SlowTestCategory.class})
public class LegacyFileFormatTest
extends MockBreezeTestProperties {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private static final String analyseLegacyXmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<workflow xmlns=\"UmBio.XML.ModelXml\" createdby=\"Administrator \" createddate=\"20161017095206\" id=\"spectral_sample_uid\" name=\"spectral_sample\">\r\n  <description/>\r\n  <settings>\r\n    <ppclass>se.prediktera.breeze.frontend.wizard.model.SampleModelWizard</ppclass>\r\n    <type>Sample</type>\r\n    <modelling>\r\n      <sample>\r\n        <reduce>2</reduce>\r\n        <number_of_samples>9</number_of_samples>\r\n        <snv>true</snv>\r\n        <excludeWavelengthsBeginningPercent>4</excludeWavelengthsBeginningPercent>\r\n        <excludeWavelengthsEndPercent>4</excludeWavelengthsEndPercent>\r\n      </sample>\r\n    </modelling>\r\n    <project>spectral_sample.map</project>\r\n  </settings>\r\n  <comments/>\r\n  <identifiers/>\r\n  <variables>\r\n    <qualitative id=\"\" name=\"SampleCategory\">\r\n      <index>0</index>\r\n      <editable>true</editable>\r\n      <class name=\"-\">\r\n        <color>red</color>\r\n      </class>\r\n      <class name=\"Sample\">\r\n        <color>#3ad23a</color>\r\n      </class>\r\n    </qualitative>\r\n  </variables>\r\n  <setup>\r\n    <variables/>\r\n    <samples>\r\n      <sample uid=\"A000002\">0</sample>\r\n      <sample uid=\"A000003\">0</sample>\r\n      <sample uid=\"A000004\">0</sample>\r\n      <sample uid=\"A000005\">0</sample>\r\n      <sample uid=\"A000006\">0</sample>\r\n      <sample uid=\"A000007\">0</sample>\r\n      <sample uid=\"A000008\">0</sample>\r\n    </samples>\r\n    <tests/>\r\n    <wavelengths>\r\n      <wavelength uid=\"index\">0,1,2,3,4,5,6,7,8,9</wavelength>\r\n    </wavelengths>\r\n    <properties>\r\n      <property key=\"snv\" value=\"true\"/>\r\n      <property key=\"calibrated\" value=\"true\"/>\r\n    </properties>\r\n  </setup>\r\n  <recordgroups>\r\n    <recordgroup recordid=\"spectral\" recordname=\"spectral\" studyid=\"spectral\" studyname=\"spectral\"/>\r\n  </recordgroups>\r\n</workflow>\r\n";
    private static String workflowLegacyXmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<workflow xmlns=\"Prediktera.XML.WorkflowXml\" createdby=\"Administrator \" createddate=\"20170210113740\" id=\"33761b19\" name=\"spectral_workflow\">\r\n  <settings>\r\n    <keyword>\r\n      <customer/>\r\n      <field/>\r\n      <application/>\r\n      <project/>\r\n    </keyword>\r\n    <measure>\r\n      <maxlines>10000</maxlines>\r\n    </measure>\r\n  </settings>\r\n  <comments/>\r\n  <identifiers>\r\n    <identifier>Name</identifier>\r\n  </identifiers>\r\n  <variables>\r\n    <qualitative id=\"e02f2b46\" name=\"Type\">\r\n      <class name=\"-\">\r\n        <color>red</color>\r\n      </class>\r\n      <class name=\"B\">\r\n        <color>#3ad23a</color>\r\n      </class>\r\n      <class name=\"V\">\r\n        <color>#4664be</color>\r\n      </class>\r\n      <class name=\"P\">\r\n        <color>#f6f76d</color>\r\n      </class>\r\n    </qualitative>\r\n    <quantitative id=\"abff2563\" name=\"B\" unit=\"%\">\r\n      <low>0.0</low>\r\n      <high>100.0</high>\r\n      <levels>2</levels>\r\n      <default/>\r\n    </quantitative>\r\n    <quantitative id=\"7d7fdb77\" name=\"V\" unit=\"%\">\r\n      <low>0.0</low>\r\n      <high>100.0</high>\r\n      <levels>2</levels>\r\n      <default/>\r\n    </quantitative>\r\n    <quantitative id=\"2ef49ecf\" name=\"P\" unit=\"%\">\r\n      <low>0.0</low>\r\n      <high>100.0</high>\r\n      <levels>2</levels>\r\n      <default/>\r\n    </quantitative>\r\n  </variables>\r\n  <descriptors>\r\n    <context name=\"workflow\">\r\n      <graph name=\"workflow\" type=\"evaluation\">\r\n        <function type=\"None\">\r\n          <function addsamples=\"true\" type=\"ModelSegmentation\">\r\n            <param name=\"analyse\">f7053a6c</param>\r\n            <param name=\"minarea\">5</param>\r\n            <param name=\"shrink\">0</param>\r\n            <param name=\"object\" type=\"NORMAL\"/>\r\n            <function alias=\"-\" type=\"Port\"/>\r\n            <function alias=\"Sample\" type=\"Port\"/>\r\n          </function>\r\n        </function>\r\n      </graph>\r\n    </context>\r\n  </descriptors>\r\n  <visualisation/>\r\n</workflow>\r\n";
    private static final String groupLegacyXmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<design xmlns=\"UmBio.XML.GroupXml\" createdby=\"Administrator \" createddate=\"20161013085234\" id=\"existinggroupuid\" name=\"spectral group name\">\r\n  <description/>\r\n  <descriptors>\r\n    <context name=\"sample\">\r\n      <graph enabled=\"true\" name=\"workflow\" type=\"evaluation\">\r\n        <function type=\"None\">\r\n          <function type=\"ModelSegmentation\">\r\n            <param name=\"analyse\">spectral_sample</param>\r\n            <param name=\"minarea\">5</param>\r\n            <param name=\"shrink\">0</param>\r\n            <param name=\"separate\">false</param>\r\n            <function alias=\"-\" type=\"Port\"/>\r\n            <function alias=\"Sample\" type=\"Port\"/>\r\n          </function>\r\n        </function>\r\n      </graph>\r\n    </context>\r\n    <context name=\"measurement\">\r\n      <graph enabled=\"true\" name=\"Warning\" type=\"evaluation\">\r\n        <function type=\"Logical\">\r\n          <param name=\"operator\" type=\"OR\"/>\r\n          <function alias=\"WM0001\" type=\"Logical\">\r\n            <param name=\"operator\" type=\"GREATER\"/>\r\n            <function id=\"4\" output=\"max\" type=\"Reference\">\r\n              <param name=\"value\">white</param>\r\n            </function>\r\n            <function type=\"Math\">\r\n              <param name=\"function\" type=\"MULT\"/>\r\n              <function type=\"MetaData\">\r\n                <param name=\"metakey\">MaxSignal</param>\r\n              </function>\r\n              <function type=\"Value\">\r\n                <param name=\"value\">0.95</param>\r\n              </function>\r\n            </function>\r\n          </function>\r\n          <function alias=\"WM0002\" type=\"Logical\">\r\n            <param name=\"operator\" type=\"LESS\"/>\r\n            <function id=\"5\" output=\"max\" type=\"Reference\">\r\n              <param name=\"value\">white</param>\r\n            </function>\r\n            <function type=\"Math\">\r\n              <param name=\"function\" type=\"MULT\"/>\r\n              <function type=\"MetaData\">\r\n                <param name=\"metakey\">MaxSignal</param>\r\n              </function>\r\n              <function type=\"Value\">\r\n                <param name=\"value\">0.5</param>\r\n              </function>\r\n            </function>\r\n          </function>\r\n          <function alias=\"WM0003\" type=\"Logical\">\r\n            <param name=\"operator\" type=\"GREATER\">0.2</param>\r\n            <function type=\"Math\">\r\n              <param name=\"function\" type=\"DIV\"/>\r\n              <function type=\"MetaData\">\r\n                <param name=\"metakey\">DroppedFrames</param>\r\n              </function>\r\n              <function type=\"MetaData\">\r\n                <param name=\"metakey\">Frames</param>\r\n              </function>\r\n            </function>\r\n          </function>\r\n          <function alias=\"WM0004\" type=\"Logical\">\r\n            <param name=\"operator\" type=\"GREATER\">0.25</param>\r\n            <function id=\"6\" output=\"stderr\" type=\"Reference\">\r\n              <param name=\"value\">white</param>\r\n            </function>\r\n          </function>\r\n        </function>\r\n      </graph>\r\n    </context>\r\n    <context name=\"group\">\r\n      <graph enabled=\"true\" name=\"Measurements\" type=\"evaluation\">\r\n        <function id=\"0\" output=\"count\" type=\"CountEntry\">\r\n          <param name=\"depth\">1</param>\r\n        </function>\r\n      </graph>\r\n      <graph enabled=\"true\" name=\"Samples\" type=\"evaluation\">\r\n        <function id=\"1\" output=\"count\" type=\"CountEntry\">\r\n          <param name=\"depth\">2</param>\r\n        </function>\r\n      </graph>\r\n      <graph enabled=\"true\" name=\"Grayed\" type=\"evaluation\">\r\n        <function type=\"Logical\">\r\n          <param name=\"operator\" type=\"NOTEQUALS\"/>\r\n          <function id=\"2\" output=\"count\" type=\"CountEntry\">\r\n            <param name=\"depth\">1</param>\r\n          </function>\r\n          <function id=\"3\" output=\"measured\" type=\"CountMeasured\"/>\r\n        </function>\r\n      </graph>\r\n    </context>\r\n    <values>\r\n      <value id=\"0\">7.0</value>\r\n      <value id=\"1\">7.0</value>\r\n      <value id=\"2\">7.0</value>\r\n      <value id=\"3\">7.0</value>\r\n    </values>\r\n  </descriptors>\r\n  <settings>\r\n    <workflow>\r\n      <sample/>\r\n      <id>spectral</id>\r\n    </workflow>\r\n    <keyword>\r\n      <customer/>\r\n      <field/>\r\n      <application/>\r\n      <project/>\r\n    </keyword>\r\n    <modelling>\r\n      <reduce>1</reduce>\r\n      <substractlines>false</substractlines>\r\n      <shrink>0</shrink>\r\n      <exclude>\r\n        <lines>0</lines>\r\n      </exclude>\r\n      <scripts>\r\n        <script/>\r\n      </scripts>\r\n      <sample>\r\n        <reduce>2</reduce>\r\n        <number_of_samples>9</number_of_samples>\r\n      </sample>\r\n    </modelling>\r\n    <preview>\r\n      <excludebackground>false</excludebackground>\r\n    </preview>\r\n  </settings>\r\n  <images/>\r\n  <comments/>\r\n  <measurements>\r\n    <measurement createdby=\"Administrator \" createddate=\"20161013085236\" id=\"A000008\" name=\"Measurement (6)\">\r\n      <comments/>\r\n      <images/>\r\n      <descriptors>\r\n        <values>\r\n          <value id=\"4\">13736.0</value>\r\n          <value id=\"5\">13736.0</value>\r\n          <value id=\"6\">0.09546813</value>\r\n        </values>\r\n      </descriptors>\r\n      <samples>\r\n        <sample>\r\n          <identifiers/>\r\n          <variables>\r\n            <qualitative id=\"AF000005\" index=\"3\">-</qualitative>\r\n            <quantitative id=\"AF000002\" index=\"0\">50</quantitative>\r\n            <quantitative id=\"AF000003\" index=\"1\">0</quantitative>\r\n            <quantitative id=\"AF000004\" index=\"2\">50</quantitative>\r\n          </variables>\r\n          <descriptors>\r\n            <values/>\r\n          </descriptors>\r\n        </sample>\r\n      </samples>\r\n    </measurement>\r\n  </measurements>\r\n</design>\r\n";
    private static final String measurementLegacyXmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<sample xmlns=\"UmBio.XML.MeasurementXml\" id=\"A000002\" name=\"Measurement HELLO\">\r\n  <files>\r\n    <samplefile file=\"A000002.raw\" header=\"A000002.hdr\"/>\r\n    <references>\r\n      <reference file=\"darkref_A000002.raw\" header=\"darkref_A000002.hdr\" reflectance=\"0\"/>\r\n      <reference file=\"whiteref_A000002.raw\" header=\"whiteref_A000002.hdr\" reflectance=\"100\"/>\r\n    </references>\r\n  </files>\r\n  <metadata>\r\n    <data name=\"Time\">20161013085235</data>\r\n    <data name=\"DoE\">spectral</data>\r\n    <data name=\"CreatedBy\">Administrator </data>\r\n    <data name=\"Instrument\"/>\r\n    <data name=\"FieldOfView\">10.0</data>\r\n    <data name=\"Length\">10.0</data>\r\n    <data name=\"Resolution\">1</data>\r\n    <data name=\"Speed\">100</data>\r\n    <data name=\"CameraType\">PowderSmall</data>\r\n    <data name=\"CameraName\">FileReader</data>\r\n    <data name=\"FrameRate\">100</data>\r\n    <data name=\"Frames\">10</data>\r\n    <data name=\"MaxSignal\">16384</data>\r\n    <data name=\"PixelsPerLine\">10</data>\r\n    <data name=\"Wavelength\">10</data>\r\n    <data name=\"IntegrationTime\">1000</data>\r\n  </metadata>\r\n  <comments/>\r\n  <settings>\r\n    <dimension>\r\n      <insets/>\r\n    </dimension>\r\n    <changed>false</changed>\r\n  </settings>\r\n  <samples>\r\n    <sample>\r\n      <identifiers/>\r\n      <settings>\r\n        <path>[11,2]1,2,8,2,8,7,9,7,9,9,3,9,3,6,2,6,2,3,1,3,1,2</path>\r\n        <average>[26,10]0.23276459,0.19670933,0.2096425,0.31896836,0.30023545,0.32607913,0.30764243,0.4341675,0.52953523,0.6642564,0.6688117,0.67803305,0.69460136,0.72067535,0.72359794,0.7782286,0.7800489,0.77736676,0.8936969,1.0438027,0.74642456,0.74368405,0.7648808,0.79564667,0.79394627,0.8527288,0.85105205,0.8383655,0.9891999,1.1299181,0.16740616,0.12805888,0.1437552,0.26870784,0.24530314,0.2564957,0.23900336,0.39053684,0.46663854,0.60039204,0.3894282,0.37366477,0.37979105,0.48772928,0.47263438,0.5068892,0.48069057,0.60343456,0.6966268,0.83227515,0.6910175,0.686059,0.6977968,0.7189257,0.71880066,0.77453303,0.7690991,0.75441575,0.88760614,1.0459505,0.10904664,0.06504679,0.08430423,0.23636091,0.215965,0.22353055,0.20230669,0.38654193,0.46149412,0.59468096,0.18926759,0.10716328,0.11427363,0.2435244,0.21994708,0.24345669,0.21815777,0.37999207,0.47424665,0.6141311,0.41935438,0.40506962,0.41737652,0.5059206,0.49238157,0.56808805,0.5359175,0.61405605,0.78407705,0.93518275,0.11678785,0.06441767,0.07765764,0.21939254,0.1944074,0.20174517,0.17997861,0.35906762,0.43719342,0.56561315,0.08170906,0.030915527,0.04545118,0.17234065,0.1538281,0.16378416,0.14478745,0.30790693,0.37842909,0.5217496,0.07998422,0.04036532,0.053024832,0.1782828,0.1604522,0.19034603,0.16757604,0.32464424,0.4234732,0.54417187,0.0945517,0.047773913,0.06526679,0.21370369,0.19430277,0.20562838,0.18656914,0.3595434,0.4447459,0.5625983,0.6193782,0.58265287,0.6016086,0.63228446,0.64058197,0.6923692,0.6994828,0.69038475,0.8227984,0.95502144,0.09307158,0.03804953,0.05272414,0.18533762,0.16719548,0.18079245,0.16163142,0.32609022,0.39996964,0.53145623,0.14503664,0.07092763,0.073542304,0.22753014,0.19574878,0.20472842,0.18059164,0.37566322,0.45809764,0.60517025,0.06393184,0.022197772,0.03856609,0.1729417,0.15073971,0.1630085,0.14491293,0.32027057,0.3886368,0.52574146,0.05052997,0.005888823,0.01863585,0.15148759,0.13254371,0.14401288,0.12797375,0.30069485,0.37332815,0.512576,0.68598944,0.7095402,0.7176748,0.7440958,0.73719543,0.8005246,0.78376544,0.7694029,0.9229011,1.0576347,0.13882716,0.08495017,0.10044705,0.23840515,0.21647088,0.22815393,0.21148518,0.39325008,0.47376156,0.6053032,0.1535868,0.10891603,0.12216868,0.2756086,0.24953789,0.27371627,0.24897817,0.42555317,0.52027357,0.64622414,0.054213934,0.024355922,0.040306702,0.17115392,0.1502754,0.16091242,0.14280626,0.30723765,0.3836285,0.5113365,0.013953292,-0.033140164,-0.028788345,0.076261334,0.05175971,0.05939238,0.031280354,0.15627837,0.2516949,0.3553212,0.073678136,0.027750865,0.039942782,0.17198429,0.1531182,0.16514966,0.14734316,0.30947965,0.3889366,0.53134996,0.12673114,0.08369874,0.098387495,0.2279175,0.20594576,0.2198772,0.2007877,0.37194636,0.4492447,0.6037867,0.16934077,0.13913517,0.15768225,0.2898369,0.26371267,0.2764015,0.25298926,0.42012042,0.5020481,0.6594805</average>\r\n      </settings>\r\n      <variables>\r\n        <qualitative id=\"AF000005\" index=\"3\" name=\"Type\">\r\n          <class>V</class>\r\n        </qualitative>\r\n        <quantitative id=\"AF000002\" index=\"0\" name=\"B\" unit=\"%\">\r\n          <value>0</value>\r\n        </quantitative>\r\n        <quantitative id=\"AF000003\" index=\"1\" name=\"V\" unit=\"%\">\r\n          <value>100</value>\r\n        </quantitative>\r\n        <quantitative id=\"AF000004\" index=\"2\" name=\"P\" unit=\"%\">\r\n          <value>0</value>\r\n        </quantitative>\r\n      </variables>\r\n      <descriptors>\r\n        <values/>\r\n      </descriptors>\r\n    </sample>\r\n  </samples>\r\n</sample>";

    @Test
    public void shouldFindLegacyXmlAndRenameXmlFileOnLoad() throws IOException {
        File file = this.tempFolder.newFolder("existinguid");
        new FileWithStringContent("<rootnode name=\"somename\"></rootnode>").writtenTo(new File(file, "existinguid.xml"));
        File file2 = this.genericFormat("dummy", "rootnode").renameIfNeeded(file);
        MatcherAssert.assertThat((Object)file2.getName(), (Matcher)CoreMatchers.is((Object)"somename"));
        MatcherAssert.assertThat((Object)new File(file, "existinggui.xml").exists(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)new File(file2, "dummy.xml").exists(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldRenameWithIndexIfFolderAlreadyExists() throws IOException {
        File file = this.tempFolder.newFolder("existinguid");
        new FileWithStringContent("<rootnode name=\"somename\"></rootnode>").writtenTo(new File(file, "existinguid.xml"));
        this.tempFolder.newFolder("somename");
        File file2 = this.genericFormat("dummy", "rootnode").renameIfNeeded(file);
        MatcherAssert.assertThat((Object)file2.getName(), (Matcher)CoreMatchers.is((Object)"somename_1"));
        MatcherAssert.assertThat((Object)new File(file, "existinggui.xml").exists(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)new File(file2, "dummy.xml").exists(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldRenameWithHigherIndexIfIndexFolderAlreadyExists() throws IOException {
        File file = this.tempFolder.newFolder("existinguid");
        new FileWithStringContent("<rootnode name=\"somename\"></rootnode>").writtenTo(new File(file, "existinguid.xml"));
        this.tempFolder.newFolder("somename");
        this.tempFolder.newFolder("somename_1");
        this.tempFolder.newFolder("somename_2");
        File file2 = this.genericFormat("dummy", "rootnode").renameIfNeeded(file);
        MatcherAssert.assertThat((Object)file2.getName(), (Matcher)CoreMatchers.is((Object)"somename_3"));
        MatcherAssert.assertThat((Object)new File(file, "existinggui.xml").exists(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)new File(file2, "dummy.xml").exists(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldNotRenameWithIndexOnMatchingLegacyNameAndUid() throws IOException {
        File file = this.tempFolder.newFolder("somename");
        new FileWithStringContent("<rootnode name=\"somename\"></rootnode>").writtenTo(new File(file, "somename.xml"));
        File file2 = this.genericFormat("dummy", "rootnode").renameIfNeeded(file);
        MatcherAssert.assertThat((Object)file2.getName(), (Matcher)CoreMatchers.is((Object)"somename"));
        MatcherAssert.assertThat((Object)new File(file, "somename.xml").exists(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)new File(file2, "dummy.xml").exists(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldTrimInvalidNameBeforeRename() throws IOException {
        File file = this.tempFolder.newFolder("someuid");
        new FileWithStringContent("<rootnode name=\"some name \"></rootnode>").writtenTo(new File(file, "someuid.xml"));
        File file2 = this.genericFormat("dummy", "rootnode").renameIfNeeded(file);
        MatcherAssert.assertThat((Object)file2.getName(), (Matcher)CoreMatchers.is((Object)"some name"));
        MatcherAssert.assertThat((Object)new File(file, "somename.xml").exists(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)new File(file2, "dummy.xml").exists(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldCleanupWeirdCharsFromNameBeforeRename() throws IOException {
        File file = this.tempFolder.newFolder("someuid");
        new FileWithStringContent("<rootnode name=\"/#)(\u00a4%/\u00a4#()\\#\u00a4\"></rootnode>").writtenTo(new File(file, "someuid.xml"));
        File file2 = this.genericFormat("dummy", "rootnode").renameIfNeeded(file);
        MatcherAssert.assertThat((Object)file2.getName(), (Matcher)CoreMatchers.is((Object)"______________"));
        MatcherAssert.assertThat((Object)new File(file, "somename.xml").exists(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)new File(file2, "dummy.xml").exists(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldCleanupTotallyCrazyNameBeforeRename() throws IOException {
        File file = this.tempFolder.newFolder("someuid");
        new FileWithStringContent("<rootnode name=\"\\\\\\\\\"></rootnode>").writtenTo(new File(file, "someuid.xml"));
        File file2 = this.genericFormat("dummy", "rootnode").renameIfNeeded(file);
        MatcherAssert.assertThat((Object)file2.getName(), (Matcher)CoreMatchers.is((Object)"____"));
        MatcherAssert.assertThat((Object)new File(file, "somename.xml").exists(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)new File(file2, "dummy.xml").exists(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldCleanupTotallyCrazyNameBeforeRenameAndAddIndexIfNeeded() throws IOException {
        File file = this.tempFolder.newFolder("someuid");
        new FileWithStringContent("<rootnode name=\"\\\\\\\\\"></rootnode>").writtenTo(new File(file, "someuid.xml"));
        this.tempFolder.newFolder("____");
        File file2 = this.genericFormat("dummy", "rootnode").renameIfNeeded(file);
        MatcherAssert.assertThat((Object)file2.getName(), (Matcher)CoreMatchers.is((Object)"_____1"));
        MatcherAssert.assertThat((Object)new File(file, "somename.xml").exists(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)new File(file2, "dummy.xml").exists(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldAbortLegacyRenameOnAccessDenied() throws IOException {
        Assume.assumeTrue((boolean)System.getProperty("os.name").startsWith("Windows"));
        File file = this.tempFolder.newFolder("existinguid");
        File file2 = new FileWithStringContent("<rootnode name=\"somename\"></rootnode>").writtenTo(new File(file, "existinguid.xml"));
        try (FileInputStream fileInputStream = new FileInputStream(file2);){
            try {
                this.genericFormat("dummy", "rootnode").renameIfNeeded(file);
                Assert.fail((String)"open should fail");
            }
            catch (Exception exception) {
                MatcherAssert.assertThat((Object)file2.exists(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((String)"cause should be access denied", (boolean)(exception.getCause() instanceof AccessDeniedException));
            }
        }
    }

    @Test
    public void analyse_shouldFindLegacyXmlAndRenameXmlAndMapFileOnLoad() throws IOException {
        File file = this.tempFolder.newFolder("existinguid");
        new FileWithStringContent(analyseLegacyXmlString).writtenTo(new File(file, "existinguid.xml"));
        new File(file, "existinguid.map").createNewFile();
        Analyse analyse = new Analyse(file){

            @Override
            protected File getParentFolder() {
                return LegacyFileFormatTest.this.tempFolder.getRoot();
            }
        };
        MatcherAssert.assertThat((Object)analyse.getName(), (Matcher)CoreMatchers.is((Object)"spectral_sample"));
        MatcherAssert.assertThat((Object)analyse.getFolder().getName(), (Matcher)CoreMatchers.is((Object)"spectral_sample"));
        MatcherAssert.assertThat((Object)new File(analyse.getFolder(), "existinguid.xml").exists(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)new File(analyse.getFolder(), "existinguid.map").exists(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)new File(analyse.getFolder(), "model.xml").exists(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)new File(analyse.getFolder(), "model.map").exists(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void workflow_shouldFindLegacyXmlAndRenameOnLoad() throws IOException {
        File file = this.tempFolder.newFolder("existinguid");
        new FileWithStringContent(workflowLegacyXmlString).writtenTo(new File(file, "existinguid.xml"));
        Workflow workflow = new Workflow(file);
        MatcherAssert.assertThat((Object)workflow.getName(), (Matcher)CoreMatchers.is((Object)"spectral_workflow"));
        MatcherAssert.assertThat((Object)workflow.getFolder().getName(), (Matcher)CoreMatchers.is((Object)"spectral_workflow"));
        MatcherAssert.assertThat((Object)new File(workflow.getFolder(), "existinguid.xml").exists(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)new File(workflow.getFolder(), "workflow.xml").exists(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void group_shouldFindLegacyXmlAndRenameOnLoad() throws IOException {
        Workflow workflow = new Workflow("workflowname", this.tempFolder.getRoot());
        workflow.save();
        File file = new File(workflow.getFolder(), "existinggroupuid");
        new FileWithStringContent(groupLegacyXmlString).writtenTo(new File(file, "existinggroupuid.xml"));
        Group group = new Group(file, workflow);
        MatcherAssert.assertThat((Object)group.getName(), (Matcher)CoreMatchers.is((Object)"spectral group name"));
        MatcherAssert.assertThat((Object)group.getFolder().getName(), (Matcher)CoreMatchers.is((Object)"spectral group name"));
        MatcherAssert.assertThat((Object)new File(group.getFolder(), "existinguid.xml").exists(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)new File(group.getFolder(), "group.xml").exists(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void measurement_shouldFindLegacyXmlAndRenameOnLoad() throws IOException {
        Workflow workflow = new Workflow("workflowname", this.tempFolder.getRoot());
        workflow.save();
        Group group = new Group("groupname", workflow);
        group.save();
        File file = new File(group.getFolder(), "A000002");
        new FileWithStringContent(measurementLegacyXmlString).writtenTo(new File(file, "A000002.xml"));
        String[] stringArray = new String[]{"A000002.raw", "A000002.hdr", "A000002_raw.png", "darkref_A000002.raw", "darkref_A000002.hdr", "whiteref_A000002.raw", "whiteref_A000002.hdr", "A000002_prediction.raw", "A000002_prediction.hdr"};
        for (String string : stringArray) {
            new File(file, string).createNewFile();
        }
        Measurement measurement = new Measurement(new LegacyFileFormat.MeasurementLegacyFileFormat().renameIfNeeded(file), group);
        MatcherAssert.assertThat((Object)measurement.getName(), (Matcher)CoreMatchers.is((Object)"Measurement HELLO"));
        MatcherAssert.assertThat((Object)measurement.getFolder().getName(), (Matcher)CoreMatchers.is((Object)"Measurement HELLO"));
        for (String string : stringArray) {
            MatcherAssert.assertThat((Object)new File(measurement.getFolder(), string).exists(), (Matcher)CoreMatchers.is((Object)false));
        }
        MatcherAssert.assertThat((Object)new File(measurement.getFolder(), "measurement.xml").exists(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((String)"measurement finds all files", (boolean)new MeasurementFileLocation.Raw().file(measurement).exists());
        MatcherAssert.assertThat((String)"measurement finds all files", (boolean)new MeasurementFileLocation.Raw().header(measurement).exists());
        MatcherAssert.assertThat((String)"measurement finds all files", (boolean)measurement.getThumbnailFile().exists());
        MatcherAssert.assertThat((String)"measurement finds all files", (boolean)measurement.hasReferences());
        MatcherAssert.assertThat((String)"measurement finds all files", (boolean)measurement.getPredictionRawFile().exists());
        MatcherAssert.assertThat((String)"measurement finds all files", (boolean)measurement.getPredictionHdrFile().exists());
    }

    private LegacyFileFormat genericFormat(final String string, final String string2) {
        return new LegacyFileFormat(this){

            @Override
            protected void renameAdditionalFiles(File file, File file2, String string3) {
            }

            @Override
            protected String getTypeFilename() {
                return string;
            }

            @Override
            protected String[] getValidXmlRootNodeNames() {
                return new String[]{string2};
            }
        };
    }
}

