/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.legacy;

import java.io.File;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import se.prediktera.breeze.common.util.StringFromFile;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.legacy.LegacyGroupToStudyFormat;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.test.MockBreezeTestProperties;
import se.prediktera.breeze.test.SlowTestCategory;
import se.prediktera.breeze.util.FileWithStringContent;

@Category(value={SlowTestCategory.class})
public class LegacyGroupToStudyFormatTest
extends MockBreezeTestProperties {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private static final String groupLegacyXmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<design xmlns=\"UmBio.XML.GroupXml\" createdby=\"Administrator \" createddate=\"20161013085234\" id=\"existinggroupuid\" name=\"spectral group name\">\r\n  <description/>\r\n  <descriptors>\r\n    <context name=\"sample\">\r\n      <graph enabled=\"true\" name=\"workflow\" type=\"evaluation\">\r\n        <function type=\"None\">\r\n          <function type=\"ModelSegmentation\">\r\n            <param name=\"analyse\">spectral_sample</param>\r\n            <param name=\"minarea\">5</param>\r\n            <param name=\"shrink\">0</param>\r\n            <param name=\"separate\">false</param>\r\n            <function alias=\"-\" type=\"Port\"/>\r\n            <function alias=\"Sample\" type=\"Port\"/>\r\n          </function>\r\n        </function>\r\n      </graph>\r\n    </context>\r\n    <context name=\"measurement\">\r\n      <graph enabled=\"true\" name=\"Warning\" type=\"evaluation\">\r\n        <function type=\"Logical\">\r\n          <param name=\"operator\" type=\"OR\"/>\r\n          <function alias=\"WM0001\" type=\"Logical\">\r\n            <param name=\"operator\" type=\"GREATER\"/>\r\n            <function id=\"4\" output=\"max\" type=\"Reference\">\r\n              <param name=\"value\">white</param>\r\n            </function>\r\n            <function type=\"Math\">\r\n              <param name=\"function\" type=\"MULT\"/>\r\n              <function type=\"MetaData\">\r\n                <param name=\"metakey\">MaxSignal</param>\r\n              </function>\r\n              <function type=\"Value\">\r\n                <param name=\"value\">0.95</param>\r\n              </function>\r\n            </function>\r\n          </function>\r\n          <function alias=\"WM0002\" type=\"Logical\">\r\n            <param name=\"operator\" type=\"LESS\"/>\r\n            <function id=\"5\" output=\"max\" type=\"Reference\">\r\n              <param name=\"value\">white</param>\r\n            </function>\r\n            <function type=\"Math\">\r\n              <param name=\"function\" type=\"MULT\"/>\r\n              <function type=\"MetaData\">\r\n                <param name=\"metakey\">MaxSignal</param>\r\n              </function>\r\n              <function type=\"Value\">\r\n                <param name=\"value\">0.5</param>\r\n              </function>\r\n            </function>\r\n          </function>\r\n          <function alias=\"WM0003\" type=\"Logical\">\r\n            <param name=\"operator\" type=\"GREATER\">0.2</param>\r\n            <function type=\"Math\">\r\n              <param name=\"function\" type=\"DIV\"/>\r\n              <function type=\"MetaData\">\r\n                <param name=\"metakey\">DroppedFrames</param>\r\n              </function>\r\n              <function type=\"MetaData\">\r\n                <param name=\"metakey\">Frames</param>\r\n              </function>\r\n            </function>\r\n          </function>\r\n          <function alias=\"WM0004\" type=\"Logical\">\r\n            <param name=\"operator\" type=\"GREATER\">0.25</param>\r\n            <function id=\"6\" output=\"stderr\" type=\"Reference\">\r\n              <param name=\"value\">white</param>\r\n            </function>\r\n          </function>\r\n        </function>\r\n      </graph>\r\n    </context>\r\n    <context name=\"group\">\r\n      <graph enabled=\"true\" name=\"Measurements\" type=\"evaluation\">\r\n        <function id=\"0\" output=\"count\" type=\"CountEntry\">\r\n          <param name=\"depth\">1</param>\r\n        </function>\r\n      </graph>\r\n      <graph enabled=\"true\" name=\"Samples\" type=\"evaluation\">\r\n        <function id=\"1\" output=\"count\" type=\"CountEntry\">\r\n          <param name=\"depth\">2</param>\r\n        </function>\r\n      </graph>\r\n      <graph enabled=\"true\" name=\"Grayed\" type=\"evaluation\">\r\n        <function type=\"Logical\">\r\n          <param name=\"operator\" type=\"NOTEQUALS\"/>\r\n          <function id=\"2\" output=\"count\" type=\"CountEntry\">\r\n            <param name=\"depth\">1</param>\r\n          </function>\r\n          <function id=\"3\" output=\"measured\" type=\"CountMeasured\"/>\r\n        </function>\r\n      </graph>\r\n    </context>\r\n    <values>\r\n      <value id=\"0\">7.0</value>\r\n      <value id=\"1\">7.0</value>\r\n      <value id=\"2\">7.0</value>\r\n      <value id=\"3\">7.0</value>\r\n    </values>\r\n  </descriptors>\r\n  <settings>\r\n    <workflow>\r\n      <sample/>\r\n      <id>spectral</id>\r\n    </workflow>\r\n    <keyword>\r\n      <customer/>\r\n      <field/>\r\n      <application/>\r\n      <project/>\r\n    </keyword>\r\n    <modelling>\r\n      <reduce>1</reduce>\r\n      <substractlines>false</substractlines>\r\n      <shrink>0</shrink>\r\n      <exclude>\r\n        <lines>0</lines>\r\n      </exclude>\r\n      <scripts>\r\n        <script/>\r\n      </scripts>\r\n      <sample>\r\n        <reduce>2</reduce>\r\n        <number_of_samples>9</number_of_samples>\r\n      </sample>\r\n    </modelling>\r\n    <preview>\r\n      <excludebackground>false</excludebackground>\r\n    </preview>\r\n  </settings>\r\n  <images/>\r\n  <comments/>\r\n  <measurements>\r\n    <measurement createdby=\"Administrator \" createddate=\"20161013085236\" id=\"A000008\" name=\"Measurement (6)\">\r\n      <comments/>\r\n      <images/>\r\n      <descriptors>\r\n        <values>\r\n          <value id=\"4\">13736.0</value>\r\n          <value id=\"5\">13736.0</value>\r\n          <value id=\"6\">0.09546813</value>\r\n        </values>\r\n      </descriptors>\r\n      <samples>\r\n        <sample>\r\n          <identifiers/>\r\n          <variables>\r\n            <qualitative id=\"AF000005\" index=\"3\">-</qualitative>\r\n            <quantitative id=\"AF000002\" index=\"0\">50</quantitative>\r\n            <quantitative id=\"AF000003\" index=\"1\">0</quantitative>\r\n            <quantitative id=\"AF000004\" index=\"2\">50</quantitative>\r\n          </variables>\r\n          <descriptors>\r\n            <values/>\r\n          </descriptors>\r\n        </sample>\r\n      </samples>\r\n    </measurement>\r\n  </measurements>\r\n</design>\r\n";
    private static final String groupWithSameNameAndUidLegacyXmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<design xmlns=\"UmBio.XML.GroupXml\" createdby=\"Administrator \" createddate=\"20161013085234\" id=\"spectral group name\" name=\"spectral group name\">\r\n</design>\r\n";

    @Test
    public void shouldCreateStudyAndMoveGroupIntoStudy() {
        File file = new File(this.tempFolder.getRoot(), "existinggroupuid");
        new FileWithStringContent(groupLegacyXmlString).writtenTo(new File(file, "existinggroupuid.xml"));
        new FileWithStringContent("<dummyfile>").writtenTo(new File(file, "dummyfolder/dummyfile.txt"));
        Workflow workflow = LegacyGroupToStudyFormat.moveLegacyGroupIntoNewStudy(file);
        MatcherAssert.assertThat((Object)workflow.getName(), (Matcher)CoreMatchers.is((Object)"spectral group name"));
        MatcherAssert.assertThat((Object)workflow.getFolder().getName(), (Matcher)CoreMatchers.is((Object)"spectral group name"));
        Group group = workflow.getChild(0);
        MatcherAssert.assertThat((Object)group.getName(), (Matcher)CoreMatchers.is((Object)"spectral group name"));
        MatcherAssert.assertThat((Object)group.getUid(), (Matcher)CoreMatchers.is((Object)"existinggroupuid"));
        MatcherAssert.assertThat((Object)group.getParent(), (Matcher)CoreMatchers.is((Object)workflow));
        MatcherAssert.assertThat((Object)group.getFolder().getParentFile(), (Matcher)CoreMatchers.is((Object)workflow.getFolder()));
        MatcherAssert.assertThat((Object)group.getFolder().getName(), (Matcher)CoreMatchers.is((Object)"spectral group name"));
        MatcherAssert.assertThat((String)"dummy file has been moved", (Object)new StringFromFile(new File(group.getFolder(), "dummyfolder/dummyfile.txt")).toString(), (Matcher)CoreMatchers.is((Object)"<dummyfile>"));
        MatcherAssert.assertThat((String)"no other folders are left", (Object)this.tempFolder.getRoot().listFiles().length, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void shouldCreateStudyAndMoveGroupIntoStudyEvenIfNameIsSameAsUid() {
        File file = new File(this.tempFolder.getRoot(), "spectral group name");
        new FileWithStringContent(groupWithSameNameAndUidLegacyXmlString).writtenTo(new File(file, "spectral group name.xml"));
        Workflow workflow = LegacyGroupToStudyFormat.moveLegacyGroupIntoNewStudy(file);
        MatcherAssert.assertThat((Object)workflow.getName(), (Matcher)CoreMatchers.is((Object)"spectral group name"));
        MatcherAssert.assertThat((Object)workflow.getFolder().getName(), (Matcher)CoreMatchers.is((Object)"spectral group name"));
        Group group = workflow.getChild(0);
        MatcherAssert.assertThat((Object)group.getName(), (Matcher)CoreMatchers.is((Object)"spectral group name"));
        MatcherAssert.assertThat((Object)group.getUid(), (Matcher)CoreMatchers.is((Object)"spectral group name"));
        MatcherAssert.assertThat((Object)group.getParent(), (Matcher)CoreMatchers.is((Object)workflow));
        MatcherAssert.assertThat((Object)group.getFolder().getParentFile(), (Matcher)CoreMatchers.is((Object)workflow.getFolder()));
        MatcherAssert.assertThat((Object)group.getFolder().getName(), (Matcher)CoreMatchers.is((Object)"spectral group name"));
    }
}

