/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.measurement;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.backend.tree.groupandmeasurementtree.GroupAndMeasurementDefaultFunctionTreeListMap;
import se.prediktera.breeze.common.entry.ObjectWithChildren;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.measurement.MeasurementFileLocation;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNodeList;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluateResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorHolder;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorInterface;
import se.prediktera.breeze.common.realtime.descriptor.usgs.CoreReg;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.raw.CachedRawFile;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawFileImpl;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.IntegrationTime;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.BreezeRecycleBin;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.EntryData;
import se.prediktera.breeze.entry.MeasurementOrSample;
import se.prediktera.breeze.entry.comment.CommentList;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.metadata.MetaDataProperties;
import se.prediktera.breeze.entry.sample.RootSample;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SampleSegmentationColumn;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.frontend.common.entry.ThumbnailManager;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.ListHelper;
import se.prediktera.breeze.frontend.common.util.xmlproperties.DefaultXmlProperties;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlProperties;
import se.prediktera.breeze.frontend.main.record.measurement.panel.MetaInterface;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMoverSettings;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.breeze.test.stubs.GroupWithoutIO;
import se.prediktera.breeze.test.stubs.WorkflowWithoutIO;
import se.prediktera.breeze.util.raw.LiveRawFile;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;

public class Measurement
implements ObjectWithChildren<BasicSample>,
Entry,
MeasurementOrSample,
DescriptorInterface,
MetaInterface {
    private final EntryData entryData;
    private final MetaDataProperties metaProperties = new MetaDataProperties();
    private final CommentList comments = new CommentList();
    private final DefaultXmlProperties properties = new DefaultXmlProperties("settings");
    private final DescriptorHolder descriptorHolder = new DescriptorHolder(this);
    private Group parent;
    private List<EvaluateResult> warnings = null;
    private RootSample rootSample;
    private RawFile rawFile;
    private Timestamp timestamp;
    private int changeIndex;
    private File thumbnailFile;
    private SpectralReference.WhiteReference whiteReference;
    private SpectralReference.DarkReference darkReference;
    private CoreReg coreReg = new CoreReg();
    private boolean cachedCleared;
    public final List<Sample> sampleAreas = new ArrayList<Sample>();
    private String baseName = "measurement";
    private String baseExt = "raw";

    public Measurement(Group group) {
        this(group.nextMeasurementName(), group);
    }

    public Measurement(String string, Group group) {
        this.entryData = new EntryData(this, string, group.getFolder());
        this.setParent(group);
    }

    public Measurement(String string, File file) {
        this.entryData = new EntryData(this, string, file);
    }

    public Measurement(File file, Group group) {
        this.setParent(group);
        this.entryData = new EntryData(file.getName());
        File file2 = this.getMeasurementXml(file);
        Node node = XmlParserHelper.parseXMLRoot(file2, "measurement", "sample");
        this.entryData.setAttributesAndNewName(node, null);
        boolean bl = false;
        NodeList nodeList = node.getChildNodes();
        block20: for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node2 = nodeList.item(i);
            switch (string = node2.getNodeName().toLowerCase()) {
                case "metadata": {
                    this.getMetaProperties().parseMetadata(this, node2);
                    continue block20;
                }
                case "grid": {
                    Node node3 = XmlParserHelper.getNode(node2, "samples", null);
                    if (node3 == null) continue block20;
                    this.replaceRootSample(this.parseSamples(node3, this.getWorkflow()));
                    continue block20;
                }
                case "variables": {
                    this.syncCategoryVariables(node2, false);
                    continue block20;
                }
                case "samples": {
                    this.replaceRootSample(this.parseSamples(node2, this.getWorkflow()));
                    continue block20;
                }
                case "comments": {
                    this.getComments().parseComments(node2);
                    continue block20;
                }
                case "settings": {
                    this.getProperties().setRootProperty(node2);
                    bl = true;
                    continue block20;
                }
                case "descriptors": {
                    this.getDescriptorHolder().parseResults(node2, GroupAndMeasurementDefaultFunctionTreeListMap.getInstance().getFunctionTreeList("measurement"));
                    continue block20;
                }
                case "depth": {
                    this.coreReg = new CoreReg(node2);
                }
            }
        }
        if (this.rootSample == null) {
            this.replaceRootSample(new RootSample());
        }
        XmlProperties.ensureThatSettingsExists(this.getProperties(), node, bl);
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getBaseExt() {
        return this.baseExt;
    }

    public int getIndexWithinGroup() {
        return this.getParent().getChildIndex(this);
    }

    protected File getMeasurementXml(File file) {
        return new File(file, "measurement.xml");
    }

    public void reload(boolean bl) {
        List<Node> list;
        Object object;
        File file = this.getMeasurementXml(this.getFolder());
        Node node = XmlParserHelper.parseXMLRoot(file, "measurement", "sample");
        this.entryData.reload(node);
        List<Node> list2 = XmlParserHelper.getNodeList(node, "metadata");
        if (!list2.isEmpty()) {
            object = this.getMetaProperties();
            ((MetaDataProperties)object).clear();
            ((MetaDataProperties)object).parseMetadata(this, list2.getFirst());
        }
        if (!(object = XmlParserHelper.getNodeList(node, "variables")).isEmpty()) {
            this.syncCategoryVariables((Node)object.getFirst(), bl);
        }
        if (!(list = XmlParserHelper.getNodeList(node, "samples")).isEmpty()) {
            this.replaceRootSample(this.parseSamples(list.getFirst(), this.getWorkflow()));
        }
        this.descriptorHolder.clear();
        List<Node> list3 = XmlParserHelper.getNodeList(node, "descriptors");
        if (!list3.isEmpty()) {
            this.descriptorHolder.parseResults(list3.getFirst(), GroupAndMeasurementDefaultFunctionTreeListMap.getInstance().getFunctionTreeList("measurement"));
        }
        List<Node> list4 = XmlParserHelper.getNodeList(node, "settings");
        this.getProperties().setRootProperty(list4.getFirst());
        this.resetWarning();
        ++this.changeIndex;
    }

    private void syncCategoryVariables(Node node, boolean bl) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getNodeName();
            if (!string.equals("qualitative")) continue;
            CategoryFactor.syncAnalyseCategoryFactor(nodeList.item(i), bl);
        }
    }

    private RootSample parseSamples(Node node, Workflow workflow) {
        List<Node> list = XmlParserHelper.getNodeList(node, "sample");
        if (list.size() > 1) {
            RootSample rootSample = this.hasData() ? new RootSample(this.rawFile()) : new RootSample();
            for (Node node2 : list) {
                rootSample.addChild(new Sample(workflow, node2, rootSample));
            }
            return rootSample;
        }
        if (list.size() == 1) {
            return new RootSample(workflow, list.getFirst());
        }
        return null;
    }

    @Override
    public boolean applyChangesNeeded() {
        if (this.hasData()) {
            return this.isApplyChangesNeeded();
        }
        return false;
    }

    public void setApplyChangedNeeded(boolean bl) {
        this.getProperties().setPropertyBoolLocal("changed", bl);
    }

    public boolean isApplyChangesNeeded() {
        return this.getProperties().getPropertyBoolLocal("changed", false);
    }

    @Override
    public String getMetaValue(String string) {
        return this.metaProperties.getMetaValue(string);
    }

    public boolean hasData() {
        RawFile rawFile = this.rawFile();
        return rawFile != null && rawFile.exits();
    }

    public boolean hasDataOrPrediction() {
        if (this.hasData()) {
            return true;
        }
        return FileHelper.exists(this.getPredictionRawFile());
    }

    public RtFramePredictor.ReferenceType getReferenceType() {
        boolean bl;
        SpectralReference.WhiteReference whiteReference = this.whiteReference();
        boolean bl2 = whiteReference != null && !whiteReference.isEmpty();
        SpectralReference.DarkReference darkReference = this.darkReference();
        boolean bl3 = bl = darkReference != null && !darkReference.isEmpty();
        if (bl2 && bl) {
            return RtFramePredictor.ReferenceType.Both;
        }
        if (bl2) {
            return RtFramePredictor.ReferenceType.OnlyWhite;
        }
        if (bl) {
            return RtFramePredictor.ReferenceType.OnlyDark;
        }
        return RtFramePredictor.ReferenceType.None;
    }

    public boolean hasReferences() {
        return this.getReferenceType().using();
    }

    public boolean hasBackup() {
        return this.getBackupFolder().exists();
    }

    public File getBackupFolder() {
        return new File(this.getFolder(), "backup");
    }

    public boolean hasThumbnail() {
        return this.getThumbnailFile().exists();
    }

    public boolean hasWarning() {
        return this.getWarnings() != null && !this.warnings.isEmpty();
    }

    public boolean hasError() {
        if (this.warnings != null && !this.warnings.isEmpty()) {
            for (EvaluateResult evaluateResult : this.warnings) {
                if (!evaluateResult.getMessageId().startsWith("E")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasCriticalWarning() {
        List<EvaluateResult> list = this.getWarnings();
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (EvaluateResult evaluateResult : list) {
            String string = evaluateResult.getMessageId();
            if ("WM0002".equals(string) || "WM0004".equals(string)) continue;
            return true;
        }
        return false;
    }

    public EvaluateResult getWarningById(String string) {
        return EvaluateResult.getWarningById(this.warnings, string);
    }

    public List<EvaluateResult> getWarnings() {
        if (this.warnings == null && this.hasData() && !this.isRgbData()) {
            this.warnings = GroupAndMeasurementDefaultFunctionTreeListMap.getInstance().getWarnings(this);
            SpectralReference.addWarnings(this.whiteReference(), this.warnings);
        }
        return this.warnings;
    }

    @Override
    public boolean isGrayed() {
        return !this.hasData();
    }

    public void resetWarning() {
        this.warnings = null;
    }

    @Override
    public File getCustomImageFile() {
        return this.getThumbnailFile();
    }

    public RootSample replaceRootSample(RootSample rootSample) {
        this.rootSample = rootSample;
        if (this.rootSample != null) {
            this.rootSample.setParentMeasurement(this);
        }
        return this.rootSample;
    }

    public RootSample getRootSample() {
        return this.rootSample;
    }

    public List<Sample> getSamplesForCurrentLevel() {
        Workflow workflow = this.getWorkflow();
        if (workflow.getSegmentationHashId() != null) {
            return this.getSamples(workflow.getSegmentationHashId());
        }
        return this.getSamples(workflow.getSegmentationLevel());
    }

    public SampleSegmentationColumn getSamples(int n) {
        return this.getSamples(new SegmentationIdentifier(n, null));
    }

    public SampleSegmentationColumn getSamples(SegmentationIdentifier segmentationIdentifier) {
        return this.getRootSample() != null ? this.getRootSample().getSamples(segmentationIdentifier) : new SampleSegmentationColumn();
    }

    public SampleSegmentationColumn getSamples(List<String> list) {
        if (list.size() == 1) {
            return this.getSamples(list.getFirst());
        }
        SampleSegmentationColumn sampleSegmentationColumn = new SampleSegmentationColumn();
        for (String string : list) {
            sampleSegmentationColumn.addAll(this.getSamples(string));
        }
        return sampleSegmentationColumn;
    }

    public SampleSegmentationColumn getSamples(String string) {
        if (string.isEmpty()) {
            return this.getSamples(0);
        }
        return this.getRootSample() != null ? this.getRootSample().getSamples(string) : new SampleSegmentationColumn();
    }

    public SegmentationNodeList getSegmentationsForCurrentLevel(Sample sample) {
        Workflow workflow = this.getWorkflow();
        if (sample != null) {
            return workflow.getSegmentationNodes(workflow.getSegmentationLevel()).filter(sample.getSegmentationHashId());
        }
        return workflow.getSegmentationNodes();
    }

    @Override
    public int getChildCount() {
        return this.hasSamples() ? 1 : 0;
    }

    @Override
    public List<BasicSample> getChildList() {
        return this.hasSamples() ? Collections.singletonList(this.rootSample) : List.of();
    }

    public void setChildList(List<Sample> list) {
        throw new RuntimeException("setChildList is deprecated for measurement");
    }

    public boolean hasSample(Sample sample) {
        return this.rootSample.hasSample(sample);
    }

    public boolean hasSamples() {
        return this.rootSample != null;
    }

    public String getPrimarySampleIdentifier() {
        if (this.hasSamples()) {
            return this.rootSample.getSettingsName();
        }
        return null;
    }

    @Override
    public boolean delete(boolean bl) {
        this.clearCache();
        return BreezeRecycleBin.delete(this, Entry.EntryType.Measurement, bl);
    }

    public void clearCache() {
        ThumbnailManager.removeMeasurementImageFromCache(this);
        DataSetCache.clear(this);
        this.clearFilesCache();
    }

    public void clearFilesCache() {
        this.rawFile = null;
        this.whiteReference = null;
        this.darkReference = null;
        this.clearPrediction();
    }

    public void clearPrediction() {
        this.thumbnailFile = null;
        this.cachedCleared = true;
    }

    public String getFactorValueString() {
        return this.getParent().getPropertyFactors().get(0).getStringValue(this.getRootSample());
    }

    public File getThumbnailFile() {
        if (this.thumbnailFile == null) {
            this.thumbnailFile = new MeasurementFileLocation.Image().file(this);
        }
        return this.thumbnailFile;
    }

    public void clearThumbnail() {
        this.thumbnailFile = null;
    }

    public void deleteThumbnail() {
        this.getThumbnailFile().delete();
        this.clearThumbnail();
    }

    public File getPredictionRawFile() {
        return new MeasurementFileLocation.Prediction().file(this);
    }

    public File getPredictionHdrFile() {
        return new MeasurementFileLocation.Prediction().header(this);
    }

    public RawFile getPrediction() {
        return new RawFileImpl(this.getPredictionRawFile());
    }

    @Override
    public void save() {
        Document document = XmlParserHelper.createXMLdoc();
        Element element = XmlParserHelper.addRoot("measurement", document);
        this.entryData.writeXmlAttributes(element, "Measurement");
        this.getMetaProperties().writeMetadataToXml(element);
        this.getComments().addComments(element);
        XmlProperties.addProperties(this.getProperties(), document, element);
        if (this.coreReg.hasData()) {
            this.coreReg.writeXml(element);
        }
        this.getDescriptorHolder().writeResults(XmlParserHelper.addElement(element, "descriptors"));
        if (this.hasSamples()) {
            this.rootSample.writeXml(element, this.getWorkflow());
        }
        XmlProperties.createDirectoriesAndOutputXML(this.getXml(), document);
        ++this.changeIndex;
    }

    @Override
    public File getXml() {
        return new File(this.getFolder(), "measurement.xml");
    }

    public String toString() {
        String string = this.entryData.getName();
        if (string != null && !string.isEmpty()) {
            return string;
        }
        String string2 = this.getPrimarySampleIdentifier();
        if (string2 != null) {
            return string2;
        }
        String string3 = this.entryData.getUid();
        if (string3 != null && !string3.isEmpty()) {
            return string3;
        }
        return super.toString();
    }

    public void deleteResultFiles() {
        this.deleteFileIfExists(this.getPredictionRawFile());
        this.deleteFileIfExists(this.getPredictionHdrFile());
    }

    private void deleteFileIfExists(File file) {
        try {
            Files.delete(file.toPath());
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public RawFile rawFileThrowIfNotExists() {
        RawFile rawFile = this.rawFile();
        if (rawFile == null) {
            throw new ErrorHandler.InformationMessageException("No raw file found for measurement: " + String.valueOf(this));
        }
        return rawFile;
    }

    public RawFile rawFile() {
        if (this.rawFile == null) {
            try {
                this.rawFile = new LiveRawFile(this, (MeasurementFileLocation)new MeasurementFileLocation.Raw());
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return this.rawFile;
    }

    public RawFile cachedRawFile(FrameListFromRaw.Reduce reduce) {
        try {
            return new CachedRawFile(this, new MeasurementFileLocation.Raw(), reduce);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
    }

    public SpectralReference.WhiteReference whiteReference() {
        if (this.whiteReference == null) {
            try {
                this.whiteReference = new SpectralReference.WhiteReference(this);
                return this.whiteReference;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.whiteReference = new SpectralReference.EmptyWhiteReference();
                return this.whiteReference;
            }
        }
        return this.whiteReference;
    }

    public void saveNewWhiteReference(SpectralReference.WhiteReference whiteReference, Rectangle rectangle) {
        whiteReference.saveToDisk(this, rectangle);
    }

    public SpectralReference.DarkReference darkReference() {
        if (this.darkReference == null) {
            try {
                this.darkReference = new SpectralReference.DarkReference(this);
                return this.darkReference;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.darkReference = new SpectralReference.EmptyDarkReference();
                return this.darkReference;
            }
        }
        return this.darkReference;
    }

    public void saveNewDarkReference(SpectralReference.DarkReference darkReference, Rectangle rectangle) {
        darkReference.saveToDisk(this, rectangle);
    }

    public Workflow getWorkflow() {
        Group group = this.getParent();
        if (group != null) {
            return group.getParent();
        }
        return null;
    }

    @Override
    public File getFolder() {
        return new File(this.getParent().getFolder(), this.getName());
    }

    @Override
    public CommentList getComments() {
        return this.comments;
    }

    @Override
    public XmlProperties getProperties() {
        return this.properties;
    }

    @Override
    public String getName() {
        return this.entryData.getName();
    }

    @Override
    public EntryData getEntryData() {
        return this.entryData;
    }

    @Override
    public String getUid() {
        return this.entryData.getUid();
    }

    @Override
    public void rename(String string) throws IOException {
        ThumbnailManager.removeMeasurementImageFromCache(this);
        this.entryData.rename(string, this.getFolder(), this.getParent().getFolder());
        this.clearFilesCache();
    }

    public static Measurement createStandaloneMeasurement(final File file) {
        final File file2 = Measurement.getNewOrLegacyFile(file, "", ".xml");
        WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO();
        GroupWithoutIO groupWithoutIO = new GroupWithoutIO(workflowWithoutIO);
        workflowWithoutIO.addChild(groupWithoutIO);
        Measurement measurement = new Measurement(file, groupWithoutIO){

            @Override
            public File getFolder() {
                return file;
            }

            @Override
            protected File getMeasurementXml(File file3) {
                return file2;
            }
        };
        groupWithoutIO.addChild(measurement);
        return measurement;
    }

    public static File getNewOrLegacyFile(File file, String string, String string2) {
        File file2 = new File(file, string + "measurement" + string2);
        if (file2.exists()) {
            return file2;
        }
        File file3 = new File(file, string + file.getName() + string2);
        if (file3.exists()) {
            return file3;
        }
        throw new RuntimeException("Cannot find measurement " + string2 + " file");
    }

    @Override
    public DescriptorHolder getDescriptorHolder() {
        return this.descriptorHolder;
    }

    @Override
    public final float getDescriptorValue(DescriptorTreeNode descriptorTreeNode) {
        return this.descriptorHolder.getDescriptorValue(descriptorTreeNode);
    }

    @Override
    public final FunctionResult getFunctionResult(String string) {
        return this.descriptorHolder.getFunctionResult(string);
    }

    @Override
    public final void putFunctionResult(String string, FunctionResult functionResult) {
        this.descriptorHolder.putFunctionResult(string, functionResult);
    }

    @Override
    public List<String> getSortedMetadataKeys() {
        return this.getMetaProperties().getSortedKeys();
    }

    public Sample getFirstSample(String string) {
        if (string == null) {
            return this.rootSample;
        }
        Sample sample = Measurement.getFirstSample(this.rootSample, string);
        if (sample != null) {
            return sample;
        }
        return this.rootSample;
    }

    private static Sample getFirstSample(Sample sample, String string) {
        if (string.equals(sample.getSegmentationHashId())) {
            return sample;
        }
        for (BasicSample basicSample : sample.getChildList()) {
            Sample sample2 = Measurement.getFirstSample((Sample)basicSample, string);
            if (sample2 == null) continue;
            return sample2;
        }
        return null;
    }

    public BandNames getBandNames() {
        try {
            if (this.hasData()) {
                return Measurement.getBandNames(this.rawFile());
            }
            if (this.hasReferences()) {
                return Measurement.getBandNames(this.whiteReference());
            }
        }
        catch (Exception exception) {
            Logg.warn((String)"Could not parse header from measurement with data", (Object[])new Object[]{exception});
        }
        return null;
    }

    private static BandNames getBandNames(RawFile rawFile) {
        if (rawFile != null) {
            return rawFile.header().bandNames();
        }
        return null;
    }

    public BandCount getBandCount() {
        if (this.hasData()) {
            return this.rawFile().header().bandCount();
        }
        return null;
    }

    public static Measurement getFirstMeasurementWithData(List<Measurement> list) {
        for (Measurement measurement : list) {
            if (!measurement.hasData()) continue;
            return measurement;
        }
        return null;
    }

    public static RtFramePredictor.ReferenceType anyMeasurementHasReferences(List<Measurement> list) {
        for (Measurement measurement : list) {
            RtFramePredictor.ReferenceType referenceType = measurement.getReferenceType();
            if (referenceType.equals((Object)RtFramePredictor.ReferenceType.None)) continue;
            return referenceType;
        }
        return RtFramePredictor.ReferenceType.None;
    }

    public static List<Measurement> getMeasurements(List<Object> list) {
        ArrayList<Measurement> arrayList = new ArrayList<Measurement>();
        for (Object object : list) {
            arrayList.addAll(Measurement.getMeasurements(object));
        }
        return arrayList;
    }

    public static List<Measurement> getMeasurements(Object object) {
        if (object instanceof Workflow) {
            Workflow workflow = (Workflow)object;
            return workflow.getAllMeasurements();
        }
        if (object instanceof Group) {
            Group group = (Group)object;
            return group.getChildList();
        }
        if (object instanceof Measurement) {
            Measurement measurement = (Measurement)object;
            return List.of(measurement);
        }
        return new ArrayList<Measurement>();
    }

    public static Measurement getMeasurement(Object object) {
        if (object instanceof Measurement) {
            Measurement measurement = (Measurement)object;
            return measurement;
        }
        if (object instanceof Sample) {
            Sample sample = (Sample)object;
            return sample.measurement();
        }
        return null;
    }

    public static void clearFromCache(Object object) {
        for (Measurement measurement : Measurement.getMeasurements(object)) {
            measurement.clearCache();
        }
    }

    public Timestamp getTimestamp() {
        if (this.timestamp != null) {
            return this.timestamp;
        }
        File file = this.getXml();
        if (file.exists()) {
            this.timestamp = new Timestamp(file.lastModified());
            return this.timestamp;
        }
        this.timestamp = new Timestamp(System.currentTimeMillis());
        return this.timestamp;
    }

    public boolean isDeeTeeCamera() {
        String string = this.getMetaValue("CameraName");
        return string != null && string.equals("Detection Technology");
    }

    public boolean isMultiCamera() {
        String string = this.getMetaValue("CameraName");
        return string != null && (string.startsWith("Dual Camera") || string.startsWith("Multi Camera"));
    }

    public boolean isRgbData() {
        Object object = this.getBandCount();
        if (object instanceof BandCount) {
            BandCount bandCount = object;
            object = this.getMaxSignal();
            if (object instanceof MaxSignal) {
                Object object2 = object;
                return ((MaxSignal)object2).value == 255.0f && (bandCount.value == 3 || bandCount.value == 4);
            }
        }
        return false;
    }

    public boolean isXrayData() {
        if (this.isDeeTeeCamera()) {
            return true;
        }
        String string = this.getMetaValue("CameraName");
        if ("Prediktera Simulator Camera".equals(string)) {
            int n = RtDataFormat.toNumberInt(this.getMetaValue("BaseLineOffset"));
            int n2 = RtDataFormat.toNumberInt(this.getMetaValue("Wavelength"));
            return n > 0 && n2 == 2;
        }
        return false;
    }

    public boolean isHySpex() {
        RawHeader rawHeader;
        return this.hasData() && (rawHeader = this.rawFile().header()).getHeaderOffset() > 0L;
    }

    public RtFramePredictor.RefSettings getRefSettings(RtFramePredictor.ReferenceConvertTo referenceConvertTo) {
        RtFramePredictor.RefSettings refSettings = new RtFramePredictor.RefSettings(this.getReferenceType());
        refSettings.convertTo = referenceConvertTo != null ? referenceConvertTo : this.getConvertTo();
        refSettings.baseLineOffset = this.getBaseLineOffset();
        Workflow workflow = this.getWorkflow();
        if (workflow != null) {
            refSettings.strayLightFile = workflow.getStrayLightFile();
        }
        refSettings.integrationTime = this.getIntegrationTime();
        return refSettings;
    }

    public int getBaseLineOffset() {
        String string = this.getMetaValue("BaseLineOffset");
        if (string != null) {
            return RtDataFormat.toNumberInt(string);
        }
        return 0;
    }

    public IntegrationTime getIntegrationTime() {
        RawHeader rawHeader;
        RawHeader.DescriptionData descriptionData;
        float f;
        String string = this.getMetaValue("IntegrationTime");
        if (string != null && (f = RtDataFormat.toNumberFloat(string)) > 0.0f) {
            return new IntegrationTime(f);
        }
        RawFile rawFile = this.rawFile();
        if (rawFile != null && (descriptionData = (rawHeader = rawFile.header()).getDescriptionData()) != null) {
            return descriptionData.integrationTime;
        }
        return null;
    }

    public MaxSignal getMaxSignal() {
        String string = this.getMetaValue("MaxSignal");
        if (string != null && !string.isEmpty()) {
            return MaxSignal.fromMeasurementMetaValue(string);
        }
        return null;
    }

    public RtFramePredictor.ReferenceConvertTo getConvertTo() {
        if (this.isDeeTeeCamera()) {
            return RtFramePredictor.ReferenceConvertTo.Reflectance;
        }
        Workflow workflow = this.getWorkflow();
        if (workflow != null) {
            return workflow.getReferenceConvertTo();
        }
        return RtFramePredictor.ReferenceConvertTo.Absorbance;
    }

    public RtFramePredictor.ReferenceConvertTo getWorkflowConvertedTo() {
        String string = this.metaProperties.getMetaValueNullIfMissing("ConvertedTo");
        if (string != null) {
            return RtFramePredictor.ReferenceConvertTo.parse(string, null);
        }
        return RtFramePredictor.ReferenceConvertTo.None;
    }

    public RtFramePredictor.ReferenceConvertTo getDataFormat() {
        RawFile rawFile = this.rawFile();
        if (rawFile != null) {
            return rawFile.getDataFormat();
        }
        return RtFramePredictor.ReferenceConvertTo.None;
    }

    public void increaseChanged() {
        ++this.changeIndex;
    }

    public Rectangle getBounds() {
        if (this.hasData()) {
            RawHeader rawHeader = this.rawFile().header();
            return new Rectangle(0, 0, rawHeader.pixelWidth().value, rawHeader.frameCount().value);
        }
        return null;
    }

    public int getSegmentationLevel() {
        Workflow workflow = this.getWorkflow();
        if (workflow != null) {
            return workflow.getSegmentationLevel();
        }
        return 0;
    }

    @Override
    public Entry.EntryType getEntryType() {
        return Entry.EntryType.Measurement;
    }

    public Measurement getPrevious() {
        Group group = this.getParent();
        ArrayList<Measurement> arrayList = new ArrayList<Measurement>(group.getChildList());
        arrayList.sort((measurement, measurement2) -> measurement.getEntryData().compareTo(ListHelper.SortType.Created, measurement2.getEntryData()));
        int n = arrayList.indexOf(this);
        int n2 = n - 1;
        if (n2 >= 0) {
            return arrayList.get(n2);
        }
        return null;
    }

    public RemoteSampleMoverSettings.MoverType getSampleMoverType() {
        String string = this.getMetaProperties().getMetaValue("SampleMoverType");
        if (string != null && string.equalsIgnoreCase("rotation")) {
            return RemoteSampleMoverSettings.MoverType.Rotation;
        }
        return RemoteSampleMoverSettings.MoverType.Translation;
    }

    public void updateThumbnail(BreezeProgressManager breezeProgressManager) {
        File file = this.rawFile().file();
        File file2 = TcpManager.getInstance().generateThumbnailFileFromRaw(breezeProgressManager, file, null);
        FileHelper.copyFile(breezeProgressManager, file2, this.getThumbnailFile());
        this.clearThumbnail();
    }

    public static Measurement getFirstMeasurementWithData(Object object) {
        Group group;
        Measurement measurement;
        if (object instanceof Measurement) {
            Measurement measurement2 = (Measurement)object;
            if (measurement2.hasData()) {
                return measurement2;
            }
        } else if (object instanceof Group && (measurement = (group = (Group)object).getFirstMeasurementWithData()) != null) {
            return measurement;
        }
        return Workflow.getWorkflow(object).getFirstMeasurementWithData();
    }

    @Generated
    public MetaDataProperties getMetaProperties() {
        return this.metaProperties;
    }

    @Generated
    public void setParent(Group group) {
        this.parent = group;
    }

    @Generated
    public Group getParent() {
        return this.parent;
    }

    @Generated
    public int getChangeIndex() {
        return this.changeIndex;
    }

    @Generated
    public CoreReg getCoreReg() {
        return this.coreReg;
    }

    @Generated
    public void setCachedCleared(boolean bl) {
        this.cachedCleared = bl;
    }

    @Generated
    public boolean isCachedCleared() {
        return this.cachedCleared;
    }
}

