/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.measurement;

import com.mycila.xmltool.XMLDoc;
import com.mycila.xmltool.XMLTag;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import se.prediktera.breeze.common.entry.factor.FactorHolder;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.measurement.MeasurementFileLocation;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.RootSample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.entry.ThumbnailManager;
import se.prediktera.breeze.test.MockBreezeTestProperties;
import se.prediktera.breeze.test.SlowTestCategory;
import se.prediktera.breeze.util.FileWithStringContent;

@Category(value={SlowTestCategory.class})
public class MeasurementTest
extends MockBreezeTestProperties {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private Group group;
    private Measurement forSave;
    private File existingXmlFileFolder;
    private static final String xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<sample xmlns=\"UmBio.XML.MeasurementXml\" id=\"A000002\">\r\n  <files>\r\n    <samplefile file=\"A000002.raw\" header=\"A000002.hdr\"/>\r\n    <references>\r\n      <reference file=\"darkref_A000002.raw\" header=\"darkref_A000002.hdr\" reflectance=\"0\"/>\r\n      <reference file=\"whiteref_A000002.raw\" header=\"whiteref_A000002.hdr\" reflectance=\"100\"/>\r\n    </references>\r\n  </files>\r\n  <metadata>\r\n    <data name=\"Time\">20161013085235</data>\r\n    <data name=\"DoE\">spectral</data>\r\n    <data name=\"CreatedBy\">Administrator </data>\r\n    <data name=\"Instrument\"/>\r\n    <data name=\"FieldOfView\">10.0</data>\r\n    <data name=\"Length\">10.0</data>\r\n    <data name=\"Resolution\">1</data>\r\n    <data name=\"Speed\">100</data>\r\n    <data name=\"CameraType\">PowderSmall</data>\r\n    <data name=\"CameraName\">FileReader</data>\r\n    <data name=\"FrameRate\">100</data>\r\n    <data name=\"Frames\">10</data>\r\n    <data name=\"MaxSignal\">16384</data>\r\n    <data name=\"PixelsPerLine\">10</data>\r\n    <data name=\"Wavelength\">10</data>\r\n    <data name=\"IntegrationTime\">1000</data>\r\n  </metadata>\r\n  <comments/>\r\n  <settings>\r\n    <dimension>\r\n      <insets/>\r\n    </dimension>\r\n    <changed>false</changed>\r\n  </settings>\r\n  <samples>\r\n    <sample>\r\n      <identifiers/>\r\n      <settings>\r\n        <path>[11,2]1,2,8,2,8,7,9,7,9,9,3,9,3,6,2,6,2,3,1,3,1,2</path>\r\n        <average>[26,10]0.23276459,0.19670933,0.2096425,0.31896836,0.30023545,0.32607913,0.30764243,0.4341675,0.52953523,0.6642564,0.6688117,0.67803305,0.69460136,0.72067535,0.72359794,0.7782286,0.7800489,0.77736676,0.8936969,1.0438027,0.74642456,0.74368405,0.7648808,0.79564667,0.79394627,0.8527288,0.85105205,0.8383655,0.9891999,1.1299181,0.16740616,0.12805888,0.1437552,0.26870784,0.24530314,0.2564957,0.23900336,0.39053684,0.46663854,0.60039204,0.3894282,0.37366477,0.37979105,0.48772928,0.47263438,0.5068892,0.48069057,0.60343456,0.6966268,0.83227515,0.6910175,0.686059,0.6977968,0.7189257,0.71880066,0.77453303,0.7690991,0.75441575,0.88760614,1.0459505,0.10904664,0.06504679,0.08430423,0.23636091,0.215965,0.22353055,0.20230669,0.38654193,0.46149412,0.59468096,0.18926759,0.10716328,0.11427363,0.2435244,0.21994708,0.24345669,0.21815777,0.37999207,0.47424665,0.6141311,0.41935438,0.40506962,0.41737652,0.5059206,0.49238157,0.56808805,0.5359175,0.61405605,0.78407705,0.93518275,0.11678785,0.06441767,0.07765764,0.21939254,0.1944074,0.20174517,0.17997861,0.35906762,0.43719342,0.56561315,0.08170906,0.030915527,0.04545118,0.17234065,0.1538281,0.16378416,0.14478745,0.30790693,0.37842909,0.5217496,0.07998422,0.04036532,0.053024832,0.1782828,0.1604522,0.19034603,0.16757604,0.32464424,0.4234732,0.54417187,0.0945517,0.047773913,0.06526679,0.21370369,0.19430277,0.20562838,0.18656914,0.3595434,0.4447459,0.5625983,0.6193782,0.58265287,0.6016086,0.63228446,0.64058197,0.6923692,0.6994828,0.69038475,0.8227984,0.95502144,0.09307158,0.03804953,0.05272414,0.18533762,0.16719548,0.18079245,0.16163142,0.32609022,0.39996964,0.53145623,0.14503664,0.07092763,0.073542304,0.22753014,0.19574878,0.20472842,0.18059164,0.37566322,0.45809764,0.60517025,0.06393184,0.022197772,0.03856609,0.1729417,0.15073971,0.1630085,0.14491293,0.32027057,0.3886368,0.52574146,0.05052997,0.005888823,0.01863585,0.15148759,0.13254371,0.14401288,0.12797375,0.30069485,0.37332815,0.512576,0.68598944,0.7095402,0.7176748,0.7440958,0.73719543,0.8005246,0.78376544,0.7694029,0.9229011,1.0576347,0.13882716,0.08495017,0.10044705,0.23840515,0.21647088,0.22815393,0.21148518,0.39325008,0.47376156,0.6053032,0.1535868,0.10891603,0.12216868,0.2756086,0.24953789,0.27371627,0.24897817,0.42555317,0.52027357,0.64622414,0.054213934,0.024355922,0.040306702,0.17115392,0.1502754,0.16091242,0.14280626,0.30723765,0.3836285,0.5113365,0.013953292,-0.033140164,-0.028788345,0.076261334,0.05175971,0.05939238,0.031280354,0.15627837,0.2516949,0.3553212,0.073678136,0.027750865,0.039942782,0.17198429,0.1531182,0.16514966,0.14734316,0.30947965,0.3889366,0.53134996,0.12673114,0.08369874,0.098387495,0.2279175,0.20594576,0.2198772,0.2007877,0.37194636,0.4492447,0.6037867,0.16934077,0.13913517,0.15768225,0.2898369,0.26371267,0.2764015,0.25298926,0.42012042,0.5020481,0.6594805</average>\r\n      </settings>\r\n      <variables>\r\n        <qualitative id=\"AF000005\" index=\"3\" name=\"Type\">\r\n          <class>V</class>\r\n        </qualitative>\r\n        <quantitative id=\"AF000002\" index=\"0\" name=\"B\" unit=\"%\">\r\n          <value>0</value>\r\n        </quantitative>\r\n        <quantitative id=\"AF000003\" index=\"1\" name=\"V\" unit=\"%\">\r\n          <value>100</value>\r\n        </quantitative>\r\n        <quantitative id=\"AF000004\" index=\"2\" name=\"P\" unit=\"%\">\r\n          <value>0</value>\r\n        </quantitative>\r\n      </variables>\r\n      <descriptors>\r\n        <values/>\r\n      </descriptors>\r\n    </sample>\r\n  </samples>\r\n</sample>";

    @Before
    public void setup() throws IOException {
        Workflow workflow = new Workflow("workflowuid", this.tempFolder.getRoot());
        this.group = new Group("MUxID", workflow);
        this.forSave = new Measurement("Measurement THEONEANDONLY", this.group);
        workflow.addChild(this.group);
        this.existingXmlFileFolder = new File(this.group.getFolder(), "measurementname");
        new FileWithStringContent(xmlString).writtenTo(new File(this.existingXmlFileFolder, "measurement.xml"));
    }

    @Test
    public void shouldSaveXmlInCorrectDirectoryWithCorrectFilename() {
        this.forSave.save();
        MatcherAssert.assertThat((Object)this.forSave.getFolder().getName(), (Matcher)CoreMatchers.is((Object)"Measurement THEONEANDONLY"));
        MatcherAssert.assertThat((Object)this.forSave.getXml().getName(), (Matcher)CoreMatchers.is((Object)"measurement.xml"));
    }

    @Test
    public void shouldRenameFolderAndChangeNameTrimmingSpaces() throws IOException {
        this.forSave.save();
        this.forSave.rename(" new name ");
        MatcherAssert.assertThat((String)"folder is renamed without spaces", (boolean)new File(this.group.getFolder(), "new name").exists());
        MatcherAssert.assertThat((String)"analyse is renamed without spaces", (Object)this.forSave.getName(), (Matcher)CoreMatchers.is((Object)"new name"));
    }

    @Test
    public void shouldSaveUidInXmlFile() {
        this.forSave.save();
        XMLTag xMLTag = XMLDoc.from((File)this.forSave.getXml(), (boolean)true);
        MatcherAssert.assertThat((Object)xMLTag.getAttribute("id", "/measurement", new Object[0]), (Matcher)CoreMatchers.equalTo((Object)this.forSave.getUid()));
    }

    @Test
    public void shouldSaveSampleInXmlFile() {
        this.forSave.replaceRootSample(new RootSample());
        this.forSave.save();
        XMLTag xMLTag = XMLDoc.from((File)this.forSave.getXml(), (boolean)true);
        MatcherAssert.assertThat((String)"xml has sample tag", (boolean)xMLTag.hasTag("/measurement/samples/sample", new Object[0]));
    }

    @Test
    public void shouldSaveSampleVariablesInXmlFile() {
        RootSample rootSample = new RootSample();
        PropertyFactor propertyFactor = new PropertyFactor("testfactor");
        this.forSave.getWorkflow().getPropertyFactors().add(propertyFactor);
        rootSample.getSampleValues().setValue(propertyFactor, 15.0f);
        this.forSave.replaceRootSample(rootSample);
        this.forSave.save();
        XMLTag xMLTag = XMLDoc.from((File)this.forSave.getXml(), (boolean)true);
        xMLTag.gotoTag("/measurement/samples/sample/variables/quantitative", new Object[0]);
        MatcherAssert.assertThat((Object)xMLTag.getAttribute("id"), (Matcher)CoreMatchers.is((Object)propertyFactor.getUid()));
        MatcherAssert.assertThat((Object)xMLTag.getAttribute("name"), (Matcher)CoreMatchers.is((Object)"testfactor"));
        xMLTag.gotoTag("value", new Object[0]);
        MatcherAssert.assertThat((Object)xMLTag.getText(), (Matcher)CoreMatchers.is((Object)"15"));
    }

    @Test
    public void shouldLoadFromXmlFile() throws Exception {
        Measurement measurement = new Measurement(this.existingXmlFileFolder, this.group);
        MatcherAssert.assertThat((String)"measurement was parsed somewhat", (Object)measurement, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void shouldSetUidFromXmlFile() throws Exception {
        Measurement measurement = new Measurement(this.existingXmlFileFolder, this.group);
        MatcherAssert.assertThat((String)"measurement uid was read from xml", (Object)measurement.getUid(), (Matcher)CoreMatchers.equalTo((Object)"A000002"));
    }

    @Test
    public void shouldSetNameFromFolder() throws Exception {
        Measurement measurement = new Measurement(this.existingXmlFileFolder, this.group);
        MatcherAssert.assertThat((String)"measurement name is folder name", (Object)measurement.getName(), (Matcher)CoreMatchers.equalTo((Object)"measurementname"));
    }

    @Test
    public void shouldLoadSampleFromXmlFile() throws Exception {
        Measurement measurement = new Measurement(this.existingXmlFileFolder, this.group);
        MatcherAssert.assertThat((String)"measurement has 1 sample from xml", (Object)measurement.getSamples(0).size(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void shouldLoadSampleVariablesFromXmlFile() throws Exception {
        Measurement measurement = new Measurement(this.existingXmlFileFolder, this.group);
        RootSample rootSample = measurement.getRootSample();
        FactorHolder factorHolder = measurement.getWorkflow().getFactorHolder();
        MatcherAssert.assertThat((String)"sample has value for factor id 0", (Object)rootSample.getVariableValue(factorHolder.getFactorByUid("AF000002")), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((String)"sample has value for factor id 1", (Object)rootSample.getVariableValue(factorHolder.getFactorByUid("AF000003")), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(100.0f)));
        MatcherAssert.assertThat((String)"sample has value for factor id 2", (Object)rootSample.getVariableValue(factorHolder.getFactorByUid("AF000004")), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((String)"sample has value for factor id 3", (Object)rootSample.getVariableValue(factorHolder.getFactorByUid("AF000005")), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(1.0f)));
    }

    @Test
    public void shouldFindImageFiles() throws IOException {
        new File(this.existingXmlFileFolder, "measurement.raw").createNewFile();
        new File(this.existingXmlFileFolder, "measurement.hdr").createNewFile();
        new File(this.existingXmlFileFolder, "measurement.jpg").createNewFile();
        new File(this.existingXmlFileFolder, "darkref_measurement.raw").createNewFile();
        new File(this.existingXmlFileFolder, "darkref_measurement.hdr").createNewFile();
        new File(this.existingXmlFileFolder, "whiteref_measurement.raw").createNewFile();
        new File(this.existingXmlFileFolder, "whiteref_measurement.hdr").createNewFile();
        new File(this.existingXmlFileFolder, "measurement_prediction.raw").createNewFile();
        new File(this.existingXmlFileFolder, "measurement_prediction.hdr").createNewFile();
        Measurement measurement = new Measurement(this.existingXmlFileFolder, this.group);
        MatcherAssert.assertThat((String)"measurement finds all files", (boolean)new MeasurementFileLocation.Raw().file(measurement).exists());
        MatcherAssert.assertThat((String)"measurement finds all files", (boolean)new MeasurementFileLocation.Raw().header(measurement).exists());
        MatcherAssert.assertThat((String)"measurement finds all files", (boolean)measurement.getThumbnailFile().exists());
        MatcherAssert.assertThat((String)"measurement finds all files", (boolean)measurement.hasReferences());
        MatcherAssert.assertThat((String)"measurement finds all files", (boolean)measurement.getPredictionRawFile().exists());
        MatcherAssert.assertThat((String)"measurement finds all files", (boolean)measurement.getPredictionHdrFile().exists());
    }

    @Test
    public void shouldChangePreviewWhenRenamed() throws IOException {
        File file = new File(this.existingXmlFileFolder, "measurement.jpg");
        ImageIO.write((RenderedImage)new BufferedImage(100, 100, 1), "jpg", file);
        ThumbnailManager thumbnailManager = ThumbnailManager.getInstance(100);
        Measurement measurement = new Measurement(this.existingXmlFileFolder, this.group);
        Assert.assertNotNull((Object)thumbnailManager.getCustomIconImage(measurement.getCustomImageFile(), null));
        Assert.assertTrue((boolean)thumbnailManager.hasFile(file));
        measurement.rename("newname");
        Assert.assertFalse((boolean)thumbnailManager.hasFile(file));
    }
}

