/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.measurement.metadata;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.map.common.NiceDataFormat;

public class MetaDataProperties {
    private final HashMap<String, String> hashMap = new HashMap();

    public String getMetaValue(String string) {
        return this.getMetaValue(string, "NA");
    }

    public String getMetaValue(String string, String string2) {
        if (this.hashMap.containsKey(string)) {
            return this.hashMap.get(string);
        }
        return string2;
    }

    public Double getMetaNumberNullIfMissing(String string) {
        String string2;
        if (this.hashMap.containsKey(string) && RtDataFormat.isNumber(string2 = this.hashMap.get(string))) {
            return NiceDataFormat.toNumber((String)string2);
        }
        return null;
    }

    public String getMetaValueNullIfMissing(String string) {
        if (this.hashMap.containsKey(string)) {
            return this.hashMap.get(string);
        }
        return null;
    }

    public void addProperty(String string, double d) {
        this.addProperty(string, RtDataFormat.toString(d));
    }

    public void addProperty(String string, String string2) {
        this.hashMap.put(string, string2);
    }

    public void addPropertyIfExist(String string, MetaDataProperties metaDataProperties) {
        if (metaDataProperties.hashMap.containsKey(string)) {
            this.addProperty(string, metaDataProperties.getMetaValue(string));
        }
    }

    public void addProperties(MetaDataProperties metaDataProperties) {
        for (Map.Entry<String, String> entry : metaDataProperties.getHashMap().entrySet()) {
            this.addProperty(entry.getKey(), entry.getValue());
        }
    }

    public void removeProperty(String string) {
        this.hashMap.remove(string);
    }

    public Properties convertMeta2Properies() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.hashMap);
        return properties;
    }

    public void parseMetadata(Measurement measurement, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            String string = node2.getAttributes().item(0).getNodeValue();
            String string2 = node2.getTextContent();
            this.addProperty(string, string2);
            if (!string.equalsIgnoreCase("time") || string2.length() <= 0) continue;
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                Date date = simpleDateFormat.parse(string2);
                measurement.getEntryData().setCreatedDate(date);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void writeMetadataToXml(Node node) {
        Element element = XmlParserHelper.addElement(node, "metadata");
        for (Map.Entry<String, String> entry : this.hashMap.entrySet()) {
            Element element2 = XmlParserHelper.addElement((Node)element, "data", entry.getValue());
            element2.setAttribute("name", entry.getKey());
        }
    }

    public void copyTo(MetaDataProperties metaDataProperties) {
        for (Map.Entry<String, String> entry : this.hashMap.entrySet()) {
            metaDataProperties.addProperty(entry.getKey(), entry.getValue());
        }
    }

    public List<String> getSortedKeys() {
        return this.hashMap.keySet().stream().sorted().collect(Collectors.toList());
    }

    public void clear() {
        this.hashMap.clear();
    }

    public int size() {
        return this.hashMap.size();
    }

    public HashMap<String, String> getHashMap() {
        return this.hashMap;
    }

    public MaxSignal getMaxSignal(MaxSignal maxSignal) {
        Double d = this.getMetaNumberNullIfMissing("MaxSignal");
        if (d != null) {
            return new MaxSignal(d.floatValue());
        }
        return maxSignal;
    }

    public static void setMetaDataToMeasurements(HashMap<String, String> hashMap, List<Measurement> list) {
        for (Measurement measurement : list) {
            for (Map.Entry<String, String> entry : hashMap.entrySet()) {
                measurement.getMetaProperties().addProperty(entry.getKey(), entry.getValue());
            }
            measurement.save();
        }
    }
}

