/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.sample;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.realtime.segmentation.spatial.SpatialRectangleObject;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SampleSegmentationColumn;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.hardware.camera.spectra.Spectra;

public class RootSample
extends Sample {
    private Measurement measurement;

    public RootSample(Workflow workflow, Node node) {
        super(workflow, node, null);
    }

    public RootSample() {
    }

    public RootSample(Spectra.FloatSpectra floatSpectra) {
        super(floatSpectra);
    }

    public RootSample(RawFile rawFile) {
        this.setSelectionPath(new SpatialRectangleObject(0, 0, rawFile.header().pixelWidth().value, rawFile.header().frameCount().value).getPath());
    }

    public SampleSegmentationColumn getSamples(SegmentationIdentifier segmentationIdentifier) {
        if (segmentationIdentifier.Level == 0) {
            return new SampleSegmentationColumn(List.of(this));
        }
        SampleSegmentationColumn sampleSegmentationColumn = new SampleSegmentationColumn();
        this.addSamplesAtDepth(sampleSegmentationColumn, this.getChildList(), 1, segmentationIdentifier);
        return sampleSegmentationColumn;
    }

    private void addSamplesAtDepth(ArrayList<Sample> arrayList, List<BasicSample> list, int n, SegmentationIdentifier segmentationIdentifier) {
        if (n == segmentationIdentifier.Level) {
            for (BasicSample basicSample : list) {
                if (segmentationIdentifier.HashId != null && !segmentationIdentifier.HashId.equals(basicSample.getSegmentationHashId())) continue;
                arrayList.add((Sample)basicSample);
            }
        } else {
            for (BasicSample basicSample : list) {
                this.addSamplesAtDepth(arrayList, basicSample.getChildList(), n + 1, segmentationIdentifier);
            }
        }
    }

    public SampleSegmentationColumn getSamples(String string) {
        SampleSegmentationColumn sampleSegmentationColumn = new SampleSegmentationColumn();
        this.addSamplesWithUid(sampleSegmentationColumn, this.getChildList(), string);
        return sampleSegmentationColumn;
    }

    private void addSamplesWithUid(ArrayList<Sample> arrayList, List<BasicSample> list, String string) {
        for (BasicSample basicSample : list) {
            if (string.equals(basicSample.getSegmentationHashId())) {
                arrayList.add((Sample)basicSample);
            }
            this.addSamplesWithUid(arrayList, basicSample.getChildList(), string);
        }
    }

    @Override
    public void writeXml(Element element, Workflow workflow) {
        Element element2 = XmlParserHelper.addElement(element, "samples");
        super.writeXml(element2, workflow);
    }

    @Override
    public String getIndexString() {
        return "1";
    }

    @Override
    public Measurement measurement() {
        return this.measurement;
    }

    public void setParentMeasurement(Measurement measurement) {
        this.measurement = measurement;
    }

    @Override
    public boolean isRoot() {
        return true;
    }
}

