/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.sample;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionHelper;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.RootSample;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.test.stubs.GroupWithoutIO;
import se.prediktera.breeze.test.stubs.WorkflowWithoutIO;

public class RootSampleTest {
    @Test
    public void shouldProduceCorrectIdxString() {
        Measurement measurement = new Measurement("asdf", (Group)new GroupWithoutIO());
        RootSample rootSample = measurement.replaceRootSample(new RootSample());
        Sample sample = (Sample)rootSample.addChild(new Sample());
        MatcherAssert.assertThat((Object)sample.getRecursiveName(Sample.DefaultSampleLabel.IDX), (Matcher)CoreMatchers.is((Object)"1"));
    }

    @Test
    public void shouldProduceCorrectIdxStringDeeper() {
        Measurement measurement = new Measurement("asdf", (Group)new GroupWithoutIO());
        RootSample rootSample = measurement.replaceRootSample(new RootSample());
        rootSample.addChild(new Sample());
        Sample sample = (Sample)rootSample.addChild(new Sample());
        Sample sample2 = (Sample)sample.addChild(new Sample());
        MatcherAssert.assertThat((Object)sample2.getRecursiveName(Sample.DefaultSampleLabel.IDX), (Matcher)CoreMatchers.is((Object)"2:1"));
    }

    @Test
    public void shouldGetCorrectDescriptor() {
        FunctionTreeNode functionTreeNode = FunctionHelper.createDefaultFunction("None");
        FunctionTreeNode functionTreeNode2 = FunctionHelper.createDefaultFunction("BandMath");
        functionTreeNode.addChild(functionTreeNode2);
        FunctionTreeNode functionTreeNode3 = FunctionHelper.createDefaultFunction("VegetationIndex");
        functionTreeNode.addChild(functionTreeNode3);
        FunctionTreeNode functionTreeNode4 = FunctionHelper.createDefaultFunction("PcaQuantification");
        functionTreeNode3.addChild(functionTreeNode4);
        FunctionTreeNode functionTreeNode5 = FunctionHelper.createDefaultFunction("IntensitySegmentation");
        functionTreeNode.addChild(functionTreeNode5);
        FunctionTreeNode functionTreeNode6 = FunctionHelper.createDefaultFunction("Function");
        functionTreeNode5.addChild(functionTreeNode6);
        FunctionTreeNode functionTreeNode7 = FunctionHelper.createDefaultFunction("Rgb");
        functionTreeNode5.addChild(functionTreeNode7);
        FunctionTreeNode functionTreeNode8 = FunctionHelper.createDefaultFunction("PcaQuantification");
        functionTreeNode7.addChild(functionTreeNode8);
        WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO();
        workflowWithoutIO.getAnalyseTree().setRoot(functionTreeNode);
        MatcherAssert.assertThat((Object)workflowWithoutIO.getAllDescriptorNodes().size(), (Matcher)CoreMatchers.is((Object)6));
        MatcherAssert.assertThat((Object)workflowWithoutIO.getSegmentationLevelDescriptorNodes(new SegmentationIdentifier(0, null), false).size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)workflowWithoutIO.getSegmentationLevelDescriptorNodes(new SegmentationIdentifier(0, null), true).size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)workflowWithoutIO.getSegmentationLevelDescriptorNodes(new SegmentationIdentifier(1, null), false).size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)workflowWithoutIO.getSegmentationLevelDescriptorNodes(new SegmentationIdentifier(1, null), true).size(), (Matcher)CoreMatchers.is((Object)3));
    }
}

