/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.sample;

import java.awt.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.breeze.common.entry.SampleVariableOrIdentifier;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CategoryList;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.util.image.RtPixel2D;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.MeasurementOrSample;
import se.prediktera.breeze.entry.factor.SampleVariableValueParser;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.identifier.IdentifierList;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.RootSample;
import se.prediktera.breeze.entry.sample.SampleIdentifierProperties;
import se.prediktera.breeze.entry.sample.SamplePath;
import se.prediktera.breeze.entry.sample.SampleRow;
import se.prediktera.breeze.entry.sample.SampleSegmentationColumn;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectMeasurementPanelStep;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectSamplePanelStep;
import se.prediktera.breeze.hardware.camera.spectra.Spectra;
import se.prediktera.map.common.error.Logg;

public class Sample
extends BasicSample
implements MeasurementOrSample {
    private final SampleIdentifierProperties idProperties = new SampleIdentifierProperties();
    private int cachedInteractionTableIndex = -1;
    private final SamplePath samplePath = new SamplePath();
    private String segmentationHashId;
    private Integer pixelCount = null;
    private HashMap<String, String> attributes = new HashMap();

    public Sample() {
        this((Sample)null);
    }

    public Sample(Spectra.FloatSpectra floatSpectra) {
        this((Sample)null);
        this.samplePath.setAverageProfile(floatSpectra);
    }

    public Sample(Sample sample) {
        this.setParent(sample);
    }

    public Sample(Sample sample, String string) {
        this.segmentationHashId = string;
        this.setParent(sample);
    }

    public Sample(Workflow workflow, Node node, Sample sample) {
        this.setParent(sample);
        IdentifierList identifierList = workflow.getIdentifiers();
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (node2.getNodeName().equals("segmentation")) {
                this.segmentationHashId = node2.getNodeValue();
                continue;
            }
            if (node2.getNodeName().equals("pixelCount")) {
                this.pixelCount = Integer.parseInt(node2.getNodeValue());
                continue;
            }
            this.attributes.put(node2.getNodeName(), node2.getNodeValue());
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Object object;
            Node node3 = nodeList.item(i);
            String string = node3.getNodeName().toLowerCase();
            if (string.equals("identifiers")) {
                this.getIdentifierProperties().parseIdentifiers(identifierList, node3);
                continue;
            }
            if (string.equals("id")) {
                object = node3.getAttributes().item(0).getNodeValue();
                String string2 = node3.getTextContent();
                this.setID((String)object, string2);
                continue;
            }
            if (string.equals("settings")) {
                this.samplePath.parse(node3);
                continue;
            }
            if (string.equals("variables")) {
                SampleVariableValueParser.parseVariables(workflow.getFactorHolder(), node3, this);
                continue;
            }
            if (string.equals("descriptors")) {
                this.getDescriptorHolder().parseResults(node3, workflow.getAnalyseTree());
                continue;
            }
            if (!string.equals("samples")) continue;
            object = node3.getChildNodes();
            for (int j = 0; j < object.getLength(); ++j) {
                Node node4 = object.item(j);
                if (node4.getNodeType() != 1 || !node4.getNodeName().equals("sample")) continue;
                this.addChild(new Sample(workflow, node4, this));
            }
        }
    }

    public Integer getPixelCount() {
        return this.pixelCount;
    }

    @Override
    public float[][] getAverageProfiles() {
        return this.samplePath.getAverageProfiles();
    }

    @Override
    public Shape getOrCreateGeneralPath() {
        return this.samplePath.getOrCreateGeneralPath();
    }

    public SamplePath getPath() {
        return this.samplePath;
    }

    @Override
    public Measurement measurement() {
        return this.rootSample().measurement();
    }

    private RootSample rootSample() {
        Sample sample;
        for (sample = this; sample != null && !(sample instanceof RootSample); sample = (Sample)sample.getParent()) {
        }
        return (RootSample)sample;
    }

    @Override
    public List<SamplePath.SelectionPath> getSelectionPaths() {
        return this.samplePath.getSelectionPaths();
    }

    @Override
    public void setAverageProfiles(float[][] fArray) {
        this.samplePath.setAverageProfiles(fArray);
    }

    @Override
    public List<RtPixel2D> getObjectPixels() {
        return this.samplePath.getObjectPixels();
    }

    @Override
    public void setSelectionPath(int[][] nArray) {
        this.samplePath.setSelectionPath(nArray);
    }

    @Override
    public void clearObjectCache() {
        super.clearObjectCache();
        for (BasicSample basicSample : this.getChildList()) {
            basicSample.clearObjectCache();
        }
    }

    public Sample clone() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public SamplePath getSamplePath() {
        return this.samplePath;
    }

    @Override
    public String getName() {
        String string = this.getSettingsName();
        if (string == null || string.length() == 0) {
            string = this.getRecursiveName(DefaultSampleLabel.SAMPLE_ONLY);
        }
        return string;
    }

    public String getRecursiveName() {
        return this.getRecursiveName(DefaultSampleLabel.ALL);
    }

    public String getRecursiveName(DefaultSampleLabel defaultSampleLabel) {
        Identifier identifier;
        if (defaultSampleLabel == DefaultSampleLabel.IDX) {
            return this.getIndexString();
        }
        String string = "";
        Measurement measurement = this.measurement();
        Identifier identifier2 = identifier = measurement != null ? measurement.getWorkflow().getIdentifiers().getFirst() : null;
        if (identifier != null) {
            string = identifier.getTextValue(this);
        }
        if ((string == null || string.length() == 0 || string.equals("NA") || string.equals("N/A")) && !(this instanceof RootSample)) {
            string = this.getIndexString();
        }
        if (measurement == null || defaultSampleLabel == DefaultSampleLabel.SAMPLE_ONLY) {
            return string;
        }
        if (defaultSampleLabel == DefaultSampleLabel.IDX_SAMPLE) {
            Object object = measurement.getName();
            if (string != null && string.length() > 0) {
                object = (String)object + " (" + string + ")";
            }
            return object;
        }
        String string2 = measurement.getName() + "(" + measurement.getUid() + ")";
        if (string != null && string.length() > 0) {
            string2 = string2 + " (" + string + ")";
        }
        return string2;
    }

    public String getSettingsName() {
        if (this.measurement() != null) {
            CategoryList categoryList;
            String string = null;
            Group group = this.measurement().getParent();
            Identifier identifier = group.getIdentifiers().getFirst();
            if (identifier != null) {
                string = identifier.getTextValue(this);
            }
            if ((string == null || string.length() == 0 || string.equals("NA") || string.equals("N/A") || string.equals("-")) && (categoryList = group.getCategoryFactors()).size() > 0) {
                string = ((Factor)categoryList.get(0)).getStringValue(this);
            }
            if (string != null && string.length() > 0 && !string.equals("NA") && !string.equals("-")) {
                return string;
            }
        }
        return "";
    }

    @Override
    public Float getVariableValue(Factor factor) {
        return this.getSampleValues().getValue(factor);
    }

    public void setID(String string, String string2) {
        Identifier identifier = this.measurement().getParent().getIdentifiers().getIdentifier(string);
        this.idProperties.setID(identifier, string2);
    }

    public void setID(Identifier identifier, String string) {
        this.idProperties.setID(identifier, string);
    }

    public String getIdentifierValue(Identifier identifier) {
        return this.idProperties.getValue(identifier);
    }

    public SampleIdentifierProperties getIdentifierProperties() {
        return this.idProperties;
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (Exception exception) {
            Logg.warn((String)"Exception occurred in toString()", (Object[])new Object[]{exception});
            return "Sample:Exception";
        }
    }

    public String getIndexString() {
        Sample sample = (Sample)this.getParent();
        if (sample instanceof RootSample) {
            return String.valueOf(sample.getChildIndex(this) + 1);
        }
        return sample.getIndexString() + ":" + (sample.getChildIndex(this) + 1);
    }

    @Override
    public boolean hasSample(BasicSample basicSample) {
        if (this.equals(basicSample)) {
            return true;
        }
        for (BasicSample basicSample2 : this.getChildList()) {
            if (!basicSample2.hasSample(basicSample)) continue;
            return true;
        }
        return false;
    }

    public void setSampleVariableOrIdentifier(SampleVariableOrIdentifier sampleVariableOrIdentifier, String string) {
        Object object;
        BasicSample basicSample2 = this.getParent();
        if (basicSample2 instanceof RootSample && ((BasicSample)(object = (RootSample)basicSample2)).getChildCount() == 1) {
            sampleVariableOrIdentifier.setValue(string, (BasicSample)object);
        }
        sampleVariableOrIdentifier.setValue(string, this);
        for (BasicSample basicSample2 : this.getChildList()) {
            ((Sample)basicSample2).setSampleVariableOrIdentifier(sampleVariableOrIdentifier, string);
        }
    }

    public void writeXml(Element element, Workflow workflow) {
        Element element2 = XmlParserHelper.addElement(element, "sample");
        if (this.segmentationHashId != null) {
            element2.setAttribute("segmentation", this.segmentationHashId);
        }
        for (Map.Entry<String, String> object2 : this.attributes.entrySet()) {
            element2.setAttribute(object2.getKey(), object2.getValue());
        }
        Element element3 = XmlParserHelper.addElement(element2, "identifiers");
        for (Object object : workflow.getIdentifiers()) {
            Element element4 = XmlParserHelper.addElement((Node)element3, "id", this.getIdentifierValue((Identifier)object));
            element4.setAttribute("name", ((Identifier)object).getName());
        }
        Element element5 = XmlParserHelper.addElement(element2, "settings");
        this.samplePath.save(element5);
        SampleVariableValueParser.createSampleVariablesNode(element2, this, workflow);
        this.getDescriptorHolder().writeResults(XmlParserHelper.addElement(element2, "descriptors"));
        for (BasicSample basicSample : this.getChildList()) {
            Element element6 = XmlParserHelper.addElement(element2, "samples");
            ((Sample)basicSample).writeXml(element6, workflow);
        }
    }

    public int getCachedInteractionTableIndex() {
        return this.cachedInteractionTableIndex;
    }

    public void setCachedInteractionTableIndex(int n) {
        this.cachedInteractionTableIndex = n;
    }

    @Override
    public Sample getChild(int n) {
        return (Sample)super.getChild(n);
    }

    public void setSegmentationHashId(String string) {
        this.segmentationHashId = string;
    }

    @Override
    public String getSegmentationHashId() {
        return this.segmentationHashId;
    }

    public HashMap<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(HashMap<String, String> hashMap) {
        this.attributes = hashMap;
    }

    public List<BasicSample> getSegmentationSamples(String string) {
        ArrayList<BasicSample> arrayList = new ArrayList<BasicSample>();
        for (BasicSample basicSample : this.getChildList()) {
            if (basicSample.getSegmentationHashId() != null && !basicSample.getSegmentationHashId().equals(string)) continue;
            arrayList.add(basicSample);
        }
        return arrayList;
    }

    public static SampleSegmentationColumn getSamples(Object object, int n) {
        if (object instanceof Workflow) {
            Workflow workflow = (Workflow)object;
            return workflow.getSamples(n);
        }
        if (object instanceof Group) {
            Group group = (Group)object;
            return group.getSamples(n);
        }
        if (object instanceof Measurement) {
            Measurement measurement = (Measurement)object;
            return measurement.getSamples(n);
        }
        return new SampleSegmentationColumn();
    }

    public static SampleSegmentationColumn getSamples(Object object, String string) {
        if (object instanceof Workflow) {
            Workflow workflow = (Workflow)object;
            return workflow.getSamples(string);
        }
        if (object instanceof Group) {
            Group group = (Group)object;
            return group.getSamples(string);
        }
        if (object instanceof Measurement) {
            Measurement measurement = (Measurement)object;
            return measurement.getSamples(string);
        }
        return new SampleSegmentationColumn();
    }

    public static SampleSegmentationColumn getSamples(SegmentationIdentifier segmentationIdentifier, List<Measurement> list) {
        SampleSegmentationColumn sampleSegmentationColumn = new SampleSegmentationColumn();
        for (Measurement measurement : list) {
            sampleSegmentationColumn.addAll(measurement.getSamples(segmentationIdentifier));
        }
        return sampleSegmentationColumn;
    }

    public static Sample getSample(Object object) {
        if (object instanceof Sample) {
            Sample sample = (Sample)object;
            return sample;
        }
        if (object instanceof SelectSamplePanelStep.SampleClass) {
            SelectSamplePanelStep.SampleClass sampleClass = (SelectSamplePanelStep.SampleClass)object;
            return sampleClass.getSample();
        }
        if (object instanceof SelectMeasurementPanelStep.MeasurementClass) {
            SelectMeasurementPanelStep.MeasurementClass measurementClass = (SelectMeasurementPanelStep.MeasurementClass)object;
            return measurementClass.measurement.getRootSample();
        }
        return null;
    }

    public boolean isAncestorOf(Sample sample) {
        for (BasicSample basicSample = sample.getParent(); basicSample != null; basicSample = basicSample.getParent()) {
            if (basicSample != this) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<SampleRow> joinSamples(ArrayList<SampleSegmentationColumn> arrayList) {
        ArrayList<SampleRow> arrayList2 = new ArrayList<SampleRow>();
        if (arrayList.isEmpty()) {
            return arrayList2;
        }
        arrayList2.ensureCapacity(arrayList.stream().mapToInt(ArrayList::size).max().getAsInt());
        SampleSegmentationColumn sampleSegmentationColumn = arrayList.getFirst();
        for (Sample sample : sampleSegmentationColumn) {
            arrayList2.add(new SampleRow(Arrays.asList(sample)));
        }
        int n = -1;
        int n2 = 0;
        int n3 = 1;
        for (int i = 1; i < arrayList.size(); ++i) {
            SampleSegmentationColumn sampleSegmentationColumn2 = arrayList.get(i);
            if (sampleSegmentationColumn2.isEmpty()) continue;
            int n4 = ((Sample)sampleSegmentationColumn2.getFirst()).getSegmentationLevel();
            if (n != n4) {
                n2 = 0;
                Sample.addChildColumn(arrayList2, sampleSegmentationColumn2);
            } else {
                Sample.addSiblingColumn(arrayList2, sampleSegmentationColumn2, ++n2, n3);
            }
            ++n3;
            n = n4;
        }
        return arrayList2;
    }

    static void addChildColumn(ArrayList<SampleRow> arrayList, SampleSegmentationColumn sampleSegmentationColumn) {
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            SampleRow sampleRow = arrayList.get(i);
            ArrayList<Sample> arrayList2 = new ArrayList<Sample>();
            while (n < sampleSegmentationColumn.size()) {
                Sample sample = (Sample)sampleSegmentationColumn.get(n);
                if (!((Sample)sampleRow.getFirst()).isAncestorOf(sample)) break;
                arrayList2.add(sample);
                ++n;
            }
            if (arrayList2.isEmpty()) {
                sampleRow.add(null);
                continue;
            }
            boolean bl = true;
            SampleRow sampleRow2 = new SampleRow(sampleRow);
            for (Sample sample : arrayList2) {
                if (bl) {
                    sampleRow.add(sample);
                    bl = false;
                    continue;
                }
                SampleRow sampleRow3 = new SampleRow(sampleRow2);
                sampleRow3.add(sample);
                arrayList.add(++i, sampleRow3);
            }
        }
    }

    static void addSiblingColumn(ArrayList<SampleRow> arrayList, SampleSegmentationColumn sampleSegmentationColumn, int n, int n2) {
        for (Iterator<SampleRow> iterator : sampleSegmentationColumn) {
            int n3;
            int n4 = -1;
            int n5 = -1;
            for (int i = 0; i < arrayList.size(); ++i) {
                SampleRow sampleRow = arrayList.get(i);
                if (!((Sample)sampleRow.getFirst()).isAncestorOf((Sample)((Object)iterator))) continue;
                n4 = i;
                if (sampleRow.size() != n2) continue;
                n5 = i;
            }
            if (n4 == -1 || n5 == -1) {
                throw new RuntimeException("Failed to find an ancestor for Sample " + ((Sample)((Object)iterator)).toString());
            }
            SampleRow sampleRow = new SampleRow(arrayList.get(n5));
            for (n3 = 0; n3 < n; ++n3) {
                sampleRow.removeLast();
            }
            for (n3 = 0; n3 < n; ++n3) {
                sampleRow.add(null);
            }
            sampleRow.add(iterator);
            arrayList.add(n4 + 1, sampleRow);
        }
        int n6 = 0;
        for (SampleRow sampleRow : arrayList) {
            n6 = Math.max(n6, sampleRow.size());
        }
        for (SampleRow sampleRow : arrayList) {
            while (sampleRow.size() < n6) {
                sampleRow.add(null);
            }
        }
    }

    public static enum DefaultSampleLabel {
        ALL,
        IDX,
        SAMPLE_ONLY,
        IDX_SAMPLE;

    }
}

