/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.sample;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import se.prediktera.breeze.backend.measure.applychanges.ReferenceValueCopyer;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.realtime.segmentation.SegmentationMatrix;
import se.prediktera.breeze.common.realtime.unmixing.Reference;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.image.RtIdentifiedObject;
import se.prediktera.breeze.common.util.image.RtObjectIdentificationHelper;
import se.prediktera.breeze.common.util.image.RtObjectValues;
import se.prediktera.breeze.common.util.image.RtPixel2D;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SamplePath;

public class SampleHelper {
    public static RtObjectIdentificationHelper.RtIdentifiedObjectList getAreas(SegmentationMatrix segmentationMatrix, boolean bl) {
        if (bl) {
            return RtObjectIdentificationHelper.identifyBlobs(segmentationMatrix, 0.2, 0, 0, 0);
        }
        return RtObjectIdentificationHelper.identifyAreas(segmentationMatrix, 0, 0, 0);
    }

    public static void addSamples(Measurement measurement, Sample sample, CatClass catClass, SegmentationNode segmentationNode, int n, List<RtIdentifiedObject> list) {
        for (RtIdentifiedObject rtIdentifiedObject : list) {
            SampleHelper.addSample(measurement, sample, catClass, segmentationNode, n, Arrays.asList(rtIdentifiedObject));
        }
    }

    public static void addSample(Measurement measurement, Sample sample, CatClass catClass, SegmentationNode segmentationNode, int n, List<RtIdentifiedObject> list) {
        Sample sample2 = new Sample(sample, segmentationNode.getUid());
        for (RtIdentifiedObject rtIdentifiedObject : list) {
            rtIdentifiedObject.analyseObject(RtObjectValues.ObjectMode.create(RtObjectValues.ObjectMode.Border));
            int[][] nArray = rtIdentifiedObject.getPath();
            if (n > 1) {
                for (int i = 0; i < nArray.length; ++i) {
                    int[] nArray2 = nArray[i];
                    nArray2[0] = nArray2[0] * n;
                    int[] nArray3 = nArray[i];
                    nArray3[1] = nArray3[1] * n;
                }
            }
            sample2.getSamplePath().addSelectionPath(new SamplePath.SelectionPath(null, nArray));
        }
        SampleHelper.addSample(measurement, sample, catClass, sample2);
    }

    public static void addSample(Measurement measurement, Sample sample, CatClass catClass, Sample sample2) {
        ReferenceValueCopyer.updateSample(measurement.getWorkflow(), sample2, sample);
        if (catClass != null) {
            sample2.getSampleValues().setValue(catClass.getFactor(), catClass.getClassIndex());
        }
        sample.addChild(sample2);
    }

    public static List<SegmentationMatrix> readBooleanMatrixFromFile(File file, String string, int n) {
        int n2;
        Object object;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            while ((object = bufferedReader.readLine()) != null) {
                if (((String)object).length() == 0) continue;
                if (string == null) {
                    string = Reference.getDelimiter((String)object);
                }
                for (String object2 : ((String)object).split(string)) {
                    String string2 = object2.trim();
                    if (RtDataFormat.isNumber(string2)) {
                        n2 = RtDataFormat.toNumberInt(string2);
                        hashSet.add(n2);
                        arrayList.add(n2);
                        continue;
                    }
                    hashSet.add(1);
                    arrayList.add(Boolean.parseBoolean(string2) ? 1 : 0);
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        int n3 = arrayList.size() / n;
        object = new ArrayList(hashSet);
        Collections.sort(object);
        ArrayList arrayList2 = new ArrayList();
        Iterator iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            Integer n4 = (Integer)iterator.next();
            if (n4 == 0) continue;
            SegmentationMatrix segmentationMatrix = new SegmentationMatrix(n3, n);
            n2 = 0;
            for (int i = 0; i < n3; ++i) {
                int n5 = 0;
                while (n5 < n) {
                    if (n2 < arrayList.size()) {
                        segmentationMatrix.setValue(i, n5, ((Integer)arrayList.get(n2)).equals(n4) ? 1 : 0);
                    }
                    ++n5;
                    ++n2;
                }
            }
            arrayList2.add(segmentationMatrix);
        }
        return arrayList2;
    }

    public static SegmentationMatrix fromSamples(Measurement measurement, List<Sample> list) {
        RawHeader rawHeader = measurement.rawFile().header();
        SegmentationMatrix segmentationMatrix = new SegmentationMatrix(rawHeader.frameCount().value, rawHeader.pixelWidth().value);
        int n = 1;
        for (Sample sample : list) {
            for (RtPixel2D rtPixel2D : sample.getSamplePath().getObjectPixels()) {
                segmentationMatrix.setValue(rtPixel2D.y, rtPixel2D.x, n);
            }
            ++n;
        }
        return segmentationMatrix;
    }
}

