/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.sample;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.util.image.RtPixel2D;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlPropertiesHelper;
import se.prediktera.breeze.hardware.camera.spectra.Spectra;

public class SamplePath {
    private Shape borderShape;
    private final List<SelectionPath> selectionPaths = new ArrayList<SelectionPath>();
    private String averageProfileContent;
    private float[][] averageProfiles;
    private Integer area;

    public void parse(Node node) {
        for (Node node2 : XmlParserHelper.getNodeList(node)) {
            String string = node2.getNodeName().toLowerCase();
            if (string.equals("path")) {
                this.selectionPaths.add(new SelectionPath(node2.getTextContent(), null));
                continue;
            }
            if (!string.equals("average")) continue;
            this.averageProfileContent = node2.getTextContent();
        }
    }

    public void save(Node node) {
        for (SelectionPath selectionPath : this.selectionPaths) {
            XmlParserHelper.addElement(node, "path", selectionPath.content != null ? selectionPath.content : XmlPropertiesHelper.createArrayString(selectionPath.array));
        }
        XmlParserHelper.addElement(node, "average", this.averageProfileContent != null ? this.averageProfileContent : XmlPropertiesHelper.createArrayString(this.averageProfiles));
    }

    public float[] getAverageProfile() {
        float[][] fArray = this.getAverageProfiles();
        if (fArray != null) {
            return fArray[0];
        }
        return null;
    }

    public float[][] getAverageProfiles() {
        if (this.averageProfiles == null && this.averageProfileContent != null) {
            this.averageProfiles = XmlPropertiesHelper.parseFloatArray(this.averageProfileContent);
        }
        return this.averageProfiles;
    }

    public Shape getOrCreateGeneralPath() {
        if (this.borderShape == null && this.getSelectionPaths() != null) {
            this.borderShape = SamplePath.createGeneralPath(this.selectionPaths);
        }
        return this.borderShape;
    }

    public List<SelectionPath> getSelectionPaths() {
        return this.selectionPaths;
    }

    public void setAverageProfile(float[] fArray) {
        this.setAverageProfiles(new float[][]{fArray});
    }

    public void setAverageProfile(Spectra.FloatSpectra floatSpectra) {
        this.setAverageProfiles(new float[][]{floatSpectra.getValues()});
    }

    public void setAverageProfiles(float[][] fArray) {
        this.averageProfiles = fArray;
        this.averageProfileContent = null;
    }

    public void setSelectionPath(int[][] nArray) {
        this.selectionPaths.clear();
        this.selectionPaths.add(new SelectionPath(null, nArray));
        this.clearCache();
    }

    public void setSelectionPaths(List<SelectionPath> list) {
        this.selectionPaths.clear();
        this.addSelectionPaths(list);
    }

    public void addSelectionPath(SelectionPath selectionPath) {
        this.selectionPaths.add(selectionPath);
        this.clearCache();
    }

    public void addSelectionPath(List<int[][]> list) {
        for (int[][] nArray : list) {
            this.selectionPaths.add(new SelectionPath(null, nArray));
        }
        this.clearCache();
    }

    public void addSelectionPaths(List<SelectionPath> list) {
        this.selectionPaths.addAll(list);
        this.clearCache();
    }

    public RtFrame getAverageProfileFrame() {
        RtFrame rtFrame = new RtFrame(new BandCount(this.averageProfiles[0].length), new PixelWidth(1), BandNames.fromIndex(this.averageProfiles[0].length), 1);
        for (int i = 0; i < this.averageProfiles[0].length; ++i) {
            rtFrame.setFrameValue(i, 0, this.averageProfiles[0][i]);
        }
        return rtFrame;
    }

    public int getArea() {
        if (this.area == null) {
            this.area = this.getObjectPixels().size();
        }
        return this.area;
    }

    public List<RtPixel2D> getObjectPixels() {
        return SamplePath.getShapePixels(this.getOrCreateGeneralPath(), false);
    }

    public void pan(double d, double d2) {
        for (SelectionPath selectionPath : this.getSelectionPaths()) {
            for (int[] nArray : selectionPath.getOrCreateArrayClearContent()) {
                nArray[0] = (int)((double)nArray[0] - d);
                nArray[1] = (int)((double)nArray[1] - d2);
            }
        }
        this.borderShape = null;
    }

    private void clearCache() {
        this.borderShape = null;
        this.area = null;
    }

    public static List<RtPixel2D> getShapePixels(Shape shape, boolean bl) {
        if (shape == null) {
            return new ArrayList<RtPixel2D>();
        }
        Rectangle rectangle = shape.getBounds();
        int n = rectangle.width + 1;
        int n2 = rectangle.height + 1;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 10);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.translate(-rectangle.x, -rectangle.y);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(shape);
        if (bl) {
            graphics2D.draw(shape);
        }
        graphics2D.dispose();
        byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
        ArrayList<RtPixel2D> arrayList = new ArrayList<RtPixel2D>();
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (byArray[n5] != 0) {
                    arrayList.add(new RtPixel2D(j + n3, i + n4));
                }
                ++n5;
            }
        }
        return arrayList;
    }

    public static GeneralPath createGeneralPath(List<SelectionPath> list) {
        GeneralPath generalPath = null;
        try {
            if (list.size() > 0) {
                generalPath = new GeneralPath();
                for (SelectionPath selectionPath : list) {
                    SamplePath.addPath(generalPath, selectionPath.getOrCreateArray());
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Cannot create general path from selection path");
            exception.printStackTrace();
        }
        return generalPath;
    }

    public static GeneralPath createGeneralPath(int[][] nArray) {
        GeneralPath generalPath = null;
        try {
            generalPath = new GeneralPath();
            SamplePath.addPath(generalPath, nArray);
        }
        catch (Exception exception) {
            System.err.println("Cannot create general path from selection path");
            exception.printStackTrace();
        }
        return generalPath;
    }

    private static void addPath(GeneralPath generalPath, int[][] nArray) {
        if (nArray != null && nArray.length > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                if (i == 0) {
                    generalPath.moveTo(nArray[i][0], nArray[i][1]);
                    continue;
                }
                generalPath.lineTo(nArray[i][0], nArray[i][1]);
            }
            generalPath.closePath();
        }
    }

    public static class SelectionPath {
        public String content;
        public int[][] array;

        public SelectionPath(String string, int[][] nArray) {
            this.content = string;
            this.array = nArray;
        }

        public int[][] getOrCreateArrayClearContent() {
            int[][] nArray = this.getOrCreateArray();
            this.content = null;
            return nArray;
        }

        public int[][] getOrCreateArray() {
            if (this.array == null && this.content != null) {
                this.array = XmlPropertiesHelper.parseIntArray(this.content);
            }
            return this.array;
        }
    }
}

