/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.sample;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import org.apache.commons.io.FileUtils;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.sample.SampleValues;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNodeList;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.UniqueUID;
import se.prediktera.breeze.common.util.raw.FrameCube;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.ModelIncludedSamplesSettings;
import se.prediktera.breeze.entry.analyse.model.UidIndex;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SampleSegmentationColumn;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.table.renderer.BreezeTableCellRenderer;
import se.prediktera.breeze.test.stubs.GroupWithoutIO;
import se.prediktera.breeze.test.stubs.WorkflowWithoutIO;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.model.predictiontable.SharedPredictionTable;

public class SamplePredictionList
implements Iterable<SamplePrediction> {
    private final List<SamplePrediction> samplePredictions = new ArrayList<SamplePrediction>();
    private final BasicAnalyse analyse;
    private final CategoryFactor actualFactor;
    private final CategoryFactor predictedFactor;
    private final boolean isModel;

    public SamplePredictionList(BasicAnalyse basicAnalyse, CategoryFactor categoryFactor, CategoryFactor categoryFactor2, boolean bl) {
        this.analyse = basicAnalyse;
        this.actualFactor = categoryFactor;
        this.predictedFactor = categoryFactor2;
        this.isModel = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SamplePredictionList fromModel(BreezeProgress breezeProgress, Analyse analyse, List<Measurement> list, int n, boolean bl, boolean bl2) {
        List<Sample> list2;
        CategoryFactor categoryFactor = (CategoryFactor)analyse.getFactor();
        SamplePredictionList samplePredictionList = new SamplePredictionList(analyse, categoryFactor, categoryFactor, true);
        int n2 = analyse.getFactorHolder().getFactorIndex(categoryFactor);
        UidIndex.UidIndexList uidIndexList = null;
        UidIndex.UidIndexList uidIndexList2 = null;
        if (!bl) {
            uidIndexList = ModelIncludedSamplesSettings.parse(analyse.getSetupXmlNode(), "sample");
            uidIndexList2 = ModelIncludedSamplesSettings.parse(analyse.getSetupXmlNode(), "test");
        }
        if ((list2 = SamplePredictionList.getSamplesToPredict(list, n, bl2, uidIndexList, uidIndexList2)).size() > 0) {
            Object object;
            Sample sample = list2.get(0);
            float[][] fArray = sample.getAverageProfiles();
            if (fArray == null) {
                return samplePredictionList;
            }
            int n3 = Math.min(list2.size(), 1000);
            int n4 = (int)Math.ceil((float)list2.size() / 1000.0f);
            FrameCube frameCube = new FrameCube(new BandCount(fArray[0].length), new PixelWidth(n3), new FrameCount(n4), sample.measurement().getBandNames(), DataSize.FLOAT_4);
            for (int i = 0; i < list2.size(); ++i) {
                int n5 = i % n3;
                int n6 = i / n3;
                object = list2.get(i).getAverageProfiles();
                if (object == null) continue;
                frameCube.setSpectrum(n6, n5, object[0]);
            }
            File file = WorkspaceManager.getInstance().getWorkspace().getTempPath();
            String string = UniqueUID.getUniqueId();
            File file2 = new File(file, string);
            try {
                object = list.get(0).getWorkflow();
                WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO((Workflow)object){
                    final /* synthetic */ Workflow val$origWorkflow;
                    {
                        this.val$origWorkflow = workflow;
                    }

                    @Override
                    public RtFramePredictor.ReferenceConvertTo getReferenceConvertTo() {
                        return this.val$origWorkflow.getReferenceConvertTo();
                    }
                };
                GroupWithoutIO groupWithoutIO = new GroupWithoutIO(workflowWithoutIO);
                groupWithoutIO.setFolder(file);
                workflowWithoutIO.getRoot().addChild(analyse.createClassificationDescriptor());
                Measurement measurement = new Measurement(string, (Group)groupWithoutIO);
                measurement.save();
                frameCube.save(new File(file2, "measurement.raw"));
                ApplyChanges.applyChanges(breezeProgress, List.of(measurement), false, true, false, false);
                FrameListFromRaw frameListFromRaw = new FrameListFromRaw(new File(file2, "measurement_prediction.raw"));
                for (int i = 0; i < list2.size(); ++i) {
                    int n7 = i % n3;
                    int n8 = i / n3;
                    RawFrame rawFrame = (RawFrame)frameListFromRaw.get(n8);
                    float f = rawFrame.getFrameValue(n2, n7);
                    samplePredictionList.samplePredictions.add(new SamplePrediction(categoryFactor, list2.get(i), null, f));
                }
            }
            finally {
                try {
                    FileUtils.deleteDirectory((File)file2);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return samplePredictionList;
    }

    private static List<Sample> getSamplesToPredict(List<Measurement> list, int n, boolean bl, UidIndex.UidIndexList uidIndexList, UidIndex.UidIndexList uidIndexList2) {
        ArrayList<Sample> arrayList = new ArrayList<Sample>();
        if (list.isEmpty()) {
            return arrayList;
        }
        HashMap<Workflow, SegmentationNodeList> hashMap = new HashMap<Workflow, SegmentationNodeList>();
        for (Measurement measurement : list) {
            Workflow workflow = measurement.getWorkflow();
            SegmentationNodeList segmentationNodeList = (SegmentationNodeList)hashMap.get(workflow);
            if (segmentationNodeList == null) {
                segmentationNodeList = workflow.getSegmentationNodes(n);
                if (segmentationNodeList.isEmpty() && n == 0) {
                    segmentationNodeList.add(new SegmentationNode(""));
                }
                hashMap.put(workflow, segmentationNodeList);
            }
            for (SegmentationNode segmentationNode : segmentationNodeList) {
                String string = measurement.getUid();
                SampleSegmentationColumn sampleSegmentationColumn = measurement.getSamples(segmentationNode.getUid());
                for (Sample sample : sampleSegmentationColumn) {
                    boolean bl2 = true;
                    if (uidIndexList != null && uidIndexList2 != null) {
                        String string2 = sample.getSegmentationHashId();
                        int n2 = sampleSegmentationColumn.indexOf(sample);
                        boolean bl3 = uidIndexList.hasUidIndex(string, string2, n2);
                        boolean bl4 = uidIndexList2.hasUidIndex(string, string2, n2) != bl;
                        boolean bl5 = bl2 = bl3 && bl4;
                    }
                    if (!bl2) continue;
                    arrayList.add(sample);
                }
            }
        }
        return arrayList;
    }

    public static SamplePredictionList fromSamples(List<Sample> list, CategoryFactor categoryFactor, CategoryFactor categoryFactor2, DescriptorTreeNode descriptorTreeNode) {
        if (categoryFactor == null) {
            throw new ErrorHandler.InformationMessageException("Cannot find Project category for prediction category: " + categoryFactor2.getName());
        }
        SamplePredictionList samplePredictionList = new SamplePredictionList(descriptorTreeNode.getAnalyse(), categoryFactor, categoryFactor2, false);
        for (Sample sample : list) {
            int n;
            Float f = sample.getSampleValues().getValue(categoryFactor);
            if (f == null || (n = f.intValue()) == 0) continue;
            int n2 = (int)sample.getDescriptorValue(descriptorTreeNode);
            samplePredictionList.samplePredictions.add(new SamplePrediction(categoryFactor2, sample, n, n2));
        }
        return samplePredictionList;
    }

    public SamplePrediction getPredictionBySample(Sample sample) {
        for (SamplePrediction samplePrediction : this.samplePredictions) {
            if (!samplePrediction.getSample().equals(sample)) continue;
            return samplePrediction;
        }
        return null;
    }

    public BasicAnalyse getAnalyse() {
        return this.analyse;
    }

    public CategoryFactor getActualFactor() {
        return this.actualFactor;
    }

    public CategoryFactor getPredictedFactor() {
        return this.predictedFactor;
    }

    public boolean isModel() {
        return this.isModel;
    }

    public List<CatClass> getActualClasses() {
        if (this.isModel) {
            return this.actualFactor.getClasses();
        }
        return this.actualFactor.getLeafs();
    }

    public List<CatClass> getPredictedClasses() {
        if (this.isModel) {
            return this.predictedFactor.getClasses();
        }
        return this.predictedFactor.getLeafs();
    }

    public int getActualIndex(CatClass catClass) {
        int n = 0;
        for (CatClass catClass2 : this.getActualClasses()) {
            if (catClass2.getName().equals(catClass.getName())) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public int size() {
        return this.samplePredictions.size();
    }

    @Override
    public Iterator<SamplePrediction> iterator() {
        return this.samplePredictions.iterator();
    }

    public SharedPredictionTable createPredictionMatrix() {
        SharedPredictionTable sharedPredictionTable = new SharedPredictionTable(this.actualFactor.getMaxSize(), this.predictedFactor.getMaxSize());
        int[] nArray = this.actualFactor.getRootMap();
        for (SamplePrediction samplePrediction : this) {
            CategoryFactor categoryFactor;
            BasicSample basicSample = samplePrediction.getSample();
            SampleValues sampleValues = basicSample.getSampleValues();
            Float f = sampleValues.getValue(this.actualFactor);
            if (f == null && (categoryFactor = basicSample.measurement().getWorkflow().getCategoryFactors().getByName(this.actualFactor.getName())) != null) {
                f = sampleValues.getValue(categoryFactor);
            }
            if (f == null || f.intValue() == 0) continue;
            int n = samplePrediction.getSampleValue() != null ? samplePrediction.getSampleValue().intValue() : this.getRootIndex(nArray, f.intValue());
            sharedPredictionTable.add(n, (int)samplePrediction.getPrediction(), (Object)basicSample);
        }
        return sharedPredictionTable;
    }

    private int getRootIndex(int[] nArray, int n) {
        if (this.isModel) {
            if (n < nArray.length) {
                return nArray[n];
            }
            throw new RuntimeException("Variables in Project does not match variables in model");
        }
        return n;
    }

    public static class SamplePrediction {
        private final Factor factor;
        private final BasicSample sample;
        private final Number sampleValue;
        private final float prediction;

        public SamplePrediction(Factor factor, BasicSample basicSample, Number number, float f) {
            this.factor = factor;
            this.sample = basicSample;
            this.sampleValue = number;
            this.prediction = f;
        }

        public BasicSample getSample() {
            return this.sample;
        }

        public Number getSampleValue() {
            return this.sampleValue;
        }

        public float getPrediction() {
            return this.prediction;
        }

        public CatClass getCatClass() {
            return ((CategoryFactor)this.factor).getClassByValueIdx((int)this.prediction);
        }

        public Factor getFactor() {
            return this.factor;
        }
    }

    public static class PredictionCellRenderer
    extends BreezeTableCellRenderer {
        private SamplePredictionList predictionList;
        private SamplePrediction prediction;
        private Sample sample;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.sample = PredictionCellRenderer.getSampleAt(jTable, n);
            Object object2 = object;
            if (object instanceof SamplePredictionList) {
                this.predictionList = (SamplePredictionList)object;
                this.prediction = this.predictionList.getPredictionBySample(this.sample);
                object2 = this.predictionList.getActualFactor() instanceof CategoryFactor ? this.prediction.getCatClass().getName() : Float.valueOf(this.prediction.getPrediction());
            }
            return super.getTableCellRendererComponent(jTable, object2, bl, bl2, n, n2);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            Sample sample = this.sample;
            CategoryFactor categoryFactor = this.predictionList.getActualFactor();
            if (sample != null) {
                int n = this.getWidth() - 20;
                int n2 = this.getHeight() - 20;
                if (categoryFactor instanceof PropertyFactor) {
                    Float f = categoryFactor.getMinMax().normalise(this.prediction.getPrediction());
                    if (f != null) {
                        graphics.setColor(new Color(255, 0, 0, 100));
                        graphics.fillRect(10, 10, (int)((float)n * f.floatValue()), n2);
                    }
                } else if (categoryFactor instanceof CategoryFactor) {
                    CatClass.render(graphics, this.prediction.getCatClass(), 10, n2);
                }
            }
            this.getUI().paint(graphics, this);
        }
    }
}

