/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.sample;

import java.util.ArrayList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionHelper;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.realtime.descriptor.spatial.SpatialDescriptor;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SamplePredictionList;
import se.prediktera.map.model.predictiontable.SharedPredictionTable;

public class SamplePredictionListTest {
    @Test
    public void testCreateFromSampleList() {
        CategoryFactor categoryFactor = new CategoryFactor("Test");
        categoryFactor.addClass("A");
        categoryFactor.addClass("B");
        categoryFactor.addClass("C");
        DescriptorTreeNode descriptorTreeNode = (DescriptorTreeNode)FunctionHelper.createNew(new SpatialDescriptor.Info());
        ArrayList<Sample> arrayList = new ArrayList<Sample>();
        arrayList.add(this.createSample(categoryFactor, descriptorTreeNode, 0, 0));
        arrayList.add(this.createSample(categoryFactor, descriptorTreeNode, 1, 1));
        arrayList.add(this.createSample(categoryFactor, descriptorTreeNode, 1, 0));
        arrayList.add(this.createSample(categoryFactor, descriptorTreeNode, 2, 2));
        arrayList.add(this.createSample(categoryFactor, descriptorTreeNode, 2, 2));
        arrayList.add(this.createSample(categoryFactor, descriptorTreeNode, 2, 3));
        arrayList.add(this.createSample(categoryFactor, descriptorTreeNode, 3, 3));
        arrayList.add(this.createSample(categoryFactor, descriptorTreeNode, 3, 3));
        arrayList.add(this.createSample(categoryFactor, descriptorTreeNode, 3, 2));
        SharedPredictionTable sharedPredictionTable = SamplePredictionList.fromSamples(arrayList, categoryFactor, categoryFactor, descriptorTreeNode).createPredictionMatrix();
        MatcherAssert.assertThat((Object)sharedPredictionTable.get(1), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)sharedPredictionTable.get(2), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)sharedPredictionTable.get(3), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)sharedPredictionTable.getIncorrectly(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)sharedPredictionTable.getTotal(), (Matcher)CoreMatchers.is((Object)8));
    }

    private Sample createSample(CategoryFactor categoryFactor, DescriptorTreeNode descriptorTreeNode, int n, int n2) {
        Sample sample = new Sample();
        sample.getSampleValues().setValue(categoryFactor, n);
        sample.getDescriptorHolder().putFunctionResult(descriptorTreeNode.getUid(), new FunctionResult(n2));
        return sample;
    }
}

