/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.util;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.util.BreezeFilter;
import se.prediktera.breeze.test.SlowTestCategory;
import se.prediktera.breeze.test.stubs.MeasurementWithoutIO;
import se.prediktera.breeze.test.stubs.WorkflowWithoutIO;

@Category(value={SlowTestCategory.class})
public class BreezeFilterTest {
    @Test
    public void test() {
        MeasurementTest measurementTest = new MeasurementTest();
        MatcherAssert.assertThat((String)"Should always be true", (boolean)new BreezeFilter.All().matches(null));
        MatcherAssert.assertThat((String)"Should be true when both argument is true", (boolean)new BreezeFilter.And(new BreezeFilter.All(), new BreezeFilter.All()).matches(measurementTest));
        MatcherAssert.assertThat((String)"Should be false if one argument is false", (Object)new BreezeFilter.And(new BreezeFilter.Warning(), new BreezeFilter.All()).matches(measurementTest), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((String)"Should be false if one argument is false", (Object)new BreezeFilter.And(new BreezeFilter.All(), new BreezeFilter.Warning()).matches(measurementTest), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((String)"Should be false is apply changes is not needed", (Object)new BreezeFilter.ApplyChangesNeeded().matches(measurementTest), (Matcher)CoreMatchers.is((Object)false));
        measurementTest.setApplyChangedNeeded(true);
        MatcherAssert.assertThat((String)"Should be true is apply changes is needed", (Object)new BreezeFilter.ApplyChangesNeeded().matches(measurementTest), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((String)"Should be false if has data", (Object)new BreezeFilter.Grayed().matches(measurementTest), (Matcher)CoreMatchers.is((Object)false));
        measurementTest.setHasdata(false);
        MatcherAssert.assertThat((String)"Should be true if has no data", (Object)new BreezeFilter.Grayed().matches(measurementTest), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((String)"Should be true if name matches", (boolean)new BreezeFilter.Name("").matches(measurementTest));
        MatcherAssert.assertThat((String)"Should be false if name not matches", (Object)new BreezeFilter.Name("na").matches(measurementTest), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((String)"Should be true if any argument is true", (boolean)new BreezeFilter.Or(new BreezeFilter.All(), new BreezeFilter.All()).matches(measurementTest));
        MatcherAssert.assertThat((String)"Should be true if any argument is true", (boolean)new BreezeFilter.Or(new BreezeFilter.Warning(), new BreezeFilter.All()).matches(measurementTest));
        MatcherAssert.assertThat((String)"Should be true if any argument is true", (boolean)new BreezeFilter.Or(new BreezeFilter.All(), new BreezeFilter.Warning()).matches(measurementTest));
        MatcherAssert.assertThat((String)"Should be false if all arguments is false", (Object)new BreezeFilter.Or(new BreezeFilter.Warning(), new BreezeFilter.Warning()).matches(measurementTest), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((String)"Should be true if uid matches", (boolean)new BreezeFilter.UID(measurementTest.getUid()).matches(measurementTest));
        MatcherAssert.assertThat((String)"Should be false is not uid matches", (Object)new BreezeFilter.UID("na").matches(measurementTest), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((String)"Should be false", (Object)new BreezeFilter.Warning().matches(measurementTest), (Matcher)CoreMatchers.is((Object)false));
        WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO();
        WorkflowWithoutIO workflowWithoutIO2 = new WorkflowWithoutIO(this){

            @Override
            public Workflow.WorkflowType getType() {
                return Workflow.WorkflowType.Play;
            }
        };
        MatcherAssert.assertThat((String)"Should be false", (Object)new BreezeFilter.AnalyseStudy(workflowWithoutIO).matches(workflowWithoutIO2), (Matcher)CoreMatchers.is((Object)false));
        workflowWithoutIO2.getProperties().setPropertyLocal("studyId", workflowWithoutIO.getUid());
        MatcherAssert.assertThat((String)"Should be true", (Object)new BreezeFilter.AnalyseStudy(workflowWithoutIO).matches(workflowWithoutIO2), (Matcher)CoreMatchers.is((Object)true));
    }

    private static class MeasurementTest
    extends MeasurementWithoutIO {
        private boolean hasdata = true;

        private MeasurementTest() {
        }

        @Override
        public boolean hasData() {
            return this.hasdata;
        }

        @Override
        public boolean isRgbData() {
            return false;
        }

        public void setHasdata(boolean bl) {
            this.hasdata = bl;
        }
    }
}

