/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.util;

import java.util.List;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.util.WizardInfo;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.pp.PPViewClass;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlProperties;
import se.prediktera.breeze.frontend.wizard.model.ANNModelWizard;
import se.prediktera.breeze.frontend.wizard.model.AbstractModelWizard;
import se.prediktera.breeze.frontend.wizard.model.ClassificationModelWizard;
import se.prediktera.breeze.frontend.wizard.model.ClassificationRuntimeModelWizard;
import se.prediktera.breeze.frontend.wizard.model.ClassificationSimcaModelWizard;
import se.prediktera.breeze.frontend.wizard.model.CurveSeparationModelWizard;
import se.prediktera.breeze.frontend.wizard.model.QuantificationModelWizard;
import se.prediktera.breeze.frontend.wizard.model.QuantificationRuntimeModelWizard;
import se.prediktera.breeze.frontend.wizard.model.SampleModelWizard;
import se.prediktera.breeze.frontend.wizard.model.SampleRuntimeModelWizard;

public abstract class PPModelInfo
extends WizardInfo
implements AbstractCardInfo {
    public abstract BasicAnalyse.ModelMethod getModelMethod();

    public abstract AbstractModelWizard createWizard(BreezeProgress var1, BreezeMainPanel var2, PPViewClass var3, Analyse var4, AbstractModelWizard.OnFinishWizardCallback var5);

    public List<BasicAnalyse.ModelMethod> getTypes(Workflow workflow) {
        return null;
    }

    public static BasicAnalyse.ModelMethod fromAnalyseProperties(Analyse analyse) {
        XmlProperties xmlProperties = analyse.getProperties();
        String string = xmlProperties.getPropertyLocal("method", null);
        if (string != null) {
            try {
                return BasicAnalyse.ModelMethod.valueOf(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return PPModelInfo.getLegacyModelMethod(xmlProperties);
    }

    private static BasicAnalyse.ModelMethod getLegacyModelMethod(XmlProperties xmlProperties) {
        String string = xmlProperties.getPropertyLocal("type", null);
        if (string != null && string.length() > 0) {
            return PPModelInfo.getLegacyModelMethodFromName(string);
        }
        String string2 = xmlProperties.getPropertyLocal("ppclass", null);
        if (string2 != null && string2.length() > 0) {
            return PPModelInfo.getLegacyModelMethodFromName(string2);
        }
        return BasicAnalyse.ModelMethod.ClassificationPlsDa;
    }

    private static BasicAnalyse.ModelMethod getLegacyModelMethodFromName(String string) {
        String string2 = string.toLowerCase();
        if (string2.contains("sample")) {
            return BasicAnalyse.ModelMethod.SamplePca;
        }
        if (string2.contains("quantification")) {
            return BasicAnalyse.ModelMethod.QuantificationPls;
        }
        if (string2.contains("simca")) {
            return BasicAnalyse.ModelMethod.SimcaClassification;
        }
        if (string2.contains("classification")) {
            return BasicAnalyse.ModelMethod.ClassificationPlsDa;
        }
        throw new RuntimeException("Cannot find model from name: " + string);
    }

    public static PPModelInfo fromModelMethod(BasicAnalyse.ModelMethod modelMethod) {
        switch (modelMethod) {
            case SamplePca: {
                return new SampleModelWizard.Info();
            }
            case SampleRuntime: {
                return new SampleRuntimeModelWizard.Info();
            }
            case QuantificationPls: {
                return new QuantificationModelWizard.Info();
            }
            case ClassificationPlsDa: {
                return new ClassificationModelWizard.Info();
            }
            case SimcaClassification: {
                return new ClassificationSimcaModelWizard.Info();
            }
            case ClassificationCurveSeparation: {
                return new CurveSeparationModelWizard.Info();
            }
            case QuantificationRuntime: {
                return new QuantificationRuntimeModelWizard.Info();
            }
            case ClassificationRuntime: {
                return new ClassificationRuntimeModelWizard.Info();
            }
            case ClassificationANN: {
                return new ANNModelWizard.Info();
            }
        }
        throw new RuntimeException("No such method " + String.valueOf((Object)modelMethod));
    }
}

