/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.workflow;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.workflow.PropertyLimit;
import se.prediktera.breeze.entry.workflow.Workflow;

public class LimitConfiguration
implements Iterable<PropertyLimit> {
    private final List<PropertyLimit> limitList = new ArrayList<PropertyLimit>();
    private String name;
    private Date updated = new Date();

    public LimitConfiguration(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    public LimitConfiguration clone() {
        LimitConfiguration limitConfiguration = new LimitConfiguration(this.name);
        for (PropertyLimit propertyLimit : this) {
            limitConfiguration.addChild(propertyLimit.clone());
        }
        return limitConfiguration;
    }

    public void addChild(PropertyLimit propertyLimit) {
        this.limitList.add(propertyLimit);
    }

    public void removeChild(PropertyLimit propertyLimit) {
        this.limitList.remove(propertyLimit);
    }

    public void parse(Workflow workflow, Node node) {
        for (Node node2 : XmlParserHelper.getNodeList(node, "limit", null)) {
            this.addChild(new PropertyLimit(workflow, node2));
        }
    }

    public PropertyLimit getWrapper(Factor factor) {
        for (PropertyLimit propertyLimit : this.getChildList()) {
            String string = propertyLimit.getId();
            if (string == null || !string.equals(factor.getOrigUid()) && !string.equals(factor.getUid())) continue;
            return propertyLimit;
        }
        return null;
    }

    @Override
    public Iterator<PropertyLimit> iterator() {
        return this.limitList.iterator();
    }

    public List<PropertyLimit> getChildList() {
        return this.limitList;
    }

    public void setUpdated() {
        this.updated = new Date();
    }

    public boolean hasChanged(LimitConfiguration limitConfiguration, Date date) {
        if (limitConfiguration != this) {
            return true;
        }
        return date.before(this.updated);
    }
}

