/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.workflow;

import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.workflow.Workflow;

public class PropertyLimit {
    private PropertyFactor factor;
    private MinMax minMax;
    private Workflow workflow;
    private String factorId;

    public PropertyLimit(PropertyFactor propertyFactor, MinMax minMax) {
        this.factor = propertyFactor;
        this.minMax = minMax;
    }

    public PropertyLimit(Workflow workflow, Node node) {
        this.workflow = workflow;
        this.factorId = XmlParserHelper.getAttribute(node, "factor");
        this.minMax = new MinMax(PropertyLimit.getFloatAttribute(node, "min"), PropertyLimit.getFloatAttribute(node, "max"));
    }

    private static float getFloatAttribute(Node node, String string) {
        String string2 = XmlParserHelper.getAttribute(node, string);
        if (string2 != null) {
            return RtDataFormat.toNumberFloat(string2);
        }
        return -1.0f;
    }

    public PropertyFactor getFactor() {
        if (this.factor == null && this.workflow != null) {
            this.factor = PropertyLimit.getFactor(this.workflow, this.factorId);
        }
        return this.factor;
    }

    private static PropertyFactor getFactor(Workflow workflow, String string) {
        for (DescriptorTreeNode descriptorTreeNode : workflow.getAllDescriptorNodes()) {
            Factor factor = descriptorTreeNode.getFactor();
            if (!(factor instanceof PropertyFactor) || !factor.getUid().equals(string) && !factor.getOrigUid().equals(string)) continue;
            return (PropertyFactor)factor;
        }
        return null;
    }

    public String toString() {
        return this.factor != null ? this.factor.getName() : "FactorId: " + this.factorId;
    }

    public void setMin(float f) {
        this.minMax = new MinMax(f, this.minMax.max().floatValue());
    }

    public float getMin() {
        return this.minMax.min().floatValue();
    }

    public void setMax(float f) {
        this.minMax = new MinMax(this.minMax.min().floatValue(), f);
    }

    public float getMax() {
        return this.minMax.max().floatValue();
    }

    public MinMax getMinMax() {
        return this.minMax;
    }

    public void setMinMax(MinMax minMax) {
        this.minMax = minMax;
    }

    public float normalize(float f) {
        return this.normalize(f, 100.0f);
    }

    public float normalize(float f, float f2) {
        return this.minMax.normalise(f).floatValue() * f2;
    }

    public PropertyLimit clone() {
        return new PropertyLimit(this.getFactor(), new MinMax(this.minMax));
    }

    public String getId() {
        PropertyFactor propertyFactor = this.getFactor();
        if (propertyFactor != null) {
            return propertyFactor.getOrigUid();
        }
        return null;
    }
}

