/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.workflow;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.workflow.LimitConfiguration;
import se.prediktera.breeze.entry.workflow.PropertyLimit;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.map.main.ColorScalesHelper;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.plot.axisplot.settings.Color.PlotContinuousColor;

public class VisualisationNode {
    private final Workflow workflow;
    private String name;
    private final List<LimitConfiguration> limitList = new ArrayList<LimitConfiguration>();
    private LimitConfiguration defaultLimitNode;
    private String segmentationBranch;
    private int segmentationLevel = 0;
    private String segmentationHashId;

    public VisualisationNode(Workflow workflow, String string) {
        this.workflow = workflow;
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    public List<LimitConfiguration> getLimitList() {
        return this.limitList;
    }

    public LimitConfiguration createLimitFromModel(BreezeProgressManager breezeProgressManager, String string) {
        LimitConfiguration limitConfiguration = new LimitConfiguration(string);
        this.updateLimit(breezeProgressManager, limitConfiguration, true);
        return limitConfiguration;
    }

    public void updateLimits(BreezeProgressManager breezeProgressManager, boolean bl) {
        for (LimitConfiguration limitConfiguration : this.getLimitList()) {
            this.updateLimit(breezeProgressManager, limitConfiguration, bl);
        }
    }

    public void updateLimit(BreezeProgressManager breezeProgressManager, LimitConfiguration limitConfiguration, boolean bl) {
        HashSet<PropertyLimit> hashSet = new HashSet<PropertyLimit>(limitConfiguration.getChildList());
        List<DescriptorTreeNode> list = this.workflow.getAllDescriptorNodes();
        for (DescriptorTreeNode object : list) {
            Factor factor;
            BasicAnalyse basicAnalyse = object.getAnalyse();
            if (basicAnalyse == null || !((factor = basicAnalyse.getFactor(object.getFactorUid())) instanceof PropertyFactor)) continue;
            PropertyFactor propertyFactor = (PropertyFactor)factor;
            if (factor.isDynamicMinMax()) continue;
            PropertyLimit propertyLimit = limitConfiguration.getWrapper(factor);
            MinMax minMax = this.getFactorMinMax(breezeProgressManager, basicAnalyse, factor);
            if (propertyLimit == null) {
                limitConfiguration.addChild(new PropertyLimit(propertyFactor, minMax));
            } else if (bl) {
                propertyLimit.setMinMax(minMax);
            }
            hashSet.remove(propertyLimit);
        }
        for (PropertyLimit propertyLimit : hashSet) {
            limitConfiguration.removeChild(propertyLimit);
        }
    }

    private MinMax getFactorMinMax(BreezeProgressManager breezeProgressManager, BasicAnalyse basicAnalyse, Factor factor) {
        AbstractModel abstractModel;
        if (basicAnalyse instanceof Analyse && (abstractModel = ((Analyse)basicAnalyse).getBaseModel(breezeProgressManager)) != null && abstractModel.getComponentsInt() > 0) {
            int n = basicAnalyse.getFactorHolder().getFactorIndex(factor);
            return new MinMax((float)abstractModel.getYmin(n), (float)abstractModel.getYmax(n));
        }
        return new MinMax(factor.getMinMax());
    }

    public void addLimit(LimitConfiguration limitConfiguration) {
        this.limitList.add(limitConfiguration);
    }

    public void parse(Node node) {
        String string = XmlParserHelper.getAttribute(node, "limit");
        List<Node> list = XmlParserHelper.getNodeList(node, "limits", null);
        for (Node node2 : list) {
            String string2 = XmlParserHelper.getName(node2);
            LimitConfiguration limitConfiguration = new LimitConfiguration(string2);
            limitConfiguration.parse(this.workflow, node2);
            this.limitList.add(limitConfiguration);
            if (string == null || !string.equals(string2)) continue;
            this.defaultLimitNode = limitConfiguration;
        }
        String string3 = XmlParserHelper.getAttribute(node, "level");
        if (string3 != null) {
            this.segmentationLevel = RtDataFormat.toNumberInt(string3);
        } else {
            this.setDefaultLevel(true);
        }
        this.segmentationHashId = XmlParserHelper.getAttribute(node, "id");
    }

    public Element save(Node node) {
        Element element = XmlParserHelper.addElement(node, "visualisation");
        if (this.defaultLimitNode != null) {
            XmlParserHelper.setAttribute((Node)element, "limit", this.defaultLimitNode.getName());
        }
        for (LimitConfiguration limitConfiguration : this.limitList) {
            Element element2 = XmlParserHelper.addElement(element, "limits");
            element2.setAttribute("name", limitConfiguration.getName());
            for (PropertyLimit propertyLimit : limitConfiguration.getChildList()) {
                Element element3 = XmlParserHelper.addElement(element2, "limit");
                XmlParserHelper.setAttribute((Node)element3, "factor", propertyLimit.getId());
                XmlParserHelper.setAttribute((Node)element3, "min", propertyLimit.getMin());
                XmlParserHelper.setAttribute((Node)element3, "max", propertyLimit.getMax());
            }
        }
        XmlParserHelper.setAttribute((Node)element, "level", this.segmentationLevel);
        if (this.segmentationHashId != null) {
            XmlParserHelper.setAttribute((Node)element, "id", this.segmentationHashId);
        }
        return element;
    }

    public int getLineWidth() {
        return 5;
    }

    public Double getObjectSize() {
        return 10.0;
    }

    public Object clone() {
        VisualisationNode visualisationNode = new VisualisationNode(this.workflow, this.name);
        for (LimitConfiguration limitConfiguration : this.limitList) {
            visualisationNode.limitList.add(limitConfiguration.clone());
        }
        int n = this.limitList.indexOf(this.getDefaultLimitNode(null));
        if (n >= 0) {
            visualisationNode.setDefaultLimitNode(visualisationNode.limitList.get(n));
        }
        visualisationNode.segmentationLevel = this.segmentationLevel;
        return visualisationNode;
    }

    public String getColor() {
        return RtPerfectSpread.getColorToString(RtPerfectSpread.generateColor(1));
    }

    public Color getTrackColor() {
        return Color.green;
    }

    public void setDefaultLimitNode(LimitConfiguration limitConfiguration) {
        this.defaultLimitNode = limitConfiguration;
    }

    public LimitConfiguration getDefaultLimitNode(Group group) {
        LimitConfiguration limitConfiguration;
        if (!this.limitList.contains(this.defaultLimitNode)) {
            this.defaultLimitNode = null;
        }
        if (this.defaultLimitNode == null && this.limitList.size() > 0) {
            this.defaultLimitNode = this.limitList.get(0);
        }
        if (group != null && (limitConfiguration = this.getGroupLimit(group)) != null) {
            return limitConfiguration;
        }
        return this.defaultLimitNode;
    }

    private LimitConfiguration getGroupLimit(Group group) {
        String string = group.getLimit();
        if (string != null) {
            for (LimitConfiguration limitConfiguration : this.limitList) {
                if (!limitConfiguration.getName().equals(string)) continue;
                return limitConfiguration;
            }
        }
        return null;
    }

    public void save() {
        this.workflow.save();
    }

    public void setDefaultLevel(boolean bl) {
        this.setDefaultLevel(bl, false);
    }

    public void setDefaultLevel(boolean bl, boolean bl2) {
        if (bl || this.segmentationLevel < 1) {
            FunctionTreeNode functionTreeNode = this.workflow.getRoot();
            SegmentationNode segmentationNode = bl2 ? SegmentationNode.getLastSegmentationNode(functionTreeNode) : SegmentationNode.getNextSegmentationNode(functionTreeNode);
            this.segmentationLevel = SegmentationNode.getSegmentationLevel(segmentationNode);
            this.segmentationHashId = null;
        }
    }

    public void setSegmentationLevel(int n) {
        this.setSegmentationLevel(n, null);
    }

    public void setSegmentationLevel(int n, String string) {
        this.segmentationLevel = n;
        this.segmentationHashId = string;
    }

    public void clearSegmentationHashId() {
        this.segmentationHashId = null;
    }

    public String getSegmentationBranch() {
        this.checkMaxLevel();
        return this.segmentationBranch;
    }

    public int getSegmentationLevel() {
        this.checkMaxLevel();
        return this.segmentationLevel;
    }

    public String getSegmentationHashId() {
        this.checkMaxLevel();
        return this.segmentationHashId;
    }

    private void checkMaxLevel() {
        int n = SegmentationNode.getMaxLevel(this.workflow.getRoot(), 0);
        if (n == 0 || this.segmentationLevel > n) {
            this.segmentationLevel = n;
            this.segmentationHashId = null;
        }
    }

    public int getLastSegmentationLevel() {
        return SegmentationNode.getSegmentationLevel(SegmentationNode.getLastSegmentationNode(this.workflow.getRoot()));
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    public static class ColorScale {
        public String name;
        public boolean reverse;

        public ColorScale(String string) {
            this(string, false);
        }

        public ColorScale(String string, boolean bl) {
            this.name = string;
            this.reverse = bl;
        }

        public ColorScale(Node node) {
            this(node.getTextContent(), XmlParserHelper.getBooleanAttribute(node, "reverse", false));
        }

        public ColorScale(PlotContinuousColor plotContinuousColor) {
            this(plotContinuousColor.getName(), plotContinuousColor.isReversed());
        }

        public boolean equals(Object object) {
            if (object instanceof ColorScale) {
                ColorScale colorScale = (ColorScale)object;
                return colorScale.name.equalsIgnoreCase(this.name) && colorScale.reverse == this.reverse;
            }
            return false;
        }

        public boolean notEquals(ColorScale colorScale) {
            return !this.equals(colorScale);
        }

        public PlotContinuousColor create() {
            PlotContinuousColor plotContinuousColor = (PlotContinuousColor)ColorScalesHelper.getInstance().getColorScale(this.name).cloneColors();
            if (this.reverse) {
                plotContinuousColor.reverseColors();
            }
            return plotContinuousColor;
        }
    }
}

