/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.workflow;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.backend.measure.writers.FileImageWriter;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.entry.BasicMasterCache;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.ObjectWithChildrenAndParent;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNodeList;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluationTree;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionHelper;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeList;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeListMap;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.entry.workflow.BasicWorkflow;
import se.prediktera.breeze.common.realtime.descriptor.spatial.SpatialDescriptor;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.BreezeRecycleBin;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.EntryData;
import se.prediktera.breeze.entry.EntryHolder;
import se.prediktera.breeze.entry.WorkflowOrGroup;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.comment.CommentList;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.identifier.IdentifierList;
import se.prediktera.breeze.entry.legacy.LegacyFileFormat;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SampleSegmentationColumn;
import se.prediktera.breeze.entry.workflow.VisualisationNode;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportBreezeRuntime;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.util.xmlproperties.DefaultXmlProperties;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.recorder.BreezeRecorder;
import se.prediktera.breeze.util.SortedFileList;
import se.prediktera.map.register.RegInfo;

public class Workflow
extends BasicWorkflow
implements ObjectWithChildrenAndParent<Workflow, Group>,
EntryHolder,
WorkflowOrGroup {
    private final EntryData entryData;
    private final File parentFolder;
    private final FunctionTreeListMap contextHolder = new FunctionTreeListMap(this);
    private final VisualisationNode visualisationNode = new VisualisationNode(this, "default");
    private boolean parsed;
    private final IdentifierList identifiers = new IdentifierList();
    private final CommentList comments = new CommentList();
    private final DefaultXmlProperties properties = new DefaultXmlProperties("settings");
    private int changeIndex;
    private List<Group> childList = new ArrayList<Group>();
    private final HighlighedSamples highlighedSamples = new HighlighedSamples();
    private RtFramePredictor.ReferenceConvertTo pixelExploreReferenceConvertTo;
    private boolean demoMode;
    public String functionErrorId;
    private boolean loadFully;

    public Workflow(String string, File file) {
        this.entryData = new EntryData(this, string, file);
        this.parentFolder = file;
        this.setDefaultProperties();
    }

    public Workflow(File file) {
        this(file, null, true);
    }

    public Workflow(File file, String string, boolean bl) {
        File file2 = new LegacyFileFormat.WorkflowLegacyFileFormat().renameIfNeeded(file);
        this.parentFolder = file2.getParentFile();
        this.entryData = new EntryData(file2.getName());
        Node node = XmlParserHelper.parseXMLRoot(this.getXml(), "workflow");
        this.entryData.setAttributesAndNewName(node, string);
        boolean bl2 = false;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string2 = node2.getNodeName().toLowerCase();
            if (string2.equals("comments")) {
                this.getComments().parseComments(node2);
                continue;
            }
            if (string2.equals("identifiers")) {
                this.identifiers.parseIdentifiers(node2);
                continue;
            }
            if (string2.equals("settings")) {
                this.getProperties().setRootProperty(node2);
                bl2 = true;
                continue;
            }
            if (string2.equals("variables")) {
                this.factorHolder.parseVariables(node2);
                continue;
            }
            if (string2.equals("descriptors")) {
                this.getContextHolder().parse(node2);
                continue;
            }
            if (!string2.equals("visualisation")) continue;
            VisualisationNode visualisationNode = this.getVisualisationNode();
            visualisationNode.parse(node2);
        }
        XmlProperties.ensureThatSettingsExists(this.getProperties(), node, bl2);
        this.clearChildList();
        if (bl) {
            this.loadFully();
        }
    }

    public void loadFully() {
        if (!this.loadFully) {
            this.loadFully = true;
            this.setDefaultProperties();
            this.getAnalyseTree().loadRtAnalyis();
        }
    }

    @Override
    public boolean delete(boolean bl) {
        Measurement.clearFromCache(this);
        return BreezeRecycleBin.delete(this, Entry.EntryType.Workflow, bl);
    }

    @Override
    public File getFolder() {
        return new File(this.parentFolder, this.getName());
    }

    public File getParentFolder() {
        return this.parentFolder;
    }

    public FunctionTreeListMap getContextHolder() {
        return this.contextHolder;
    }

    @Override
    public EvaluationTree getAnalyseTree() {
        FunctionTreeList functionTreeList = this.getContextHolder().getFunctionTreeList("workflow");
        EvaluationTree evaluationTree = (EvaluationTree)functionTreeList.getDefaultFunctionTree();
        if (evaluationTree == null) {
            evaluationTree = new EvaluationTree();
            evaluationTree.setRoot(FunctionHelper.createDefaultFunction("None"));
            functionTreeList.addChild(evaluationTree);
        }
        return evaluationTree;
    }

    public List<DescriptorTreeNode> getAllDescriptorNodes() {
        return this.getAnalyseTree().getDescriptorNodes();
    }

    public List<DescriptorTreeNode> getSegmentationLevelDescriptorNodes(boolean bl) {
        return this.getSegmentationLevelDescriptorNodes(new SegmentationIdentifier(this.getSegmentationLevel(), this.getSegmentationHashId()), bl);
    }

    public List<DescriptorTreeNode> getSegmentationLevelDescriptorNodes(SegmentationIdentifier segmentationIdentifier, boolean bl) {
        SegmentationNode segmentationNode = SegmentationNode.getNodesAtLevel(this.getRoot(), segmentationIdentifier.Level).filter(segmentationIdentifier.HashId).getFirst();
        if (segmentationNode != null) {
            return segmentationNode.getDescriptorNodes(bl);
        }
        return this.getRoot().getDescriptorNodes(bl);
    }

    public FunctionTreeNode getRoot() {
        return this.getAnalyseTree().getRoot();
    }

    public List<FunctionTreeNode> getRootList() {
        FunctionTreeNode functionTreeNode = this.getRoot();
        if (functionTreeNode != null) {
            return functionTreeNode.getChildList();
        }
        return new ArrayList<FunctionTreeNode>();
    }

    @Override
    public void save() {
        this.save(this.getXml());
    }

    public void save(File file) {
        this.saveNoChangeIndex(file);
        this.increaseChangeIndex();
    }

    public void saveNoChangeIndex() {
        this.saveNoChangeIndex(this.getXml());
    }

    public void saveNoChangeIndex(File file) {
        Document document = XmlParserHelper.createXMLdoc();
        Element element = XmlParserHelper.addRoot("workflow", document);
        this.entryData.writeXmlAttributes(element, "Workflow");
        XmlProperties.addProperties(this.getProperties(), document, element);
        this.getComments().addComments(element);
        this.identifiers.addIdentifiers(element);
        this.factorHolder.addVariableDef(element);
        this.getContextHolder().save(element);
        this.getVisualisationNode().save(element);
        XmlProperties.createDirectoriesAndOutputXML(file, document);
    }

    public void increaseChangeIndex() {
        ++this.changeIndex;
    }

    public int getChangeIndex() {
        return this.changeIndex;
    }

    @Override
    public File getXml() {
        return new File(this.getFolder(), "workflow.xml");
    }

    public VisualisationNode getVisualisationNode() {
        return this.visualisationNode;
    }

    private File getCustomizedImageFile() {
        return new File(this.getFolder(), "workflow.png");
    }

    @Override
    public File getCustomImageFile() {
        File file = this.getCustomizedImageFile();
        if (file != null && file.exists()) {
            return file;
        }
        for (File file2 : new SortedFileList.SortedFolderList(this.getFolder())) {
            File file3 = Group.getMeasurementImageFile(file2);
            if (file3 == null) continue;
            return file3;
        }
        return null;
    }

    public void setApplyChangesNeededOnAllMeasurements() {
        for (Group group : this.getChildList()) {
            for (Measurement measurement : group.getChildList()) {
                if (measurement.isApplyChangesNeeded()) continue;
                measurement.setApplyChangedNeeded(true);
                measurement.save();
            }
            group.save();
        }
    }

    public String toString() {
        return this.getName();
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public void setParsed(boolean bl) {
        this.parsed = bl;
    }

    public IdentifierList getIdentifiers() {
        return this.identifiers;
    }

    protected void setDefaultProperties() {
        this.getMaxLines();
        this.shouldSaveMeasurementsWithObjectRecognition();
        this.shouldSaveRawDataWhenMeasuringWithObjectRecognition();
        this.isParallelMeasurementSegmentation();
        this.isCropMeasurement();
        this.getMinPixels();
        this.getMaxSignalReference();
        this.isIncludeChildObjects();
        this.getReferenceConvertTo();
        this.isValueCorrectionPixels();
        this.getDefaultUnit();
        if (StringUtils.isEmpty((CharSequence)this.getProperties().getPropertyNodeLocal("visualisation/colorScale").getTextContent())) {
            this.setColorScale(BreezeProperties.getInstance().getColorScale());
        }
        this.getDescription();
        this.getDefaultReduce();
        this.getVisualisationDirection();
        this.getVisualisationHorizontalDirection();
        this.getVisualisationVerticalDirection();
        this.getObjectBorder();
        this.getProperties().getPropertyLocal("runtime/predictionMode", "Rgb");
        this.getModellingExplorePixel();
        this.getModellingDefaultExcludeWavelengthsBeginningPercent();
        this.getModellingDefaultExcludeWavelengthsEndPercent();
        this.getModellingExplorePixelSnv();
        this.getModellingExploreSnv();
        this.getDescriptorExplorePixel();
        this.getExplorePixelFilter();
        this.getExploreFilter();
        this.getImageHistogramPerctage();
        this.getImageHistogramNormalizeMin();
        this.getImageHistogramBucketSize();
        this.getImageHistogramStrechAll();
        this.getImageHistogramRange();
        this.getImageHistogramEnable();
        this.getImageHistogramMinBands();
        this.getStrayLightFile();
        this.getMaxSaturatedBand();
        this.isCompressReferences();
        if (RegInfo.isGeoFeature()) {
            this.getDepthRegistration();
        }
    }

    public BreezeRecorder.RecordMode getRecordMode() {
        return BreezeRecorder.RecordMode.parse(this.getProperties().getPropertyLocal("measure/recordMode", this.getDefaultRecordMode().name()));
    }

    private BreezeRecorder.RecordMode getDefaultRecordMode() {
        if (this.getType().equals((Object)WorkflowType.Play)) {
            return BreezeRecorder.RecordMode.Play;
        }
        return BreezeRecorder.RecordMode.Measurement;
    }

    public void setRecordMode(BreezeRecorder.RecordMode recordMode) {
        this.getProperties().setPropertyLocal("measure/recordMode", recordMode.name());
    }

    public void setMaxLines(int n) {
        this.getProperties().setPropertyLocal("measure/maxlines", Integer.toString(n));
    }

    @Override
    public int getMaxLines() {
        return this.getProperties().getPropertyIntLocal("measure/maxlines", 10000);
    }

    public boolean shouldSaveMeasurementsWithObjectRecognition() {
        return this.getProperties().getPropertyBoolLocal("measure/saveMeasurements", false);
    }

    public boolean shouldSaveRawDataWhenMeasuringWithObjectRecognition() {
        return this.getProperties().getPropertyBoolLocal("measure/saveRawData", true);
    }

    public PPExportBreezeRuntime.ObjectProcessing isParallelMeasurementSegmentation() {
        return PPExportBreezeRuntime.ObjectProcessing.parse(this.getProperties().getPropertyBoolLocal("measure/parallelMeasurementSegmentation", true));
    }

    public boolean isToggleComments() {
        return this.getProperties().getPropertyBoolLocal("measure/toggleCommens", false);
    }

    public void setToggleComments(boolean bl) {
        this.getProperties().setPropertyLocal("measure/toggleCommens", String.valueOf(bl));
    }

    public boolean isCropMeasurement() {
        return this.getProperties().getPropertyBoolLocal("measure/cropMeasurement", false);
    }

    public void setMinLines(int n) {
        this.getProperties().setPropertyLocal("measure/minPixels", Integer.toString(n));
    }

    public int getMinPixels() {
        return this.getProperties().getPropertyIntLocal("measure/minPixels", 1);
    }

    public float getMaxSignalReference() {
        return (float)this.getProperties().getPropertyDoubleLocal("measure/maxSignalReference", 1.0);
    }

    public boolean isIncludeChildObjects() {
        return this.getProperties().getPropertyBoolLocal("measure/includeChildObjects", false);
    }

    public void setReferenceConvertTo(RtFramePredictor.ReferenceConvertTo referenceConvertTo) {
        this.getProperties().setPropertyLocal("measure/referenceConvertTo", referenceConvertTo.name().toLowerCase());
    }

    public RtFramePredictor.ReferenceConvertTo getReferenceConvertTo() {
        return RtFramePredictor.ReferenceConvertTo.parse(this.getProperties().getPropertyLocal("measure/referenceConvertTo", this.getDefaultReferenceConvertTo().name().toLowerCase()));
    }

    public RtFramePredictor.ReferenceConvertTo getDefaultReferenceConvertTo() {
        return this.isXrayData() ? RtFramePredictor.ReferenceConvertTo.Reflectance : BreezeProperties.getInstance().getReferenceConvertTo();
    }

    public RtFramePredictor.ReferenceConvertTo getPixelExploreReferenceConvertTo() {
        if (this.pixelExploreReferenceConvertTo == null) {
            this.pixelExploreReferenceConvertTo = this.getReferenceConvertTo();
        }
        return this.pixelExploreReferenceConvertTo;
    }

    public void clearPixelExploreCache() {
        this.pixelExploreReferenceConvertTo = null;
    }

    public void setPixelExploreReferenceConvertTo(RtFramePredictor.ReferenceConvertTo referenceConvertTo) {
        this.pixelExploreReferenceConvertTo = referenceConvertTo;
    }

    public boolean isValueCorrectionPixels() {
        return this.getProperties().getPropertyBoolLocal("measure/applyValueCorrection", true);
    }

    public SpatialDescriptor.SiUnit getDefaultUnit() {
        return SpatialDescriptor.SiUnit.parse(this.getProperties().getPropertyLocal("measure/defaultUnit", BreezeProperties.getInstance().getDefaultUnit().name()));
    }

    public void setColorScale(VisualisationNode.ColorScale colorScale) {
        Node node = this.getProperties().getPropertyNodeLocal("visualisation/colorScale");
        node.setTextContent(colorScale.name);
        XmlParserHelper.setAttribute(node, "reverse", colorScale.reverse);
    }

    public VisualisationNode.ColorScale getColorScale() {
        return new VisualisationNode.ColorScale(this.getProperties().getPropertyNodeLocal("visualisation/colorScale"));
    }

    public FileImageWriter.ImageHistogram getHistogramSettings() {
        return new FileImageWriter.ImageHistogram(this);
    }

    public void setImageHistogramPerctage(double d) {
        this.getProperties().setPropertyLocal("visualisation/imageHistogramPercentage", RtDataFormat.toString(d));
    }

    public double getImageHistogramPerctage() {
        return this.getProperties().getPropertyDoubleLocal("visualisation/imageHistogramPercentage", 0.01);
    }

    public void setImageHistogramBucketSize(int n) {
        this.getProperties().setPropertyLocal("visualisation/imageHistogramBucketSize", RtDataFormat.toString(n));
    }

    public int getImageHistogramBucketSize() {
        return this.getProperties().getPropertyIntLocal("visualisation/imageHistogramBucketSize", 10000);
    }

    public void setImageHistogramStrechAll(boolean bl) {
        this.getProperties().setPropertyLocal("visualisation/imageHistogramStrechAll", Boolean.toString(bl));
    }

    public boolean getImageHistogramStrechAll() {
        return this.getProperties().getPropertyBoolLocal("visualisation/imageHistogramStrechAll", true);
    }

    public void setImageHistogramNormalizeMin(boolean bl) {
        this.getProperties().setPropertyLocal("visualisation/imageHistogramNormalizeMin", Boolean.toString(bl));
    }

    public boolean getImageHistogramNormalizeMin() {
        return this.getProperties().getPropertyBoolLocal("visualisation/imageHistogramNormalizeMin", true);
    }

    public void setImageHistogramRange(String string) {
        this.getProperties().setPropertyLocal("visualisation/imageHistogramRange", string);
    }

    public String getImageHistogramRange() {
        return this.getProperties().getPropertyLocal("visualisation/imageHistogramRange", "");
    }

    public void setImageHistogramEnable(boolean bl) {
        this.getProperties().setPropertyLocal("visualisation/imageHistogramEnable", Boolean.toString(bl));
    }

    public boolean getImageHistogramEnable() {
        return this.getProperties().getPropertyBoolLocal("visualisation/imageHistogramEnable", true);
    }

    public void setImageHistogramMinBands(int n) {
        this.getProperties().setPropertyLocal("visualisation/imageHistogramMinBands", RtDataFormat.toString(n));
    }

    public int getImageHistogramMinBands() {
        return this.getProperties().getPropertyIntLocal("visualisation/imageHistogramMinBands", BreezeProperties.getInstance().getMinBandsCountForHistogram());
    }

    public int getDefaultReduce() {
        return this.getProperties().getPropertyIntLocal("visualisation/reduce", 0);
    }

    public void setDefaultReduce(int n) {
        this.getProperties().setPropertyLocal("visualisation/reduce", String.valueOf(n));
    }

    public String getVisualisationDirection() {
        return this.getProperties().getPropertyLocal("visualisation/direction", BreezeProperties.getInstance().getVisualisationDirection());
    }

    public String getVisualisationHorizontalDirection() {
        return this.getProperties().getPropertyLocal("visualisation/horizontalDirection", BreezeProperties.getInstance().getVisualisationHorizontalDirection());
    }

    public String getVisualisationVerticalDirection() {
        return this.getProperties().getPropertyLocal("visualisation/verticalDirection", BreezeProperties.getInstance().getVisualisationVerticalDirection());
    }

    public boolean getObjectBorder() {
        return this.getProperties().getPropertyBoolLocal("visualisation/objectBorder", true);
    }

    public void setObjectBorder(boolean bl) {
        this.getProperties().setPropertyBoolLocal("visualisation/objectBorder", bl);
    }

    public boolean getShowBackground() {
        return this.getProperties().getPropertyBoolLocal("visualisation/showBackground", true);
    }

    public void setShowBackground(boolean bl) {
        this.getProperties().setPropertyBoolLocal("visualisation/showBackground", bl);
    }

    @Override
    public String getDescription() {
        return this.getProperties().getPropertyLocal("measure/description", "");
    }

    public void setModellingExplorePixel(boolean bl) {
        this.getProperties().setPropertyBoolLocal("model/explorePixelPca", bl);
    }

    public boolean getModellingExplorePixel() {
        return this.getProperties().getPropertyBoolLocal("model/explorePixelPca", false);
    }

    public void setDescriptorExplorePixel(boolean bl) {
        this.getProperties().setPropertyBoolLocal("model/explorePixelDescriptor", bl);
    }

    public boolean getDescriptorExplorePixel() {
        return this.getProperties().getPropertyBoolLocal("model/explorePixelDescriptor", false);
    }

    public void setExplorePixelFilter(String string) {
        this.getProperties().setPropertyLocal("model/explorePixelFilter", string);
    }

    public String getExplorePixelFilter() {
        return this.getProperties().getPropertyLocal("model/explorePixelFilter", "");
    }

    public void setExploreFilter(String string) {
        this.getProperties().setPropertyLocal("model/exploreFilter", string);
    }

    public String getExploreFilter() {
        return this.getProperties().getPropertyLocal("model/exploreFilter", "");
    }

    public double getModellingDefaultExcludeWavelengthsBeginningPercent() {
        Double d = this.getExcludePercent("ExcludeWavelengthsBeginningPercent");
        if (d != null) {
            return d;
        }
        return this.getProperties().getPropertyDoubleLocal("model/excludeWavelengthsBeginningPercent", BreezeProperties.getInstance().getModellingDefaultExcludeWavelengthsBeginningPercent());
    }

    public double getModellingDefaultExcludeWavelengthsEndPercent() {
        Double d = this.getExcludePercent("ExcludeWavelengthsEndPercent");
        if (d != null) {
            return d;
        }
        return this.getProperties().getPropertyDoubleLocal("model/excludeWavelengthsEndPercent", BreezeProperties.getInstance().getModellingDefaultExcludeWavelengthsEndPercent());
    }

    private Double getExcludePercent(String string) {
        Double d;
        Measurement measurement = this.getFirstMeasurementWithData();
        if (measurement != null && (d = measurement.getMetaProperties().getMetaNumberNullIfMissing(string)) != null) {
            return d;
        }
        return null;
    }

    public void setModellingExplorePixelSnv(boolean bl) {
        this.getProperties().setPropertyBoolLocal("model/explorePixelSnv", bl);
    }

    public boolean getModellingExplorePixelSnv() {
        return this.getProperties().getPropertyBoolLocal("model/explorePixelSnv", false);
    }

    public void setModellingExploreSnv(boolean bl) {
        this.getProperties().setPropertyBoolLocal("model/exploreSnv", bl);
    }

    public boolean getModellingExploreSnv() {
        return this.getProperties().getPropertyBoolLocal("model/exploreSnv", true);
    }

    public int getSegmentationLevel() {
        return this.getVisualisationNode().getSegmentationLevel();
    }

    public String getSegmentationHashId() {
        return this.getVisualisationNode().getSegmentationHashId();
    }

    public String getStrayLightFile() {
        return this.getProperties().getPropertyLocal("measure/strayLightFile", "");
    }

    public int getMaxSaturatedBand() {
        return this.getProperties().getPropertyIntLocal("measure/maxSaturatedBand", 5);
    }

    public boolean useDarkRefAfter() {
        return this.getProperties().getPropertyBoolLocal("measure/useDarkRefAfter", true);
    }

    public boolean getDepthRegistration() {
        return this.getProperties().getPropertyBoolLocal("measure/depthRegistration", false);
    }

    public SegmentationNodeList getSegmentationNodes() {
        return this.getSegmentationNodes(this.getSegmentationLevel(), this.getSegmentationHashId());
    }

    public SegmentationNodeList getSegmentationNodes(int n) {
        return this.getSegmentationNodes(n, null);
    }

    public SegmentationNodeList getSegmentationNodes(int n, String string) {
        return SegmentationNode.getNodesAtLevel(this.getRoot(), n).filter(string);
    }

    public boolean isCompressReferences() {
        return this.getProperties().getPropertyBoolLocal("measure/compressReferences", BreezeProperties.getInstance().useCompressedReferences());
    }

    public void setDemoMode(boolean bl) {
        this.demoMode = bl;
    }

    public boolean isDemoMode() {
        return this.demoMode;
    }

    public void setStudyId(String string) {
        this.getProperties().setPropertyLocal("studyId", string);
    }

    @Override
    public String getStudyId() {
        if (this.getType().equals((Object)WorkflowType.Record)) {
            return this.getUid();
        }
        String string = this.getProperties().getPropertyLocal("studyId", "");
        if (string != null && string.length() > 0) {
            return string;
        }
        return "";
    }

    public WorkflowType getType() {
        File file;
        File file2 = this.getFolder();
        if (file2 != null && (file = file2.getParentFile()) != null) {
            String string = file.getName();
            if (string.equalsIgnoreCase("record")) {
                return WorkflowType.Record;
            }
            if (string.equalsIgnoreCase("play")) {
                return WorkflowType.Play;
            }
        }
        return WorkflowType.Record;
    }

    public boolean partOfStudy(String string) {
        String string2 = this.getStudyId();
        if (string.equals(string2)) {
            return true;
        }
        if (this.partOfStudy(this.getRoot(), string)) {
            if (string2.length() == 0) {
                this.setStudyId(string);
                this.save();
            }
            return true;
        }
        return false;
    }

    private boolean partOfStudy(FunctionTreeNode functionTreeNode, String string) {
        BasicAnalyse basicAnalyse = (BasicAnalyse)BreezeMasterCache.getInstance().getAnalyseList().byId(functionTreeNode.getAnalyseUid());
        if (basicAnalyse != null && basicAnalyse.partOfStudy(string)) {
            return true;
        }
        for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
            if (!this.partOfStudy(functionTreeNode2, string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CommentList getComments() {
        return this.comments;
    }

    @Override
    public XmlProperties getProperties() {
        return this.properties;
    }

    @Override
    public String getName() {
        return this.entryData.getName();
    }

    @Override
    public EntryData getEntryData() {
        return this.entryData;
    }

    @Override
    public String getUid() {
        return this.entryData.getUid();
    }

    @Override
    public boolean applyChangesNeeded() {
        return false;
    }

    @Override
    public boolean isGrayed() {
        return false;
    }

    public Group createDefaultGroup() {
        Group group = new Group("Group", this);
        this.addChild(group);
        group.save();
        return group;
    }

    @Override
    public void rename(String string) throws IOException {
        Measurement.clearFromCache(this);
        this.entryData.rename(string, this.getFolder(), this.parentFolder);
    }

    public List<Measurement> getAllMeasurements() {
        ArrayList<Measurement> arrayList = new ArrayList<Measurement>();
        for (Group group : this.getChildList()) {
            arrayList.addAll(group.getChildList());
        }
        return arrayList;
    }

    public Measurement getFirstMeasurementWithDataCheckStudyContext() {
        Measurement measurement = this.getFirstMeasurementWithData();
        if (measurement != null) {
            return measurement;
        }
        BasicWorkflow basicWorkflow = (BasicWorkflow)BasicMasterCache.getInstance().getStudyList().byId(this.getStudyId());
        if (basicWorkflow != this && basicWorkflow instanceof Workflow) {
            Workflow workflow = (Workflow)basicWorkflow;
            return workflow.getFirstMeasurementWithData();
        }
        return null;
    }

    public Measurement getFirstMeasurementWithData() {
        for (Group group : this.getChildList()) {
            Measurement measurement = group.getFirstMeasurementWithData();
            if (measurement == null) continue;
            return measurement;
        }
        return null;
    }

    public SampleSegmentationColumn getSamples(int n) {
        SampleSegmentationColumn sampleSegmentationColumn = new SampleSegmentationColumn();
        for (Group group : this.getChildList()) {
            sampleSegmentationColumn.addAll(group.getSamples(n));
        }
        return sampleSegmentationColumn;
    }

    public SampleSegmentationColumn getSamples(String string) {
        SampleSegmentationColumn sampleSegmentationColumn = new SampleSegmentationColumn();
        for (Group group : this.getChildList()) {
            sampleSegmentationColumn.addAll(group.getSamples(string));
        }
        return sampleSegmentationColumn;
    }

    public static WorkflowType getType(Object object) {
        Workflow workflow = Workflow.getWorkflow(object);
        if (workflow != null) {
            return workflow.getType();
        }
        return WorkflowType.None;
    }

    public static Workflow getWorkflow(Object object) {
        if (object instanceof Workflow) {
            Workflow workflow = (Workflow)object;
            return workflow;
        }
        if (object instanceof Group) {
            Group group = (Group)object;
            return group.getParent();
        }
        if (object instanceof Measurement) {
            Measurement measurement = (Measurement)object;
            return measurement.getWorkflow();
        }
        if (object instanceof Sample) {
            Sample sample = (Sample)object;
            return sample.measurement().getWorkflow();
        }
        if (object instanceof Analyse) {
            Analyse analyse = (Analyse)object;
            return analyse.getWorkflowElseNull();
        }
        if (object instanceof FunctionTreeNode) {
            FunctionTreeNode functionTreeNode = (FunctionTreeNode)object;
            return AbstractBreezeFunction.getWorkflowFromNode(functionTreeNode);
        }
        return null;
    }

    public boolean isXrayData() {
        Measurement measurement = this.getFirstMeasurementWithData();
        if (measurement != null) {
            return measurement.isXrayData();
        }
        return Camera.isXray(HardwareRegistry.getInstance().getActiveCamera());
    }

    public MaxSignal getMaxSignalOrNull() {
        Measurement measurement = this.getFirstMeasurementWithData();
        if (measurement != null) {
            return measurement.getMaxSignal();
        }
        return null;
    }

    public MaxSignal getMaxSignalForVisualizationOrNull(String string) {
        if (this.isXrayData()) {
            return new MaxSignal(32767.0f);
        }
        RtFramePredictor.ReferenceConvertTo referenceConvertTo = RtFramePredictor.ReferenceConvertTo.parse(string);
        if (referenceConvertTo.useReferences()) {
            return new MaxSignal(1.0f);
        }
        return this.getMaxSignalOrNull();
    }

    public void clearChildList() {
        this.childList = null;
    }

    public List<Group> getChildList() {
        if (this.childList == null) {
            this.childList = new ArrayList<Group>();
            for (File file : new SortedFileList.SortedFolderList(this.getFolder())) {
                try {
                    this.addChild(new Group(file, this));
                }
                catch (XmlParserHelper.XmlFileNotFoundException xmlFileNotFoundException) {}
            }
        }
        return this.childList;
    }

    public void insertChild(Group group) {
        group.setParent(this);
        this.getChildList().add(0, group);
    }

    @Override
    public Group addChild(Group group) {
        group.setParent(this);
        this.getChildList().add(group);
        return group;
    }

    public Group getChild(int n) {
        return this.getChildList().get(n);
    }

    @Override
    public int getChildCount() {
        return this.getChildList().size();
    }

    @Override
    public Workflow getParent() {
        return null;
    }

    @Override
    public void removeChild(Group group) {
        this.getChildList().remove(group);
    }

    @Override
    public int getChildIndex(Group group) {
        return this.getChildList().indexOf(group);
    }

    public List<BasicAnalyse> getConnectedAnalysis() {
        return this.getConnectedAnalysis(true);
    }

    public List<BasicAnalyse> getConnectedAnalysis(boolean bl) {
        return this.getConnectedAnalysis(bl, true);
    }

    public List<BasicAnalyse> getConnectedAnalysis(boolean bl, boolean bl2) {
        ArrayList<BasicAnalyse> arrayList = new ArrayList<BasicAnalyse>();
        for (String string : Workflow.addConnectedAnalysisUid(this, bl)) {
            BasicAnalyse basicAnalyse = (BasicAnalyse)BreezeMasterCache.getInstance().getAnalyseList().byId(string);
            if (basicAnalyse != null) {
                arrayList.add(basicAnalyse);
                continue;
            }
            if (!bl2 || (basicAnalyse = (BasicAnalyse)BreezeMasterCache.getInstance().getRtAnalyseList().byId(string)) == null) continue;
            arrayList.add(basicAnalyse);
        }
        return arrayList;
    }

    public List<BasicAnalyse> getAnalysisFromStudyId() {
        ArrayList<BasicAnalyse> arrayList = new ArrayList<BasicAnalyse>();
        String string = this.getStudyId();
        for (Analyse analyse : BreezeMasterCache.getInstance().getAnalyseList()) {
            if (!string.equals(analyse.getStudyId())) continue;
            arrayList.add(analyse);
        }
        return arrayList;
    }

    public float[] getBandValues() {
        Measurement measurement = this.getFirstMeasurementWithData();
        if (measurement != null) {
            BandNames bandNames = measurement.getBandNames();
            float f = bandNames.getValue(0);
            float f2 = bandNames.getValue(bandNames.size() - 1);
            MaxSignal maxSignal = measurement.getMetaProperties().getMaxSignal(null);
            return new float[]{f, f2, maxSignal != null ? maxSignal.value : 0.0f};
        }
        return null;
    }

    public static List<String> addConnectedAnalysisUid(Workflow workflow, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Workflow.addConnectedAnalysisUid(workflow.getRoot(), arrayList, bl);
        return arrayList;
    }

    private static void addConnectedAnalysisUid(FunctionTreeNode functionTreeNode, List<String> list, boolean bl) {
        block5: {
            try {
                String string = functionTreeNode.getAnalyseUid();
                if (string != null && !list.contains(string)) {
                    list.add(string);
                }
            }
            catch (Exception exception) {
                if (!functionTreeNode.isEnabled()) break block5;
                if (functionTreeNode instanceof FunctionTreeNodeWithId) {
                    FunctionTreeNodeWithId functionTreeNodeWithId = (FunctionTreeNodeWithId)functionTreeNode;
                    throw new FunctionTreeNodeWithId.MethodException(exception.getMessage(), exception, functionTreeNodeWithId);
                }
                throw exception;
            }
        }
        for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
            if (!functionTreeNode2.isEnabled() && !bl) continue;
            Workflow.addConnectedAnalysisUid(functionTreeNode2, list, bl);
        }
    }

    public HighlighedSamples getHighlighedSamples() {
        return this.highlighedSamples;
    }

    public List<Logging> getLoggins() {
        return Arrays.asList(new Logging("startDepth"), new Logging("endDepth"));
    }

    public Group getGroupById(String string) {
        for (Group group : this.getChildList()) {
            if (group == null || !group.getUid().equals(string)) continue;
            return group;
        }
        return null;
    }

    public Group getGroupByName(String string) {
        for (Group group : this.getChildList()) {
            if (group == null || !group.getName().equals(string)) continue;
            return group;
        }
        return null;
    }

    @Override
    public Entry.EntryType getEntryType() {
        return Entry.EntryType.Workflow;
    }

    public static Workflow createWorkflow(String string) {
        Workflow workflow = new Workflow(string, WorkspaceManager.getInstance().getWorkspace().getRecordPath());
        FunctionTreeList functionTreeList = workflow.getContextHolder().getFunctionTreeList("workflow");
        EvaluationTree evaluationTree = new EvaluationTree();
        FunctionTreeNode functionTreeNode = FunctionHelper.createDefaultFunction("None");
        evaluationTree.setRoot(functionTreeNode);
        functionTreeList.addChild(evaluationTree);
        workflow.save();
        return workflow;
    }

    public static class HighlighedSamples {
        private final HashSet<Sample> samples = new HashSet();

        public void add(Sample sample) {
            this.samples.add(sample);
        }

        public void remove(Sample sample) {
            this.samples.remove(sample);
        }

        public boolean contains(Sample sample) {
            return this.samples.contains(sample);
        }

        public void update(Sample sample, boolean bl) {
            if (bl) {
                this.samples.add(sample);
            } else {
                this.samples.remove(sample);
            }
        }

        public List<Sample> getSamples() {
            return new ArrayList<Sample>(this.samples);
        }

        public void update(List<Measurement> list) {
            block0: for (Sample sample : this.getSamples()) {
                Measurement measurement = HighlighedSamples.getById(list, sample.measurement().getUid());
                if (measurement == null) continue;
                this.remove(sample);
                Rectangle rectangle = sample.getSamplePath().getOrCreateGeneralPath().getBounds();
                SampleSegmentationColumn sampleSegmentationColumn = measurement.getSamples(sample.getSegmentationLevel());
                for (Sample sample2 : sampleSegmentationColumn) {
                    Rectangle rectangle2 = sample2.getSamplePath().getOrCreateGeneralPath().getBounds();
                    if (rectangle.x != rectangle2.x || rectangle.y != rectangle2.y || rectangle.width != rectangle2.width || rectangle.height != rectangle2.height) continue;
                    this.add(sample2);
                    continue block0;
                }
            }
        }

        private static Measurement getById(List<Measurement> list, String string) {
            for (Measurement measurement : list) {
                if (!measurement.getUid().equals(string)) continue;
                return measurement;
            }
            return null;
        }
    }

    public static enum WorkflowType {
        Record,
        Play,
        None;


        public BreezeType getPageType() {
            if (this.equals((Object)Play)) {
                return BreezeType.Workflow;
            }
            return BreezeType.Project;
        }

        public Color getColor() {
            return this.getPageType().getColor();
        }
    }

    public record Logging(String name) {
        public String formatName() {
            return StringHelper.formatLabel(this.name);
        }
    }
}

