/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.workflow;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.sample.SampleValues;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.UniqueUID;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;

public class WorkflowMergeHandler {
    public static Workflow merge(BreezeProgressManager breezeProgressManager, List<Workflow> list, String string) {
        Workflow workflow = list.get(0);
        File file = new File(workflow.getParentFolder(), string);
        File file2 = new File(file, "workflow.xml");
        for (Workflow workflow2 : list) {
            for (Group object : workflow2.getChildList()) {
                FileHelper.copyFolder(breezeProgressManager, object.getFolder(), new File(file, workflow2.getName() + "_" + object.getName()), true);
            }
            if (file2.exists()) continue;
            FileHelper.copyFile(breezeProgressManager, workflow2.getXml(), file2);
        }
        Workflow workflow3 = new Workflow(file);
        workflow3.getEntryData().setUid(UniqueUID.getUniqueId());
        workflow3.getEntryData().setCreatedDate();
        for (int i = 1; i < list.size(); ++i) {
            Workflow workflow4 = list.get(i);
            workflow3.getCategoryFactors().addAll(workflow4.getCategoryFactors());
            workflow3.getPropertyFactors().addAll(workflow4.getPropertyFactors());
            for (FunctionTreeNode functionTreeNode : workflow4.getRoot().clone(true).getChildList()) {
                workflow3.getRoot().addChild(functionTreeNode);
            }
        }
        workflow3.getAllMeasurements();
        WorkflowMergeHandler.mergeCategories(workflow3);
        WorkflowMergeHandler.mergeProperties(workflow3);
        workflow3.save();
        return workflow3;
    }

    private static void mergeCategories(Workflow workflow) {
        LinkedHashMap<String, CategoryFactor> linkedHashMap = new LinkedHashMap<String, CategoryFactor>();
        Iterator<CategoryFactor> iterator = workflow.getCategoryFactors().iterator();
        while (iterator.hasNext()) {
            CategoryFactor categoryFactor = iterator.next();
            CategoryFactor categoryFactor2 = (CategoryFactor)linkedHashMap.get(categoryFactor.getName());
            if (categoryFactor2 == null) {
                linkedHashMap.put(categoryFactor.getName(), categoryFactor);
                continue;
            }
            categoryFactor2.syncModelFactor(categoryFactor, false);
            iterator.remove();
            WorkflowMergeHandler.forEverySample(workflow, list -> WorkflowMergeHandler.updateCategory(categoryFactor, categoryFactor2, list));
        }
    }

    private static void mergeProperties(Workflow workflow) {
        LinkedHashMap<String, PropertyFactor> linkedHashMap = new LinkedHashMap<String, PropertyFactor>();
        Iterator<PropertyFactor> iterator = workflow.getPropertyFactors().iterator();
        while (iterator.hasNext()) {
            PropertyFactor propertyFactor = iterator.next();
            PropertyFactor propertyFactor2 = (PropertyFactor)linkedHashMap.get(propertyFactor.getName());
            if (propertyFactor2 == null) {
                linkedHashMap.put(propertyFactor.getName(), propertyFactor);
                continue;
            }
            iterator.remove();
            WorkflowMergeHandler.forEverySample(workflow, list -> WorkflowMergeHandler.updateProperty(propertyFactor, propertyFactor2, list));
        }
    }

    public static void forEverySample(Workflow workflow, SamplesAction samplesAction) {
        for (Group group : workflow.getChildList()) {
            for (Measurement measurement : group.getChildList()) {
                if (!samplesAction.onAction(measurement.getChildList())) continue;
                measurement.save();
            }
        }
    }

    private static boolean updateCategory(CategoryFactor categoryFactor, CategoryFactor categoryFactor2, List<BasicSample> list) {
        boolean bl = false;
        for (BasicSample basicSample : list) {
            SampleValues sampleValues = basicSample.getSampleValues();
            Float f = sampleValues.getValue(categoryFactor);
            if (f != null) {
                sampleValues.removeValue(categoryFactor);
                CatClass catClass = categoryFactor.getClassByValueIdx(f.intValue());
                sampleValues.setValue(categoryFactor2, categoryFactor2.getClassIndex(catClass.getName()));
                bl = true;
            }
            if (!WorkflowMergeHandler.updateCategory(categoryFactor, categoryFactor2, basicSample.getChildList())) continue;
            bl = true;
        }
        return bl;
    }

    private static boolean updateProperty(PropertyFactor propertyFactor, PropertyFactor propertyFactor2, List<BasicSample> list) {
        boolean bl = false;
        for (BasicSample basicSample : list) {
            SampleValues sampleValues = basicSample.getSampleValues();
            Float f = sampleValues.getValue(propertyFactor);
            if (f != null) {
                sampleValues.removeValue(propertyFactor);
                sampleValues.setValue(propertyFactor2, f.floatValue());
                bl = true;
            }
            if (!WorkflowMergeHandler.updateProperty(propertyFactor, propertyFactor2, basicSample.getChildList())) continue;
            bl = true;
        }
        return bl;
    }

    public static List<Workflow> getWorkflows(List<Object> list) {
        ArrayList<Workflow> arrayList = new ArrayList<Workflow>();
        for (Object object : list) {
            arrayList.add((Workflow)object);
        }
        return arrayList;
    }

    public static interface SamplesAction {
        public boolean onAction(List<BasicSample> var1);
    }
}

