/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.entry.workflow;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.util.raw.FrameCube;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.RootSample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.entry.workflow.WorkflowMergeHandler;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;

public class WorkflowMergeHandlerTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void testMerge() throws IOException {
        File file = this.tempFolder.getRoot();
        BreezeProgressManager breezeProgressManager = BreezeProgressManager.createEmpty();
        Workflow workflow = WorkflowMergeHandler.merge(breezeProgressManager, Arrays.asList(this.createWorkflow(file, "A"), this.createWorkflow(file, "B")), "C");
        MatcherAssert.assertThat((Object)workflow.getName(), (Matcher)CoreMatchers.is((Object)"C"));
        MatcherAssert.assertThat((Object)workflow.getCategoryFactors().size(), (Matcher)CoreMatchers.is((Object)1));
        CategoryFactor categoryFactor = workflow.getCategoryFactors().get(0);
        List<CatClass> list = categoryFactor.getClasses();
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)list.get(1).getName(), (Matcher)CoreMatchers.is((Object)"A"));
        MatcherAssert.assertThat((Object)list.get(1).getColorString(), (Matcher)CoreMatchers.is((Object)"A"));
        MatcherAssert.assertThat((Object)list.get(2).getName(), (Matcher)CoreMatchers.is((Object)"B"));
        MatcherAssert.assertThat((Object)list.get(2).getColorString(), (Matcher)CoreMatchers.is((Object)"B"));
        MatcherAssert.assertThat((Object)workflow.getPropertyFactors().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    private Workflow createWorkflow(File file, String string) {
        Workflow workflow = new Workflow(string, file);
        Group group = new Group(string, workflow);
        workflow.addChild(group);
        group.save();
        Measurement measurement = new Measurement(string, group);
        FrameCube frameCube = new FrameCube(new BandCount(10), new PixelWidth(10), new FrameCount(10), DataSize.SHORT_2);
        int n = 0;
        for (RawFrame object2 : frameCube.getFrameList()) {
            for (int categoryFactor = 0; categoryFactor < object2.getColumns().value; ++categoryFactor) {
                for (int catClass = 0; catClass < object2.getRows().value; ++catClass) {
                    object2.setFrameValue(catClass, categoryFactor, n++);
                }
            }
        }
        frameCube.save(new File(measurement.getFolder(), "measurement.raw"));
        group.addChild(measurement);
        RootSample rootSample = measurement.replaceRootSample(new RootSample());
        Identifier identifier = workflow.getIdentifiers().add(new Identifier("Id"));
        rootSample.setID(identifier, string);
        CategoryFactor categoryFactor = workflow.getCategoryFactors().add(new CategoryFactor("Category"));
        CatClass catClass = categoryFactor.addClass(string);
        catClass.setColor(string);
        rootSample.getSampleValues().setValue(categoryFactor, categoryFactor.getClassIndex(string));
        PropertyFactor propertyFactor = workflow.getPropertyFactors().add(new PropertyFactor("Property"));
        rootSample.getSampleValues().setValue(propertyFactor, string.charAt(0) - 65 + 1);
        measurement.save();
        workflow.save();
        return workflow;
    }
}

