/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.evince;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import se.prediktera.breeze.entry.MeasurementOrSample;
import se.prediktera.breeze.entry.WorkflowOrGroup;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.datasetcontainer.dataset.DataSet;

public class DataSetCache {
    private static final Cache cache = new Cache();

    public static boolean contains(Analyse analyse) {
        return cache.containsKey(analyse);
    }

    public static void set(Analyse analyse, DataSet dataSet) {
        cache.put(analyse, dataSet);
    }

    public static DataSet get(Analyse analyse) {
        return cache.get(analyse);
    }

    public static boolean contains(Measurement measurement) {
        return cache.containsKey(measurement);
    }

    public static void set(Measurement measurement, DataSet dataSet) {
        cache.put(measurement, dataSet);
    }

    public static DataSet get(Measurement measurement) {
        return cache.get(measurement);
    }

    public static void clear(Object object) {
        if (object instanceof Measurement) {
            DataSetCache.clearParents((Measurement)object);
        } else if (object instanceof Group) {
            DataSetCache.clearParents((Group)object);
        } else if (object instanceof Workflow) {
            DataSetCache.clear((Workflow)object);
        } else if (object instanceof Analyse) {
            DataSetCache.clear((Analyse)object);
        }
    }

    public static void clear(Measurement measurement) {
        cache.remove(measurement);
        measurement.clearPrediction();
    }

    public static void reload(Measurement measurement) {
        DataSet dataSet = cache.get(measurement);
        if (dataSet != null) {
            dataSet.setReload(true);
        }
    }

    public static void clearParents(Measurement measurement) {
        DataSetCache.clear(measurement);
        cache.remove(measurement.getParent());
        cache.remove(measurement.getParent().getParent());
    }

    public static void clear(Group group) {
        cache.remove(group);
    }

    public static void clearParents(Group group) {
        cache.remove(group);
        cache.remove(group.getParent());
    }

    public static void clear(Workflow workflow) {
        cache.remove(workflow);
    }

    public static void clearMeasurements(WorkflowOrGroup workflowOrGroup) {
        DataSetCache.clearMeasurements(Measurement.getMeasurements(workflowOrGroup));
    }

    public static void clearMeasurements(List<Measurement> list) {
        for (Measurement measurement : list) {
            cache.remove(measurement);
        }
    }

    public static void clear(Analyse analyse) {
        cache.remove(analyse);
    }

    public static DataSet get(WorkflowOrGroup workflowOrGroup) {
        return cache.get(workflowOrGroup);
    }

    public static void set(WorkflowOrGroup workflowOrGroup, DataSet dataSet) {
        cache.put(workflowOrGroup, dataSet);
    }

    public static DataSet get(MeasurementOrSample measurementOrSample) {
        return cache.get(measurementOrSample);
    }

    public static void set(MeasurementOrSample measurementOrSample, DataSet dataSet) {
        cache.put(measurementOrSample, dataSet);
    }

    public static void clearRecursive(Object object) {
        DataSetCache.clearRecursive(object, true);
    }

    private static void clearRecursive(Object object, boolean bl) {
        if (object instanceof Workflow) {
            DataSetCache.clear((Workflow)object);
            List<Group> list = ((Workflow)object).getChildList();
            for (Group group : list) {
                DataSetCache.clearRecursive(group, bl);
            }
        } else if (object instanceof Group) {
            DataSetCache.clear((Group)object);
            if (bl) {
                List<Measurement> list = ((Group)object).getChildList();
                for (Measurement measurement : list) {
                    DataSetCache.clear(measurement);
                }
            }
        } else {
            DataSetCache.clear(object);
        }
    }

    public static void clearAll() {
        cache.clear();
    }

    private static class Cache {
        private final LinkedHashMap<Object, DataSet> cache = new LinkedHashMap();
        private final double maxMemoryRatio = BreezeProperties.getInstance().getMaxMemoryRatio();

        private Cache() {
        }

        public boolean containsKey(Object object) {
            this.removeDataSetIfClosed(object);
            return this.cache.containsKey(object);
        }

        public void put(Object object, DataSet dataSet) {
            this.closePreviousDataSetIfExistsAndIsDifferent(object, dataSet);
            if (dataSet != null) {
                this.cache.put(object, dataSet);
                this.closeDataSetsIfMemoryIsRunnigLow(dataSet);
            }
        }

        public DataSet get(Object object) {
            this.removeDataSetIfClosed(object);
            return this.cache.get(object);
        }

        public void remove(Object object) {
            DataSet dataSet = (DataSet)this.cache.remove(object);
            if (dataSet != null && !dataSet.isCleaned()) {
                dataSet.close();
            }
        }

        public void clear() {
            Iterator<DataSet> iterator = this.cache.values().iterator();
            while (iterator.hasNext()) {
                DataSet dataSet = iterator.next();
                dataSet.close();
                iterator.remove();
            }
        }

        private void removeDataSetIfClosed(Object object) {
            DataSet dataSet = this.cache.get(object);
            if (dataSet != null && dataSet.isCleaned()) {
                this.cache.remove(object);
            }
        }

        private void closePreviousDataSetIfExistsAndIsDifferent(Object object, DataSet dataSet) {
            DataSet dataSet2 = this.cache.get(object);
            if (dataSet2 != null && !dataSet2.isCleaned() && dataSet2 != dataSet) {
                dataSet2.close();
            }
        }

        private void closeDataSetsIfMemoryIsRunnigLow(DataSet dataSet) {
            double d = 0.0;
            Iterator<DataSet> iterator = this.cache.values().iterator();
            while (iterator.hasNext() && !((d = Cache.getUsedMemoryRatio()) < this.maxMemoryRatio)) {
                try {
                    DataSet dataSet2 = iterator.next();
                    if (dataSet2.equals((Object)dataSet)) continue;
                    iterator.remove();
                    if (dataSet2.isCleaned()) continue;
                    dataSet2.close();
                    System.gc();
                }
                catch (Exception exception) {
                    ErrorHandler.logAndReportException((Throwable)exception);
                }
            }
        }

        private static double getUsedMemoryRatio() {
            Runtime runtime = Runtime.getRuntime();
            double d = runtime.totalMemory() - runtime.freeMemory();
            double d2 = runtime.maxMemory();
            return d / d2;
        }
    }
}

