/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.evince;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.test.stubs.MeasurementWithoutIO;
import se.prediktera.map.datasetcontainer.dataset.DataSet;

public class DataSetCacheTest {
    @Test
    public void shouldCleanDataSetOnRemove() {
        MeasurementWithoutIO measurementWithoutIO = new MeasurementWithoutIO();
        FakeDataSet fakeDataSet = new FakeDataSet();
        DataSetCache.set(measurementWithoutIO, (DataSet)fakeDataSet);
        MatcherAssert.assertThat((Object)DataSetCache.get(measurementWithoutIO), (Matcher)CoreMatchers.is((Object)((Object)fakeDataSet)));
        DataSetCache.clear(measurementWithoutIO);
        MatcherAssert.assertThat((Object)DataSetCache.get(measurementWithoutIO), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)fakeDataSet.isCleaned(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldNotReturnCleanedDataSet() {
        MeasurementWithoutIO measurementWithoutIO = new MeasurementWithoutIO();
        FakeDataSet fakeDataSet = new FakeDataSet();
        DataSetCache.set(measurementWithoutIO, (DataSet)fakeDataSet);
        fakeDataSet.close();
        MatcherAssert.assertThat((Object)DataSetCache.get(measurementWithoutIO), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private static class FakeDataSet
    extends DataSet {
        private boolean cleaned = false;

        private FakeDataSet() {
        }

        public boolean isCleaned() {
            return this.cleaned;
        }

        public void close() {
            this.cleaned = true;
        }
    }
}

