/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.evince;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.DataTypeInterface;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.script.EvinceScriptCommands;

public class EvinceHelper {
    public static void startEvince(Analyse analyse) {
        EvinceHelper.startEvince(" \"" + String.valueOf(analyse.getProjectFile()));
    }

    public static void startEvince(List<File> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" -files=\"");
        boolean bl = false;
        for (File file : list) {
            if (bl) {
                stringBuilder.append(";");
            }
            stringBuilder.append(file);
            bl = true;
        }
        if (string != null) {
            stringBuilder.append("\"");
            stringBuilder.append(" -importTemplate=\"");
            stringBuilder.append(string);
        }
        EvinceHelper.startEvince(stringBuilder.toString());
    }

    public static void startEvince(Object object) {
        EvinceHelper.startEvince(Measurement.getMeasurement(object));
    }

    public static void startEvince(List<Measurement> list) {
        if (list.size() == 1) {
            EvinceHelper.startEvince(list.get(0).rawFile().file());
        } else if (list.size() > 1) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" -files=\"");
            boolean bl = false;
            for (Measurement measurement : list) {
                if (bl) {
                    stringBuilder.append(";");
                }
                stringBuilder.append(measurement.rawFile().file());
                bl = true;
            }
            EvinceHelper.startEvince(stringBuilder.toString());
        }
    }

    public static void startEvince(File file) {
        EvinceHelper.startEvince((String)(file != null ? " -file=\"" + file.getAbsolutePath() : ""));
    }

    public static void startEvinceWithProject(File file) {
        EvinceHelper.startEvince((String)(file != null ? " \"" + file.getAbsolutePath() : ""));
    }

    private static void startEvince(String string) {
        try {
            File file = EvinceHelper.findEvinceFile();
            if (file == null) {
                throw new RuntimeException("Cannot find Evince, please make sure that Evince is installed on the computer and try again");
            }
            File file2 = file.getParentFile();
            ProcessBuilder processBuilder = EvinceHelper.createProcessBuilder(file, string);
            processBuilder.directory(file2);
            processBuilder.start();
        }
        catch (Exception exception) {
            throw new RuntimeException("Couldn't start Evince: " + exception.getMessage(), exception);
        }
    }

    private static ProcessBuilder createProcessBuilder(File file, String string) throws IOException {
        UpdateHelper.Platform platform = UpdateHelper.getPlatform();
        if (platform.equals((Object)UpdateHelper.Platform.Windows)) {
            return new ProcessBuilder("cmd", "/C start " + file.getName() + string);
        }
        if (platform.equals((Object)UpdateHelper.Platform.MacOSX)) {
            return new ProcessBuilder("java", "-Djava.library.path=../MacOS", "-cp", "*", "se.prediktera.map.main.Evince", EvinceHelper.removeBackslash(string));
        }
        return new ProcessBuilder("java", "-cp", "*;Lib/*", "se.prediktera.map.main.Evince", EvinceHelper.removeBackslash(string));
    }

    private static String removeBackslash(String string) {
        return string.trim().replace("\"", "");
    }

    public static boolean exists() {
        return EvinceHelper.findEvinceFile() != null;
    }

    private static File findEvinceFile() {
        File file;
        UpdateHelper.Platform platform = UpdateHelper.getPlatform();
        if (platform.equals((Object)UpdateHelper.Platform.Windows)) {
            File file2 = new File(System.getenv("ProgramFiles") + "/Prediktera/Evince", "Evince.exe");
            if (file2.exists()) {
                return file2;
            }
            File file3 = new File(IniManager.getStartDir(), "Evince.exe");
            if (file3.exists()) {
                return file3;
            }
        } else if (platform.equals((Object)UpdateHelper.Platform.MacOSX) && (file = new File("/Applications", "Evince.app/Contents/Java/Evince.jar")).exists()) {
            return file;
        }
        return null;
    }

    public static void importUsingEvince(BreezeProgressManager breezeProgressManager, File file, File file2) {
        Properties properties = new Properties();
        properties.put("forcemultilayer", "true");
        DataSet dataSet = (DataSet)EvinceScriptCommands.load((ProgressManager)breezeProgressManager, (String)file.getAbsolutePath(), (Properties)properties);
        AbstractDataMatrix abstractDataMatrix = dataSet.getOriginalMatrix();
        Properties properties2 = new Properties();
        properties2.put("datatype", EvinceHelper.getDataType(dataSet.getCase().getDataSource()));
        abstractDataMatrix.save((ProgressManager)breezeProgressManager, file2.getAbsolutePath(), "raw", properties2);
    }

    private static String getDataType(AbstractDataSource abstractDataSource) {
        if (abstractDataSource != null) {
            return DataTypeInterface.TYPE_DESCR[abstractDataSource.getDataType()].toLowerCase();
        }
        return "float";
    }

    public static void main(String[] stringArray) {
        EvinceHelper.startEvince(" -file=C:\\Prediktera\\Evince\\MAP\\samples\\imports-85.txt");
    }
}

