/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.evince.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import se.prediktera.breeze.common.entry.factor.FactorList;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.AnalyseSpectralGroup;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.SamplePredictionList;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.evince.data.DataTemplatesHelper;
import se.prediktera.breeze.evince.datasource.MeasurementDataSource;
import se.prediktera.breeze.evince.datasource.MeasurementImportInfo;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.main.model.table.PredictionTableViewContainer;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.LoadHelper;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class AnalyseDataHelper {
    public static Object getInmatrix(Project_GUI project_GUI, BreezeProgressManager breezeProgressManager, Analyse analyse, String string, PredictionTableViewContainer.ClassificationViewType classificationViewType) {
        if (string.equals("analyse")) {
            return analyse;
        }
        AbstractModel abstractModel = analyse.getBaseModel(breezeProgressManager);
        if (abstractModel != null) {
            if (string.startsWith("model")) {
                return DataTemplatesHelper.getMatrix(abstractModel, string);
            }
            if (string.equals("xtr")) {
                DataSet dataSet = abstractModel.getDataSet();
                if (dataSet != null) {
                    return dataSet.getMatrix(0);
                }
                return null;
            }
        }
        if (string.equals("xtraining")) {
            analyse.checkFullyParsed();
            DataSet dataSet = DataSetCache.get(analyse);
            if (dataSet == null) {
                dataSet = AnalyseDataHelper.createExternalDataSet(project_GUI, breezeProgressManager, analyse, classificationViewType);
                DataSetCache.set(analyse, dataSet);
            }
            if (dataSet == null) {
                throw new ErrorHandler.InformationMessageException("No data available");
            }
            return dataSet.getMatrix(0);
        }
        throw new RuntimeException("AnalyseDataHelper: No such matrix type " + string);
    }

    private static DataSet createExternalDataSet(Project_GUI project_GUI, BreezeProgressManager breezeProgressManager, Analyse analyse, PredictionTableViewContainer.ClassificationViewType classificationViewType) {
        PredictionDataSource predictionDataSource = AnalyseDataHelper.createPredictionDataSource(breezeProgressManager, analyse, classificationViewType);
        predictionDataSource.autoIdentifyData(breezeProgressManager, Integer.MAX_VALUE);
        return LoadHelper.loadDataSource((Project_GUI)project_GUI, (ProgressManager)breezeProgressManager, (AbstractImportInfo)new MeasurementImportInfo(), (CellIdentifierModel)predictionDataSource, (Properties)new Properties());
    }

    public static PredictionDataSource createPredictionDataSource(BreezeProgressManager breezeProgressManager, Analyse analyse, PredictionTableViewContainer.ClassificationViewType classificationViewType) {
        Integer n = analyse.getSegmentationIdentifier().Level;
        if (n < 0) {
            n = 0;
        }
        return new PredictionDataSource(breezeProgressManager, analyse, analyse.getGroups(classificationViewType.isExternal()), n, classificationViewType);
    }

    public static class PredictionDataSource
    extends MeasurementDataSource {
        private final SamplePredictionList samplePredictionList;

        public PredictionDataSource(BreezeProgressManager breezeProgressManager, Analyse analyse, List<AnalyseSpectralGroup> list, int n, PredictionTableViewContainer.ClassificationViewType classificationViewType) {
            super(list, new SegmentationIdentifier(n, null), null, classificationViewType.isExternal(), null);
            if (!analyse.getModelMethod().isClassification()) {
                throw new ErrorHandler.InformationMessageException("Only for classification models");
            }
            this.samplePredictionList = SamplePredictionList.fromModel(breezeProgressManager, analyse, this.getMeasurements(analyse, list), n, classificationViewType.isExternal(), classificationViewType.isTrain());
        }

        public SamplePredictionList getSamplePredictionList() {
            return this.samplePredictionList;
        }

        private List<Measurement> getMeasurements(Analyse analyse, List<AnalyseSpectralGroup> list) {
            ArrayList<Measurement> arrayList = new ArrayList<Measurement>();
            for (AnalyseSpectralGroup analyseSpectralGroup : list) {
                arrayList.addAll(analyseSpectralGroup.getChildList());
            }
            return arrayList;
        }

        public FactorList getFactorList() {
            return this.samplePredictionList.getAnalyse().getFactorList();
        }
    }
}

