/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.evince.data;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.BasicTreeInterface;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.datainfo.VariablesInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.transform.AbstractTransform;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.windows.FloatWindow;
import se.prediktera.map.plot.layout.AbstractPlotLayout;

public class DataTemplatesHelper {
    public static AbstractModel createPCA(BreezeProgressManager breezeProgressManager, DataSet dataSet, int n) {
        AbstractModel abstractModel = (AbstractModel)dataSet.getNodeByName("PCAModel");
        if (abstractModel == null) {
            if (dataSet.hasX(null, 1) == 0.0) {
                return null;
            }
            Properties properties = new Properties();
            properties.put("removezerovariance", "false");
            properties.put("calcdmodx", "false");
            abstractModel = dataSet.createModel((ProgressManager)breezeProgressManager, "pca", Double.valueOf(n), properties);
            if (abstractModel != null) {
                abstractModel.setName("PCAModel");
            }
        }
        return abstractModel;
    }

    public static boolean createThumbnail(BreezeProgressManager breezeProgressManager, Measurement measurement, String string, DataSet dataSet, boolean bl) {
        File file = measurement.getThumbnailFile();
        if (!file.exists() || bl) {
            Properties properties = new Properties();
            AbstractDataMatrix abstractDataMatrix = null;
            if (string.equals("raw")) {
                abstractDataMatrix = dataSet.getOriginalMatrix();
            } else if (string.equals("sample")) {
                abstractDataMatrix = dataSet.getMatrix(0);
            }
            AbstractPlotLayout abstractPlotLayout = (AbstractPlotLayout)EvinceScriptCommands.createPlot((ProgressManager)breezeProgressManager, (String)"rgbimage", (DataTreeInterface)abstractDataMatrix, null, (Properties)properties);
            abstractPlotLayout.setContentReady(false);
            abstractPlotLayout.removeArea("all");
            FloatWindow floatWindow = abstractPlotLayout.getArea("plot");
            floatWindow.setDimension(Double.valueOf(100.0), Double.valueOf(100.0));
            floatWindow.setPosition(Double.valueOf(0.0), Double.valueOf(0.0));
            double d = abstractDataMatrix.getFoldK();
            double d2 = abstractDataMatrix.getFoldN();
            abstractPlotLayout.save((ProgressManager)breezeProgressManager, file.getAbsolutePath(), "png", Double.valueOf(d), Double.valueOf(d2));
            abstractPlotLayout.close();
            return true;
        }
        return false;
    }

    public static void excludeWavelength(BreezeProgressManager breezeProgressManager, DataSet dataSet, double d, double d2) {
        int n;
        VariablesInfo variablesInfo = dataSet.getVarDataInfo();
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(3);
        if (innerColumnBoolean == null) {
            return;
        }
        int n2 = innerColumnBoolean.getSize();
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            if (!innerColumnBoolean.getValueBool(n)) continue;
            if (n4 == 0) {
                n3 = n;
            }
            ++n4;
        }
        n = (int)((double)n4 * d / 100.0);
        int n5 = (int)((double)n4 * d2 / 100.0);
        if (n2 > n + n5) {
            Double[] doubleArray;
            Double[] doubleArray2 = DataTemplatesHelper.interval(n3, n3 + n);
            if (doubleArray2.length > 0) {
                try {
                    dataSet.exclude((ProgressManager)breezeProgressManager, "var", doubleArray2);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            if ((doubleArray = DataTemplatesHelper.interval(n3 + n4 - n5, n3 + n4)).length > 0) {
                try {
                    dataSet.exclude((ProgressManager)breezeProgressManager, "var", doubleArray);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
    }

    public static void excludeWavelengthByDatatype(BreezeProgressManager breezeProgressManager, DataSet dataSet, double d, double d2) {
        try {
            InnerColumnClass innerColumnClass = dataSet.getCategory((AbstractDataInfo)dataSet.getVarDataInfo(), "Datatype");
            Double[] doubleArray = innerColumnClass.getClassIndex("Descriptor");
            if (doubleArray.length > 0) {
                dataSet.exclude((ProgressManager)breezeProgressManager, "var", doubleArray);
            }
            Double[] doubleArray2 = innerColumnClass.getClassIndex("NIR");
            int n = (int)((double)doubleArray2.length * d / 100.0);
            int n2 = Math.min(doubleArray2.length, n);
            ArrayList<Double> arrayList = new ArrayList<Double>(Arrays.asList(doubleArray2).subList(0, n2));
            int n3 = (int)((double)doubleArray2.length * d2 / 100.0);
            int n4 = Math.min(doubleArray2.length, n3);
            for (int i = 0; i < n4; ++i) {
                arrayList.add(doubleArray2[doubleArray2.length - i - 1]);
            }
            if (!arrayList.isEmpty()) {
                Double[] doubleArray3 = arrayList.toArray(new Double[0]);
                dataSet.exclude((ProgressManager)breezeProgressManager, "var", doubleArray3);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static float[] getWavelength(DataSet dataSet) {
        VariablesInfo variablesInfo = dataSet.getVarDataInfo();
        InnerColumnString innerColumnString = (InnerColumnString)variablesInfo.getPrimaryColumnByType(0);
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(1);
        InnerColumnBoolean innerColumnBoolean2 = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(3);
        ArrayList<Float> arrayList = new ArrayList<Float>();
        for (int i = 0; i < innerColumnBoolean.getSize(); ++i) {
            if (!innerColumnBoolean.getValueBool(i) || !innerColumnBoolean2.getValueBool(i)) continue;
            arrayList.add(Float.valueOf(RtDataFormat.toNumberFloat(innerColumnString.getValueLocal(i))));
        }
        float[] fArray = new float[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            fArray[i] = ((Float)arrayList.get(i)).floatValue();
        }
        return fArray;
    }

    public static DataSet getAverageDataSet(BreezeProgressManager breezeProgressManager, DataSet dataSet) {
        DataContainer dataContainer = (DataContainer)dataSet.getTreeParent();
        DataSet dataSet2 = (DataSet)dataContainer.getNodeByName("Average");
        if (dataSet2 == null) {
            try {
                dataSet2 = dataSet.cloneDataSet();
                dataSet2.setName("Average_" + dataSet.getName());
                Properties properties = new Properties();
                properties.put("grouptype", "all");
                AbstractTransform abstractTransform = (AbstractTransform)dataSet2.createModification((ProgressManager)breezeProgressManager, "obs", "reducetoaverage", "included", properties);
                Double d = (Double)dataSet2.get("observations");
                Double[] doubleArray = DataTemplatesHelper.interval(d.intValue());
                dataSet2.exclude((ProgressManager)breezeProgressManager, "obs", doubleArray);
                dataSet2.setTrain(abstractTransform);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return dataSet2;
    }

    public static DataSet getDescriptorsDataSet(BreezeProgressManager breezeProgressManager, DataSet dataSet) {
        DataContainer dataContainer = (DataContainer)dataSet.getTreeParent();
        if (dataContainer == null) {
            return null;
        }
        DataSet dataSet2 = (DataSet)dataContainer.getNodeByName("Descriptors");
        if (dataSet2 == null) {
            dataSet2 = dataSet.cloneDataSet();
            dataSet2.setManual((ProgressManager)breezeProgressManager, dataSet.isManual());
            dataSet2.setName("Descriptors");
            dataSet2.exclude((ProgressManager)breezeProgressManager, "var");
            InnerColumnClass innerColumnClass = dataSet.getCategory((AbstractDataInfo)dataSet.getVarDataInfo(), "Datatype");
            Double[] doubleArray = innerColumnClass.getClassIndex("Descriptor");
            dataSet2.include((ProgressManager)breezeProgressManager, "var", doubleArray);
        }
        return dataSet2;
    }

    public static Double[] interval(int[] nArray) {
        Double[] doubleArray = new Double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            doubleArray[i] = (double)nArray[i] + 1.0;
        }
        return doubleArray;
    }

    public static Double[] interval(int n) {
        return DataTemplatesHelper.interval(0, n);
    }

    public static Double[] interval(int n, int n2) {
        if (n2 < n) {
            return new Double[0];
        }
        Double[] doubleArray = new Double[n2 - n];
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray[i] = (double)n + (double)i + 1.0;
        }
        return doubleArray;
    }

    public static void setDefaultBand(String string, String string2, AbstractDataMatrix abstractDataMatrix, AbstractPlotLayout abstractPlotLayout) {
        Properties properties = new Properties();
        if ((string.equals("origmatrix") || string.equals("xtraining")) && !string2.equals("Contour2D") && string2.equals("RGBImage")) {
            Case case_ = abstractDataMatrix.getCase();
            int[] nArray = null;
            if (case_ != null && case_.getOriginalMatrix() instanceof LayerMatrix) {
                nArray = ((LayerMatrix)case_.getOriginalMatrix()).getDefaultBand();
            }
            if (nArray != null) {
                for (int i = 0; i < Math.min(nArray.length, 3); ++i) {
                    AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf((double)i + 1.0));
                    abstractAxisLayer.setDataRange(new Object[]{"range", "matrix", (double)(nArray[i] + 1), properties});
                }
            }
        }
    }

    public static void setGrayBackground(AbstractPlotLayout abstractPlotLayout, double d, boolean bl) {
        Properties properties = new Properties();
        properties.put("colorscheme", "gray");
        properties.put("forcereflectance", String.valueOf(abstractPlotLayout.isAbsorbanceData()));
        if (bl) {
            properties.put("reverse", "true");
        }
        AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(d));
        abstractAxisLayer.setColor(new Object[]{"amplitude", properties});
        abstractAxisLayer.setDataRange(new Object[]{"range", "matrix", 43.0, properties});
    }

    public static AbstractDataMatrix smoothData(BreezeProgressManager breezeProgressManager, AbstractDataMatrix abstractDataMatrix) {
        Properties properties = new Properties();
        properties.put("type", "median");
        properties.put("kernel", "5");
        MVmatrix mVmatrix = new MVmatrix(abstractDataMatrix.getN(), abstractDataMatrix.getK(), abstractDataMatrix.getName());
        for (int i = 0; i < abstractDataMatrix.getK(); ++i) {
            properties.put("index", String.valueOf(i + 1));
            AbstractDataMatrix abstractDataMatrix2 = (AbstractDataMatrix)EvinceScriptCommands.apply((ProgressManager)breezeProgressManager, (String)"processimage", (BasicTreeInterface)abstractDataMatrix, (Properties)properties);
            int[] nArray = abstractDataMatrix2.getFNref();
            int n = abstractDataMatrix2.getN();
            int n2 = abstractDataMatrix2.getK();
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n2; ++k) {
                    int n3 = nArray[k * n + j];
                    if (n3 < 0) continue;
                    mVmatrix.setValue(n3, i, abstractDataMatrix2.getValue(j, k));
                }
            }
        }
        mVmatrix.set(abstractDataMatrix);
        mVmatrix.setTreeParent(abstractDataMatrix.getTreeParent());
        return mVmatrix;
    }

    public static AbstractDataMatrix getMatrix(AbstractModel abstractModel, String string) {
        if (abstractModel != null) {
            AbstractPrediction abstractPrediction;
            if (string.equals("model")) {
                if (abstractModel.getModelName().equals("SIMCA")) {
                    return abstractModel.getMatrixByName("ObsDMX");
                }
                return abstractModel.getMatrixByName("T");
            }
            String string2 = string.substring("model_".length());
            AbstractDataMatrix abstractDataMatrix = abstractModel.getMatrixByName(string2);
            if (abstractDataMatrix == null && (abstractPrediction = abstractModel.getPrediction("")) != null) {
                abstractDataMatrix = (AbstractDataMatrix)abstractPrediction.getNodeByName(string2);
            }
            if (abstractDataMatrix == null && (abstractPrediction = (DataContainer)abstractModel.getNodeByName("Explained variances")) != null) {
                abstractDataMatrix = (AbstractDataMatrix)abstractPrediction.getNodeByName(string2);
            }
            return abstractDataMatrix;
        }
        return null;
    }
}

