/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.evince.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.entry.WorkflowOrGroup;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.AnalyseSpectralGroup;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.evince.data.DataTemplatesHelper;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.evince.datasource.MeasurementDataSource;
import se.prediktera.breeze.evince.datasource.MeasurementImportInfo;
import se.prediktera.breeze.frontend.common.pp.PPClass;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.main.play.group.panel.ExploreSummaryPlots;
import se.prediktera.breeze.frontend.main.record.measurement.panel.PixelExplorePanel;
import se.prediktera.breeze.test.stubs.GroupWithoutIO;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.interaction.InteractionGroup;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.classes.ClassSettings;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.classes.prediction.InnerColumnPredClass;
import se.prediktera.map.datasetcontainer.classes.prediction.PredictionClasses;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.LoadHelper;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class MeasurementDataHelper {
    public static Object getInmatrixByInMemoryMeasurementDataSource(Project_GUI project_GUI, BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, Workflow workflow, String string, BandNames bandNames) {
        return MeasurementDataHelper.getInmatrix(project_GUI, breezeProgressManager, updateVisualizationJob, workflow, string, bandNames);
    }

    public static Object getInmatrix(Project_GUI project_GUI, BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, Workflow workflow, String string) {
        return MeasurementDataHelper.getInmatrix(project_GUI, breezeProgressManager, updateVisualizationJob, workflow, string, null);
    }

    public static Object getInmatrix(Project_GUI project_GUI, BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, Workflow workflow, String string, BandNames bandNames) {
        MeasurementDataSource measurementDataSource;
        Case case_;
        Object object = updateVisualizationJob.getEntryData();
        if (object == null) {
            return null;
        }
        ArrayList<AnalyseSpectralGroup> arrayList = new ArrayList<AnalyseSpectralGroup>();
        WorkflowOrGroup workflowOrGroup = MeasurementDataHelper.addAnalyseSpectralGroupListFromEntryReturnGetDataSetEntry(object, arrayList);
        if (arrayList.isEmpty()) {
            arrayList.add(new AnalyseSpectralGroup(new GroupWithoutIO()));
        }
        DataSet dataSet = DataSetCache.get(workflowOrGroup);
        int n = workflow.getSegmentationLevel();
        String string2 = workflow.getSegmentationHashId();
        InteractionArray interactionArray = null;
        if (dataSet != null) {
            case_ = dataSet.getCase();
            if (case_ != null) {
                measurementDataSource = (MeasurementDataSource)case_.getDataSource();
                boolean bl = measurementDataSource.workflowChanged(workflow);
                if (measurementDataSource.getSegmentationLevel() != n || measurementDataSource.getSegmentationHashId() != string2 || bl) {
                    if (bl) {
                        interactionArray = MeasurementDataHelper.getCurrentInteractionArray(project_GUI);
                    }
                    DataSetCache.clearRecursive(workflowOrGroup);
                    dataSet = null;
                }
            } else {
                DataSetCache.clearRecursive(workflowOrGroup);
                dataSet = null;
            }
        }
        if (dataSet == null) {
            dataSet = MeasurementDataHelper.createDataSet(project_GUI, breezeProgressManager, arrayList, new SegmentationIdentifier(n, string2), bandNames, workflow.getExploreFilter());
            MeasurementDataHelper.excludeWavelengthAndCreateModifications(breezeProgressManager, dataSet, workflow);
            DataSetCache.set(workflowOrGroup, dataSet);
            if (interactionArray != null) {
                MeasurementDataHelper.copyInteraction(project_GUI, dataSet, interactionArray);
            }
            MeasurementDataHelper.addPredictionClasses(breezeProgressManager, dataSet, workflow);
            MeasurementDataHelper.addPredictionClasses(breezeProgressManager, dataSet.getCase().getOriginalDataSet(), workflow);
        }
        if (string.startsWith("descriptors")) {
            case_ = DataTemplatesHelper.getDescriptorsDataSet(breezeProgressManager, dataSet);
            if (case_ == null) {
                return null;
            }
            measurementDataSource = case_.getMatrix(0);
            if (string.equals("descriptors_count")) {
                return MeasurementDataHelper.createCategoryCountMatrix(workflow, (AbstractDataMatrix)measurementDataSource);
            }
            return measurementDataSource;
        }
        if (string.startsWith("model_descriptor")) {
            return MeasurementDataHelper.createDescriptorModel(breezeProgressManager, string, dataSet);
        }
        if (string.startsWith("modelPca")) {
            return MeasurementDataHelper.getPcaModelMatrix(breezeProgressManager, workflow, string, ((AnalyseSpectralGroup)arrayList.get(0)).getGroup(), dataSet);
        }
        if (string.equals("origmatrix")) {
            return dataSet.getOriginalMatrix();
        }
        if (string.equals("xtraining")) {
            return dataSet.getMatrix(0);
        }
        if (string.equals("ytraining")) {
            return dataSet.getMatrix(2);
        }
        if (string.equals("model_xres")) {
            case_ = DataTemplatesHelper.createPCA(breezeProgressManager, dataSet, 0);
            return case_.getMatrixByName("xres");
        }
        if (string.startsWith("model")) {
            return MeasurementDataHelper.createPcaModel(breezeProgressManager, string, dataSet);
        }
        throw new RuntimeException("MeasurementDataHelper: No such matrix type " + string);
    }

    private static void addPredictionClasses(BreezeProgressManager breezeProgressManager, DataSet dataSet, Workflow workflow) {
        ObservationInfo observationInfo = dataSet.getObsDataInfo();
        PredictionClasses predictionClasses = (PredictionClasses)observationInfo.getGroupColumnByType(11);
        if (predictionClasses == null) {
            predictionClasses = new PredictionClasses(observationInfo.getRowCount());
            observationInfo.addTreeNode((DataTreeInterface)predictionClasses);
        }
        for (DescriptorTreeNode descriptorTreeNode : PixelExplorePanel.getDescriptors(workflow)) {
            String string;
            Object object = descriptorTreeNode.getFactor();
            if (!(object instanceof CategoryFactor)) continue;
            CategoryFactor categoryFactor = (CategoryFactor)object;
            object = descriptorTreeNode.getAliasOrNodeString();
            InnerColumnClass innerColumnClass = dataSet.getCategory((AbstractDataInfo)dataSet.getVarDataInfo(), "Datatype");
            int[] nArray = innerColumnClass.getClassIndexInt("Descriptor");
            AbstractDataMatrix abstractDataMatrix = dataSet.getOriginalMatrix();
            InnerColumnString innerColumnString = (InnerColumnString)abstractDataMatrix.getColumnDescription().getPrimaryColumn();
            int n = -1;
            for (int i = 0; i < nArray.length; ++i) {
                string = innerColumnString.getValueLocal(nArray[i]);
                if (!string.equalsIgnoreCase((String)object)) continue;
                n = i;
                break;
            }
            if (n < 0) continue;
            InnerColumnPredClass innerColumnPredClass = predictionClasses.getPredictionClass((DataTreeInterface)dataSet, (String)object);
            for (int i = 0; i < innerColumnPredClass.getSize(); ++i) {
                innerColumnPredClass.setValueShort(i, (short)abstractDataMatrix.getValue(i, n));
            }
            string = innerColumnPredClass.getHoldObject();
            for (CatClass catClass : categoryFactor.getAllClasses()) {
                if (catClass.isNoClass()) {
                    ClassSettings classSettings = (ClassSettings)string.get(0);
                    classSettings.setName(catClass.getName());
                    classSettings.setColor(catClass.getColor());
                    continue;
                }
                string.add((Object)new ClassSettings(catClass.getName(), string.size(), catClass.getColor()));
            }
        }
    }

    private static void copyInteraction(Project_GUI project_GUI, DataSet dataSet, InteractionArray interactionArray) {
        if (project_GUI == null || dataSet == null) {
            return;
        }
        InteractionGroup interactionGroup = project_GUI.getInteractionGroup(0);
        if (interactionGroup != null) {
            InteractionArray interactionArray2 = interactionGroup.getInteractionArray((DataTreeInterface)dataSet.getCase(), 1, dataSet.getOriginalMatrix().getN());
            int n = Math.min(interactionArray.size(), interactionArray2.size());
            for (int i = 0; i < n; ++i) {
                if (!interactionArray.get(i)) continue;
                interactionArray2.set(i);
            }
        }
    }

    private static InteractionArray getCurrentInteractionArray(Project_GUI project_GUI) {
        InteractionArray interactionArray;
        InteractionGroup interactionGroup = project_GUI.getInteractionGroup(0);
        if (interactionGroup != null && (interactionArray = interactionGroup.getInteractionArray(1)) != null) {
            return interactionArray.cloneArray();
        }
        return null;
    }

    private static WorkflowOrGroup addAnalyseSpectralGroupListFromEntryReturnGetDataSetEntry(Object object, List<AnalyseSpectralGroup> list) {
        if (object instanceof Group || object instanceof Measurement) {
            Group group = Group.getGroup(object);
            list.add(new AnalyseSpectralGroup(group));
            return group;
        }
        if (object instanceof Workflow) {
            Workflow workflow = (Workflow)object;
            for (Group group : workflow.getChildList()) {
                list.add(new AnalyseSpectralGroup(group));
            }
            return workflow;
        }
        if (object instanceof ViewClass) {
            ViewClass viewClass = (ViewClass)object;
            PPClass pPClass = (PPClass)viewClass.getValue();
            Group group = (Group)pPClass.getEntrydata();
            list.add(new AnalyseSpectralGroup(group));
            return group;
        }
        throw new RuntimeException("Entry data not supported " + String.valueOf(object));
    }

    private static void excludeWavelengthAndCreateModifications(BreezeProgressManager breezeProgressManager, DataSet dataSet, Workflow workflow) {
        double d = workflow.getModellingDefaultExcludeWavelengthsBeginningPercent();
        double d2 = workflow.getModellingDefaultExcludeWavelengthsEndPercent();
        DataTemplatesHelper.excludeWavelengthByDatatype(breezeProgressManager, dataSet, d, d2);
        if (workflow.isXrayData()) {
            Properties properties = new Properties();
            properties.put("log10", (Object)false);
            dataSet.createModification((ProgressManager)breezeProgressManager, "var", "logarithm", (Double[])null, properties);
        } else {
            dataSet.createModification((ProgressManager)breezeProgressManager, "var", "center");
            if (workflow.getModellingExploreSnv() && dataSet.getMatrix(0).getK() > 3) {
                dataSet.createModification((ProgressManager)breezeProgressManager, "var", "snv");
            }
        }
    }

    private static Object createPcaModel(BreezeProgressManager breezeProgressManager, String string, DataSet dataSet) {
        AbstractModel abstractModel = DataTemplatesHelper.createPCA(breezeProgressManager, dataSet, 2);
        if (abstractModel != null) {
            if (string.equals("model_p")) {
                return abstractModel.getMatrixByName("P");
            }
            return abstractModel.getMatrixByName("T");
        }
        return null;
    }

    private static Object getPcaModelMatrix(BreezeProgressManager breezeProgressManager, Workflow workflow, String string, Group group, DataSet dataSet) {
        Analyse analyse = MeasurementDataHelper.getFirstConnectedAnalysis(workflow);
        if (analyse == null || dataSet.hasX() == 0.0) {
            return null;
        }
        String string2 = analyse.getUid();
        AbstractModel abstractModel = (AbstractModel)dataSet.getNodeByName(string2);
        if (abstractModel == null) {
            abstractModel = analyse.getBaseModel(breezeProgressManager);
            abstractModel.getCase().setLinkedDataSource(dataSet.getCase().getDataSource());
        }
        if (string.equals("modelPca_tpred") || string.equals("modelPca_obsdmxpred")) {
            DataContainer dataContainer = abstractModel.getExternalPredictions();
            if (dataContainer == null) {
                dataContainer = new DataContainer("External predictions", 13);
                abstractModel.addTreeNode((DataTreeInterface)dataContainer);
            }
            String string3 = group.getName() + string2;
            AbstractPrediction abstractPrediction = MeasurementDataHelper.getPredictionByName(dataContainer, string3);
            abstractPrediction = (AbstractPrediction)abstractModel.createPrediction((ProgressManager)breezeProgressManager, dataSet);
            abstractPrediction.setName(string3);
            dataContainer.addTreeNode((DataTreeInterface)abstractPrediction);
            if (string.equals("modelPca_tpred")) {
                return abstractPrediction.getMatrixByName("Tpred");
            }
            return abstractPrediction.getMatrixByName("ObsDMXpred");
        }
        if (string.equals("modelPca_obsdmx")) {
            return abstractModel.getMatrixByName("obsdmx");
        }
        if (string.equals("modelPca_p")) {
            return abstractModel.getMatrixByName("P");
        }
        return abstractModel.getMatrixByName("T");
    }

    private static Analyse getFirstConnectedAnalysis(Workflow workflow) {
        for (BasicAnalyse basicAnalyse : workflow.getConnectedAnalysis()) {
            if (!(basicAnalyse instanceof Analyse)) continue;
            Analyse analyse = (Analyse)basicAnalyse;
            return analyse;
        }
        return null;
    }

    private static Object createDescriptorModel(BreezeProgressManager breezeProgressManager, String string, DataSet dataSet) {
        DataSet dataSet2 = DataTemplatesHelper.getDescriptorsDataSet(breezeProgressManager, dataSet);
        AbstractModel abstractModel = (AbstractModel)dataSet2.getNodeByName("PCA_Descriptor");
        if (abstractModel == null && (abstractModel = dataSet2.createModel((ProgressManager)breezeProgressManager, "pca")) != null) {
            abstractModel.setName("PCA_Descriptor");
        }
        String string2 = string.substring("model_descriptor_".length());
        return abstractModel.getMatrixByName(string2);
    }

    private static Object createCategoryCountMatrix(Workflow workflow, AbstractDataMatrix abstractDataMatrix) {
        List<DescriptorTreeNode> list = workflow.getAllDescriptorNodes();
        CategoryFactor categoryFactor = (CategoryFactor)ExploreSummaryPlots.getFirstClassificationFactor(list);
        int n = categoryFactor.getClassCount();
        MVmatrix mVmatrix = new MVmatrix(n, 1);
        if (abstractDataMatrix.getK() > 0) {
            int n2;
            Description description = new Description(1);
            mVmatrix.setColumnDescription(description);
            InnerColumnString innerColumnString = (InnerColumnString)description.addColumn();
            innerColumnString.setValue(0, (Object)categoryFactor.getName());
            Description description2 = new Description(n);
            mVmatrix.setRowDescription(description2);
            InnerColumnString innerColumnString2 = (InnerColumnString)description2.addColumn();
            for (n2 = 0; n2 < n; ++n2) {
                innerColumnString2.setValue(n2, (Object)categoryFactor.getClasses().get(n2).getName());
            }
            for (n2 = 0; n2 < abstractDataMatrix.getK() && !abstractDataMatrix.getColumnDescription(n2, 0).equals(categoryFactor.getName()); ++n2) {
            }
            for (int i = 0; i < n; ++i) {
                int n3 = 0;
                for (int j = 0; j < abstractDataMatrix.getN(); ++j) {
                    if (abstractDataMatrix.getValue(j, n2) != (double)i) continue;
                    ++n3;
                }
                mVmatrix.setValue(i, 0, (double)n3);
            }
        }
        return mVmatrix;
    }

    private static DataSet createDataSet(Project_GUI project_GUI, BreezeProgressManager breezeProgressManager, List<AnalyseSpectralGroup> list, SegmentationIdentifier segmentationIdentifier, BandNames bandNames, String string) {
        Properties properties = new Properties();
        properties.put("recursive", "true");
        properties.put("includerootfolder", "false");
        properties.put("referenceonly", "true");
        properties.put("checkemptydata", "false");
        Group group = list.get(0).getGroup();
        if (group.getFolder() != null) {
            properties.put("rootfolder", group.getFolder().getAbsolutePath());
        }
        MeasurementDataSource measurementDataSource = new MeasurementDataSource(list, segmentationIdentifier, bandNames, false, string);
        measurementDataSource.autoIdentifyData(breezeProgressManager, Integer.MAX_VALUE);
        return LoadHelper.loadDataSource((Project_GUI)project_GUI, (ProgressManager)breezeProgressManager, (AbstractImportInfo)new MeasurementImportInfo(), (CellIdentifierModel)measurementDataSource, (Properties)properties);
    }

    private static AbstractPrediction getPredictionByName(DataContainer dataContainer, String string) {
        for (int i = 0; i < dataContainer.getTreeNodeCount(); ++i) {
            AbstractPrediction abstractPrediction;
            DataTreeInterface dataTreeInterface = dataContainer.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof AbstractPrediction) || !(abstractPrediction = (AbstractPrediction)dataTreeInterface).getName().equals(string)) continue;
            return abstractPrediction;
        }
        return null;
    }
}

