/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.evince.data;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;

public final class PixelCounter {
    private final ConcurrentHashMap<Long, LongAdder> counts = new ConcurrentHashMap();

    private static long packRC(int n, int n2) {
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    private static int unpackRow(long l) {
        return (int)(l >>> 32);
    }

    private static int unpackCol(long l) {
        return (int)(l & 0xFFFFFFFFL);
    }

    public void increment(int n, int n2) {
        this.counts.computeIfAbsent(PixelCounter.packRC(n, n2), l -> new LongAdder()).increment();
    }

    public long get(int n, int n2) {
        LongAdder longAdder = this.counts.get(PixelCounter.packRC(n, n2));
        return longAdder == null ? 0L : longAdder.sum();
    }

    public boolean exceeds(int n, int n2, long l) {
        return this.get(n, n2) >= l;
    }

    public Iterable<Map.Entry<Long, LongAdder>> entries() {
        return this.counts.entrySet();
    }

    public static int rowOf(long l) {
        return PixelCounter.unpackRow(l);
    }

    public static int colOf(long l) {
        return PixelCounter.unpackCol(l);
    }
}

