/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.evince.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.BitSet;
import java.util.List;
import java.util.Properties;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.measurement.MeasurementFileLocation;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNodeList;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.realtime.segmentation.model.ModelExpressionSegmentation;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.IntHolder;
import se.prediktera.breeze.common.util.image.RtPixel2D;
import se.prediktera.breeze.common.util.image.RtSpatialObject;
import se.prediktera.breeze.common.util.raw.CachedRawFile;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.entry.MeasurementOrSample;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.ReduceFromFileSize;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SampleSegmentationColumn;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.evince.data.DataTemplatesHelper;
import se.prediktera.breeze.evince.data.SpectralMatrixCache;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.evince.matrix.FrameMatrix;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailImage;
import se.prediktera.breeze.frontend.main.record.measurement.panel.PixelExplorePanel;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeClass;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.classes.ClassSettings;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.classes.prediction.InnerColumnPredClass;
import se.prediktera.map.datasetcontainer.classes.prediction.PredictionClasses;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.datainfo.DataGroupValues;
import se.prediktera.map.datasetcontainer.datainfo.DataInfoEvent;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBooleanIncExc;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnType;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.matrix.MatrixContainer;
import se.prediktera.map.datasetcontainer.transform.category.Category;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;
import se.prediktera.mda.model.ModelException;

public class PixelDataHelper {
    private static final SpectralMatrixCache matrixCache = new SpectralMatrixCache();

    public static AbstractDataMatrix getInmatrix(Project_GUI project_GUI, BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, Analyse analyse, String string) {
        return PixelDataHelper.getInmatrix(project_GUI, breezeProgressManager, analyse, string, (MeasurementOrSample)updateVisualizationJob.getEntryData());
    }

    public static AbstractDataMatrix getInmatrix(Project_GUI project_GUI, BreezeProgressManager breezeProgressManager, Analyse analyse, String string, MeasurementOrSample measurementOrSample) {
        BitSet bitSet;
        DataSet dataSet = DataSetCache.get(measurementOrSample);
        Measurement measurement = measurementOrSample instanceof Sample ? ((Sample)measurementOrSample).measurement() : (Measurement)measurementOrSample;
        if (string.startsWith("reference")) {
            return matrixCache.getMatrix(measurement, string);
        }
        if (dataSet == null || dataSet.hasX() == 0.0 || dataSet.isReload()) {
            if (!measurement.hasData()) {
                throw new RawFileNotFoundException("Measurement has no data");
            }
            bitSet = null;
            BitSet bitSet2 = null;
            if (dataSet != null) {
                if (dataSet.isReload()) {
                    bitSet = ((InnerColumnBoolean)dataSet.getObsDataInfo().getPrimaryColumnByType(1)).getValues();
                    bitSet2 = ((InnerColumnBoolean)dataSet.getVarDataInfo().getPrimaryColumnByType(1)).getValues();
                }
                dataSet.close();
            }
            dataSet = PixelDataHelper.createDataSet(project_GUI, measurement, breezeProgressManager, PixelDataHelper.calcReduce(measurement), bitSet, bitSet2);
            DataSetCache.set(measurement, dataSet);
        }
        if (string.equals("origmatrix")) {
            return dataSet.getOriginalMatrix();
        }
        if (string.equals("xtraining")) {
            return dataSet.getMatrix(0);
        }
        if (string.equals("model")) {
            return PixelDataHelper.createPcaModelMatrix(breezeProgressManager, dataSet, "T");
        }
        if (string.equals("model_p")) {
            return PixelDataHelper.createPcaModelMatrix(breezeProgressManager, dataSet, "P");
        }
        if (string.equals("model_xres")) {
            bitSet = DataTemplatesHelper.createPCA(breezeProgressManager, dataSet, 0);
            return bitSet.getMatrixByName("xres");
        }
        if (string.startsWith("prediction") || string.startsWith("classification")) {
            return PixelDataHelper.createPredictionAndGetYpredMatrix(breezeProgressManager, string, dataSet, analyse);
        }
        if (string.equals("descriptors")) {
            return PixelDataHelper.createDescriptorDataSet(breezeProgressManager, dataSet, measurement).getMatrix(0);
        }
        throw new RuntimeException("PixelDataHelper: No such matrix type " + string);
    }

    private static DataSet createDescriptorDataSet(BreezeProgressManager breezeProgressManager, DataSet dataSet, Measurement measurement) {
        Case case_ = dataSet.getCase();
        DataSet dataSet2 = (DataSet)case_.getDsContainer().getNodeByName("Descriptors");
        if (dataSet2 == null) {
            final FrameMatrix frameMatrix = (FrameMatrix)case_.getOriginalMatrix();
            int n = frameMatrix.addPredictionMatrix(measurement, new FrameListFromRaw.Reduce(case_.getReduce()));
            dataSet.updateReferences();
            dataSet.triggetDataInfoEvent(new DataInfoEvent((AbstractDataInfo)dataSet.getVarDataInfo(), 10));
            InnerColumnBooleanIncExc innerColumnBooleanIncExc = (InnerColumnBooleanIncExc)dataSet.getVarDataInfo().getPrimaryColumnByType(1);
            InnerColumnString innerColumnString = (InnerColumnString)dataSet.getVarDataInfo().getPrimaryColumnByType(0);
            InnerColumnClass innerColumnClass = dataSet.getCategory((AbstractDataInfo)dataSet.getVarDataInfo(), "Datatype");
            for (int i = n; i < innerColumnClass.getSize(); ++i) {
                innerColumnBooleanIncExc.setValueLocal(i, Boolean.valueOf(false));
                innerColumnString.setValueLocal(i, frameMatrix.getMatrixAt(i).getName());
                innerColumnClass.setValueShort(i, innerColumnClass.getHoldObject().addString("Descriptor", true));
            }
            dataSet.updateReferences();
            dataSet2 = DataTemplatesHelper.getDescriptorsDataSet(breezeProgressManager, dataSet);
            for (DescriptorTreeNode descriptorTreeNode : PixelExplorePanel.getDescriptors(measurement.getWorkflow())) {
                Object object = descriptorTreeNode.getFactor();
                if (!(object instanceof CategoryFactor)) continue;
                CategoryFactor categoryFactor = (CategoryFactor)object;
                object = descriptorTreeNode.getAnalyseUid() + "_" + descriptorTreeNode.getFactorUid();
                final int n2 = frameMatrix.getMatrixIndex((String)object);
                ObservationInfo observationInfo = dataSet2.getObsDataInfo();
                PredictionClasses predictionClasses = (PredictionClasses)observationInfo.getGroupColumnByType(11);
                if (predictionClasses == null) {
                    predictionClasses = new PredictionClasses(observationInfo.getRowCount()){

                        public InnerColumnClass createInnerColumn(String string, CellIdentifierModel cellIdentifierModel, int n) {
                            return new InnerColumnPredClass(this, string, (DataGroupValues)this, cellIdentifierModel, n){
                                final /* synthetic */ 1 this$0;
                                {
                                    this.this$0 = var1_1;
                                    super(string, dataGroupValues, cellIdentifierModel, n);
                                }

                                public Object getValue(int n) {
                                    return (int)frameMatrix.getValue(n, n2);
                                }
                            };
                        }
                    };
                    observationInfo.addTreeNode((DataTreeInterface)predictionClasses);
                }
                InnerColumnPredClass innerColumnPredClass = predictionClasses.getPredictionClass((DataTreeInterface)dataSet2, categoryFactor.getUid());
                ClassTypes classTypes = innerColumnPredClass.getHoldObject();
                for (CatClass catClass : categoryFactor.getAllClasses()) {
                    if (catClass.isNoClass()) {
                        ClassSettings classSettings = (ClassSettings)classTypes.get(0);
                        classSettings.setName(catClass.getName());
                        classSettings.setColor(catClass.getColor());
                        continue;
                    }
                    classTypes.add((Object)new ClassSettings(catClass.getName(), classTypes.size(), catClass.getColor()));
                }
            }
        }
        return dataSet2;
    }

    public static int calcReduce(Measurement measurement) {
        int n = measurement.getWorkflow().getDefaultReduce();
        if (n > 0) {
            return n;
        }
        return ReduceFromFileSize.fromMeasurement(measurement).value();
    }

    private static void setCaseInformation(DataSet dataSet, Measurement measurement, RtFramePredictor.RefSettings refSettings) {
        Case case_ = dataSet.getCase();
        String string = measurement.getMetaValue("Resolution");
        if (string != null) {
            case_.setCellArea(NiceDataFormat.toNumber((String)string));
            case_.setCellUnit("mm");
        }
        case_.setConvertTo(refSettings.convertTo.name());
    }

    private static AbstractDataMatrix createPcaModelMatrix(BreezeProgressManager breezeProgressManager, DataSet dataSet, String string) {
        try {
            AbstractModel abstractModel = DataTemplatesHelper.createPCA(breezeProgressManager, dataSet, 2);
            if (abstractModel != null) {
                return abstractModel.getMatrixByName(string);
            }
        }
        catch (ModelException.ModelNoDataException modelNoDataException) {
            throw new RuntimeException("Not enough data to create model");
        }
        return null;
    }

    private static AbstractDataMatrix createPredictionAndGetYpredMatrix(BreezeProgressManager breezeProgressManager, String string, DataSet dataSet, Analyse analyse) {
        DataTreeClass dataTreeClass;
        DataTreeClass dataTreeClass2;
        AbstractPrediction abstractPrediction = null;
        int n = string.indexOf("_");
        String string2 = string.substring(n + 1);
        DataSet dataSet2 = dataSet;
        if (string.indexOf("average") > 0) {
            dataSet2 = DataTemplatesHelper.getAverageDataSet(breezeProgressManager, dataSet);
        }
        if ((dataTreeClass2 = (DataTreeClass)dataSet2.getNodeByName("Predictions")) != null) {
            abstractPrediction = (AbstractPrediction)dataTreeClass2.getNodeByName(string2);
        }
        if (abstractPrediction == null) {
            AbstractModel[] abstractModelArray;
            dataTreeClass = (DataTreeClass)dataSet2.getRoot();
            AbstractModel abstractModel = (AbstractModel)dataTreeClass.getNodeByName(string2);
            if (abstractModel == null) {
                abstractModelArray = EvinceScriptCommands.loadModels((ProgressManager)breezeProgressManager, (String)analyse.getProjectFile().getAbsolutePath());
                abstractModel = abstractModelArray[0];
                abstractModel.setName(string2);
                dataTreeClass.addTreeNode((DataTreeInterface)abstractModel);
            }
            abstractModelArray = new Properties();
            abstractPrediction = (AbstractPrediction)abstractModel.createPrediction((ProgressManager)breezeProgressManager, dataSet2, (Properties)abstractModelArray);
        }
        dataTreeClass = (MatrixContainer)abstractPrediction.getNodeByName("Ypred");
        return dataTreeClass.getLastAbstractMatrix();
    }

    private static DataSet createDataSet(Project_GUI project_GUI, Measurement measurement, BreezeProgressManager breezeProgressManager, int n, BitSet bitSet, BitSet bitSet2) {
        Workflow workflow = measurement.getWorkflow();
        Case case_ = project_GUI.getOrCreatePrimaryCase();
        RtFramePredictor.RefSettings refSettings = measurement.getRefSettings(workflow.getPixelExploreReferenceConvertTo());
        refSettings.reduce = new FrameListFromRaw.Reduce(n);
        FrameMatrix frameMatrix = FrameMatrix.readReferenceOrRawFrameMatrix((BreezeProgress)breezeProgressManager, measurement, refSettings);
        DataSet dataSet = case_.importCaseFromMatrix((AbstractDataMatrix)frameMatrix, project_GUI, (ProgressManager)breezeProgressManager, n);
        frameMatrix.initiateCaseAndDataSet(case_, dataSet, refSettings);
        PixelDataHelper.createTypeCategory(breezeProgressManager, dataSet);
        dataSet.setName(measurement.getName() + "(" + measurement.getUid() + ")");
        PixelDataHelper.transformData(breezeProgressManager, dataSet, workflow);
        if (bitSet != null && bitSet2 != null) {
            ((InnerColumnBoolean)dataSet.getObsDataInfo().getPrimaryColumnByType(1)).setValues(bitSet);
            ((InnerColumnBoolean)dataSet.getVarDataInfo().getPrimaryColumnByType(1)).setValues(bitSet2);
        } else {
            PixelDataHelper.includeOnlySamplePixels(breezeProgressManager, measurement, dataSet, n);
        }
        dataSet.updateReferences((ProgressManager)breezeProgressManager, true);
        PixelDataHelper.setCaseInformation(dataSet, measurement, refSettings);
        return dataSet;
    }

    private static void createTypeCategory(ProgressManager progressManager, DataSet dataSet) {
        try {
            Category category = (Category)dataSet.createModification(progressManager, "var", "category");
            InnerColumnClass innerColumnClass = category.getInnerColumn();
            ClassTypes classTypes = innerColumnClass.getHoldObject();
            InnerColumnType innerColumnType = (InnerColumnType)dataSet.getVarDataInfo().getPrimaryColumnByType(6);
            for (int i = 0; i < innerColumnType.getSize(); ++i) {
                innerColumnClass.setValueShort(i, classTypes.addString(switch (innerColumnType.getType(i)) {
                    case 4 -> "NIR";
                    case 10 -> "Property";
                    case 16 -> "Descriptor";
                    default -> "N/A";
                }, true));
            }
            category.setLayerName("Datatype");
            category.updateClasses();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException((Throwable)exception);
        }
    }

    private static void transformData(BreezeProgressManager breezeProgressManager, DataSet dataSet, Workflow workflow) {
        double d = workflow.getModellingDefaultExcludeWavelengthsBeginningPercent();
        double d2 = workflow.getModellingDefaultExcludeWavelengthsEndPercent();
        DataTemplatesHelper.excludeWavelength(breezeProgressManager, dataSet, d, d2);
        if (workflow.isXrayData()) {
            Properties properties = new Properties();
            properties.put("log10", (Object)false);
            dataSet.createModification((ProgressManager)breezeProgressManager, "var", "logarithm", (Double[])null, properties);
        } else {
            dataSet.createModification((ProgressManager)breezeProgressManager, "var", "center");
            if (workflow.getModellingExplorePixelSnv() && dataSet.getOriginalMatrix().getK() > 3) {
                dataSet.createModification((ProgressManager)breezeProgressManager, "var", "snv");
            }
        }
    }

    private static void includeOnlySamplePixels(BreezeProgressManager breezeProgressManager, Measurement measurement, DataSet dataSet, int n) {
        int n5;
        AbstractDataMatrix abstractDataMatrix = dataSet.getOriginalMatrix();
        FoldMatrix foldMatrix = new FoldMatrix(abstractDataMatrix);
        ObservationInfo observationInfo = dataSet.getObsDataInfo();
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)observationInfo.getPrimaryColumnByType(1);
        List<Sample> list = PixelDataHelper.getSamples(measurement);
        SegmentationNodeList segmentationNodeList = measurement.getSegmentationsForCurrentLevel(null);
        File file = measurement.getPredictionRawFile();
        CachedRawFile cachedRawFile = null;
        if (file.exists()) {
            try {
                cachedRawFile = new CachedRawFile(measurement, new MeasurementFileLocation.Prediction(), new FrameListFromRaw.Reduce(n));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (!list.isEmpty()) {
            innerColumnBoolean.fillColumn(false);
            IntHolder intHolder = new IntHolder();
            for (Sample sample : list) {
                RtSpatialObject rtSpatialObject = sample.getCachedSpatialObject();
                if (rtSpatialObject != null) {
                    rtSpatialObject.forEveryPixel((n2, n3, n4) -> {
                        innerColumnBoolean.setValueBool(foldMatrix.getIndex(n3 / n, n2 / n), true);
                        intHolder.increase();
                    });
                } else {
                    for (RtPixel2D rtPixel2D : sample.getObjectPixels()) {
                        innerColumnBoolean.setValueBool(foldMatrix.getIndex(rtPixel2D.y / n, rtPixel2D.x / n), true);
                        intHolder.increase();
                    }
                }
                if (cachedRawFile == null || segmentationNodeList.size() <= 0) continue;
                for (SegmentationNode j2 : segmentationNodeList) {
                    int n6;
                    int n7;
                    SegmentationNode j2;
                    int d2 = ThumbnailImage.getBandLayer(cachedRawFile.header().bandNames(), j2.getAnalyse(), j2.getFactor());
                    if (d2 < 0) continue;
                    List<RawFrame> list2 = cachedRawFile.readFrames();
                    Object n9 = j2.getFunction();
                    if (n9 instanceof ModelExpressionSegmentation) {
                        ModelExpressionSegmentation modelExpressionSegmentation = (ModelExpressionSegmentation)n9;
                        ModelExpressionSegmentation.ExpInsideList i = ((ModelExpressionSegmentation.ModelExpression)(n9 = modelExpressionSegmentation.getExpression().getModelExpression())).getSimpleExpressionValues(j2.getAnalyse());
                        if (i.size() <= 0) continue;
                        for (int rawFrame = 0; rawFrame < foldMatrix.getN(); ++rawFrame) {
                            RawFrame j3 = list2.get(rawFrame);
                            for (n7 = 0; n7 < foldMatrix.getK(); ++n7) {
                                n6 = foldMatrix.getIndex(rawFrame, n7);
                                if (!innerColumnBoolean.getValueBool(n6) || i.anyInside(j3.getFrameValue(d2, n7))) continue;
                                innerColumnBoolean.setValueBool(n6, false);
                            }
                        }
                        continue;
                    }
                    int n8 = j2.getFunction().isInverse() ? 1 : 0;
                    for (int i = 0; i < foldMatrix.getN(); ++i) {
                        RawFrame rawFrame = list2.get(i);
                        for (int k = 0; k < foldMatrix.getK(); ++k) {
                            n7 = foldMatrix.getIndex(i, k);
                            if (!innerColumnBoolean.getValueBool(n7) || (n6 = (int)rawFrame.getFrameValue(d2, k)) != n8) continue;
                            innerColumnBoolean.setValueBool(n7, false);
                        }
                    }
                }
            }
            if (intHolder.getValue() < 5) {
                innerColumnBoolean.fillColumn(true);
            }
        }
        if ((n5 = abstractDataMatrix.getK()) > 5) {
            abstractDataMatrix.beginCalculations();
            for (int i = 0; i < abstractDataMatrix.getN(); ++i) {
                if (!innerColumnBoolean.getValueBool(i)) continue;
                boolean bl = true;
                double d = 0.0;
                for (int j = 0; j < n5; ++j) {
                    double d2 = abstractDataMatrix.getValue(i, j);
                    if (j > 0 && d2 != d) {
                        bl = false;
                        break;
                    }
                    d = d2;
                }
                if (!bl) continue;
                innerColumnBoolean.setValueBool(i, false);
            }
            abstractDataMatrix.endCalculations();
        }
        dataSet.originalObs = ((InnerColumnBoolean)dataSet.getObsDataInfo().getPrimaryColumnByType(1)).getValues();
    }

    private static List<Sample> getSamples(Measurement measurement) {
        Workflow workflow = measurement.getWorkflow();
        int n = workflow.getSegmentationLevel();
        String string = workflow.getSegmentationHashId();
        if (string != null) {
            return measurement.getSamples(string);
        }
        SampleSegmentationColumn sampleSegmentationColumn = measurement.getSamples(n);
        if (sampleSegmentationColumn.isEmpty() && n > 1) {
            return measurement.getSamples(n - 1);
        }
        return sampleSegmentationColumn;
    }

    public static void clearSpectralMatrixCache() {
        matrixCache.clear();
    }

    public static class RawFileNotFoundException
    extends ErrorHandler.InformationMessageException {
        public RawFileNotFoundException(String string) {
            super(string);
        }
    }
}

