/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.evince.data;

import java.util.Properties;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.script.EvinceScriptCommands;

public class SamplePredictionDataHelper {
    public static AbstractDataMatrix getInmatrix(BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, Analyse analyse, String string) {
        Object object = updateVisualizationJob.getEntryData();
        Measurement measurement = (Measurement)object;
        DataSet dataSet = DataSetCache.get(measurement);
        if (dataSet == null || dataSet.hasX() == 0.0) {
            dataSet = SamplePredictionDataHelper.createDataSet(breezeProgressManager, measurement);
            DataSetCache.set(measurement, dataSet);
        }
        if (string.equals("origmatrix")) {
            return dataSet.getOriginalMatrix();
        }
        if (string.startsWith("prediction") || string.startsWith("classification")) {
            return dataSet.getMatrix(0);
        }
        throw new RuntimeException("SamplePredictionDataHelper: No such matrix type " + string);
    }

    private static DataSet createDataSet(BreezeProgressManager breezeProgressManager, Measurement measurement) {
        Properties properties = new Properties();
        properties.put("apply", "nounitconversion");
        properties.put("masklayer", "0");
        properties.put("masksampleid", "1");
        DataSet dataSet = (DataSet)EvinceScriptCommands.load((ProgressManager)breezeProgressManager, (String)measurement.getPredictionRawFile().getAbsolutePath(), (Properties)properties);
        dataSet.setName(measurement.getName() + "(" + measurement.getUid() + ")");
        return dataSet;
    }
}

