/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.evince.data;

import java.util.ArrayList;
import java.util.List;
import no.uib.cipr.matrix.Matrix;
import se.prediktera.breeze.common.frame.DoubleFrame;
import se.prediktera.breeze.common.frame.FloatFrame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.util.AverageFrame;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.raw.RtReferenceTarget;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.common.util.type.RtThreader;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.evince.matrix.FrameMatrix;
import se.prediktera.breeze.util.raw.HySpexHelper;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;

public class SpectralMatrixCache {
    private Measurement measurement;
    private FrameMatrix darkMatrixXray;
    private AbstractDataMatrix darkMatrixIntensity;
    private AverageFrame darkMatrixAvgFrame;
    private MVmatrix darkMatrixAvg;
    private AbstractDataMatrix whiteMatrixIntensity;
    private MVmatrix whiteMatrixAvg;
    private MVmatrix whiteMatrixRefAvg;
    private float[][] reMatrixInv;

    public AbstractDataMatrix getMatrix(Measurement measurement, String string) {
        if (measurement.hasReferences()) {
            String[] stringArray = string.split("_");
            int n = stringArray.length > 1 ? RtDataFormat.toNumberInt(stringArray[1]) : 0;
            String string2 = stringArray.length > 2 ? stringArray[2] : "";
            String string3 = stringArray.length > 3 ? stringArray[3] : "";
            return this.getMatrix(measurement, n, string2, string3);
        }
        return null;
    }

    public AbstractDataMatrix getMatrix(Measurement measurement, int n, String string, String string2) {
        Object object;
        if (!measurement.equals(this.measurement)) {
            this.clear();
            this.measurement = measurement;
        }
        if (!measurement.hasData()) {
            return null;
        }
        RawHeader rawHeader = measurement.rawFile().header();
        MaxSignal maxSignal = measurement.getMaxSignal();
        if (measurement.isXrayData()) {
            return this.getXrayReference(measurement, n, string, rawHeader);
        }
        SpectralReference.WhiteReference whiteReference = measurement.whiteReference();
        if (this.reMatrixInv == null) {
            this.reMatrixInv = SpectralMatrixCache.getReMatrixInv(measurement);
        }
        if (this.darkMatrixIntensity == null) {
            object = measurement.darkReference();
            if (object != null && object.exits()) {
                this.darkMatrixAvgFrame = new AverageFrame(((SpectralReference)object).readFrames());
                this.darkMatrixAvg = SpectralMatrixCache.getAverage((SpectralReference)object, List.of(this.darkMatrixAvgFrame));
            }
            this.darkMatrixIntensity = SpectralMatrixCache.createIntensityMatrix((SpectralReference)object, null, this.reMatrixInv, maxSignal);
        }
        if (this.whiteMatrixIntensity == null) {
            this.whiteMatrixAvg = SpectralMatrixCache.getAverage(whiteReference);
            this.whiteMatrixIntensity = SpectralMatrixCache.createIntensityMatrix(whiteReference, this.darkMatrixAvgFrame, this.reMatrixInv, maxSignal);
        }
        if (whiteReference != null) {
            object = whiteReference.getReferenceTarget();
            if (this.whiteMatrixRefAvg == null && object != null && string2.contains("reftarget")) {
                this.whiteMatrixRefAvg = SpectralMatrixCache.adjustReflectanceTarget(this.whiteMatrixAvg, this.darkMatrixAvg, (RtReferenceTarget)object, rawHeader.bandNames());
            }
        }
        return this.getMatrix(n, string2, string.equals("line"));
    }

    private static float[][] getReMatrixInv(Measurement measurement) {
        RawHeader rawHeader = measurement.rawFile().header();
        int n = rawHeader.pixelWidth().value;
        int n2 = rawHeader.bandCount().value;
        float[][] fArray = new float[n2][n];
        DoubleFrame doubleFrame = SpectralMatrixCache.getReFrame(measurement.whiteReference());
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (doubleFrame != null) {
                    float f = (float)doubleFrame.getFrameValueNative(j, i);
                    if (f != 0.0f) {
                        fArray[j][i] = 1.0f / f;
                        continue;
                    }
                    fArray[j][i] = 1.0f;
                    continue;
                }
                fArray[j][i] = 1.0f;
            }
        }
        return fArray;
    }

    private static DoubleFrame getReFrame(SpectralReference.WhiteReference whiteReference) {
        if (whiteReference.exits()) {
            return HySpexHelper.getReFrame(whiteReference.rawFile().file());
        }
        return null;
    }

    public static MVmatrix getAverage(SpectralReference spectralReference) {
        if (spectralReference == null || !spectralReference.exits()) {
            return null;
        }
        return SpectralMatrixCache.getAverage(spectralReference, spectralReference.readFrames());
    }

    private static MVmatrix getAverage(SpectralReference spectralReference, List<RawFrame> list) {
        RawHeader rawHeader = spectralReference.header();
        int n = rawHeader.bandCount().value;
        final float[] fArray = AverageFrame.computeAverageSpectrum(list);
        final MVmatrix mVmatrix = SpectralMatrixCache.createAvgMatrix(n, rawHeader.bandNames());
        new RtThreader(){

            @Override
            protected void doOp(boolean bl, int n, int n2) {
                for (int i = n; i < n2; ++i) {
                    mVmatrix.setValue(0, i, (double)fArray[i]);
                }
            }
        }.execute(n);
        return mVmatrix;
    }

    private static MVmatrix createAvgMatrix(int n, BandNames bandNames) {
        MVmatrix mVmatrix = new MVmatrix(1, n);
        Description description = new Description(n);
        description.addStringColumn("Wavelength");
        mVmatrix.setRowDescription(description);
        mVmatrix.setColumnDescription(description);
        for (int i = 0; i < n; ++i) {
            description.setValue(i, 0, bandNames.get(i));
        }
        return mVmatrix;
    }

    private AbstractDataMatrix getMatrix(int n, String string, boolean bl) {
        if (n == 0) {
            if (bl) {
                return this.darkMatrixAvg;
            }
            return this.darkMatrixIntensity;
        }
        if (bl) {
            if (string.contains("reftarget") && this.whiteMatrixRefAvg != null) {
                return this.whiteMatrixRefAvg;
            }
            return this.whiteMatrixAvg;
        }
        return this.whiteMatrixIntensity;
    }

    public void clear() {
        this.measurement = null;
        this.reMatrixInv = null;
        this.darkMatrixXray = null;
        this.darkMatrixIntensity = null;
        this.darkMatrixAvgFrame = null;
        this.darkMatrixAvg = null;
        this.whiteMatrixIntensity = null;
        this.whiteMatrixAvg = null;
        this.whiteMatrixRefAvg = null;
    }

    public static FrameMatrix createMatrix(RawFile rawFile) {
        return SpectralMatrixCache.createMatrix(rawFile, rawFile.header());
    }

    private static AbstractDataMatrix createIntensityMatrix(SpectralReference spectralReference, FloatFrame floatFrame, final float[][] fArray, MaxSignal maxSignal) {
        if (spectralReference == null || !spectralReference.exits()) {
            return null;
        }
        float f = maxSignal != null ? maxSignal.value : 65534.0f;
        final float f2 = f * 0.99f;
        final List<RawFrame> list = spectralReference.readFrames();
        RawHeader rawHeader = spectralReference.header();
        final int n = rawHeader.bandCount().value;
        final int n2 = rawHeader.pixelWidth().value;
        final float[][] fArray2 = SpectralMatrixCache.getOrCreate(floatFrame, n, n2);
        MVmatrix mVmatrix = new MVmatrix(list.size(), n2, "Max percent");
        final Matrix matrix = mVmatrix.getInternalMatrixPublic();
        new RtThreader(){

            @Override
            protected void doOp(boolean bl, int n3, int n22) {
                for (int i = n3; i < n22; ++i) {
                    RawFrame rawFrame = (RawFrame)list.get(i);
                    for (int j = 0; j < n2; ++j) {
                        float f = 0.0f;
                        for (int k = 0; k < n; ++k) {
                            float f22;
                            float f3 = fArray2[k][j];
                            float f4 = f2 - f3;
                            if (f4 <= 0.0f || (f22 = rawFrame.getFrameValue(k, j) - f3) <= 0.0f) continue;
                            if (f22 >= f4) {
                                f = 1.0f;
                                continue;
                            }
                            if (f22 < 0.0f || !(f < 1.0f)) continue;
                            float f5 = (f22 *= fArray[k][j]) / f4;
                            if (f5 > 0.99f) {
                                f5 = 0.99f;
                            }
                            if (!(f5 > f)) continue;
                            f = f5;
                        }
                        matrix.set(i, j, (double)(f * 100.0f));
                    }
                }
            }
        }.execute(list.size());
        return mVmatrix;
    }

    private static float[][] getOrCreate(FloatFrame floatFrame, int n, int n2) {
        if (floatFrame != null) {
            return floatFrame.origframe;
        }
        return new float[n][n2];
    }

    private static MVmatrix adjustReflectanceTarget(MVmatrix mVmatrix, MVmatrix mVmatrix2, RtReferenceTarget rtReferenceTarget, BandNames bandNames) {
        if (mVmatrix != null && mVmatrix2 != null) {
            MVmatrix mVmatrix3 = SpectralMatrixCache.createAvgMatrix(mVmatrix.getK(), bandNames);
            float[] fArray = rtReferenceTarget.getValuesInv();
            Matrix matrix = mVmatrix3.getInternalMatrixPublic();
            Matrix matrix2 = mVmatrix.getInternalMatrixPublic();
            Matrix matrix3 = mVmatrix2.getInternalMatrixPublic();
            for (int i = 0; i < mVmatrix.getK(); ++i) {
                float f = fArray[i];
                double d = matrix3.get(0, i);
                matrix.set(0, i, (matrix2.get(0, i) - d) * (double)f + d);
            }
            return mVmatrix3;
        }
        return mVmatrix;
    }

    private AbstractDataMatrix getXrayReference(Measurement measurement, int n, String string, RawHeader rawHeader) {
        if (n == 0) {
            if (this.darkMatrixXray == null) {
                this.darkMatrixXray = SpectralMatrixCache.createMatrix(measurement.darkReference(), rawHeader);
            }
            if (string.equals("line")) {
                return SpectralMatrixCache.getXrayAverageForAllPixels(this.darkMatrixXray);
            }
            return this.darkMatrixXray;
        }
        if (this.whiteMatrixIntensity == null) {
            this.whiteMatrixIntensity = SpectralMatrixCache.createMatrix(measurement.whiteReference(), rawHeader);
        }
        if (string.equals("line")) {
            // empty if block
        }
        return this.whiteMatrixIntensity;
    }

    private static FrameMatrix createMatrix(RawFile rawFile, RawHeader rawHeader) {
        List<RawFrame> list = SpectralMatrixCache.getFrames(rawFile, 1);
        if (list == null || list.isEmpty()) {
            return null;
        }
        FrameMatrix frameMatrix = new FrameMatrix(list);
        frameMatrix.setName(FileHelper.getFileName(rawFile.file()));
        Description description = new Description(rawHeader.bandCount().value);
        description.setID(Integer.valueOf(0));
        frameMatrix.setColumnDescription(description);
        InnerColumnString innerColumnString = description.addStringColumn("Wavelength");
        int n = 0;
        for (String string : rawHeader.bandNames()) {
            AbstractDataMatrix abstractDataMatrix = frameMatrix.getMatrixAt(n);
            if (abstractDataMatrix != null) {
                abstractDataMatrix.setName(string);
            }
            innerColumnString.setValue(n++, (Object)string);
        }
        return frameMatrix;
    }

    private static List<RawFrame> getFrames(RawFile rawFile, int n) {
        try {
            List<RawFrame> list = rawFile.readFrames();
            if (list.size() >= n) {
                return list;
            }
            ArrayList<RawFrame> arrayList = new ArrayList<RawFrame>();
            int n2 = (int)Math.ceil((float)n / (float)list.size());
            for (RawFrame rawFrame : list) {
                for (int i = 0; i < n2; ++i) {
                    arrayList.add(rawFrame);
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static AbstractDataMatrix getXrayAverageForAllPixels(FrameMatrix frameMatrix) {
        int n = frameMatrix.getFoldK();
        int n2 = frameMatrix.getK();
        MVmatrix mVmatrix = new MVmatrix(1, n * n2);
        Description description = new Description(mVmatrix.getK());
        description.addStringColumn("Wavelength");
        mVmatrix.setRowDescription(description);
        mVmatrix.setColumnDescription(description);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            AbstractDataMatrix abstractDataMatrix = frameMatrix.getMatrixAt(i);
            int n4 = 0;
            while (n4 < n) {
                description.setValue(n3, 0, abstractDataMatrix.getName() + ":" + abstractDataMatrix.getColumnDescription(n4, 0));
                int n5 = abstractDataMatrix.getN();
                if (n5 > 0) {
                    for (int j = 0; j < n5; ++j) {
                        double d = mVmatrix.getValue(0, n3);
                        mVmatrix.setValue(0, n3, d + abstractDataMatrix.getValue(j, n4));
                    }
                    double d = mVmatrix.getValue(0, n3);
                    mVmatrix.setValue(0, n3, d / (double)n5);
                }
                ++n4;
                ++n3;
            }
        }
        return mVmatrix;
    }
}

