/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.evince.data.queue;

import java.util.concurrent.LinkedBlockingQueue;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.BreezeThread;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.evince.data.queue.CreateVisualizationJob;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.evince.data.queue.VisualizationJob;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;

public class VisualizationJobQueue {
    protected static VisualizationJobQueue instance;
    private final LinkedBlockingQueue<CreateVisualizationJob> createVisualizationJobQueue = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<UpdateVisualizationJob> updateVisualizationJobQueue = new LinkedBlockingQueue();
    private Thread processQueuesThread;
    private BreezeProgressManager invisibleProgressManager;
    private boolean running = true;

    public static VisualizationJobQueue getInstance() {
        if (instance == null) {
            instance = new VisualizationJobQueue();
            instance.startProcessQueue();
        }
        return instance;
    }

    public static void clearInstance() {
        instance = null;
    }

    public static void stopAndWaitUntilQueueIsEmpty() {
        if (instance != null) {
            instance.stop();
            ThreadUtil.awaitAndReturn(() -> VisualizationJobQueue.instance.createVisualizationJobQueue.isEmpty() && VisualizationJobQueue.instance.updateVisualizationJobQueue.isEmpty(), new Time.Seconds(30.0));
        }
    }

    protected void startProcessQueue() {
        this.processQueuesThread = new BreezeThread("VisualizationJobQueue"){

            @Override
            public void run() {
                while (instance != null && VisualizationJobQueue.this.running) {
                    VisualizationJobQueue.this.processQueue(VisualizationJobQueue.this.createVisualizationJobQueue);
                    VisualizationJobQueue.this.processQueue(VisualizationJobQueue.this.updateVisualizationJobQueue);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        if (instance == null) continue;
                        throw new RuntimeException(interruptedException);
                    }
                }
                VisualizationJobQueue.this.createVisualizationJobQueue.clear();
                VisualizationJobQueue.this.updateVisualizationJobQueue.clear();
            }
        };
        this.processQueuesThread.start();
        this.invisibleProgressManager = BreezeProgressManager.createEmpty();
    }

    public void stop() {
        this.running = false;
    }

    public synchronized void addToQueue(CreateVisualizationJob createVisualizationJob) {
        this.createVisualizationJobQueue.add(createVisualizationJob);
    }

    public synchronized void addToQueue(UpdateVisualizationJob updateVisualizationJob) {
        this.clearAllJobsWithOtherEntryDataThenThisJob(this.updateVisualizationJobQueue, updateVisualizationJob);
        this.updateVisualizationJobQueue.add(updateVisualizationJob);
    }

    public boolean isWorking() {
        return !this.createVisualizationJobQueue.isEmpty() || !this.updateVisualizationJobQueue.isEmpty();
    }

    private void clearAllJobsWithOtherEntryDataThenThisJob(LinkedBlockingQueue<UpdateVisualizationJob> linkedBlockingQueue, UpdateVisualizationJob updateVisualizationJob) {
        linkedBlockingQueue.removeIf(updateVisualizationJob2 -> updateVisualizationJob2.getEntryData() != updateVisualizationJob.getEntryData());
    }

    private void processQueue(LinkedBlockingQueue<? extends VisualizationJob> linkedBlockingQueue) {
        while (!linkedBlockingQueue.isEmpty() && this.running) {
            VisualizationJob visualizationJob = linkedBlockingQueue.peek();
            visualizationJob.doJob(this.invisibleProgressManager);
            linkedBlockingQueue.remove(visualizationJob);
        }
    }
}

