/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.evince.datasource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.category.CategoryList;
import se.prediktera.breeze.common.entry.factor.property.PropertyList;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.RtModule;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TransformationParameter;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.AnalyseSpectralGroup;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.analyse.model.QuantificationModel;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.identifier.IdentifierList;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.datasource.AbstractBreezeDataSource;
import se.prediktera.breeze.evince.datasource.SampleDataRow;
import se.prediktera.breeze.frontend.common.util.ListHelper;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.datasetcontainer.classes.ClassTypes;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.transform.category.Category;
import se.prediktera.map.main.extclass.ExtClassLoader;

public class MeasurementDataSource
extends AbstractBreezeDataSource {
    private Group referenceGroup;
    private CategoryFactor classificationFactor;
    private final List<CategoryFactor> referenceCategories = new ArrayList<CategoryFactor>();
    private PropertyList propertyList;
    private IdentifierList sampleIdentifiers;
    private CategoryList categoryList;
    private List<DescriptorTreeNode> descriptorList;
    private BandNames bandNames = null;
    private final int numberOfRepresenative = 1;
    private int maxDataSize = 0;
    private SegmentationIdentifier segmentationIdentifier;
    private int workflowChangeIndex;
    private List<RtModule> filterModules;
    private Model model;

    public MeasurementDataSource(Analyse analyse, Model model, SegmentationIdentifier segmentationIdentifier) {
        this(analyse.getGroups(), segmentationIdentifier, null, false, null);
        this.model = model;
        if (model instanceof Model.IClassificationModel) {
            this.classificationFactor = ((Model.IClassificationModel)((Object)model)).getFactor();
            if (this.classificationFactor != null) {
                this.referenceCategories.add(0, this.classificationFactor);
            }
        }
    }

    public MeasurementDataSource(List<AnalyseSpectralGroup> list, SegmentationIdentifier segmentationIdentifier, BandNames bandNames, boolean bl, String string) {
        this.segmentationIdentifier = segmentationIdentifier;
        this.dataSetName = list.toString();
        if (list.isEmpty()) {
            if (bl) {
                throw new RuntimeException("At least one external record test group is required");
            }
            throw new RuntimeException("At least one record group is required");
        }
        this.referenceGroup = AnalyseSpectralGroup.getFirstGroup(list);
        if (this.referenceGroup == null) {
            throw new RuntimeException("Cannot find any groups, please re-train model");
        }
        this.init(this.referenceGroup.getParent(), segmentationIdentifier);
        this.referenceCategories.addAll(this.categoryList.getList());
        this.filterModules = TransformationParameter.getTransformationModules(string, 1);
        int n = 0;
        for (AnalyseSpectralGroup analyseSpectralGroup : MeasurementDataSource.getSortedGroups(list)) {
            for (Measurement measurement : MeasurementDataSource.getSortedMeasurements(analyseSpectralGroup)) {
                if (bandNames == null) {
                    bandNames = measurement.getBandNames();
                }
                n = this.addSamples(measurement.getSamples(segmentationIdentifier), n);
            }
        }
        this.bandNames = bandNames;
    }

    public MeasurementDataSource(List<BasicSample> list) {
        Measurement measurement = null;
        if (list.size() > 0) {
            Sample sample = (Sample)list.get(0);
            measurement = sample.measurement();
        }
        if (measurement != null) {
            this.init(measurement.getWorkflow(), new SegmentationIdentifier(0, null));
            if (this.bandNames == null) {
                this.bandNames = measurement.getBandNames();
            }
        } else {
            this.sampleIdentifiers = new IdentifierList();
            this.propertyList = new PropertyList(null);
            this.categoryList = new CategoryList(null);
            this.descriptorList = new ArrayList<DescriptorTreeNode>();
        }
        this.addSamples(list, 0);
    }

    private int addSamples(List list, int n) {
        for (Object e : list) {
            Sample sample = (Sample)e;
            sample.setCachedInteractionTableIndex(n++);
            SampleDataRow sampleDataRow = new SampleDataRow(sample, TransformationParameter.getData(this.filterModules, sample.getPath().getAverageProfile()));
            this.maxDataSize = Math.max(this.maxDataSize, sampleDataRow.getDataSize());
            this.includedDataList.add(sampleDataRow);
        }
        return n;
    }

    private void init(Workflow workflow, SegmentationIdentifier segmentationIdentifier) {
        this.maxDataSize = 0;
        this.sampleIdentifiers = workflow.getIdentifiers();
        this.propertyList = workflow.getPropertyFactors();
        this.categoryList = workflow.getCategoryFactors();
        this.descriptorList = workflow.getSegmentationLevelDescriptorNodes(segmentationIdentifier, true);
        this.workflowChangeIndex = workflow.getChangeIndex();
        this.setDataSourceMatrix(false);
    }

    public MeasurementDataSource(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
    }

    public int getSegmentationLevel() {
        return this.segmentationIdentifier.Level;
    }

    public String getSegmentationHashId() {
        return this.segmentationIdentifier.HashId;
    }

    public void autoIdentifyData(ProgressManager progressManager, int n) {
        int n2;
        this.addInterval(0, 0, (byte)0);
        int n3 = 0;
        for (n2 = 0; n2 < SampleDataRow.headerDesc.length; ++n2) {
            this.addInterval(1, n3++, (byte)1);
        }
        for (n2 = 0; n2 < this.sampleIdentifiers.size(); ++n2) {
            this.addInterval(1, n3++, (byte)1);
        }
        if (this.classificationFactor != null) {
            this.addInterval(1, n3++, (byte)3);
        }
        for (n2 = 0; n2 < this.categoryList.size(); ++n2) {
            this.addInterval(1, n3++, (byte)3);
        }
        for (n2 = 0; n2 < this.propertyList.size(); ++n2) {
            this.addInterval(1, n3++, (byte)10);
        }
        for (n2 = 0; n2 < this.descriptorList.size(); ++n2) {
            if (this.model instanceof QuantificationModel && !this.propertyList.hasName(this.descriptorList.get(n2).getAliasOrNodeString())) {
                this.addInterval(1, n3++, (byte)10);
                continue;
            }
            this.addInterval(1, n3++, (byte)16);
        }
    }

    public int getColumnCount() {
        if (!this.includedDataList.isEmpty()) {
            int n = SampleDataRow.headerDesc.length + this.sampleIdentifiers.size() + this.categoryList.size() + this.propertyList.size() + this.descriptorList.size() + this.maxDataSize;
            if (this.classificationFactor != null) {
                ++n;
            }
            return n;
        }
        return 0;
    }

    public FastDecimal getDoubleAt(int n, int n2, FastDecimal fastDecimal) {
        if (n < 1) {
            return fastDecimal.error();
        }
        --n;
        if (n2 < SampleDataRow.headerDesc.length) {
            return fastDecimal.error();
        }
        n2 -= SampleDataRow.headerDesc.length + this.sampleIdentifiers.size();
        if (this.classificationFactor != null) {
            if (n2 < 1) {
                return fastDecimal.error();
            }
            --n2;
        }
        if (n2 < this.categoryList.size()) {
            return fastDecimal.error();
        }
        if ((n2 -= this.categoryList.size()) < this.propertyList.size()) {
            return fastDecimal.setValueOrError(((SampleDataRow)this.includedDataList.get(n)).getFactorValue(this.propertyList.get(n2)));
        }
        if ((n2 -= this.propertyList.size()) < this.descriptorList.size()) {
            return ((SampleDataRow)this.includedDataList.get(n)).getDescriptorValue(this.descriptorList.get(n2), fastDecimal);
        }
        return fastDecimal.setValue(((SampleDataRow)this.includedDataList.get(n)).getValue(n2 -= this.descriptorList.size()));
    }

    public String getInformation() {
        return "group Data Source";
    }

    public String getLayerName(int n) {
        return String.valueOf(n + 1);
    }

    public String getName() {
        return "MeasurementDataSource";
    }

    public String getReferenceCategory(int n) {
        CategoryFactor categoryFactor = this.referenceCategories.get(n);
        return categoryFactor.getName();
    }

    public String[] getReferenceCategoryClasses(int n) {
        List<CatClass> list = this.referenceCategories.get(n).getIncludedRoot();
        String[] stringArray = new String[list.size()];
        int n2 = 0;
        for (CatClass catClass : list) {
            stringArray[n2++] = catClass.getName();
        }
        return stringArray;
    }

    public String[] getReferenceCategoryColor(int n) {
        List<CatClass> list = this.referenceCategories.get(n).getIncludedRoot();
        String[] stringArray = new String[list.size()];
        int n2 = 0;
        for (CatClass catClass : list) {
            stringArray[n2++] = catClass.getColorString();
        }
        return stringArray;
    }

    public int getReferenceCategorys() {
        return this.referenceCategories.size();
    }

    public int getReferenceValues() {
        return this.propertyList.size();
    }

    @Override
    public Workflow getRoot() {
        return this.referenceGroup.getParent();
    }

    public int getRowCount() {
        if (this.includedDataList != null) {
            return 1 + this.includedDataList.size();
        }
        return 0;
    }

    public SampleDataRow getRowAt(int n) {
        if (n < this.includedDataList.size()) {
            return (SampleDataRow)this.includedDataList.get(n);
        }
        return null;
    }

    public Sample getSampleAt(int n) {
        SampleDataRow sampleDataRow = this.getRowAt(n);
        if (sampleDataRow != null) {
            return sampleDataRow.getSample();
        }
        return null;
    }

    public List<Measurement> getMeasurements() {
        ArrayList<Measurement> arrayList = new ArrayList<Measurement>();
        HashSet<Measurement> hashSet = new HashSet<Measurement>();
        for (SampleDataRow sampleDataRow : this.includedDataList) {
            Measurement measurement = sampleDataRow.getMeasurement();
            if (hashSet.contains(measurement)) continue;
            hashSet.add(measurement);
            arrayList.add(measurement);
        }
        return arrayList;
    }

    public byte getNodeType() {
        return 5;
    }

    public byte getTreeType() {
        return 1;
    }

    public ExtClassLoader.LicenseLibrary getLibrary() {
        return ExtClassLoader.LicenseLibrary.BREEZE;
    }

    public Object getValueAt_Transpose(int n, int n2) {
        if (n2 < SampleDataRow.headerDesc.length) {
            if (n < 1) {
                return SampleDataRow.headerDesc[n2];
            }
            return ((SampleDataRow)this.includedDataList.get(n - 1)).getHeaderValue(n2);
        }
        if ((n2 -= SampleDataRow.headerDesc.length) < this.sampleIdentifiers.size()) {
            if (n < 1) {
                return this.sampleIdentifiers.get(n2).getName();
            }
            return ((SampleDataRow)this.includedDataList.get(n - 1)).getSample().getIdentifierValue(this.sampleIdentifiers.get(n2));
        }
        n2 -= this.sampleIdentifiers.size();
        if (this.classificationFactor != null) {
            if (n2 < 1) {
                if (n < 1) {
                    return this.classificationFactor.getName();
                }
                Float f = ((SampleDataRow)this.includedDataList.get(n - 1)).getFactorValue(this.classificationFactor);
                if (f != null) {
                    return this.classificationFactor.getClassificationString(f.intValue());
                }
                return "-";
            }
            --n2;
        }
        if (n2 < this.categoryList.size()) {
            if (n < 1) {
                return this.categoryList.get(n2).getName();
            }
            return ((SampleDataRow)this.includedDataList.get(n - 1)).getStringValue(this.categoryList.get(n2));
        }
        if ((n2 -= this.categoryList.size()) < this.propertyList.size()) {
            if (n < 1) {
                return this.propertyList.get(n2).getName();
            }
            return ((SampleDataRow)this.includedDataList.get(n - 1)).getStringValue(this.propertyList.get(n2));
        }
        if ((n2 -= this.propertyList.size()) < this.descriptorList.size()) {
            if (n < 1) {
                return this.descriptorList.get(n2).getAliasOrNodeString(FunctionTreeNode.TextType.Table);
            }
            return ((SampleDataRow)this.includedDataList.get(n - 1)).getDescriptorValue(this.descriptorList.get(n2));
        }
        n2 -= this.descriptorList.size();
        if (n < 1) {
            if (this.bandNames != null && n2 < this.bandNames.count().value) {
                return this.bandNames.get(n2);
            }
            return String.valueOf(n2 + 1);
        }
        return ((SampleDataRow)this.includedDataList.get(n - 1)).getValue(n2);
    }

    public void importComplete(ProgressManager progressManager, DataSet dataSet) {
        super.importComplete(progressManager, dataSet);
        try {
            Category category = (Category)dataSet.createModification(progressManager, "var", "category");
            InnerColumnClass innerColumnClass = category.getInnerColumn();
            ClassTypes classTypes = innerColumnClass.getHoldObject();
            int n = this.getColumnCount();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (!this.isColumnTypeData(i)) continue;
                int n3 = this.getColumnType(i);
                String string = switch (n3) {
                    case 4 -> "NIR";
                    case 10 -> "Property";
                    case 16 -> "Descriptor";
                    default -> "N/A";
                };
                short s = classTypes.addString(string, true);
                innerColumnClass.setValueShort(n2++, s);
            }
            category.setLayerName("Datatype");
            category.updateClasses();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException((Throwable)exception);
        }
    }

    public void printForDebug() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                System.out.print(String.valueOf(this.getValueAt_Transpose(i, j)) + "\t");
            }
            System.out.println("");
        }
    }

    public void refreshDataSourceLocal(ProgressManager progressManager) throws IOException {
    }

    public int getNumberOfRepresenative() {
        return 1;
    }

    public List<Sample> getSamplesIncludedInDataSetColumn(DataSet dataSet, int n) {
        ArrayList<Sample> arrayList = new ArrayList<Sample>();
        ObservationInfo observationInfo = dataSet.getObsDataInfo();
        InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)observationInfo.getPrimaryColumnByType(n);
        for (int i = 0; i < innerColumnBoolean.getSize(); ++i) {
            if (!innerColumnBoolean.getValueBool(i) || i >= this.includedDataList.size()) continue;
            arrayList.add(((SampleDataRow)this.includedDataList.get(i)).getSample());
        }
        return arrayList;
    }

    public List<BasicSample> getAllSamples() {
        return this.includedDataList.stream().map(SampleDataRow::getSample).collect(Collectors.toList());
    }

    public int getSampleIndex(Sample sample) {
        for (int i = 0; i < this.includedDataList.size(); ++i) {
            if (((SampleDataRow)this.includedDataList.get(i)).getSample() != sample) continue;
            return i;
        }
        return -1;
    }

    public boolean workflowChanged(Workflow workflow) {
        return workflow.getChangeIndex() != this.workflowChangeIndex;
    }

    public static List<AnalyseSpectralGroup> getSortedGroups(List<AnalyseSpectralGroup> list) {
        list.sort((analyseSpectralGroup, analyseSpectralGroup2) -> {
            if (analyseSpectralGroup.getGroup() == null || analyseSpectralGroup2.getGroup() == null) {
                return 0;
            }
            return analyseSpectralGroup2.getGroup().getEntryData().compareTo(ListHelper.SortType.Created, analyseSpectralGroup.getGroup().getEntryData());
        });
        return list;
    }

    public static List<Measurement> getSortedMeasurements(AnalyseSpectralGroup analyseSpectralGroup) {
        return MeasurementDataSource.getSortedMeasurements(analyseSpectralGroup.getGroup());
    }

    public static List<Measurement> getSortedMeasurements(Group group) {
        if (group == null) {
            return new ArrayList<Measurement>();
        }
        ArrayList<Measurement> arrayList = new ArrayList<Measurement>(group.getChildList());
        arrayList.sort((measurement, measurement2) -> measurement.getEntryData().compareTo(ListHelper.SortType.Created, measurement2.getEntryData()));
        return arrayList;
    }
}

