/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.evince.datasource;

import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.map.dataimport.FastDecimal;

public class SampleDataRow {
    public static String[] headerDesc = new String[]{"Sample", "Measurement", "Group"};
    private final Sample sample;
    private final Measurement measurement;
    private final Workflow workflow;
    private String name;
    private final float[] data;
    private final String[] headerValues = new String[3];

    public SampleDataRow(Sample sample, float[] fArray) {
        this.sample = sample;
        this.data = fArray;
        this.name = sample.toString();
        this.measurement = sample.measurement();
        this.workflow = this.measurement.getWorkflow();
        this.headerValues[0] = sample.getRecursiveName(Sample.DefaultSampleLabel.IDX_SAMPLE);
        if (this.measurement != null) {
            this.headerValues[1] = this.measurement.getName();
            Group group = this.measurement.getParent();
            this.headerValues[2] = group.getName();
        }
    }

    public int getDataSize() {
        if (this.data != null) {
            return this.data.length;
        }
        return 0;
    }

    public Object getDescriptorValue(DescriptorTreeNode descriptorTreeNode) {
        return Float.valueOf(this.sample.getDescriptorValue(descriptorTreeNode));
    }

    public Sample getEntry() {
        return this.sample;
    }

    public String getHeaderValue(int n) {
        return this.headerValues[n];
    }

    public Sample getSample() {
        return this.sample;
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    public double getValue(int n) {
        if (this.data != null && n < this.data.length) {
            return this.data[n];
        }
        return 0.0;
    }

    public Float getFactorValue(Factor factor) {
        if (factor.isMissing(this.sample)) {
            Factor factor2 = this.workflow.getFactorHolder().getFactorByName(factor.getName());
            if (factor2 != null) {
                return this.sample.getSampleValues().getValue(factor2);
            }
            return null;
        }
        return this.sample.getSampleValues().getValue(factor);
    }

    public String getStringValue(Factor factor) {
        if (factor.isMissing(this.sample)) {
            Factor factor2 = this.workflow.getFactorHolder().getFactorByName(factor.getName());
            if (factor2 != null) {
                return factor2.getStringValue(this.sample);
            }
            return "-";
        }
        return factor.getStringValue(this.sample);
    }

    public FastDecimal getDescriptorValue(DescriptorTreeNode descriptorTreeNode, FastDecimal fastDecimal) {
        if (this.sample.getDescriptorHolder().hasDescriptorValue(descriptorTreeNode)) {
            return fastDecimal.setValue((double)this.sample.getDescriptorValue(descriptorTreeNode));
        }
        return fastDecimal.error();
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }
}

