/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.evince.datasource.image;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.dataimport.image.hdr.HdrDataSource;

public class BreezeDataSource
extends HdrDataSource {
    private Measurement measurement;
    private final Sample sample;
    private List<PropertyFactor> propertyList = new ArrayList<PropertyFactor>();
    private List<CategoryFactor> categoryList = new ArrayList<CategoryFactor>();
    private int maskLayer = -1;

    public BreezeDataSource(File[] fileArray, byte by, Measurement measurement) throws IOException {
        super(fileArray, by);
        this.measurement = measurement;
        this.sample = measurement.getRootSample();
        Group group = measurement.getParent();
        this.propertyList = group.getPropertyFactors().getList();
        this.categoryList = group.getCategoryFactors().getList();
    }

    public Properties getEnvProperties() {
        return null;
    }

    public int getMaskLayer() {
        return this.maskLayer;
    }

    public Properties getMetaProperties() {
        return this.measurement.getMetaProperties().convertMeta2Properies();
    }

    public String getReferenceFileName() {
        if (this.measurement != null) {
            return this.measurement.getName();
        }
        return null;
    }

    public String getReferenceCategory(int n) {
        if (n < this.categoryList.size()) {
            return this.categoryList.get(n).getName();
        }
        return null;
    }

    public int getReferenceCategorys() {
        return this.categoryList.size();
    }

    public String getReferenceCategoryValue(int n) {
        if (n < this.categoryList.size()) {
            return this.categoryList.get(n).getStringValue(this.sample);
        }
        return null;
    }

    public String getReferenceName(int n) {
        if (n < this.propertyList.size()) {
            return this.propertyList.get(n).getName();
        }
        return "NA";
    }

    public FastDecimal getReferenceValue(int n, int n2, int n3, FastDecimal fastDecimal) {
        PropertyFactor propertyFactor;
        if (n < this.propertyList.size() && !(propertyFactor = this.propertyList.get(n)).isMissing(this.sample)) {
            return fastDecimal.setValue((double)this.sample.getSampleValues().getValue(propertyFactor).floatValue());
        }
        return fastDecimal.error();
    }

    public int getReferenceValues() {
        return this.propertyList.size();
    }

    public Properties getRefProperties() {
        return null;
    }

    public void setMaskLayer(int n) {
        this.maskLayer = n;
    }

    protected void cleanUpChild() {
        super.cleanUpChild();
        this.measurement = null;
    }

    public void crop(ProgressManager progressManager, File file, int n, int n2, int n3, int n4) throws Exception {
        String string;
        File file2;
        File file3;
        super.crop(progressManager, file, n, n2, n3, n4);
        Measurement measurement = null;
        String string2 = FileHelper.getFileName(this.file);
        File file4 = new File(this.file.getParentFile(), string2 + ".xml");
        if (!(string2.startsWith("white") || string2.startsWith("dark") || (file3 = new File(file2 = file.getParentFile(), (string = FileHelper.getFileName(file)) + ".xml")).exists())) {
            measurement = Measurement.createStandaloneMeasurement(file4);
            measurement.save();
        }
    }
}

