/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.evince.datasource.image;

import java.awt.geom.RectangularShape;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.category.CategoryList;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.measurement.metadata.MetaDataProperties;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.evince.datasource.image.BreezeImportPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.importdata.PPImportDataHelper;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.ImportInterface;
import se.prediktera.map.dataimport.image.sac.SacXMLImageImportInfo;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.classes.InnerColumnClass;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.datasetcontainer.transform.category.Category;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.model.AbstractModel;

public class BreezeImportInfo
extends AbstractImportInfo {
    private Measurement measurement;
    private boolean supportcalibration = true;
    private final boolean ismultilayer = true;

    public boolean accepts(File file) {
        if (file.isDirectory()) {
            if (SacXMLImageImportInfo.isSpecimFolder((File)file)) {
                return false;
            }
            return PPImportDataHelper.isBreezeOrLegacyFolder(file);
        }
        if (file.getName().equalsIgnoreCase("manifest.xml")) {
            return false;
        }
        return super.accepts(file);
    }

    public String finishImport(ProgressManager progressManager, Project_GUI project_GUI, Case case_, AbstractModel abstractModel) {
        Object[] objectArray = case_.listDataSet();
        if (objectArray.length > 0) {
            DataSet dataSet = (DataSet)objectArray[0];
            AbstractDataMatrix abstractDataMatrix = dataSet.getMatrix(0);
            FoldMatrix foldMatrix = new FoldMatrix(abstractDataMatrix);
            HashMap<String, Category> hashMap = new HashMap<String, Category>();
            try {
                for (CategoryFactor object : this.measurement.getParent().getCategoryFactors()) {
                    Category category = (Category)dataSet.createModification(progressManager, "obs", "Category");
                    String string = object.getName();
                    category.setName(string);
                    hashMap.put(string, category);
                    for (CatClass catClass : object) {
                        if (catClass.getName().equals("-")) continue;
                        category.updateClasses();
                    }
                }
                for (BasicSample basicSample : this.measurement.getChildList()) {
                    this.setClasses(basicSample, foldMatrix, this.measurement.getParent().getCategoryFactors(), hashMap);
                }
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException((Throwable)exception);
            }
        }
        return super.finishImport(progressManager, project_GUI, case_, abstractModel);
    }

    public String getDescription() {
        return "Breeze xml file (*.xml)";
    }

    public String[] getExt() {
        return new String[]{"xml"};
    }

    public void setCalibrationProperties(Properties properties, boolean bl) {
        List<File> list = this.getWhiteAndDarkReferenceFiles(this.measurement);
        if (this.supportCalibration() && list.size() == 2 && list.get(0).exists() && list.get(1).exists()) {
            this.addPropertiesForReference(properties, bl, list.get(0), 100, 1);
            this.addPropertiesForReference(properties, bl, list.get(1), 0, 2);
            ScriptHelper.addIfNotExist((Properties)properties, (String)"apply", (String)"unitconversion");
            ScriptHelper.addIfNotExist((Properties)properties, (String)"nrimages", (String)"2");
            ScriptHelper.addIfNotExist((Properties)properties, (String)"convertto", (String)"absorbance");
            ScriptHelper.addIfNotExist((Properties)properties, (String)"type", (String)"line");
        }
    }

    private List<File> getWhiteAndDarkReferenceFiles(Measurement measurement) {
        File file = measurement.getFolder();
        try {
            return Arrays.asList(Measurement.getNewOrLegacyFile(file, "whiteref_", ".raw"), Measurement.getNewOrLegacyFile(file, "darkref_", ".raw"));
        }
        catch (Exception exception) {
            return new ArrayList<File>();
        }
    }

    private void addPropertiesForReference(Properties properties, boolean bl, File file, int n, int n2) {
        if (bl || !ScriptHelper.hasKey((Properties)properties, (String)("file" + n2))) {
            properties.put("file" + n2, file.getAbsolutePath());
        }
        if (bl || !ScriptHelper.hasKey((Properties)properties, (String)("percentage" + n2))) {
            properties.put("percentage" + n2, String.valueOf(n));
        }
    }

    public boolean supportCalibration() {
        return this.supportcalibration;
    }

    public boolean supportDataSource() {
        return true;
    }

    public String toString() {
        return "Breeze";
    }

    protected void cleanUpChild() {
        super.cleanUpChild();
        this.measurement = null;
    }

    protected AbstractImportPanel createImportPanel(ImportInterface importInterface) throws Exception {
        return this.createImportPanel(importInterface, null);
    }

    protected AbstractImportPanel createImportPanel(ImportInterface importInterface, Properties properties) {
        try {
            File file = importInterface.getFiles()[0];
            this.measurement = this.getMeasurement(file);
            importInterface.getFiles()[0] = this.getMeasurementRawFile(file);
            this.supportcalibration = true;
            return new BreezeImportPanel(importInterface, this.measurement);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private File getMeasurementRawFile(File file) {
        File file2 = file.isDirectory() ? file : file.getParentFile();
        return Measurement.getNewOrLegacyFile(file2, "", ".raw");
    }

    private Measurement getMeasurement(File file) {
        if (file.isDirectory()) {
            return Measurement.createStandaloneMeasurement(file);
        }
        return Measurement.createStandaloneMeasurement(file.getParentFile());
    }

    public boolean isMultiLayer() {
        return true;
    }

    private void findAndSet(BasicSample basicSample, FoldMatrix foldMatrix, CategoryList categoryList, HashMap<String, Category> hashMap) {
        Object object;
        Sample sample = (Sample)basicSample;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (sample != null && sample.getPath().getOrCreateGeneralPath() != null) {
            object = sample.getPath().getOrCreateGeneralPath().getBounds2D();
            for (double d = ((RectangularShape)object).getMinX(); d < ((RectangularShape)object).getMaxX(); d += 1.0) {
                for (double d2 = ((RectangularShape)object).getMinY(); d2 < ((RectangularShape)object).getMaxY(); d2 += 1.0) {
                    if (!sample.getPath().getOrCreateGeneralPath().contains(d, d2)) continue;
                    arrayList.add(foldMatrix.getIndex((int)d2, (int)d) + 1);
                }
            }
        }
        object = new Double[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object[i] = (double)((Integer)arrayList.get(i)).intValue();
        }
        if (((Object)object).length > 0) {
            for (CategoryFactor categoryFactor : categoryList) {
                InnerColumnClass innerColumnClass = hashMap.get(categoryFactor.getName()).getInnerColumn();
                String string = categoryFactor.getClass(sample).getName();
                innerColumnClass.setClass((Double[])object, string, false);
            }
        }
    }

    private void setClasses(BasicSample basicSample, FoldMatrix foldMatrix, CategoryList categoryList, HashMap<String, Category> hashMap) {
        this.findAndSet(basicSample, foldMatrix, categoryList, hashMap);
        for (BasicSample basicSample2 : basicSample.getChildList()) {
            this.setClasses(basicSample2, foldMatrix, categoryList, hashMap);
        }
    }

    public boolean isBreezeImport() {
        return true;
    }

    public String getPreviewDescription(File file) {
        try {
            Measurement measurement = this.getMeasurement(file);
            Object object = "";
            if (measurement != null) {
                object = "<html><body><b>" + FileHelper.getFileName(file);
                String string = measurement.getPrimarySampleIdentifier();
                if (string != null) {
                    object = (String)object + " (" + string + ")";
                }
                object = (String)object + "</b><br>";
                object = (String)object + "<table cellpadding=\"0\">";
                object = (String)object + this.printSampleList(measurement);
                object = (String)object + this.printMetadataList(measurement);
                object = (String)object + "</table>";
            }
            return object;
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    public File getPreviewFile(File file) {
        return BreezeImportInfo.getImageFile(file);
    }

    public static File getImageFile(File file) {
        String string;
        File file2;
        if (file.isDirectory() && (file2 = Group.getThumbnailInFolder(file)) != null) {
            return file2;
        }
        file2 = file.getParentFile();
        File file3 = new File(file2, (string = FileHelper.getFileName(file)) + "_raw.png");
        if (file3.exists()) {
            return file3;
        }
        File file4 = new File(file2, string + ".png");
        if (file4.exists()) {
            return file4;
        }
        return new File(file2, string + ".jpg");
    }

    public File getPreviewDataFile(File file) {
        try {
            return this.getMeasurementRawFile(file);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            return null;
        }
    }

    private String printMetadataList(Measurement measurement) {
        StringBuilder stringBuilder = new StringBuilder();
        MetaDataProperties metaDataProperties = measurement.getMetaProperties();
        List<String> list = metaDataProperties.getSortedKeys();
        if (list.size() > 0) {
            stringBuilder.append("<tr><td colspan=\"3\"><font size=\"3\"><b>");
            stringBuilder.append("Metadata:");
            stringBuilder.append("</b></font></td></tr>");
            for (String string : list) {
                String string2 = metaDataProperties.getMetaValue(string);
                stringBuilder.append("<tr><td width=\"10px\"></td>");
                stringBuilder.append("<td><font size=\"3\">");
                stringBuilder.append(string);
                stringBuilder.append(" </font></td><td><font size=\"3\">");
                if (string != null && string.equalsIgnoreCase("time")) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMhhHHmmss");
                    try {
                        Date date = simpleDateFormat.parse(string2);
                        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-hh HH:mm:ss");
                        stringBuilder.append(simpleDateFormat2.format(date));
                    }
                    catch (ParseException parseException) {
                        stringBuilder.append(string2);
                    }
                } else {
                    stringBuilder.append(string2);
                }
                stringBuilder.append("</font></td></tr>");
            }
        }
        return stringBuilder.toString();
    }

    private String printSampleList(Measurement measurement) {
        StringBuffer stringBuffer = new StringBuffer();
        for (BasicSample basicSample : measurement.getChildList()) {
            this.printSample(basicSample, stringBuffer);
        }
        return stringBuffer.toString();
    }

    private void printSample(BasicSample basicSample, StringBuffer stringBuffer) {
        stringBuffer.append("<tr><td colspan=\"3\"><font size=\"3\"><b>");
        stringBuffer.append("Sample: " + basicSample.toString());
        stringBuffer.append("</b></font></td></tr>");
        Group group = ((Sample)basicSample).measurement().getParent();
        if (group != null) {
            stringBuffer.append(this.printVariableList(basicSample, "Variables", group.getPropertyFactors().getList()));
            stringBuffer.append(this.printVariableList(basicSample, "Categories", group.getCategoryFactors().getList()));
        }
        for (BasicSample basicSample2 : basicSample.getChildList()) {
            this.printSample(basicSample2, stringBuffer);
        }
    }

    private String printVariableList(BasicSample basicSample, String string, List list) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list.size() > 0) {
            stringBuilder.append("<tr><td colspan=\"3\"><font size=\"3\"><b>");
            stringBuilder.append(string + ":");
            stringBuilder.append("</b></font></td></tr>");
            for (Object e : list) {
                Factor factor = (Factor)e;
                stringBuilder.append("<tr><td width=\"10px\"></td>");
                stringBuilder.append("<td><font size=\"3\">");
                stringBuilder.append(factor.getName());
                stringBuilder.append(" </font></td><td><font size=\"3\">");
                stringBuilder.append(factor.getStringValue(basicSample));
                stringBuilder.append("</font></td></tr>");
            }
        }
        return stringBuilder.toString();
    }
}

