/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.evince.datasource.reference;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.dataexport.AbstractExportInfo;

public class EndMemberExportInfo
extends AbstractExportInfo {
    public String getDescription() {
        return "Spectral library - ENVI ASCII Plot File (*.txt)";
    }

    public String getExt() {
        return "txt";
    }

    protected void SaveNow(ProgressManager progressManager) {
        try {
            int n = this.model.getRowCount();
            int n2 = this.model.getColumnCount();
            progressManager.setMaximumAndReset(n);
            try (PrintWriter printWriter = new PrintWriter(this.file, StandardCharsets.ISO_8859_1);){
                int n3;
                printWriter.println("ENVI ASCII Plot File [" + String.valueOf(new Date()) + "]");
                printWriter.println("Column 1: Wavelength");
                int n4 = 2;
                for (n3 = 0; n3 < n; ++n3) {
                    printWriter.println("Column " + n4++ + ": " + this.model.getColumnDescriptionSorted(n3, 0));
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    printWriter.print("   ");
                    printWriter.print(this.model.getRowDescription(0, n3));
                    for (int i = 0; i < n; ++i) {
                        printWriter.print("   ");
                        Object object = this.model.getValueAt(i, n3);
                        Double d = SimpleTableModel.parseObject((Object)object);
                        if (d != null) {
                            printWriter.print(RtDataFormat.toString(d));
                            continue;
                        }
                        printWriter.print(0);
                    }
                    printWriter.println();
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

