/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.evince.datasource.reference;

import java.util.List;
import se.prediktera.breeze.common.realtime.unmixing.Reference;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.FastDecimal;
import se.prediktera.map.dataimport.ImportInterface;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class ReferenceDataSource
extends CellIdentifierModel {
    private final List<Reference> references;
    private String[] names = null;
    private final List<String> informations;

    public ReferenceDataSource(List<Reference> list, List<String> list2, ImportInterface importInterface) {
        super(list.size() + 1, list.get(0).getWavelength().length + (importInterface.includeFileNames() ? 1 : 0) + list2.size());
        this.references = list;
        this.informations = list2;
        if (importInterface.includeFileNames()) {
            this.names = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.names[i] = list.get(i).getName();
                if (this.names[i] != null) continue;
                this.names[i] = "Obs: " + i;
            }
        }
    }

    public void autoIdentifyData(ProgressManager progressManager, int n) {
        this.addInterval(0, 0, (byte)0);
        this.setPrimaryRow(0);
        int n2 = 0;
        if (this.names != null) {
            this.addInterval(1, 0, (byte)1);
            this.setPrimaryCol(0);
            ++n2;
        }
        for (int i = 0; i < this.informations.size(); ++i) {
            this.addInterval(1, i + n2, (byte)1);
        }
    }

    public FastDecimal getDoubleAt_Transpose(int n, int n2, FastDecimal fastDecimal) {
        if (n == 0) {
            return fastDecimal.error();
        }
        if (this.names != null) {
            if (n2 == 0) {
                return fastDecimal.error();
            }
            --n2;
        }
        if (n2 < this.informations.size()) {
            return fastDecimal.error();
        }
        fastDecimal.setValue((double)this.references.get(n - 1).getMatrix().get(n2 -= this.informations.size()));
        return fastDecimal;
    }

    public Object getValueAt_Transpose(int n, int n2) {
        if (this.names != null) {
            if (n2 == 0) {
                if (n == 0) {
                    return "Name";
                }
                return this.names[n - 1];
            }
            --n2;
        }
        if (n2 < this.informations.size()) {
            String string = this.informations.get(n2);
            if (n == 0) {
                return string;
            }
            return this.references.get(n - 1).getInformation().get(string);
        }
        n2 -= this.informations.size();
        if (n == 0) {
            return Double.toString(this.references.get(0).getWavelength()[n2]);
        }
        return Double.toString(this.references.get(n - 1).getMatrix().get(n2));
    }
}

