/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.evince.datasource.reference;

import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import se.prediktera.breeze.common.realtime.unmixing.Reference;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.evince.datasource.reference.ReferenceDataSource;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.ImportInterface;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class ReferenceImportPanel
extends AbstractImportPanel {
    private ReferenceDataSource dsciModel;

    public ReferenceImportPanel(ImportInterface importInterface) {
        super((LayoutManager)new BorderLayout(), importInterface.getFiles());
        List<Reference> list = Reference.read(Arrays.asList(importInterface.getFiles()), null);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Reference reference : list) {
            InformationPanel.InformationList informationList = reference.getInformation();
            File file = reference.getFile();
            if (file != null) {
                informationList.add("Filename", FileHelper.getFileName(file));
            }
            for (Map.Entry<String, String> entry : informationList.getList()) {
                if (arrayList.contains(entry.getKey())) continue;
                arrayList.add(entry.getKey());
            }
        }
        this.dsciModel = new ReferenceDataSource(list, arrayList, importInterface);
    }

    public boolean canFinish() {
        return false;
    }

    public CellIdentifierModel getCashedCiModel() {
        return this.dsciModel;
    }

    public CellIdentifierModel getTableModel(ProgressManager progressManager, boolean bl) {
        return this.dsciModel;
    }

    public String getType() {
        return "Reference";
    }

    public boolean hasSettings() {
        return false;
    }

    protected void cleanUpChild() {
        super.cleanUpChild();
        this.dsciModel = null;
    }
}

