/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.evince.matrix;

import java.io.IOException;
import java.util.List;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.data.SimpleTableModel;
import se.prediktera.map.datasetcontainer.datainfo.AbstractDataInfo;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;

public class BilMatrix
extends AbstractDataMatrix {
    private List<? extends Frame> frames;
    protected int noFrames;
    protected int pixels;
    protected int bands;
    private int n;

    public BilMatrix(int[] nArray) {
        super("BilMatrix");
    }

    public void setFrames(List<? extends Frame> list) {
        this.frames = list;
        this.noFrames = list.size();
        Frame frame = list.get(0);
        this.pixels = frame.getColumns().value;
        this.bands = frame.getRows().value;
        this.n = this.pixels * this.noFrames;
        this.setFoldN(this.noFrames);
    }

    public byte getTreeType() {
        return 0;
    }

    public Object clone() {
        return null;
    }

    public SimpleTableModel createTableModel(boolean bl) {
        return null;
    }

    public String getColumnDescription(int n, int n2) {
        return null;
    }

    public int getK() {
        return this.bands;
    }

    public int getN() {
        return this.n;
    }

    public String getRowDescription(int n, int n2) {
        return null;
    }

    public final double getFoldValue(int n, int n2) {
        return this.getValue(n, n2);
    }

    public double getValue(int n, int n2) {
        int n3 = n / this.noFrames;
        int n4 = n % this.noFrames;
        if (n4 < this.frames.size()) {
            Frame frame = this.frames.get(n4);
            return frame.getFrameValue(n2, n3);
        }
        return 15.0;
    }

    public boolean isModel() {
        return false;
    }

    public void setKInfo(int n, int n2, String string) {
    }

    public void setNInfo(int n, int n2, String string) {
    }

    public void setValue(int n, int n2, double d) {
    }

    public void setValue(int n, int n2, double d, boolean bl) {
    }

    protected void ClearChild() throws IOException {
    }

    protected void LoadChild(RandomInputStream randomInputStream) throws IOException {
    }

    protected void SaveChild(RandomOutputStream randomOutputStream) throws IOException {
    }

    public AbstractDataInfo getDataInfo(int n) {
        return null;
    }

    public static class RtFrameBilMatrix
    extends BilMatrix {
        private RtFrame[] rtFrames;
        private int[] block;
        private int[] index;

        public RtFrameBilMatrix(int[] nArray) {
            super(nArray);
        }

        @Override
        public void setFrames(List<? extends Frame> list) {
            super.setFrames(list);
            this.rtFrames = new RtFrame[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.rtFrames[i] = (RtFrame)list.get(i);
            }
            RtFrame rtFrame = this.rtFrames[0];
            this.block = rtFrame.block;
            this.index = rtFrame.index;
        }

        @Override
        public double getValue(int n, int n2) {
            int n3 = n / this.noFrames;
            int n4 = n % this.noFrames;
            FloatMatrix[] floatMatrixArray = this.rtFrames[n4].floatMatrix;
            return floatMatrixArray[this.block[n3]].get(n2, this.index[n3]);
        }
    }
}

