/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.evince.matrix;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import no.uib.cipr.matrix.Matrix;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.backend.realtime.holder.RtTransformationModuleHolder;
import se.prediktera.breeze.common.entry.measurement.MeasurementFileLocation;
import se.prediktera.breeze.common.frame.ByteFrame;
import se.prediktera.breeze.common.frame.FloatFrame;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.frame.ShortFrame;
import se.prediktera.breeze.common.realtime.RtModule;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TransformationParameter;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.realtime.frame.RtFrameStack;
import se.prediktera.breeze.common.realtime.frame.RtFrameStackList;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.raw.CachedRawFile;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.FrameReader;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RtThreader;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.main.settings.testscan.TestScanRealTimePanel;
import se.prediktera.map.common.mtj.DenseMatrixFloat;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.ObservationInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrixFloat;

public class FrameMatrix
extends LayerMatrix {
    private boolean[][] includeMatrix;

    public FrameMatrix(List<RawFrame> list) {
        super(new int[0]);
        RawFrame rawFrame = list.get(0);
        this.readData(list, rawFrame.getColumns(), rawFrame.getRows());
    }

    public FrameMatrix(RtFrameStackList.RealtimeFrameList realtimeFrameList, int[] nArray) {
        super(nArray);
        this.readData(realtimeFrameList, realtimeFrameList.getWidth(), realtimeFrameList.getBandCount());
    }

    public FrameMatrix(List<RtFrameStackList.RealtimeFrameList> list, int[] nArray) {
        super(nArray);
        int n;
        int n2;
        int n3;
        double d = Math.sqrt(list.size());
        int n4 = n3 = (int)Math.ceil(d);
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n4];
        int n5 = 0;
        RtFrameStackList.RealtimeFrameList[][] realtimeFrameListArray = new RtFrameStackList.RealtimeFrameList[n3][n4];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                if (n5 >= list.size()) continue;
                realtimeFrameListArray[n2][n] = list.get(n5++);
                nArray2[n2] = Math.max(nArray2[n2], realtimeFrameListArray[n2][n].size());
                nArray3[n] = Math.max(nArray3[n], realtimeFrameListArray[n2][n].getWidth().value);
            }
        }
        n2 = 0;
        for (n = 0; n < n4; ++n) {
            n2 += nArray3[n];
        }
        n = 0;
        for (int i = 0; i < n3; ++i) {
            n += nArray2[i];
        }
        BandCount bandCount = list.get(0).getBandCount();
        DenseMatrixFloat[] denseMatrixFloatArray = this.addMatrices(bandCount.value, n, n2);
        this.includeMatrix = new boolean[n][n2];
        int n6 = 0;
        for (int i = 0; i < n3; ++i) {
            int n7 = 0;
            for (int j = 0; j < n4; ++j) {
                if (realtimeFrameListArray[i][j] != null) {
                    int n8 = 0;
                    for (RtFrame rtFrame : realtimeFrameListArray[i][j]) {
                        int n9 = rtFrame.getColumns().value;
                        int n10 = n6 + n8;
                        for (int k = 0; k < n9; ++k) {
                            int n11 = n7 + k;
                            int n12 = rtFrame.index[k];
                            FloatMatrix floatMatrix = rtFrame.floatMatrix[rtFrame.block[k]];
                            for (int i2 = 0; i2 < bandCount.value; ++i2) {
                                denseMatrixFloatArray[i2].set(n10, n11, (double)floatMatrix.get(i2, n12));
                            }
                            this.includeMatrix[n10][n11] = true;
                        }
                        ++n8;
                    }
                }
                n7 += nArray3[j];
            }
            n6 += nArray2[i];
        }
    }

    public boolean isOrigMatrix() {
        return true;
    }

    public void readData(final List<? extends Frame> list, PixelWidth pixelWidth, BandCount bandCount) {
        Frame frame = list.get(0);
        final int n = list.size();
        final int n2 = bandCount.value;
        final int n3 = pixelWidth.value;
        final DenseMatrixFloat[] denseMatrixFloatArray = this.addMatrices(n2, n, pixelWidth.value);
        if (frame instanceof RtFrame) {
            RtFrame rtFrame = (RtFrame)frame;
            final int[] nArray = rtFrame.block;
            final int[] nArray2 = rtFrame.index;
            new RtThreader(this){

                @Override
                protected void doOp(boolean bl, int n5, int n22) {
                    for (int i = n5; i < n22; ++i) {
                        FloatMatrix[] floatMatrixArray = ((RtFrame)list.get((int)i)).floatMatrix;
                        for (int j = 0; j < n2; ++j) {
                            float[] fArray = denseMatrixFloatArray[j].data;
                            int n32 = 0;
                            int n4 = 0;
                            while (n32 < n3) {
                                fArray[i + n4] = floatMatrixArray[nArray[n32]].get(j, nArray2[n32]);
                                ++n32;
                                n4 += n;
                            }
                        }
                    }
                }
            }.execute(n);
        } else {
            DataSize dataSize = frame.getType();
            if (dataSize.equals((Object)DataSize.BYTE_1)) {
                new RtThreader(this){

                    @Override
                    protected void doOp(boolean bl, int n5, int n22) {
                        for (int i = n5; i < n22; ++i) {
                            Frame frame = (Frame)list.get(i);
                            byte[][] byArray = ((ByteFrame)frame).origframe;
                            for (int j = 0; j < n2; ++j) {
                                float[] fArray = denseMatrixFloatArray[j].data;
                                byte[] byArray2 = byArray[j];
                                int n32 = 0;
                                int n4 = 0;
                                while (n32 < n3) {
                                    fArray[i + n4] = byArray2[n32] & 0xFF;
                                    ++n32;
                                    n4 += n;
                                }
                            }
                        }
                    }
                }.execute(n);
            } else if (dataSize.equals((Object)DataSize.SHORT_2)) {
                new RtThreader(this){

                    @Override
                    protected void doOp(boolean bl, int n5, int n22) {
                        for (int i = n5; i < n22; ++i) {
                            Frame frame = (Frame)list.get(i);
                            short[][] sArray = ((ShortFrame)frame).origframe;
                            for (int j = 0; j < n2; ++j) {
                                float[] fArray = denseMatrixFloatArray[j].data;
                                short[] sArray2 = sArray[j];
                                int n32 = 0;
                                int n4 = 0;
                                while (n32 < n3) {
                                    fArray[i + n4] = sArray2[n32] & 0xFFFF;
                                    ++n32;
                                    n4 += n;
                                }
                            }
                        }
                    }
                }.execute(n);
            } else if (dataSize.equals((Object)DataSize.FLOAT_4)) {
                new RtThreader(this){

                    @Override
                    protected void doOp(boolean bl, int n5, int n22) {
                        for (int i = n5; i < n22; ++i) {
                            Frame frame = (Frame)list.get(i);
                            float[][] fArray = ((FloatFrame)frame).origframe;
                            for (int j = 0; j < n2; ++j) {
                                float[] fArray2 = denseMatrixFloatArray[j].data;
                                float[] fArray3 = fArray[j];
                                int n32 = 0;
                                int n4 = 0;
                                while (n32 < n3) {
                                    fArray2[i + n4] = fArray3[n32];
                                    ++n32;
                                    n4 += n;
                                }
                            }
                        }
                    }
                }.execute(n);
            } else {
                new RtThreader(this){

                    @Override
                    protected void doOp(boolean bl, int n5, int n22) {
                        for (int i = n5; i < n22; ++i) {
                            Frame frame = (Frame)list.get(i);
                            for (int j = 0; j < n2; ++j) {
                                float[] fArray = denseMatrixFloatArray[j].data;
                                int n32 = 0;
                                int n4 = 0;
                                while (n32 < n3) {
                                    fArray[i + n4] = frame.getFrameValue(j, n32);
                                    ++n32;
                                    n4 += n;
                                }
                            }
                        }
                    }
                }.execute(n);
            }
        }
    }

    private DenseMatrixFloat[] addMatrices(int n, int n2, int n3) {
        DenseMatrixFloat[] denseMatrixFloatArray = new DenseMatrixFloat[n];
        for (int i = 0; i < n; ++i) {
            MVmatrixFloat mVmatrixFloat = new MVmatrixFloat(n2, n3);
            mVmatrixFloat.setFoldN(n);
            this.addMatrix((AbstractDataMatrix)mVmatrixFloat);
            denseMatrixFloatArray[i] = (DenseMatrixFloat)mVmatrixFloat.getInternalMatrixPublic();
        }
        return denseMatrixFloatArray;
    }

    public void initiateCaseAndDataSet(Case case_, DataSet dataSet, RtFramePredictor.RefSettings refSettings) {
        if (this.includeMatrix != null) {
            ObservationInfo observationInfo = dataSet.getObsDataInfo();
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)observationInfo.getPrimaryColumnByType(1);
            int n = 0;
            for (int i = 0; i < this.includeMatrix[0].length; ++i) {
                for (boolean[] blArray : this.includeMatrix) {
                    innerColumnBoolean.setValueBool(n++, blArray[i]);
                }
            }
        }
        if (refSettings.referenceType.using()) {
            if (refSettings.convertTo.equals((Object)RtFramePredictor.ReferenceConvertTo.Reflectance)) {
                case_.setCalibrationType((byte)2);
            } else {
                case_.setCalibrationType((byte)1);
            }
        }
    }

    public static FrameMatrix readReferenceOrRawFrameMatrix(BreezeProgress breezeProgress, List<Measurement> list, FrameListFromRaw.Reduce reduce) {
        Object object2;
        ArrayList<RtFrameStackList.RealtimeFrameList> arrayList = new ArrayList<RtFrameStackList.RealtimeFrameList>();
        List<ApplyChanges.MeasurementList> list2 = ApplyChanges.MeasurementList.splitMeasurementsIntoSpecificLists(list);
        int n = breezeProgress.setGroupMaximumAndReset(list2.size());
        for (Object object2 : list2) {
            FrameMatrix.addMeasurementsToFrameList(breezeProgress, reduce, arrayList, object2.getMeasurements());
            breezeProgress.incStepGroup(n);
        }
        RawHeader rawHeader = list.get(0).rawFile().header();
        object2 = new FrameMatrix(arrayList, rawHeader.rgbBands().getWithin(rawHeader.bandCount().value));
        FrameMatrix.setBandNames(rawHeader, (FrameMatrix)((Object)object2));
        return object2;
    }

    private static void addMeasurementsToFrameList(BreezeProgress breezeProgress, FrameListFromRaw.Reduce reduce, List<RtFrameStackList.RealtimeFrameList> list, List<Measurement> list2) {
        Measurement measurement = list2.get(0);
        MaxSignal maxSignal = measurement.getMetaProperties().getMaxSignal(new MaxSignal(0.0f));
        RawHeader rawHeader = measurement.rawFile().header();
        RtFramePredictor rtFramePredictor = new RtFramePredictor(breezeProgress, rawHeader.bandCount(), new PixelWidth(rawHeader.pixelWidth().value / reduce.x), rawHeader.bandNames(), maxSignal, new RtFramePredictor.FramePoolSettings(true), measurement.getWorkflow(), measurement.getRefSettings(null));
        int n = 1;
        for (Measurement measurement2 : list2) {
            if (breezeProgress.isAborted()) {
                throw new BreezeProgress.ProgressActionCancelledException();
            }
            breezeProgress.setInfoText("Loading " + measurement2.getName() + " (" + n + " of " + list2.size() + ")");
            list.add(FrameMatrix.readReferenceOrRawFrameMatrix(breezeProgress, rtFramePredictor, measurement2, reduce).getReferenceOrRawFrameList());
            ++n;
        }
        rtFramePredictor.stop();
    }

    public static FrameMatrix readReferenceOrRawFrameMatrix(BreezeProgress breezeProgress, Measurement measurement, RtFramePredictor.RefSettings refSettings) {
        MaxSignal maxSignal = measurement.getMetaProperties().getMaxSignal(new MaxSignal(0.0f));
        RawHeader rawHeader = measurement.rawFile().header();
        FrameListFromRaw.Reduce reduce = refSettings.reduce;
        if (rawHeader.pixelWidth().value / reduce.x < 1) {
            reduce = new FrameListFromRaw.Reduce(1);
        }
        Workflow workflow = measurement.getWorkflow();
        RtFramePredictor rtFramePredictor = new RtFramePredictor(breezeProgress, rawHeader.bandCount(), new PixelWidth(rawHeader.pixelWidth().value / reduce.x), rawHeader.bandNames(), maxSignal, new RtFramePredictor.FramePoolSettings(true), workflow, refSettings);
        List<RtModule> list = TransformationParameter.getTransformationModules(workflow.getExplorePixelFilter(), rtFramePredictor.getBlocks());
        if (list.size() > 0) {
            rtFramePredictor.add(rtFramePredictor.getAbsRefOrRawHolder(), new RtTransformationModuleHolder(list, rawHeader.bandCount(), rawHeader.pixelWidth(), rawHeader.bandNames(), rtFramePredictor.getBlocks(), true));
        }
        breezeProgress.setInfoText("Loading " + measurement.getName());
        RtFrameStackList rtFrameStackList = FrameMatrix.readReferenceOrRawFrameMatrix(breezeProgress, rtFramePredictor, measurement, reduce);
        FrameMatrix frameMatrix = new FrameMatrix(rtFrameStackList.getReferenceOrRawFrameList(), rawHeader.rgbBands().getWithin(rawHeader.bandCount().value));
        frameMatrix.setImage(measurement.isRgbData());
        rtFramePredictor.stop();
        FrameMatrix.setBandNames(rawHeader, frameMatrix);
        return frameMatrix;
    }

    public int addPredictionMatrix(Measurement measurement, FrameListFromRaw.Reduce reduce) {
        int n = this.getMatrixCount();
        try {
            CachedRawFile cachedRawFile = new CachedRawFile(measurement, new MeasurementFileLocation.Prediction(), reduce);
            List<RawFrame> list = cachedRawFile.readFrames();
            RawHeader rawHeader = cachedRawFile.header();
            this.readData(list, list.get(0).getColumns(), list.get(0).getRows());
            BandNames bandNames = rawHeader.bandNames();
            for (int i = n; i < this.getMatrixCount(); ++i) {
                this.getMatrixAt(i).setName(bandNames.get(i - n));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        return n;
    }

    private static void setBandNames(RawHeader rawHeader, FrameMatrix frameMatrix) {
        BandNames bandNames = rawHeader.bandNames();
        for (int i = 0; i < frameMatrix.getMatrixCount(); ++i) {
            frameMatrix.getMatrixAt(i).setName(bandNames.getOrInterpolate(i));
        }
    }

    public static RtFrameStackList readReferenceOrRawFrameMatrix(BreezeProgress breezeProgress, RtFramePredictor rtFramePredictor, Measurement measurement, FrameListFromRaw.Reduce reduce) {
        try {
            SpectralReference.WhiteReference whiteReference = null;
            SpectralReference.DarkReference darkReference = null;
            if (rtFramePredictor.getReferenceType().using()) {
                whiteReference = new MeasurementFileLocation.WhiteRef().file(measurement).exists() ? new SpectralReference.WhiteReference(measurement, reduce) : new SpectralReference.EmptyWhiteReference();
                darkReference = new MeasurementFileLocation.DarkRef().file(measurement).exists() ? new SpectralReference.DarkReference(measurement, reduce) : new SpectralReference.EmptyDarkReference();
            }
            RawFile rawFile = measurement.rawFile();
            int n = 0;
            ArrayList<RtFrameStack> arrayList = new ArrayList<RtFrameStack>();
            if (rawFile instanceof TestScanRealTimePanel.FramesRawFile) {
                for (RawFrame rawFrame : rawFile.readFrames()) {
                    if (reduce.x != 1) {
                        rawFrame = rawFrame.recudeFrame(reduce);
                    }
                    arrayList.add(rtFramePredictor.apply(rawFrame, n, whiteReference, darkReference, measurement));
                    ++n;
                }
            } else {
                try (FrameReader.FrameIterator frameIterator = new FrameReader(rawFile.file(), rawFile.header(), null, true, reduce).iterator();){
                    while (frameIterator.hasNext()) {
                        RawFrame rawFrame = frameIterator.next();
                        if (reduce.x != 1) {
                            rawFrame = rawFrame.recudeFrame(reduce);
                        }
                        arrayList.add(rtFramePredictor.apply(rawFrame, n, whiteReference, darkReference, measurement));
                        ++n;
                    }
                }
            }
            return new RtFrameStackList(arrayList);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
    }

    public MVmatrix createAverage() {
        AbstractDataMatrix abstractDataMatrix = this.getMatrixAt(0);
        int n = abstractDataMatrix.getK();
        int n2 = this.getK();
        int n3 = abstractDataMatrix.getN();
        MVmatrix mVmatrix = new MVmatrix(n2, n);
        Matrix matrix = mVmatrix.getInternalMatrixPublic();
        for (int i = 0; i < n2; ++i) {
            Matrix matrix2 = ((MVmatrixFloat)this.getMatrixAt(i)).getInternalMatrixPublic();
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n3; ++k) {
                    double d = matrix.get(i, j);
                    double d2 = matrix2.get(k, j);
                    matrix.set(i, j, d + d2);
                }
            }
        }
        matrix.scale(1.0 / (double)n3);
        return mVmatrix;
    }

    public int getMatrixIndex(String string) {
        for (int i = 0; i < this.getMatrixCount(); ++i) {
            if (!this.getMatrixAt(i).getName().equals(string)) continue;
            return i;
        }
        return 0;
    }

    public BandNames getBandNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.getMatrixCount(); ++i) {
            arrayList.add(this.getMatrixAt(i).getName());
        }
        return new BandNames(arrayList);
    }

    public int getReduce() {
        Case case_ = this.getCase();
        if (case_ != null) {
            return case_.getReduce();
        }
        return 1;
    }
}

