/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.evince.matrix;

import java.util.ArrayList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import se.prediktera.breeze.common.frame.ByteFrame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.evince.matrix.FrameMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;

public class FrameMatrixTest {
    @Test
    public void simpleMatrix() {
        ArrayList<RawFrame> arrayList = new ArrayList<RawFrame>();
        arrayList.add(this.createFrame(1.0f));
        FrameMatrix frameMatrix = new FrameMatrix(arrayList);
        MatcherAssert.assertThat((Object)frameMatrix.getK(), (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((Object)frameMatrix.getN(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)frameMatrix.getFoldN(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)frameMatrix.getValue(0, 0), (Matcher)CoreMatchers.is((Object)1.0));
    }

    private ByteFrame createFrame(float f) {
        ByteFrame byteFrame = new ByteFrame(new BandCount(10), new PixelWidth(5), BandNames.fromIndex(10));
        for (int i = 0; i < byteFrame.getRows().value; ++i) {
            for (int j = 0; j < byteFrame.getColumns().value; ++j) {
                byteFrame.setFrameValue(i, j, f);
            }
        }
        return byteFrame;
    }

    @Test
    public void createAverage() {
        ArrayList<RawFrame> arrayList = new ArrayList<RawFrame>();
        arrayList.add(this.createFrame(1.0f));
        arrayList.add(this.createFrame(2.0f));
        FrameMatrix frameMatrix = new FrameMatrix(arrayList);
        MVmatrix mVmatrix = frameMatrix.createAverage();
        MatcherAssert.assertThat((Object)mVmatrix.getN(), (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((Object)mVmatrix.getK(), (Matcher)CoreMatchers.is((Object)5));
        for (int i = 0; i < mVmatrix.getN(); ++i) {
            for (int j = 0; j < mVmatrix.getK(); ++j) {
                MatcherAssert.assertThat((Object)mVmatrix.getValue(i, j), (Matcher)CoreMatchers.is((Object)1.5));
            }
        }
    }
}

