/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import se.prediktera.breeze.Breeze;
import se.prediktera.breeze.InitClass;
import se.prediktera.breeze.backend.Migrator;
import se.prediktera.breeze.backend.SettingsManager;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.backend.realtime.descriptor.discriminatory.DiscriminatoryAnalysisDescriptor;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionHelper;
import se.prediktera.breeze.common.util.BreezeInterface;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.BreezeViewStack;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainSwitchPanel;
import se.prediktera.breeze.frontend.common.entry.MainPanelInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeActionListener;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.util.BreezeUser;
import se.prediktera.breeze.frontend.common.util.BreezeUserManager;
import se.prediktera.breeze.hardware.tcp.BreezeRuntime;
import se.prediktera.breeze.hardware.tcp.TcpManagerTest;
import se.prediktera.breeze.util.BreezeProcess;
import se.prediktera.map.common.MacHelper;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.main.extclass.ExtClassLoader;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.RegisterKeyManager;
import se.prediktera.map.register.wizard.RegisterWizard;

public class BreezeFrame
extends JFrame
implements BreezeInterface {
    public static boolean showCursor = true;
    private static Cursor invisibleCursor;
    public static boolean touchscreen;
    public static boolean development;
    public static boolean prototype;
    private final Preferences prefs = Preferences.userNodeForPackage(BreezeFrame.class);
    private final WorkspaceManager workspaceManager;
    private final GraphicsDevice device;
    private final BreezeViewStack viewStack;
    private JPanel mainPanel;
    private final List<OnCloseCallback> onCloseCallbacks = new ArrayList<OnCloseCallback>();
    private final BreezeRuntime runtime;
    private Runnable requestExit;
    private final UpdateHelper.Product product;
    private static BreezeFrame instance;
    public static boolean projectFeature;
    private static ComponentShowned componentShowned;
    private final OffsetDateTime launchDate;

    public BreezeFrame(UpdateHelper.Product product) {
        this.product = product;
        this.workspaceManager = null;
        this.device = Breeze.getGraphicsDevice();
        this.viewStack = new BreezeViewStack(this, null);
        this.mainPanel = null;
        this.runtime = null;
        instance = this;
        this.launchDate = OffsetDateTime.now();
        this.requestExit = null;
    }

    public BreezeFrame(WorkspaceManager workspaceManager, BreezeRuntime breezeRuntime, GraphicsDevice graphicsDevice, CreatePanelCallback createPanelCallback, UpdateHelper.Product product, boolean bl, boolean bl2, boolean bl3) {
        super(graphicsDevice.getDefaultConfiguration());
        this.workspaceManager = workspaceManager;
        this.runtime = breezeRuntime;
        this.device = graphicsDevice;
        this.product = product;
        this.requestExit = null;
        touchscreen = bl2;
        development = bl3;
        this.mainPanel = createPanelCallback.createPanel(this);
        this.viewStack = new BreezeViewStack(this, this.mainPanel);
        instance = this;
        this.launchDate = OffsetDateTime.now();
        UIManager.put("MenuItem.selectionBackground", new Color(150, 150, 150));
        UIManager.put("TabbedPane.contentAreaColor", BreezeTheme.TRANSPARENT);
        UIManager.put("TabbedPane.selected", BreezeTheme.TRANSPARENT);
        UIManager.put("TabbedPane.background", BreezeTheme.TRANSPARENT);
        this.setBackgroundFromTheme();
        BreezeFrame.loadCustomFonts();
        this.setDefaultCloseOperation(0);
        this.restoreWindowState();
        if (SystemUtils.IS_OS_MAC) {
            MacHelper.setup((Window)this, (String)"Breeze", (ImageIcon)new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/images/icons/Breeze_256_Mac.png"))));
        }
        showCursor = bl;
        this.setCursor(BreezeFrame.getDefaultCursor());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (componentShowned != null && componentShowned.isVisible(BreezeFrame.this)) {
                    BreezeFrame.setRelativeSize(componentShowned);
                    componentShowned.revalidate();
                } else {
                    componentShowned = null;
                }
            }
        });
        Toolkit.getDefaultToolkit().addAWTEventListener(aWTEvent -> {
            if (aWTEvent instanceof WindowEvent && aWTEvent.getID() == 207) {
                SwingUtilities.invokeLater(this::repaint);
            }
        }, 64L);
        UpdateHelper.Product.setExitCallback(() -> {
            if (this.requestExit != null) {
                this.requestExit.run();
            }
        });
        Breeze.setFrameIcons(this);
        this.setTitle(BreezeFrame.getDefaultTitle(product));
        FunctionHelper.add(Collections.singletonList(new DiscriminatoryAnalysisDescriptor.Info()));
        try {
            boolean bl4 = Migrator.shouldMigrateWorkspace(workspaceManager);
            if (bl4 && BreezeFrame.isMigrateToProjectStructureFeature()) {
                BreezeProgressDialog.startProgress(this, breezeProgressManager -> {
                    try {
                        Migrator.migrateWorkspaceDirectoryStructure(workspaceManager.getWorkspace().getFolder(), breezeProgressManager);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                }, "Migrating directory structure");
            }
        }
        catch (WorkspaceManager.WorkspacePermissionException workspacePermissionException) {
            // empty catch block
        }
    }

    private static void loadCustomFonts() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String string : new String[]{"ProximaNova-Bold", "ProximaNova-Regular", "ProximaNova-Semibold"}) {
            try (InputStream inputStream = BreezeTheme.class.getResourceAsStream("/fonts/" + string + ".otf");){
                if (inputStream == null) continue;
                graphicsEnvironment.registerFont(Font.createFont(0, inputStream));
            }
            catch (Exception exception) {
                Logg.error((String)("Could not load font " + string + ".otf"), (Throwable)exception);
            }
        }
    }

    public void setBackgroundFromTheme() {
        Color color = BreezeTheme.getInstance().getPanelBackground();
        this.setBackground(color);
        this.getContentPane().setBackground(color);
    }

    public static String getDefaultTitle(UpdateHelper.Product product) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Prediktera ");
        stringBuilder.append(product).append(" ");
        stringBuilder.append(InitClass.getBreezeVersion().format(true));
        RegInfo regInfo = RegisterKeyManager.getRegInfo();
        int n = regInfo.getDaysUntilExpire(ExtClassLoader.LicenseLibrary.BREEZE);
        if (regInfo.isTrialLicense() && n > 0) {
            if (n > 1) {
                stringBuilder.append(" [Trial ").append(n).append(" days left]");
            } else {
                stringBuilder.append(" [Trial expiring today]");
            }
        } else if (regInfo.isArchived) {
            if (n > 1 && n < 11) {
                stringBuilder.append(" [License revoked - will expire in ").append(n).append(" days]");
            } else if (n == 1) {
                stringBuilder.append(" [License revoked as of today]");
            }
        }
        return stringBuilder.toString();
    }

    public void addPage(JPanel jPanel) {
        this.viewStack.addPage(jPanel);
    }

    public void removePage(JPanel jPanel) {
        Container container = jPanel.getParent();
        if (container instanceof AbstractBreezeDialog.BreezeDialog) {
            AbstractBreezeDialog.BreezeDialog breezeDialog = (AbstractBreezeDialog.BreezeDialog)((Object)container);
            this.removePage((JPanel)((Object)breezeDialog), breezeDialog.refreshSelectedEntry(jPanel));
        } else {
            this.removePage(jPanel, true);
        }
    }

    public void removePage(JPanel jPanel, boolean bl) {
        this.viewStack.removePage(jPanel, bl);
        if (jPanel instanceof BreezeMainPanel) {
            BreezeMainPanel breezeMainPanel = (BreezeMainPanel)jPanel;
            breezeMainPanel.cleanUp();
        }
    }

    public boolean hasPage(JPanel jPanel) {
        Container container = jPanel.getParent();
        if (container instanceof AbstractBreezeDialog.BreezeDialog) {
            AbstractBreezeDialog.BreezeDialog breezeDialog = (AbstractBreezeDialog.BreezeDialog)((Object)container);
            return this.viewStack.hasPage((JPanel)((Object)breezeDialog));
        }
        return this.viewStack.hasPage(jPanel);
    }

    public void switchPage(Object object, EntryMainSwitchPanel entryMainSwitchPanel, BreezeType breezeType) {
        this.viewStack.switchPage(object, entryMainSwitchPanel, breezeType);
    }

    public void showFullScreen(boolean bl) {
        boolean bl2 = bl && this.device.isFullScreenSupported();
        this.setResizable(!bl2);
        if (bl2) {
            this.setUndecorated(true);
        } else {
            this.setMinimumSize(new Dimension(1024, 600));
        }
        this.restoreWindowState();
        this.setVisible(true);
    }

    public void switchWorkspace() {
        this.switchWorkspace(breezeActionEvent2 -> {
            if (this.workspaceManager.switchToNewWorkspace(breezeActionEvent2.result().toString())) {
                BreezeOptionDialog.showDialog(this, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Restart", "Breeze will exit. Restart it to use the new workspace.", null, breezeActionEvent -> this.stop());
            }
        });
    }

    public void switchWorkspace(BreezeActionListener breezeActionListener) {
        BreezeOptionDialog.showDialog(this, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Choose workspace location", "Specify the path to the workspace to use. A new empty workspace will be created if the location doesn't already contain a workspace.\n\nA workspace stores Breeze projects including measurements, workflows, models, and settings for cameras.", (AbstractBreezeCustomPanel)new SwitchWorkspacePanel(this), null, breezeActionListener);
    }

    public void stop() {
        if (this.requestExit != null) {
            this.requestExit.run();
        }
    }

    public final void exit() {
        this.saveWindowState();
        this.localWindowClosing(BreezeProgressManager.createFake());
        if (this.product == UpdateHelper.Product.Breeze) {
            BreezeProcess.breezeExit();
        }
    }

    private void saveWindowState() {
        this.prefs.putInt("state", this.getExtendedState());
        this.prefs.putInt("width", this.getWidth());
        this.prefs.putInt("height", this.getHeight());
        this.prefs.putInt("xPos", this.getX());
        this.prefs.putInt("yPos", this.getY());
    }

    private void restoreWindowState() {
        int n = this.prefs.getInt("state", 6);
        this.setExtendedState(n);
        int n2 = this.prefs.getInt("width", 1024);
        int n3 = this.prefs.getInt("height", 600);
        if (n == 0 || n == 4) {
            int n4 = this.prefs.getInt("xPos", 100);
            int n5 = this.prefs.getInt("yPos", 100);
            this.setBounds(n4, n5, n2, n3);
        } else {
            this.setPreferredSize(new Dimension(n2, n3));
        }
    }

    public final BufferedImage takeScreenShot() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n > 0 && n2 > 0) {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            this.paint(graphics2D);
            graphics2D.dispose();
            return bufferedImage;
        }
        return null;
    }

    public void localWindowClosing(BreezeProgressManager breezeProgressManager) {
        for (OnCloseCallback onCloseCallback : this.onCloseCallbacks) {
            onCloseCallback.onClose(breezeProgressManager);
        }
    }

    public void showLicenseError() {
        BreezeOptionDialog.showDialog(this, Color.gray, AbstractBreezeDialog.MessageType.WARNING_OPTION, "No valid license", "No valid license.\n\nPlease contact sales@prediktera.se for a valid license\n\nPress OK to open Prediktera Licence Wizard", null, breezeActionEvent -> {
            new RegisterWizard(RegisterKeyManager.getRegInfo(), this.product).executeWizard((Frame)this, this.product, InitClass.getBreezeVersion());
            this.exit();
        });
    }

    public void showStartupError(Exception exception) {
        if (exception instanceof XmlParserHelper.XmlParseException || exception.getCause() instanceof XmlParserHelper.XmlParseException) {
            WorkspaceManager.Workspace workspace = BreezeProperties.getWorkspace();
            workspace.getBreezeProperties().renameTo(BreezeFrame.createErrorFile(workspace));
            BreezeOptionDialog.showDialog(this, Color.gray, AbstractBreezeDialog.MessageType.ERROR_OPTION, "Error", "Cannot parse BreezeProperties.xml. The file has been moved to [workspace]/Data folder and a BreezeProperties.xml will be create on next startup.\n\nCause: " + exception.getMessage() + "\n\nPlease try to start Breeze again\n\nBreeze will exit", null, breezeActionEvent -> this.exit());
        } else {
            BreezeOptionDialog.showDialog(this, Color.gray, AbstractBreezeDialog.MessageType.ERROR_OPTION, "Error", "An unexpected error occurred while starting Breeze.\n\nCause: " + exception.getMessage() + "\n\nPlease contact support@prediktera.se for assistance\n\nBreeze will exit", null, breezeActionEvent -> this.exit());
        }
    }

    public static File createErrorFile(WorkspaceManager.Workspace workspace) {
        return new File(workspace.getDataPath(), "BreezeProperties_Error_" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + ".xml");
    }

    public void show32bitJavaWarningDialog() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Breeze is running on 32-bit Java. This will limit the memory available.");
        stringBuilder.append('\n');
        stringBuilder.append('\n');
        stringBuilder.append("It is recommended to run Breeze on 64-bit Java.");
        stringBuilder.append('\n');
        stringBuilder.append('\n');
        stringBuilder.append("64-bit Java can be downloaded from:\n\nhttps://adoptium.net/temurin/releases/?os=");
        if (SystemUtils.IS_OS_WINDOWS) {
            stringBuilder.append("windows");
        } else if (SystemUtils.IS_OS_LINUX) {
            stringBuilder.append("linux");
        } else if (SystemUtils.IS_OS_MAC_OSX) {
            stringBuilder.append("mac");
        }
        stringBuilder.append("&package=jre&version=");
        stringBuilder.append(Runtime.version().feature());
        BreezeOptionDialog.showDialog(this, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Java Information", stringBuilder.toString());
    }

    public void showSetWorkspaceDialog(final WorkspaceDialogCallback workspaceDialogCallback) {
        this.switchWorkspace(new BreezeActionListener(){

            @Override
            public void actionPerformed(BreezeActionListener.BreezeActionEvent breezeActionEvent) {
                String string = breezeActionEvent.result().toString();
                workspaceDialogCallback.workspacePathChosen(string);
            }

            @Override
            public void cancelPerformed(BreezeActionListener.BreezeActionEvent breezeActionEvent) {
                workspaceDialogCallback.cancelled();
            }
        });
    }

    public void showFolderPermissionErrorDialog(FolderPermissionErrorDialog folderPermissionErrorDialog, File file, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Breeze must have both Read and Write access on all folders. ");
        stringBuilder.append("The given folder below has incorrect permission:\n\n");
        stringBuilder.append(file.getAbsolutePath());
        stringBuilder.append("\n");
        stringBuilder.append("(Read: ").append(file.canRead() ? "Yes" : "No");
        stringBuilder.append(", Write: ").append(file.canRead() ? "Yes" : "No").append(")");
        stringBuilder.append("\n\n\n");
        if (bl) {
            stringBuilder.append("Breeze will exit. ");
        }
        stringBuilder.append("Please try again.");
        BreezeOptionDialog.showDialog(this, AbstractBreezeDialog.MessageType.ERROR_OPTION, "Incorrect folder permission", stringBuilder.toString(), breezeActionEvent -> folderPermissionErrorDialog.onActionPerformed());
    }

    public void addOnCloseCallback(OnCloseCallback onCloseCallback) {
        this.onCloseCallbacks.add(onCloseCallback);
    }

    public void removeOnCloseCallback(OnCloseCallback onCloseCallback) {
        this.onCloseCallbacks.remove(onCloseCallback);
    }

    public static Cursor getDefaultCursor() {
        if (showCursor) {
            return Cursor.getDefaultCursor();
        }
        return BreezeFrame.getInvisibleCursor();
    }

    public static Cursor getHandCursor() {
        if (showCursor) {
            return Cursor.getPredefinedCursor(12);
        }
        return BreezeFrame.getInvisibleCursor();
    }

    public static Cursor getInvisibleCursor() {
        if (invisibleCursor == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Point point = new Point(0, 0);
            BufferedImage bufferedImage = new BufferedImage(1, 1, 3);
            invisibleCursor = toolkit.createCustomCursor(bufferedImage, point, "InvisibleCursor");
        }
        return invisibleCursor;
    }

    public void login() {
        if (BreezeUserManager.getInstance().isEnabled()) {
            BreezeUserManager.getInstance().showLoginDialog(this, new BreezeUserManager.LoginCallback(){

                @Override
                public void login(BreezeUser breezeUser) {
                    BreezeFrame.this.addMainPage();
                }

                @Override
                public void cancelled() {
                    BreezeFrame.this.exit();
                }
            }, null);
        } else {
            this.addMainPage();
        }
    }

    public void setMainPanel(JPanel jPanel) {
        this.mainPanel = jPanel;
        this.viewStack.setMainPanel(jPanel);
    }

    public void addMainPage() {
        if (this.mainPanel instanceof MainPanelInterface) {
            ((MainPanelInterface)((Object)this.mainPanel)).showSelectedEntry(true);
        }
        this.getViewStack().addMainPage();
    }

    public static boolean isSelectSimilarFeature() {
        return development;
    }

    public static boolean isModeFeature() {
        return development;
    }

    public static boolean isPredictionTableFeature() {
        return development;
    }

    public static boolean isHelpFeature() {
        return development;
    }

    public static boolean isDiscriminatoryAnalysisFeature() {
        return development;
    }

    public static boolean isPixelMaskCategoryFeature() {
        return development;
    }

    public static boolean isMeasurementSummaryPanel() {
        return development;
    }

    public static boolean isExcludeOutlierWithHotellingT2InClassificationFeature() {
        return development;
    }

    public static boolean isStudyImportFeature() {
        return development;
    }

    public static boolean isSettingsFeature() {
        return development;
    }

    public static boolean isLoggingFeature(Workflow workflow) {
        return RegInfo.isGeoFeature() && workflow.getDepthRegistration();
    }

    public static boolean isCustomNeuralNetworkFeature() {
        return false;
    }

    public static boolean isRuntimeSampleFeature() {
        return false;
    }

    public static boolean isMigrateToProjectStructureFeature() {
        return false;
    }

    public static boolean isProjectMainFeature() {
        if (WorkspaceManager.GUITEST) {
            return false;
        }
        return projectFeature;
    }

    public static boolean isOnnxGlobalsFeature() {
        return false;
    }

    public static boolean isPixelExploreDescriptors() {
        return true;
    }

    public static boolean isCategoryByFeature() {
        return true;
    }

    public static boolean isSmoothFeature() {
        return false;
    }

    public static boolean isModelCardDialog() {
        return !WorkspaceManager.GUITEST;
    }

    public static UpdateHelper.Product getRunningProduct() {
        if (instance != null) {
            return instance.getProduct();
        }
        return UpdateHelper.Product.Unknown;
    }

    public static Dimension getScreenSize() {
        if (instance != null) {
            return instance.getSize();
        }
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static void setRelativeSize(JComponent jComponent, double d) {
        BreezeFrame.setRelativeSize(jComponent, d, d);
    }

    public static void setRelativeSize(JComponent jComponent, double d, double d2) {
        BreezeFrame.setRelativeSize(new ComponentShowned(jComponent, d, d2));
    }

    public static void setRelativeSize(ComponentShowned componentShowned) {
        BreezeFrame.componentShowned = componentShowned;
        Dimension dimension = BreezeFrame.getScreenSize();
        double d = dimension.getWidth();
        double d2 = dimension.getHeight();
        componentShowned.component.setPreferredSize(new Dimension((int)(d * componentShowned.sizePercentW), (int)(d2 * componentShowned.sizePercentH)));
    }

    @Generated
    public BreezeViewStack getViewStack() {
        return this.viewStack;
    }

    @Generated
    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    @Generated
    public BreezeRuntime getRuntime() {
        return this.runtime;
    }

    @Generated
    public void setRequestExit(Runnable runnable) {
        this.requestExit = runnable;
    }

    @Generated
    public UpdateHelper.Product getProduct() {
        return this.product;
    }

    @Generated
    public static BreezeFrame getInstance() {
        return instance;
    }

    @Generated
    public OffsetDateTime getLaunchDate() {
        return this.launchDate;
    }

    static {
        prototype = false;
        projectFeature = true;
    }

    public static interface CreatePanelCallback {
        public JPanel createPanel(BreezeFrame var1);
    }

    public static class SwitchWorkspacePanel
    extends AbstractBreezeCustomPanel {
        private final BreezeComboBox comboBox = new BreezeComboBox();

        public SwitchWorkspacePanel(BreezeFrame breezeFrame) {
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.comboBox.setFont(new Font("Tahoma", 0, 16));
            this.comboBox.setPreferredSize(new Dimension(34, 30));
            this.comboBox.setName("input");
            this.comboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        this.okPressed(false);
                    }
                }
            });
            this.comboBox.setEditable(true);
            this.comboBox.addItem(new File(WorkspaceManager.getInstance().getCurrentOrDefaultWorkspacePath()));
            for (File file : SettingsManager.getInstance().getWorkspaces()) {
                if (!file.exists() || this.comboBox.hasItem(file)) continue;
                this.comboBox.addItem(file);
            }
            GridBagConstraints gridBagConstraints = GridBagHelper.createWithWeigthX1(0, new Insets(0, 0, 0, 0));
            gridBagConstraints.gridwidth = 1;
            this.add((Component)this.comboBox, gridBagConstraints);
            this.add((Component)EntryMainHelper.createTextButton("Browse", () -> this.comboBox.getEditor().setItem(this.browseFolder(breezeFrame, this.comboBox.getEditor().getItem().toString()))), GridBagHelper.create(1, 0, new Insets(0, 5, 0, 0)));
        }

        private String browseFolder(BreezeFrame breezeFrame, String string) {
            jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Select Workspace directory", (Component)breezeFrame);
            jopensaveDialog2.setDialogType(1);
            jopensaveDialog2.setFileSelectionMode(1);
            jopensaveDialog2.setCurrentDirectory(new File(string));
            if (jopensaveDialog2.openshow()) {
                return jopensaveDialog2.getSelectedFile().getAbsolutePath();
            }
            return string;
        }

        @Override
        public Object getResult() {
            Object object = this.comboBox.getEditor().getItem();
            List<File> list = SettingsManager.getInstance().getWorkspaces();
            File file = new File(object.toString());
            list.remove(file);
            list.addFirst(file);
            while (list.size() > 10) {
                list.removeLast();
            }
            SettingsManager.getInstance().save();
            return object;
        }

        @Override
        public void onShow() {
            SwingUtilities.invokeLater(this.comboBox::requestFocusAndSelectAll);
        }
    }

    public static interface OnCloseCallback {
        public void onClose(BreezeProgressManager var1);
    }

    public static interface WorkspaceDialogCallback {
        public void workspacePathChosen(String var1);

        public void cancelled();
    }

    public static interface FolderPermissionErrorDialog {
        public void onActionPerformed();
    }

    private record ComponentShowned(JComponent component, double sizePercentW, double sizePercentH) {
        public boolean isVisible(BreezeFrame breezeFrame) {
            return this.component.isVisible() && breezeFrame.equals(SwingUtilities.getRoot(this.component));
        }

        public void revalidate() {
            this.component.revalidate();
            this.component.repaint();
        }
    }

    public static interface IFrameColor {
        public BreezeFrame getFrame();

        public Color getPageColor();
    }

    public static class FakeBreezeFrame
    extends BreezeFrame {
        public FakeBreezeFrame() {
            super(null, new TcpManagerTest.FakeRuntime(), new GraphicsDevice(){

                @Override
                public int getType() {
                    return 0;
                }

                @Override
                public String getIDstring() {
                    return "";
                }

                @Override
                public GraphicsConfiguration[] getConfigurations() {
                    return new GraphicsConfiguration[0];
                }

                @Override
                public GraphicsConfiguration getDefaultConfiguration() {
                    return null;
                }
            }, breezeFrame -> new JPanel(), UpdateHelper.Product.Breeze, false, false, false);
        }

        @Override
        public void localWindowClosing(BreezeProgressManager breezeProgressManager) {
        }
    }
}

