/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lombok.Generated;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeCardLayout;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainSwitchPanel;
import se.prediktera.breeze.frontend.common.entry.MainPanelInterface;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.main.MainPanel;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.camera.PredikteraSimulatorCamera;
import se.prediktera.breeze.util.automation.GuiComponentFinder;
import se.prediktera.map.common.cleanup.CleanUpInterface;

public class BreezeViewStack {
    private final SwitchCache switchCache = new SwitchCache();
    private final ContentPaneWrapper contentPane;
    private final BreezeFrame frame;
    private JPanel mainPanel;

    public BreezeViewStack(BreezeFrame breezeFrame, JPanel jPanel) {
        this.frame = breezeFrame;
        this.mainPanel = jPanel;
        this.contentPane = new ContentPaneWrapper(breezeFrame);
    }

    public void setMainPanel(JPanel jPanel) {
        this.mainPanel = jPanel;
    }

    public synchronized void addPage(JPanel jPanel) {
        this.contentPane.add(jPanel);
    }

    public void addMainPage() {
        this.addPage(this.mainPanel);
    }

    public void removeMainPage() {
        this.removePage(this.mainPanel, false);
    }

    public synchronized void switchPage(Object object, EntryMainSwitchPanel entryMainSwitchPanel, BreezeType breezeType) {
        Object object2;
        BreezeType breezeType2 = entryMainSwitchPanel.getPageType();
        List<EntryMainSwitchPanel> list = this.switchCache.freshList(breezeType2);
        for (int i = this.contentPane.getComponentCount() - 1; i > 0; --i) {
            object2 = this.contentPane.getComponent(i);
            if (object2 == this.mainPanel || !(object2 instanceof EntryMainPanel)) continue;
            list.add((EntryMainSwitchPanel)object2);
        }
        if (breezeType2.equals((Object)BreezeType.Project)) {
            Workflow workflow = entryMainSwitchPanel.getStudyContext();
            if (workflow == null) {
                throw new EntryMainPanel.NoEntrySelectedException(entryMainSwitchPanel.getEntryName());
            }
            this.switchCache.setNewStudyContextAndClear(workflow);
        }
        EntryMainSwitchPanel entryMainSwitchPanel2 = null;
        if (this.switchCache.contains(breezeType) && !(object2 = this.switchCache.get(breezeType)).isEmpty()) {
            this.contentPane.addReverse((List<EntryMainSwitchPanel>)object2);
            entryMainSwitchPanel2 = (EntryMainSwitchPanel)object2.getFirst();
        }
        boolean bl = false;
        if (entryMainSwitchPanel2 == null) {
            entryMainSwitchPanel2 = (EntryMainSwitchPanel)MainPanel.createEntryMainPanel(this.frame, BreezeProgressManager.createEmpty(), breezeType, this.switchCache.getStudyContext());
            bl = true;
        }
        entryMainSwitchPanel2.setStudyContext(this.switchCache.getStudyContext());
        if (!entryMainSwitchPanel2.showEmptyPageIfNoItems()) {
            if (bl && !breezeType.equals((Object)BreezeType.Project)) {
                entryMainSwitchPanel2.selectFirstItem(true);
            } else {
                entryMainSwitchPanel2.showSelectedEntry(false);
            }
        }
        this.addPage(entryMainSwitchPanel2);
        this.contentPane.remove(list);
    }

    public synchronized void removePage(JPanel jPanel, boolean bl) {
        if (jPanel.getParent() != this.contentPane.get()) {
            return;
        }
        this.contentPane.remove(jPanel);
        if (jPanel instanceof EntryMainPanel) {
            EntryMainPanel entryMainPanel = (EntryMainPanel)jPanel;
            this.switchCache.remove(entryMainPanel);
            entryMainPanel.cleanUp();
        } else if (jPanel instanceof CleanUpInterface) {
            CleanUpInterface cleanUpInterface = (CleanUpInterface)jPanel;
            cleanUpInterface.cleanUp();
        }
        if (this.contentPane.getComponentCount() == 1) {
            this.switchCache.clearAll();
        }
        SwingUtilities.invokeLater(() -> {
            MainPanelInterface mainPanelInterface = this.getVisibleMainPanel();
            if (mainPanelInterface != null && bl) {
                mainPanelInterface.showSelectedEntry(false);
            }
        });
    }

    public boolean hasPage(JPanel jPanel) {
        return this.contentPane.contains(jPanel);
    }

    public Component getVisiblePanel(Class clazz) {
        return GuiComponentFinder.getComponent(this.contentPane.get(), clazz);
    }

    public boolean isUpHomeScreen() {
        int n = 0;
        for (int i = 0; i < this.contentPane.getComponentCount(); ++i) {
            if (this.contentPane.getComponent(i) instanceof BreezeProgressDialog) continue;
            ++n;
        }
        return n == 1;
    }

    public MainPanelInterface getVisibleMainPanel() {
        for (Component component : this.contentPane.getComponents()) {
            if (!component.isVisible() || !(component instanceof MainPanelInterface)) continue;
            return (MainPanelInterface)((Object)component);
        }
        return null;
    }

    public void setStudyContext(Workflow workflow) {
        this.switchCache.setNewStudyContextAndClear(workflow);
    }

    public Workflow getStudyContext() {
        return this.switchCache.getStudyContext();
    }

    @Generated
    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    private static class SwitchCache {
        private Workflow studyContext;
        private final HashMap<BreezeType, List<EntryMainSwitchPanel>> cache = new HashMap();

        private SwitchCache() {
        }

        public List<EntryMainSwitchPanel> freshList(BreezeType breezeType2) {
            List list = this.cache.computeIfAbsent(breezeType2, breezeType -> new ArrayList());
            list.clear();
            return list;
        }

        public void remove(EntryMainPanel entryMainPanel) {
            if (this.contains(entryMainPanel.getPageType())) {
                this.get(entryMainPanel.getPageType()).remove(entryMainPanel);
            }
        }

        public void clearAll() {
            this.cache.keySet().forEach(this::clear);
        }

        public void clear(BreezeType breezeType) {
            List<EntryMainSwitchPanel> list = this.cache.get((Object)breezeType);
            if (list != null) {
                for (EntryMainPanel entryMainPanel : list) {
                    entryMainPanel.cleanUp();
                }
                list.clear();
            }
        }

        public List<EntryMainSwitchPanel> get(BreezeType breezeType) {
            return this.cache.get((Object)breezeType);
        }

        public boolean contains(BreezeType breezeType) {
            return this.cache.containsKey((Object)breezeType);
        }

        public void setNewStudyContextAndClear(Workflow workflow) {
            if (workflow != null && !workflow.equals(this.studyContext)) {
                this.studyContext = workflow;
                this.clear(BreezeType.Analyse);
                this.clear(BreezeType.Workflow);
                for (Camera camera : HardwareRegistry.getInstance().getCameras()) {
                    if (camera == null || !camera.isConnected() || !(camera instanceof PredikteraSimulatorCamera) || !((PredikteraSimulatorCamera.PredikteraSimulatorSettings)((PredikteraSimulatorCamera)camera).getSettings()).getDirectory().isAutomatic) continue;
                    camera.disconnect(BreezeProgressManager.createEmpty());
                }
            }
        }

        @Generated
        public Workflow getStudyContext() {
            return this.studyContext;
        }
    }

    private static class ContentPaneWrapper {
        private final BreezeCardLayout layout = new BreezeCardLayout();
        private final JPanel contentPane;
        private int uniqueCardIndex;

        public ContentPaneWrapper(BreezeFrame breezeFrame) {
            this.contentPane = (JPanel)breezeFrame.getContentPane();
            this.contentPane.setLayout(this.layout);
        }

        public boolean contains(JPanel jPanel) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                if (!this.getComponent(i).equals(jPanel)) continue;
                return true;
            }
            return false;
        }

        public Component[] getComponents() {
            return this.contentPane.getComponents();
        }

        public JPanel getComponent(int n) {
            return (JPanel)this.contentPane.getComponent(n);
        }

        public int getComponentCount() {
            return this.contentPane.getComponentCount();
        }

        public Container get() {
            return this.contentPane;
        }

        public void addReverse(List<EntryMainSwitchPanel> list) {
            for (int i = list.size() - 1; i > 0; --i) {
                this.add(list.get(i));
            }
        }

        public void add(JPanel jPanel) {
            this.contentPane.add((Component)jPanel, String.valueOf(++this.uniqueCardIndex));
        }

        public void remove(List<EntryMainSwitchPanel> list) {
            for (EntryMainPanel entryMainPanel : list) {
                this.remove(entryMainPanel);
            }
        }

        public void remove(JPanel jPanel) {
            this.contentPane.remove(jPanel);
            this.layout.showLastComponent(this.contentPane);
        }
    }
}

