/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.AbstractBorder;

public class FilledRoundedBorder
extends AbstractBorder {
    private final Color color;
    private final int thickness;
    private final int radii;
    private final Insets insets;
    private final BasicStroke stroke;
    private final int strokePad;

    public FilledRoundedBorder(Color color, int n, int n2) {
        this.thickness = n;
        this.radii = n2;
        this.color = color;
        this.stroke = new BasicStroke(n);
        this.strokePad = n / 2;
        int n3 = n2 + this.strokePad;
        int n4 = n3 + this.strokePad;
        this.insets = new Insets(n3, n3, n4, n3);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.insets;
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        return this.getBorderInsets(component);
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n5 = n4 - this.thickness;
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(this.strokePad, this.strokePad, n3 - this.thickness, n5, this.radii, this.radii);
        Area area = new Area(double_);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        Area area2 = new Area(new Rectangle(0, 0, n3, n4));
        area2.subtract(area);
        graphics2D.setColor(this.color);
        graphics2D.setStroke(this.stroke);
        graphics2D.fill(area);
        graphics2D.draw(area);
    }
}

