/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend;

import java.awt.IllegalComponentStateException;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.map.common.error.ErrorHandler;

public class GeneralErrorDialog {
    private final BreezeFrame breezeFrame;
    private static final List<String> filterExceptionMessages = Arrays.asList("Cannot find header file:", "is not compatible to number of variables ", "No raw file has been selected for simulator camera", "The field must contain at least 1 character", "Cannot find lens with Id", "No Measurement selected");

    public GeneralErrorDialog(BreezeFrame breezeFrame) {
        this.breezeFrame = breezeFrame;
    }

    public ErrorHandler.OnExceptionCallback onExceptionCallback() {
        return throwable -> GeneralErrorDialog.handleException(this.breezeFrame, throwable);
    }

    public static boolean handleException(BreezeFrame breezeFrame, Throwable throwable) {
        FilterType filterType = GeneralErrorDialog.filterException(throwable);
        if (filterType != FilterType.Ignore) {
            GeneralErrorDialog.showErrorDialog(breezeFrame, throwable);
            return filterType == FilterType.LogAndDialog;
        }
        return false;
    }

    private static void showErrorDialog(BreezeFrame breezeFrame, Throwable throwable) {
        if (throwable instanceof ToastHandler.ToasterMessageException) {
            ToastHandler.ToasterMessageException toasterMessageException = (ToastHandler.ToasterMessageException)((Object)throwable);
            toasterMessageException.showToast(breezeFrame);
        } else if (throwable instanceof ErrorHandler.MessageException) {
            ErrorHandler.MessageException messageException = (ErrorHandler.MessageException)throwable;
            BreezeOptionDialog.showExceptionDialog(breezeFrame, GeneralErrorDialog.getMessageType(messageException), messageException.getTitle(), throwable);
        } else {
            BreezeOptionDialog.showErrorDialog(breezeFrame, "Error", throwable);
        }
    }

    private static AbstractBreezeDialog.MessageType getMessageType(ErrorHandler.MessageException messageException) {
        return switch (messageException.getOptionType()) {
            case 1 -> AbstractBreezeDialog.MessageType.INFORMATION_OPTION;
            case 2 -> AbstractBreezeDialog.MessageType.WARNING_OPTION;
            default -> AbstractBreezeDialog.MessageType.ERROR_OPTION;
        };
    }

    public static FilterType filterException(Throwable throwable) {
        String string;
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (stackTraceElementArray.length == 0) {
            return FilterType.LogAndDialog;
        }
        String string2 = stackTraceElementArray[0].getClassName();
        String string3 = stackTraceElementArray[0].getMethodName();
        if (throwable instanceof ArrayIndexOutOfBoundsException && string2.endsWith("java.awt.Container") && string3.equals("getComponent")) {
            return FilterType.Ignore;
        }
        if (stackTraceElementArray.length > 1 && string2.endsWith("javax.swing.plaf.basic.BasicListUI") && string3.equals("updateLayoutState")) {
            return FilterType.Ignore;
        }
        if (stackTraceElementArray.length > 1 && string2.endsWith("java.util.Vector") && (string3.equals("elementAt") || string3.equals("removeElementAt")) && ((string = stackTraceElementArray[1].getClassName()).contains("DefaultMutableTreeNode") || string.contains("DefaultTableColumnModel") || string.contains("VariableHeightLayoutCache"))) {
            return FilterType.Ignore;
        }
        if (throwable instanceof NoSuchElementException && string2.equals("java.util.Vector$1") && string3.equals("nextElement")) {
            return FilterType.Ignore;
        }
        if (string2.endsWith("javax.swing.plaf.basic.BasicProgressBarUI") || throwable instanceof IllegalComponentStateException && string2.endsWith("java.awt.Component.getLocationOnScreen_NoTreeLock")) {
            return FilterType.Ignore;
        }
        if (throwable instanceof ClassCastException && string2.endsWith("javax.swing.LayoutComparator")) {
            return FilterType.Ignore;
        }
        string = throwable.getMessage();
        if (string != null) {
            for (String string4 : filterExceptionMessages) {
                if (!string.contains(string4)) continue;
                return FilterType.OnlyDialog;
            }
        }
        return FilterType.LogAndDialog;
    }

    public static enum FilterType {
        Ignore,
        OnlyDialog,
        LogAndDialog;

    }
}

